/*
** Copyright (C) 2000 Idan Shoham <idan@m-tech.ab.ca>
** Copyright (C) 2003 Guilhem Bonnefille <guilhem.bonnefille@free.fr>
**  
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
** 
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
** 
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software 
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#ifndef MESSENGER_H
#define MESSENGER_H

#include <cstdarg>

/// Manage all messages
class MESSENGER
{
private:
  static bool _globalDebug;

public:

  /// Enum of all the entities
  typedef enum {
    ALL,      ///< Can be used to identify all or any
    PROJECT,  ///< For sched.cc
    REPORTER  ///< For graph.cc
  } ENTITY;

  static void Format(char *buf, const char *fmt, va_list args);
  static void Format(char *buf, const char *fmt, ...);
  static void Error(const char *fmt, va_list args);
  static void Error(const char *fmt, ...);
  static void Warning(const char *fmt, va_list args);
  static void Warning(const char *fmt, ...);
  static void Debug(ENTITY entity, const char *fmt, va_list args);
  static void Debug(ENTITY entity, const char *fmt, ...);

  static void setGlobalDebug(bool state)
    { _globalDebug = state; }
  static bool getGlobalDebug()
    { return _globalDebug; }
};

#endif

