/*
 * Decompiled with CFR 0.152.
 */
package org.javagroups.protocols;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import org.javagroups.Address;
import org.javagroups.Event;
import org.javagroups.Header;
import org.javagroups.Message;
import org.javagroups.View;
import org.javagroups.log.Trace;
import org.javagroups.stack.Protocol;
import org.javagroups.util.Promise;
import org.javagroups.util.TimeScheduler;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class FD_SIMPLE
extends Protocol {
    Address local_addr;
    TimeScheduler timer;
    HeartbeatTask task;
    long interval;
    long timeout;
    Vector members;
    HashMap counters;
    int max_missed_hbs;
    final String name = "FD_SIMPLE";

    public String getName() {
        return "FD_SIMPLE";
    }

    public void init() throws Exception {
        this.timer = this.stack.timer;
    }

    public boolean setProperties(Properties props) {
        String str = props.getProperty("timeout");
        if (str != null) {
            this.timeout = new Long(str);
            props.remove("timeout");
        }
        if ((str = props.getProperty("interval")) != null) {
            this.interval = new Long(str);
            props.remove("interval");
        }
        if ((str = props.getProperty("max_missed_hbs")) != null) {
            this.max_missed_hbs = Integer.parseInt(str);
            props.remove("max_missed_hbs");
        }
        if (props.size() > 0) {
            System.err.println("FD_SIMPLE.setProperties(): the following properties are not recognized:");
            props.list(System.out);
            return false;
        }
        return true;
    }

    public void stop() {
        if (this.task != null) {
            this.task.stop();
            this.task = null;
        }
    }

    public void up(Event evt) {
        FdHeader hdr = null;
        boolean counter_reset = false;
        switch (evt.getType()) {
            case 8: {
                this.local_addr = (Address)evt.getArg();
                break;
            }
            case 1: {
                Message msg = (Message)evt.getArg();
                Address sender = msg.getSrc();
                this.resetCounter(sender);
                counter_reset = true;
                hdr = (FdHeader)msg.removeHeader("FD_SIMPLE");
                if (hdr == null) break;
                switch (hdr.type) {
                    case 1: {
                        Message rsp = new Message(sender, null, null);
                        rsp.putHeader("FD_SIMPLE", new FdHeader(2));
                        this.passDown(new Event(1, rsp));
                        return;
                    }
                    case 2: {
                        if (Trace.trace) {
                            Trace.info("FD_SIMPLE.up()", "received I_AM_ALIVE response from " + sender);
                        }
                        if (this.task != null) {
                            this.task.receivedHeartbeatResponse(sender);
                        }
                        if (!counter_reset) {
                            this.resetCounter(sender);
                        }
                        return;
                    }
                }
                Trace.warn("FD_SIMPLE.up()", "FdHeader type " + hdr.type + " not known");
                return;
            }
        }
        this.passUp(evt);
    }

    public void down(Event evt) {
        switch (evt.getType()) {
            case 6: {
                View new_view = (View)evt.getArg();
                this.members.clear();
                this.members.addAll(new_view.getMembers());
                if (new_view.size() > 1) {
                    if (this.task == null) {
                        this.task = new HeartbeatTask();
                        if (Trace.trace) {
                            Trace.info("FD_SIMPLE.down()", "starting heartbeat task");
                        }
                        this.timer.add(this.task, true);
                    }
                } else if (this.task != null) {
                    if (Trace.trace) {
                        Trace.info("FD_SIMPLE.down()", "stopping heartbeat task");
                    }
                    this.task.stop();
                    this.task = null;
                }
                Iterator it = this.counters.keySet().iterator();
                while (it.hasNext()) {
                    Address key = (Address)it.next();
                    if (this.members.contains(key)) continue;
                    if (Trace.trace) {
                        Trace.info("FD_SIMPLE.down()", "removing " + key + " from counters");
                    }
                    it.remove();
                }
                break;
            }
        }
        this.passDown(evt);
    }

    Address getHeartbeatDest() {
        Address retval = null;
        if (this.members == null || this.members.size() < 2 || this.local_addr == null) {
            return null;
        }
        Vector members_copy = (Vector)this.members.clone();
        members_copy.removeElement(this.local_addr);
        int size = members_copy.size();
        int r = (int)(Math.random() * (double)(size + 1)) % size;
        retval = (Address)members_copy.elementAt(r);
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    int incrementCounter(Address mbr) {
        int ret = 0;
        if (mbr == null) {
            return ret;
        }
        HashMap hashMap = this.counters;
        synchronized (hashMap) {
            block5: {
                Integer cnt;
                block4: {
                    cnt = (Integer)this.counters.get(mbr);
                    if (cnt != null) break block4;
                    cnt = new Integer(0);
                    this.counters.put(mbr, cnt);
                    break block5;
                }
                ret = cnt + 1;
                this.counters.put(mbr, new Integer(ret));
            }
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void resetCounter(Address mbr) {
        if (mbr == null) {
            return;
        }
        HashMap hashMap = this.counters;
        synchronized (hashMap) {
            this.counters.put(mbr, new Integer(0));
            return;
        }
    }

    String printCounters() {
        StringBuffer sb = new StringBuffer();
        Iterator it = this.counters.keySet().iterator();
        while (it.hasNext()) {
            Address key = (Address)it.next();
            sb.append(key).append(": ").append(this.counters.get(key)).append("\n");
        }
        return sb.toString();
    }

    private final /* synthetic */ void this() {
        this.local_addr = null;
        this.timer = null;
        this.task = null;
        this.interval = 3000L;
        this.timeout = 3000L;
        this.members = new Vector();
        this.counters = new HashMap();
        this.max_missed_hbs = 5;
        this.name = "FD_SIMPLE";
    }

    public FD_SIMPLE() {
        this.this();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class FdHeader
    extends Header {
        static final int ARE_YOU_ALIVE = 1;
        static final int I_AM_ALIVE = 2;
        int type;

        public String toString() {
            switch (this.type) {
                case 1: {
                    return "[FD_SIMPLE: ARE_YOU_ALIVE]";
                }
                case 2: {
                    return "[FD_SIMPLE: I_AM_ALIVE]";
                }
            }
            return "[FD_SIMPLE: unknown type (" + this.type + ")]";
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(this.type);
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.type = in.readInt();
        }

        private final /* synthetic */ void this() {
            this.type = 1;
        }

        public FdHeader() {
            this.this();
        }

        FdHeader(int type) {
            this.this();
            this.type = type;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class HeartbeatTask
    implements TimeScheduler.Task {
        boolean stopped;
        Promise promise;
        Address dest;

        void stop() {
            this.stopped = true;
        }

        public boolean cancelled() {
            return this.stopped;
        }

        public long nextInterval() {
            return FD_SIMPLE.this.interval;
        }

        public void receivedHeartbeatResponse(Address from) {
            if (from != null && this.dest != null && from.equals(this.dest)) {
                this.promise.setResult(from);
            }
        }

        public void run() {
            int num_missed_hbs = 0;
            this.dest = FD_SIMPLE.this.getHeartbeatDest();
            if (this.dest == null) {
                Trace.warn("FD_SIMPLE.HeartbeatTask.run()", "heartbeat destination was null, will not send ARE_YOU_ALIVE message");
                return;
            }
            if (Trace.trace) {
                Trace.info("FD_SIMPLE.HeartbeatTask.run()", "sending ARE_YOU_ALIVE message to " + this.dest + ", counters are\n" + FD_SIMPLE.this.printCounters());
            }
            this.promise.reset();
            Message msg = new Message(this.dest, null, null);
            msg.putHeader("FD_SIMPLE", new FdHeader(1));
            FD_SIMPLE.this.passDown(new Event(1, msg));
            this.promise.getResult(FD_SIMPLE.this.timeout);
            num_missed_hbs = FD_SIMPLE.this.incrementCounter(this.dest);
            if (num_missed_hbs >= FD_SIMPLE.this.max_missed_hbs) {
                if (Trace.trace) {
                    Trace.info("FD_SIMPLE.HeartbeatTask.run()", "missed " + num_missed_hbs + " from " + this.dest + ", suspecting member");
                }
                FD_SIMPLE.this.passUp(new Event(9, this.dest));
            }
        }

        private final /* synthetic */ void this() {
            this.stopped = false;
            this.promise = new Promise();
            this.dest = null;
        }

        HeartbeatTask() {
            this.this();
        }
    }
}

