
#include "libosiris.h"
#include "logging.h"
#include "scanner.h"
#include "modules.h"

void execute_module( const char *module_name, SCANNER *scanner )
{
    int index;

    if( module_name == NULL )
    {
        log_error( "configuration block was null or invalid, skipping." );
        return;
    }

    for( index = 0; active_modules[index].name; index++ )
    {
        if( strcmp( module_name, active_modules[index].name ) == 0 )
        {
            if( active_modules[index].module_function != NULL )
            {
                log_info( "launching module: (%s)", module_name );
                active_modules[index].module_function( scanner );

                return;
            }

            else
            {
                log_error( "failed to execute module: (%s).",
                           module_name );
            }
        }
    }

    log_error( "agent does not support module: (%s).", module_name );
}
