//
// C++ Interface: %{MODULE}
//
// Description: 
//
//
// Author: %{AUTHOR} <%{EMAIL}>, (C) %{YEAR}
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef __DUMPAVAILPACKAGEDB_H_2005_02_19
#define __DUMPAVAILPACKAGEDB_H_2005_02_19

#include <map>

#include "ipackagedb.h"
#include "iaptsearch.h"

namespace NPlugin
{
	class IProvider;
}

namespace NApt
{

/**
This is a package database that gets its information from the apt-cache dumpavail command.

@author Benjamin Mesing
*/
class DumpAvailPackageDB : public IPackageDB, public IAptSearch
{
	typedef map<int, Package> PackageMap;
	/** @brief This maps the package handles to the package structures. */
	PackageMap _packages;
	/** @brief This holds estimated number of packages. 
	  *
	  * After construction (where set directly) this holds the number of packages
	  * read during the last reloadPackageInformation() call. 
	  */
	uint _estimatedPackageNum;
public:
	typedef QStringList PackageContainer;
	/** Create a new DB parsing the output of apt-cache dumpavail this may take
	  * some time. 
	  *
	  * @param pLoader the observer where to report the progress, 0 if no progress should be reported  
	  * @param estimatedPackageNum the estimated number of packages available (used for progress information)
	  * hand 0 if you can make no assumption (progress reporting will be surpressed
	  */
	DumpAvailPackageDB(NUtil::IProgressObserver* pObserver, uint estimatedPackageNum);

	virtual ~DumpAvailPackageDB();
	// documented in base class
	virtual const Package& getPackageRecord(const QString& pkg, const QString& linebreak="\n") const;
	// documented in base class
	virtual const Package& getPackageRecord(int packageHandle, const QString& linebreak="\n") const;
	// documented in base class
	virtual const QString getShortDescription(int packageHandle) const;
	// documented in base class
	virtual Package::InstalledState getState(int packageHandle) const;
	// documented in base class	
	virtual void reloadPackageInformation(NUtil::IProgressObserver* pObserver);

	
	// documented in base class	
	virtual bool search(Tagcoll::OpSet<int>& result, Tagcoll::HandleMaker<string>& handleMaker, 
		const PackageContainer& includePatterns, const PackageContainer& excludePatterns, bool searchDescr=true) const;
	// documented in base class	
	virtual bool search(Tagcoll::OpSet<int>& result, Tagcoll::HandleMaker<string>& handleMaker, 
		const string& pattern, bool searchDescr=true) const;
	


};

}	// NApt

#endif	//  __DUMPAVAILPACKAGEDB_H_2005_02_19
