//
// C++ Interface: stringtagcollbuilder
//
// Description: 
//
//
// Author: Benjamin Mesing <bensmail@gmx.net>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef __STRINGTAGCOLLBUILDER_H_2004_03_21
#define __STRINGTAGCOLLBUILDER_H_2004_03_21

// #include <string>
// #include <set>
// 
#include <TagCollection.h>
// #include <TagcollConsumer.h>
#include <TagcollBuilder.h>
// #include <OpSet.h>
// 
// using namespace std;
// 
// template <typename T>
// class HandleMaker;

/** @brief This namespace is used for classes which are useful only for
  * the debtags system, and do not offer other functionality.
  * 
  * Most often being direct subclasses of Tagcoll classes like Consumers.
  */
namespace NDebtags
{

// 
// /**  @brief This consumer simply takes all the items and tags it gets and puts them into the #_coll.
//   *
//   * @author Benjamin Mesing
// */
// 
// class StringTagcollBuilder  : public TagcollConsumer<std::string>
// {
// protected:
// 	TagCollection<std::string> _coll;
// 	
// public:
// 	StringTagcollBuilder();
// 
// 	virtual ~StringTagcollBuilder();
// 
// 	virtual void consume(const std::string& item) throw ()
// 	{
// 		_coll.add(item);
// 	}
// 	
// 	virtual void consume(const std::string& item, const OpSet<std::string>& tags) throw ()
// 	{
// 		_coll.add(tags, item);
// 	}
// 
// 	virtual void consume(const OpSet<std::string>& items) throw ()
// 	{
// 		_coll.add(items);
// 	}
// 	
// 	virtual void consume(const OpSet<std::string>& items, const OpSet<std::string>& tags) throw ()
// 	{
// 		_coll.add(tags, items);
// 	}
// 
// 	// Retrieve the resulting collection
// 	TagCollection<std::string> collection() throw () { return _coll; }
// 	const TagCollection<std::string> collection() const throw () { return _coll; }
// };
// 

/** @brief This extends the TagcollBuilder in that way, that it allows to map the 
  * handles back to the strings.
  * @author Benjamin Mesing
  */
class TagcollBuilderExt : public Tagcoll::TagcollBuilder
{
public:
	TagcollBuilderExt(Tagcoll::HandleMaker<std::string>& handleMaker) throw ()
		: TagcollBuilder(handleMaker) {}
	virtual ~TagcollBuilderExt() throw () {}
	/** Maps one handle to a string. */
	static string mapToString(const int handle, Tagcoll::HandleMaker<std::string>& handleMaker)	
	{ return handleMaker.getItem(handle); };
	/** Maps the handles to strings. */
	static Tagcoll::OpSet<string> mapToString(const Tagcoll::OpSet<int>& handles, Tagcoll::HandleMaker<std::string>& handleMaker)
	{
		Tagcoll::OpSet<string> res;
		for (Tagcoll::OpSet<int>::const_iterator it = handles.begin(); it != handles.end(); it++)
			res += handleMaker.getItem(*it);
		return res;
	}
	/** @brief Offer a faster version of set retrieval (by reference).
	  * 
	  * This hides the original versions. */
	const Tagcoll::TagCollection<int, string>& collection() const throw()	{ return coll; }
};

}	// namespace NDebtags

#endif	//  __STRINGTAGCOLLBUILDER_H_2004_03_21
