/*
 * symtab.h
 *
 * Copyright 1995-2000 Timo Rossi, <trossi@iki.fi>
 * See the file LICENSE for license terms.
 *
 */

struct symbol {
  struct symbol *next;
  union {
    long value;
    struct macro_line *text;
  } v;
  char type;
  char type2;
  char name[1]; /*struct hack*/
};

/* symbol types */
enum {
  SYM_MACRO,
  SYM_FORWARD,
  SYM_SET,
  SYM_DEFINED
};

#define SYMTAB_GLOBAL 0
#define SYMTAB_LOCAL  1

/* type2 */
enum {
  SYMT_UNKNOWN,
  SYMT_LABEL,
  SYMT_REGFILE,
  SYMT_CONSTANT
};

/*prototypes*/
void init_symtab(void);
void add_local_symtab(void);
void remove_local_symtab(void);
struct symbol *add_symbol(char *name, int tab);
struct symbol *lookup_symbol(char *name, int tab);
void dump_symtab(FILE *);

