#ifndef DOMLETTE_XMLCHAR_H
#define DOMLETTE_XMLCHAR_H

#ifdef __cplusplus
extern "C" {
#endif

#include "Python.h"
#include "expat.h"
#include "expat_config.h"

  /* Converts the unicode value of the PyObject to a new XML_Char buffer.
     It is the responsibility of the caller to free the result when done. */
  extern XML_Char* XMLChar_FromObject(PyObject *ob);

#ifdef XML_UNICODE
  /* Converts a string of XML_Chars into a PyUnicode string.  Returns None if 
     'str' is a null-pointer. */
  extern PyObject *Unicode_FromXMLChar(const XML_Char *s);

  /* Converts a string of XML_Chars into a PyUnicode string.  Returns None if 
     'str' is a null-pointer. */
  extern PyObject *Unicode_FromXMLCharAndSize(const XML_Char *s, int n);

  /* Calculates the length of the string s. */
  extern size_t XMLChar_Len(const XML_Char *s);

  /* Compares the two XML_Char strings s1 and s2. */
  extern int XMLChar_Cmp(const XML_Char *s1, const XML_Char *s2);

  /* Compares the first (at most) n characters of s1 and s2. */
  extern int XMLChar_NCmp(const XML_Char *s1, const XML_Char *s2, size_t n);
#else
#define XMLChar_Len(s1) strlen(s1)
#define XMLChar_Cmp(s1, s2) strcmp((s1), (s2))
#define XMLChar_NCmp(s1, s2, n) strncmp((s1), (s2), (n))

#define Unicode_FromXMLCharAndSize(s,n) PyUnicode_DecodeUTF8((s), (n), NULL)
#define Unicode_FromXMLChar(s) Unicode_FromXMLCharAndSize((s), XMLChar_Len(s))
#endif

  extern void XMLChar_Print(FILE *fp, const XML_Char *s);

#ifdef __cplusplus
}
#endif

#endif /* DOMLETTE_XMLCHAR_H */
