import string, cStringIO, base64

from Ft.Server.Core import Constants
from Ft.Server.Protocols.Http import PostHandler
from Ft.Server.Protocols.Http import CommonHandler

g_xmlTemplate = """<?xml version = "1.0"?>
<dummy/>
"""

g_xsltTemplate = """<?xml version="1.0"?>
<xsl:stylesheet
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:ftext="http://xmlns.4suite.org/4ss"
  extension-element-prefixes="ftext"
  version="1.0"
>

  <xsl:param name='name'/>

  <xsl:template match="/">
    <employee>
      <name><xsl:value-of select='$name'/></name>
    </employee>
    <ftext:set-post-template-params doc-uri="doc1.xml"/>
  </xsl:template>

  </xsl:stylesheet>
"""

g_employeeXslt = """<?xml version="1.0"?>
<xsl:stylesheet
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  version="1.0"
>

  <xsl:template match="/employee">
    <HTML>
      <BODY>
        <P>Employee names <xsl:value-of select='name'/></P>
      </BODY>
    </HTML>
  </xsl:template>

</xsl:stylesheet>
"""

g_form = """<HTML>
<BODY>
  <FORM action='http://localhost:8080/testDoc1' METHOD='POST'>
    <P>Employee Name <INPUT NAME='name' TYPE='TEXT'></P>
    <INPUT TYPE='HIDDEN' NAME='template-xslt' VALUE='testSheet1'>
    <INPUT TYPE='HIDDEN' NAME='new-doc-uri' VALUE='http://localhost/doc3.xml'>    
    <INPUT TYPE='HIDDEN' NAME='response-uri' VALUE='http://localhost:8080/doc3.xml?xslt=employee.xslt'>    
    <INPUT TYPE='HIDDEN' NAME='action' VALUE='create'>
    <INPUT TYPE='SUBMIT'>
  </FORM>
</BODY>
</HTML>"""

# Emacs "
def prime(tester):
    tester.startTest("Prime DB")
    repo = tester.test_data['util'].getRepo()

    if repo.hasContainer('/test.4ss'):
        repo.deleteContainer('/test.4ss')

    local = repo.createContainer('/test.4ss', 1)

    local.setWorldRead()
    local.setWorldWrite()

    doc1 = local.createDocument('BASE_XML','testDoc1',g_xmlTemplate)
    doc1.setWorldRead()
    sheet1 = local.createDocument('POST_HANDLER_XSLT','testSheet1', g_xsltTemplate)
    sheet1.setWorldRead()

    repo.txCommit()
    tester.testDone()
    

def get_no_response(tester):
    tester.startTest("No Response URI")

    h = PostHandler.PostHandler({})

    #Create a request for the uri
    headers = {}
    body = ""
    requestUri = "/testDoc1?template-xslt=testSheet1&name=user1&action-name=create"
    request = CommonHandler.Request(requestUri, headers, body, host='test.4ss',configFile=tester.test_data['util'].configFileName)

    res = h.handle(request)
    tester.compare(200, res.code)
    tester.compare(None, res.body)

    
    repo = tester.test_data['util'].getRepo()
    doc = repo.fetchDocument("/test.4ss/doc1.xml")
    tester.compare(result1,doc.getContent())
    repo.txRollback()

    tester.testDone()


def get_with_response(tester):

    tester.startTest("Get With Response")

    h = PostHandler.PostHandler({'TemplateXslt' : 'template-xslt',
                                 'ResponseUri' : 'response-uri',
                                 'NewDocUri' : 'doc-uri',
                                 'DocDefName' : 'doc-def-name'
                                 })

    #Create a request for the uri
    headers = {}
    body = ""
    requestUri = "/testDoc1?template-xslt=testSheet1&doc-uri=doc2.xml&name=user1&response-uri=http://fourthought.com/index.html&action-name=create"
    request = CommonHandler.Request(requestUri, headers, body, host='test.4ss',configFile=tester.test_data['util'].configFileName)

    res = h.handle(request)
    tester.compare(302, res.code, msg=res.body)
    tester.compare(1, res.headers.has_key('Location'))
    tester.compare("http://fourthought.com/index.html", res.headers['Location'])
    
    repo = tester.test_data['util'].getRepo()
    doc = repo.fetchDocument("/test.4ss/doc2.xml")
    tester.compare(result1,doc.getContent())
    repo.txRollback()

    tester.testDone()


def Test(tester):
    tester.startGroup("Default Post Handler")
    prime(tester)
    get_no_response(tester)
    get_with_response(tester)
    tester.groupDone()

result1 = """<?xml version='1.0' encoding='UTF-8'?>
<employee><name>user1</name></employee>"""

