(use gauche.test)
(use file.util)
(use rfc.822)
(use srfi-1)
(use gauche.uvector)
(use gauche.net)

(test-start "scmail.mail")
(use scmail.mail)

(test-module 'scmail.mail)

(define test-file "1")
(define temporary-file "test.tmp")
(define mail #f)

(define (file->string file)
  (let* ((iport (open-input-file file))
         (string (port->string iport)))
    (close-input-port iport)
    string))

(test "make" #t
      (lambda ()
        (set! mail (make <mail> :file test-file))
        (string=? (file->string test-file)
                  (string-incomplete->complete (ref mail 'content)))))

(test* "scmail-mail-from-stdin?" #f (scmail-mail-from-stdin? mail))
(test* "scmail-mail-removed?" #f (scmail-mail-removed? mail))

(test "scmail-mail-write" #t
      (lambda ()
        (scmail-mail-write mail temporary-file)
        (string=? (file->string test-file)
                  (file->string temporary-file))))

(test "scmail-mail-remove and scmail-mail-removed?" #t
      (lambda ()
        (let1 tmp (make <mail> :file temporary-file)
              (and (scmail-mail-remove tmp)
                   (scmail-mail-removed? tmp)
                   (not (file-exists? temporary-file))))))

(test "scmail-mail-query" #t
      (lambda ()
        (call-with-input-file test-file
          (lambda (iport)
            (every (lambda (field)
                     (string=? (cadr field)
                               (scmail-mail-query mail 
                                           (string->symbol (car field)))))
                   (rfc822-header->list iport))))))

(test* "scmail-mail-query" #t
       (string=? (scmail-mail-query mail 'file)
                 (scmail-mail-query mail 'file-name)))

(test* "scmail-mail-query" #t
       (string=? (scmail-mail-query mail 'file)
                 (scmail-mail-query mail 'file-name)))

(test* "scmail-mail-query" #t
       (string=? (scmail-mail-query mail 'body)
                 (string-scan (file->string test-file) "\n\n" 'after)))

(test* "scmail-mail-decode-field successful" #t
       (equal? #u8(#xa4 #xa2 #x61 #x62 #x63)  ; "abc" in euc
               (string->u8vector
                (scmail-mail-decode-field 
                 "=?iso-2022-jp?Q?=1B=24=42=24=22=1B=28=42?=abc" "eucjp"))))

(test* "scmail-mail-decode-field" #t
       (equal? #u8(#xa4 #xa2 #x61 #x62 #x63)  ; "abc" in euc
               (string->u8vector
                (scmail-mail-decode-field 
                 "=?iso-2022-jp?Q?=1B=24=42=24=22=1B=28=42?=abc" "eucjp"))))

(test* "scmail-mail-decode-field" #t
       (equal? #u8(#xa4 #xa2 #x61 #x62 #x63)  ; "abc" in euc
               (string->u8vector
                (scmail-mail-decode-field 
                 "=?ISO-2022-JP?B?GyRCJCIbKEJhYmM=?=" "eucjp"))))

(test* "scmail-mail-decode-field" #t
       (string=? "=?iso-9999-jp?Q?=1B=24=42=24=22=1B=28=42?=abc"
                 (scmail-mail-decode-field 
                  "=?iso-9999-jp?Q?=1B=24=42=24=22=1B=28=42?=abc" "eucjp")))


(with-module 
 gauche.net
 (define (smtp-responses)
   (string-join (map number->string 
                     (list 220 250 250 250 354 250 221 ))

                "\n"))

 (define (call-with-client-socket socket proc)
   (call-with-input-string (smtp-responses)
                           (lambda (smtp-port)
                             (proc smtp-port
                                   (standard-output-port)))))

 (define (make-client-socket type host port)
   'dummy))

(test* "scmail-send-mail" #t
       (call-with-input-string 
        "From: foo@example.org\n\n.Hello!\n"
        (lambda (iport)
          (newline)
          (scmail-send-mail "localhost" 25 iport 
                     "from@example.org" 
                     "to@example.net"))))

(test* "scmail-send-mail" #t
       (call-with-input-string 
        #*"From: foo@example.org\n\n.Hello!\n\xff\n"
        (lambda (iport)
          (newline)
          (scmail-send-mail "localhost" 25 iport 
                     "from@example.org" 
                     "to@example.net"))))

(test "scmail-mail-forward" #t
      (lambda ()
        (newline)
        (scmail-mail-forward mail
                      "localhost"
                      "to@example.org")))

(test-end)
