/***************************************************************************
                          midiout_midifile_device.h  -  description
                             -------------------
    begin                : Tue Jan 1 2002
    copyright            : (C) 2002 by red
    email                : red@server
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef MIDIOUT_MIDIFILE_DEVICE_H
#define MIDIOUT_MIDIFILE_DEVICE_H

#include "midioutdevice.h"
#include "file_writer.h"
/**
  *@author red
  */

class MidiOut_MidiFile_Device : public MidiOutDevice  {

        File_Writer writer;

        unsigned chunk_length;

        int old_time,current_time;

        void write_begining();

	void write_delta_time();
	void write_vlength_number(unsigned p_number);

public:

	void open_file(string p_filename);
	void close_file();
	void set_current_time_offset(int p_time);
	

	bool enable_subdevice(int subdevicenum);
	bool disable_subdevice(int subdevicenum);

	string get_subdevice_name(int subdevicenum);

	//midi
	void send_MIDI_noteon(int subdevice,char channel, char note, char velocity);
	void send_MIDI_noteoff(int subdevice,char channel, char note, char velocity);
	void send_MIDI_program(int subdevice,char channel, char patch);
	void send_MIDI_control(int subdevice,char channel, char controller, char value);
	void send_MIDI_pitch_bender(int subdevice,char channel, int value);
	void send_MIDI_note_aftertouch(int subdevice,char channel, char note, char pressure);
	void send_MIDI_channel_aftertouch(int subdevice,char channel, char pressure);
	void send_MIDI_RPN(int subdevice, char channel, char lsb, char msb, char datamsb, char datalsb);
	void send_MIDI_reset(int subdevice);

	void device_wait(int wait_amount); // in msecs

	void play_notify();
	void stop_notify();

	MidiOut_MidiFile_Device();
	~MidiOut_MidiFile_Device();
};

#endif
