/***************************************************************************
                          interface_update.cpp  -  description
                             -------------------
    begin                : Mon Oct 16 2000
    copyright            : (C) 2000 by Juan Sebastian Linietsky
    email                : reduz@anime.com.ar
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "interface.h"

static char * return_cstring_from_string_with_number(int number, string sourcestring) {

	// any better way? mail me comments and modifications please
	char *tmpchrstring;
	unsigned int i;

	(void*)tmpchrstring=malloc(sourcestring.length()+5);
	tmpchrstring[0]='0'+number/100;	
	tmpchrstring[1]='0'+(number/10) % 10;	
	tmpchrstring[2]='0'+number%10;	
	tmpchrstring[3]='-';

	for (i=0;i<sourcestring.length();i++) tmpchrstring[i+4]=sourcestring[i];
	tmpchrstring[sourcestring.length()+4]=0;	

	return tmpchrstring; // dont forget to free what you've got!
}

string Interface::return_string_with_number(int number,string instring) {

 	string tmpstring;
	char *tmpcstring;
        tmpcstring=return_cstring_from_string_with_number(number,instring);
	tmpstring=tmpcstring;
	free(tmpcstring);

	return tmpstring;

}


/*****************************************************
		TRACK PROPERTIES
******************************************************/


void Interface::update_track_list() {

	int i;

	gchar *pepe[1]={"kakaz"};

	track_list->clear();

	track_properties_set_enabled(song->get_tracks()>0);

	for (i=0;i<song->get_tracks();i++) {

		pepe[0]=(gchar*)song->get_instrument(i)->name.c_str();
		track_list->append(pepe);
	}

	track_list->row(selected_track).select();

}


void Interface::request_update_combobox_devices(int track_number) {


	if (track_number!=selected_track) return ;

	if ((song->user_devices.get_device_count()==0) || song->get_tracks()==0) {

		cout << ("FIXME: No devices.. disable combo") << endl;

		combo_track_devices->set_sensitive(false);
	} else {

		int i;
		list<string> gl;

		string tmpstring;
		string tmpdevice;

		char *tmpcstring;

		for (i=0;i<song->user_devices.get_device_count();i++) {

			tmpcstring=return_cstring_from_string_with_number(i,song->user_devices.get_device(i)->name);		
			tmpstring=tmpcstring;
			if (i==song->get_instrument(selected_track)->midi.device.get()) tmpdevice=tmpcstring;
			gl.push_back(tmpstring);
			free(tmpcstring);
		}

		combo_track_devices->set_popdown_strings(gl);
		combo_track_devices->set_sensitive(true);
		combo_track_devices->get_entry()->set_text(tmpdevice);
	}


}

#define CURRENT_DEVICE song->user_devices.get_device(song->get_instrument(selected_track)->midi.device.get())
#define CURRENT_BANK song->user_devices.get_device(song->get_instrument(selected_track)->midi.device.get())->instrument_map.bank[song->get_instrument(selected_track)->midi.bank.get()]

void Interface::request_update_combobox_banks(int track_number) {


        // The device that this instrument uses

	if (track_number!=selected_track) return ;

	if ((song->user_devices.get_device_count()==0)
         || (CURRENT_DEVICE->instrument_map.get_banks_count()==0)) {

		cout << ("FIXME: No devices or banks.. disable this combo") << endl;

		combo_track_banks->set_sensitive(false);
	} else {

		int i;
		list<string> gl;

		string tmpstring;
		char *tmpcstring;
		string tmpbank;

		for (i=0;i<CURRENT_DEVICE->instrument_map.get_banks_count();i++) {
		

			tmpcstring=return_cstring_from_string_with_number(i,CURRENT_DEVICE->instrument_map.bank[i]->name);		
			tmpstring=tmpcstring;
			if (i==song->get_instrument(selected_track)->midi.bank.get()) tmpbank=tmpcstring;
			gl.push_back(tmpstring);
			free(tmpcstring);

		}

		combo_track_banks->set_popdown_strings(gl);
		combo_track_banks->set_sensitive(true);
		combo_track_banks->get_entry()->set_text(tmpbank);
	}


}


void Interface::request_update_clist_patches(int track_number) {


        // The device that this instrument uses
	if (track_number!=selected_track) return ;

	clist_track_patches->clear();

	if ((song->user_devices.get_device_count()==0)
         || (CURRENT_DEVICE->instrument_map.get_banks_count()==0)) {

		clist_track_patches->set_sensitive(false);

	} else {

		int i;
		string tmppatchname;	
		gchar *pepe[1]={"kakaz"};



//	#define CURRENT_BANK song->user_devices.device[song->get_instrument(selected_track)->midi.device]->instrument_map.bank[song->get_instrument(selected_track)->midi.bank]


                clist_track_patches->freeze(); //stop showing changes
		
	
		for (i=0;i<128;i++) {

			pepe[0]=return_cstring_from_string_with_number(i+1,CURRENT_BANK->patch_names[i]);
			clist_track_patches->append(pepe);

			if (song->get_instrument(selected_track)->midi.patch==i) {
		
				tmppatchname=pepe[0];
			}

			free(pepe[0]); // must free it, must free it !

		}

                clist_track_patches->thaw(); // show all changes

		clist_track_patches->set_sensitive(true);

		clist_track_patches->row(song->get_instrument(selected_track)->midi.patch.get()).select();

        	entry_track_selected_patch->set_text(tmppatchname);
			
	}


}

void Interface::request_update_controller_spinbuttons() {
	
	int i;

	for (i=0;i<128;i++) {

//		controller_line[i].controller_spinbutton->set_value(song->get_instrument(selected_track)->initial_controller_value[i]);
	}

}

void Interface::request_update_track_properties(int track_number) {
        Instrument::Initial_Value_List::iterator I;
        unsigned int i;

        if (song->get_tracks()>0) {

			vbox5->show();
	} else {

			vbox5->hide();
			return;
	}

	if (track_number!=selected_track) return ;



	if (selected_track<0)  {

		return;
	}

	// Main Screen
	track_properties_updating_in_progress=true;

	togglebutton_track_mute->set_active(song->get_instrument(selected_track)->mute);
	entry_track_name->set_text(song->get_instrument(selected_track)->name);

	// Instrument tab

	request_update_combobox_devices(track_number);
	request_update_combobox_banks(track_number);
	request_update_clist_patches(track_number);
	spinbutton_track_channel->set_value(song->get_instrument(selected_track)->midi.channel.get()+1);

	// Initial Variables tab

	spinbutton_track_def_volume->set_value(song->get_instrument(selected_track)->def_volume.get());
	spinbutton_track_glb_volume->set_value(song->get_instrument(selected_track)->glb_volume.get());
	spinbutton_track_bender_sens->set_value(song->get_instrument(selected_track)->midi.PBS.get());
	spinbutton_track_bender_def->set_value(song->get_instrument(selected_track)->midi.DBV.get());
        spinbutton_track_volume_post_controller->set_value(song->get_instrument(selected_track)->PNVA_controller.get());

	switch (song->get_instrument(selected_track)->PNVA_type.get()) {

		case Instrument::PNVA_NOTHING: {

		        radiobutton_tracker_post_volume_nothing->set_active(true);
		} break;
		case Instrument::PNVA_NOTE_AFTERTOUCH: {

		        radiobutton_tracker_post_volume_note_aftertouch->set_active(true);
		} break;
		case Instrument::PNVA_CHAN_AFTERTOUCH: {

		        radiobutton_tracker_post_volume_channel_aftertouch->set_active(true);
		} break;
		case Instrument::PNVA_CONTROLLER: {

		        radiobutton_tracker_post_volume_controller->set_active(true);
		} break;
	}

	switch (song->get_instrument(selected_track)->VCB.get()) {

		case Instrument::VCB_NORMAL: {

		        radiobutton_track_volume_behavior_normal->set_active(true);
		} break;
		case Instrument::VCB_TRACKER: {

		        radiobutton_track_volume_behavior_tracker->set_active(true);
		} break;
	}

	request_update_controller_spinbuttons();

	for (i=0;i<initial_values.size();i++) {

		delete initial_values[i];

	}

	initial_values.resize(song->get_instrument(selected_track)->initial_value.size());

	I=song->get_instrument(selected_track)->initial_value.begin();

	for (i=0;i<initial_values.size();i++) {
            	
		string new_name;

		switch (I->type) {

			case Instrument::Initial_Value::CONTROLLER: {

				new_name=" - "+CURRENT_DEVICE->instrument_map.controller_names[I->controller];
			} break;
		}

        	Initial_Value_Line * new_value_line= new Initial_Value_Line(new_name,&I->value);
	        new_value_line->button_value_delete->clicked.connect(SigC::bind<int>(slot(this,&Interface::button_value_delete_pressed),i));
		initial_values[i]=new_value_line;
		vbox9->pack_start(*new_value_line,false, false, 2);
		I++;
		
	}

	track_properties_updating_in_progress=false;




}

/*****************************************************
		VIRTUAL DEVICES
******************************************************/


void Interface::update_clist_virtual_devices () {

	int i;

	gchar *pepe[1]={"kakaz"};

	clist_virtual_devices->clear();
	
	if (song->user_devices.get_device_count()>0) virtual_devices_enabled(true);
	else {
		
		virtual_devices_enabled(false);
		virtual_devices_bank_properties_set_enabled(false);

	}


 	if (song->user_devices.get_device_count()==0) return;

	for(i=0;i<song->user_devices.get_device_count();i++) {

		pepe[0]=(gchar*)song->user_devices.get_device(i)->name.c_str();
		clist_virtual_devices->append(pepe);

	}

	clist_virtual_devices->row(selected_device).select();
}


void Interface::update_entry_virtual_device_name (int device_number) {

	if (device_number!=selected_device) return ;

	entry_virtual_device_name->set_text(song->user_devices.get_device(device_number)->name);	

}

void Interface::update_combobox_hardware_devices() {


	int i;
	list<string> gl;
	string tmpstring;
	char *tmpcstring;
	string tmphardwaredev;

	for (i=0;i<midiout->GetDevicesCount();i++) {

                if (midiout->is_device_enabled(i)) {

			tmpcstring=return_cstring_from_string_with_number(i,midiout->GetDeviceName(i));
			tmpstring=tmpcstring;
	
			if (i==song->user_devices.get_device(selected_device)->hardware_device_index) tmphardwaredev=tmpcstring;
	
			gl.push_back(tmpstring);
			free(tmpcstring);
		}

	}

        combo_virtual_device_hardware_output->set_popdown_strings(gl);
        combo_virtual_device_hardware_output->get_entry()->set_text(tmphardwaredev);

}


void Interface::update_clist_aviable_banks (int device_number) {

	int i;

	gchar *pepe[1]={"kakaz"};

	if (device_number!=selected_device) return ;

	if (selected_bank>=song->user_devices.get_device(selected_device)->instrument_map.get_banks_count()) selected_bank=song->user_devices.get_device(selected_device)->instrument_map.get_banks_count()-1;

	virtual_devices_bank_properties_set_enabled(song->user_devices.get_device(selected_device)->instrument_map.get_banks_count()>0);

	clist_aviable_banks->clear();

	for(i=0;i<song->user_devices.get_device(device_number)->instrument_map.get_banks_count();i++) {

		pepe[0]=(gchar*)song->user_devices.get_device(device_number)->instrument_map.bank[i]->name.c_str();
		clist_aviable_banks->append(pepe);
	}

	clist_aviable_banks->row(selected_bank).select();
}


void Interface::update_clist_bank_patchnames(int device_number,int bank_number) {

	int i;

	if (device_number!=selected_device) return ;
	if (bank_number!=selected_bank) return ;


	gchar *pepe[1]={"kakaz"};

	clist_bank_patchnames->freeze();

	clist_bank_patchnames->clear();

	for(i=0;i<128;i++) {

		pepe[0]=return_cstring_from_string_with_number(i+1,song->user_devices.get_device(device_number)->instrument_map.bank[bank_number]->patch_names[i]);
		clist_bank_patchnames->append(pepe);
		free (pepe[0]); // must free it, must free it !
	}

	clist_bank_patchnames->thaw();

}

void Interface::request_update_patchnames_info(int device_number,int bank_number,int patch_number) {

	if (device_number!=selected_device) return ;
	if (bank_number!=selected_bank) return ;
	if (patch_number!=selected_patch) return ;

	virtual_device_patches_updating_in_progress=true;

	entry_bank_patchname->set_text(song->user_devices.get_device(device_number)->instrument_map.bank[bank_number]->patch_names[selected_patch]);
	
	virtual_device_patches_updating_in_progress=false;

}

void Interface::update_entry_bank_name(int device_number,int bank_number) {

	if (device_number!=selected_device) return ;
	if (bank_number!=selected_bank) return ;

	entry_bank_name->set_text(song->user_devices.get_device(device_number)->instrument_map.bank[bank_number]->name);	
	update_clist_bank_patchnames(selected_device,selected_bank);

}

void Interface::request_update_bank_info(int device_number,int bank_number) {

	if (device_number!=selected_device) return ;
	if (bank_number!=selected_bank) return ;

	virtual_device_banks_updating_in_progress=true;

	update_entry_bank_name(device_number,bank_number);

	spinbutton_bank_lsb->set_value(song->user_devices.get_device(device_number)->instrument_map.bank[bank_number]->LSB);
	spinbutton_bank_msb->set_value(song->user_devices.get_device(device_number)->instrument_map.bank[bank_number]->MSB);
	entry_bank_customstring->set_text(song->user_devices.get_device(device_number)->instrument_map.bank[bank_number]->custom_bank_select_string);

	switch (song->user_devices.get_device(device_number)->instrument_map.bank[bank_number]->bank_select_method) {
		case 0: {
	
			radio_bsm_option1->set_active(true);
		} break;
		case 1: {
	
			radio_bsm_option2->set_active(true);
		} break;
		case 2: {
	
			radio_bsm_option3->set_active(true);
		} break;

	}

        selected_patch=0;
	request_update_patchnames_info(selected_device,selected_bank,selected_patch);

	virtual_device_banks_updating_in_progress=false;
}

void Interface::update_clist_bank_controller_names(int device_number) {

	int i;

	if (device_number!=selected_device) return ;

	gchar *pepe[1]={"kakaz"};

	clist_bank_controller_names->freeze();

	clist_bank_controller_names->clear();

	for(i=0;i<128;i++) {

		pepe[0]=return_cstring_from_string_with_number(i,song->user_devices.get_device(device_number)->instrument_map.controller_names[i]);
		clist_bank_controller_names->append(pepe);
		free (pepe[0]); // must free it, must free it !
	}

	clist_bank_controller_names->thaw();

}


void Interface::request_update_controllers_info(int device_number) {

	if (device_number!=selected_device) return ;

	virtual_device_controllers_updating_in_progress=true;

	entry_controller_name->set_text(song->user_devices.get_device(device_number)->instrument_map.controller_names[selected_controller]);

	virtual_device_controllers_updating_in_progress=false;
}



void Interface::request_update_virtual_devices(int device_number) {

	if (device_number!=selected_device) return ;

	virtual_device_updating_in_progress=true;	
	
	update_entry_virtual_device_name(device_number);
	update_clist_aviable_banks (device_number);
	update_clist_bank_controller_names(device_number);
	update_combobox_hardware_devices();

	selected_bank=0;

	if (song->user_devices.get_device(selected_device)->instrument_map.get_banks_count()>0) {

		request_update_bank_info(device_number,selected_bank);
	}


	selected_controller=0;
	request_update_controllers_info(selected_device);

	virtual_device_updating_in_progress=false;	
}

/********************************
        SONG INFO / SPEED
*********************************/


void Interface::request_song_info_speed_update() {

	song_speed_and_info_updating_in_progress = true;

	spinbutton_song_rpq->set_value(song->speed.rpq);
	spinbutton_song_tempo->set_value(song->speed.tempo);

	song_speed_and_info_updating_in_progress = false;

}

/********************************
        DRIVERS/SYSINFO
*********************************/

void Interface::update_clist_driver_list() {

	int i;


	gchar *pepe[1]={"kakaz"};


	clist_drivers_list->clear();

	for(i=0;i<midiout->GetDevicesCount();i++) {

		pepe[0]=return_cstring_from_string_with_number(i,midiout->GetDeviceName(i));
		clist_drivers_list->append(pepe);
		free(pepe[0]); // must free it, must free it !
	}


}

void Interface::update_midiout_drivers() {

	midiout_drivers_updating_in_progress=true;

	entry_drivers_parent->set_text(midiout->GetParentDeviceName(selected_midiout));
	checkbutton_drivers_disable->set_active(midiout->is_device_enabled(selected_midiout));
	//	textarea_drivers_description->forward_delete(500); // how the fuck do i clear the textbox?
	//	textarea_drivers_description->insert(midiout->GetParentDeviceInfo(row));

	midiout_drivers_updating_in_progress=false;
}


void Interface::update_system_status_box() {

	if ((player==NULL) || (song==NULL)) return;

	int tmp_timer_freq;
	char tmp_string[20];

//	tmp_timer_freq=player->timer->get_minimum_frequency();
	
//	sprintf(tmp_string,"%i ms",tmp_timer_freq);

//	label_system_freemem->set_text(tmp_string);
	
//	label_system_eventsused->set_text("N/A");
/*
	if (player->get_preprocess_amount()==1) {

		label_system_totalevents->set_text("Realtime");

	} else {


		sprintf(tmp_string,"%i ms",tmp_timer_freq*player->get_preprocess_amount());
		label_system_totalevents->set_text(tmp_string);

	}
*/

	label_system_totalrows->set_text("              -");


//   label_system_totalevents = new Gtk::Label("hhum");
//   label_system_totalrows = new Gtk::Label("blahblah");

//	sprintf(tmp_string,"%i",Column::event_count);
	
//	label_system_totalpatterns->set_text(tmp_string);

	sprintf(tmp_string,"%i",song->get_tracks());
	
	label_system_totaltracks->set_text(tmp_string);

}