/***************************************************************************
                          devicelist.h  -  description
                             -------------------
    begin                : Mon Oct 16 2000
    copyright            : (C) 2000 by Juan Sebastian Linietsky
    email                : reduz@anime.com.ar
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef DEVICELIST_H
#define DEVICELIST_H

#define MAX_DEVICES 100

#include "typedefs.h"
#include "instrumentmap.h"
#include "file_reader.h"
#include "file_writer.h"

/**Container of the List of Devices
  *@author Juan Sebastian Linietsky
  */



class User_Device_List {

	struct User_Device {

		string name;
		char hardware_device_index; // -1 = nothing
		InstrumentMap instrument_map;
		User_Device();
	};

	int device_count;
	User_Device *device[MAX_DEVICES];

public:
	
	User_Device* get_device(int device_index);

	void add_device();
	void delete_device(int devicenum);

	//file operations
	bool load_device_from_reader(File_Reader *file_reader);
	bool save_device_to_writer(int device_number,File_Writer *file_writer);

	void load_device(string filename);
	void save_device(int devicenum,string filename);

        //get amount of registered virtual devices
	int get_device_count() { return device_count; };

	User_Device_List();
	~User_Device_List();
};

#endif
