/***************************************************************************
                          effect_misc.h  -  description
                             -------------------
    begin                : Wed Oct 17 2001
    copyright            : (C) 2001 by Juan Sebastian Linietsky
    email                : reduz@anime.com.ar
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "effect.h"
#include "event_basic.h"


class Effect_Retrigger : public Effect  {

	int volume_change,time_to_retrigger;
	int counter;
	char current_note,current_volume;

public:

	void notify_command(Uint8 p_parameter) {

		if ((p_parameter&0xF)!=0) {

			int aux_volchange=p_parameter>>4;

			if (aux_volchange<8) {

				volume_change=0-aux_volchange;
			} else {

				volume_change=aux_volchange-8;
			}


			time_to_retrigger=30*(p_parameter&0xF);
			counter=0;
		}
	}
	int notify_begin(Uint8 p_note,Uint8 p_volume,Uint8 p_old_note) {

      		if (p_note<128) {

			current_note=p_note;
			current_volume=(p_volume<65)?p_volume:data->song->get_instrument(track)->def_volume.get();

		} else if (p_old_note<128) {

			current_note=p_old_note;

		} else return PROCESS_NOTE;

		return PROCESS_NOTE|PROCESS_COMMAND;
	}

       	void process(int p_time_amount,int p_time_offset) {

		int i;
		int real_offset=p_time_offset-p_time_amount;

		if (time_to_retrigger==0) return;
			
		for (i=0;i<p_time_amount;i++) {

			if ((counter % time_to_retrigger)==0) {

			        Event_NoteOn *noteon_event = new Event_NoteOn;
				noteon_event->set_note(current_note,current_volume);
				queue->push(real_offset,track,column,noteon_event);
				current_volume+=volume_change;
				if (current_volume>64) current_volume=64;
				if (current_volume<0) current_volume=0;
			}

			counter++;
			real_offset++;			
		}
	}
	Effect_Retrigger() {
		processing=true;
	}
};

class Effect_Arpegio : public Effect  {

	int counter,event_counter;
	char note1,note2;
	int resolution;

public:

	void notify_command(Uint8 p_parameter) {

		if (p_parameter!=0) {

			note1=p_parameter>>4;
			note2=p_parameter&0xF;
		}
	}

	void stop_notify() {

		Event_Pitch_Virtual *pitch_event = new Event_Pitch_Virtual;
		pitch_event->set_pitch(0);
		queue->push(0,track,column,pitch_event);
	}

       	void process(int p_time_amount,int p_time_offset) {

		int i;
		int real_offset=p_time_offset-p_time_amount;

		for (i=0;i<p_time_amount;i++) {

			if ((counter % resolution)==0) {


				Event_Pitch_Virtual *pitch_event = new Event_Pitch_Virtual;



				switch (event_counter % 3) {

                                 	case 0: {
						pitch_event->set_pitch(0);
					} break;
                                 	case 1: {

						pitch_event->set_pitch((note1*0x2000)/data->song->get_instrument(track)->midi.PBS.get());
					} break;
                                 	case 2: {

						pitch_event->set_pitch((note2*0x2000)/data->song->get_instrument(track)->midi.PBS.get());
					} break;

				}

				queue->push(real_offset,track,column,pitch_event);
				event_counter++;
			}

			counter++;
			real_offset++;			
		}
	}
	Effect_Arpegio() {
		processing=true;
		resolution=30;
		counter=0;
		event_counter=0;
	}


};
