/***************************************************************************
                          effect_table.cpp  -  description
                             -------------------
    begin                : Sun Sep 16 2001
    copyright            : (C) 2001 by Juan Sebastian Linietsky
    email                : reduz@anime.com.ar
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "effect_table.h"

const char* Effect_Table::effect_names[Effect_Table::MAX_COMMANDS] = {
	"Set RPQ",
	"Break to order",
	"Break to row of next order",
	"Volume slide",
	"Pich slide down",
	"Pitch slide up",
	"Pitch slide to note",
	"Pitch Vibrato",
	"Undefined",
	"Arpeggio",
	"Dual D & H",
	"Undefined",
	"Track volume (cont. 07)",
	"Undefined",
	"Channel pressure",
	"Pan slide",
	"Note retrigger",
	"Tremolo",
	"Special",
	"Set Tempo/Slide Tempo",
	"Undefined",
	"Alternate Volume",
	"Undefined",
	"Set Pan (cont. 10)",
	"Panbrello (pan vibrato)",
	"Undefined",
	"Macro 1",
	"Macro 2",
	"Macro 3",
	"Macro 4",
	"Macro 5",
	"Macro 6",
	"Macro 7",
	"Macro 8",
	"Macro 9",
	"Macro 10"
};
	


void Effect_Table::register_effect(Effect *p_effect,int p_name) {


        if ((p_name<0) || (p_name>MAX_COMMANDS)) {

		ERROR("request for invalid insertion " << p_name);
		return;
	}

	p_effect->set_event_queue(queue);
	p_effect->set_player_data(data);
	p_effect->set_track(track);
	p_effect->set_column(column);

	table[p_name]=p_effect;
}
Effect* Effect_Table::get_effect(int p_name) {
        if ((p_name<0) || (p_name>MAX_COMMANDS)) {

		ERROR("request for invalid effect " << p_name);
		return NULL;
	}

	return table[p_name];
}

void Effect_Table::set_queue(Event_Queue *p_queue) {
        int i;

	if (queue==p_queue) return;
	queue=p_queue;
	for (i=0;i<MAX_COMMANDS;i++) table[i]->set_event_queue(queue);
	
}
void Effect_Table::set_data(Player_Data *p_data) {

        int i;
	if (data==p_data) return;
	data=p_data;
	for (i=0;i<MAX_COMMANDS;i++) table[i]->set_player_data(data);
}

void Effect_Table::set_track(int p_track) {

        int i;
	if (track==p_track) return;
	track=p_track;
	for (i=0;i<MAX_COMMANDS;i++) table[i]->set_track(track);
}
void Effect_Table::set_column(int p_column) {

        int i;
	if (column==p_column) return;
	column=p_column;
	for (i=0;i<MAX_COMMANDS;i++) table[i]->set_column(column);

}
Effect_Table::Effect_Table(Event_Queue *p_queue,Player_Data *p_data,int p_track,int p_column) {

	int i;

	/* null as default */
	for (i=0;i<MAX_COMMANDS;i++) table[i]=&null_effect;

	column=p_column;
	track=p_track;
	data=p_data;
	queue=p_queue;
	/* register */

	register_effect(&e_rpq,COMMAND_A);
        register_effect(&e_volslide,COMMAND_D);	
	register_effect(&e_pitch_down,COMMAND_E);
	register_effect(&e_pitch_up,COMMAND_F);
	register_effect(&e_portamento,COMMAND_G);
	register_effect(&e_vibrato,COMMAND_H);
	register_effect(&e_arpegio,COMMAND_J);
        register_effect(&e_channel_volume,COMMAND_M);
        register_effect(&e_aftertouch_set,COMMAND_O);
	register_effect(&e_pan_slide,COMMAND_P);
	register_effect(&e_retrigger,COMMAND_Q);
        register_effect(&e_tremolo,COMMAND_R);	
	register_effect(&e_special,COMMAND_S);
	register_effect(&e_tempo,COMMAND_T);
        register_effect(&e_pan_set,COMMAND_X);
        register_effect(&e_panbrello,COMMAND_Y);


	/* config */

}




Effect_Table::Effect_Table(){

}
Effect_Table::~Effect_Table(){
//	for (i=0;i<MAX_COMMANDS;i++) if (table[i]!=&null_effect) delete table[i];
}
