/***************************************************************************
                          event_execute_utils.cpp  -  description
                             -------------------
    begin                : Wed Sep 19 2001
    copyright            : (C) 2001 by Juan Sebastian Linietsky
    email                : reduz@anime.com.ar
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "event_execute.h"

char Event_Execute::convert_volume_to_velocity(int p_track,Uint8 p_volume) {

	int tmpvol;

	if (p_volume>64) p_volume=song->get_instrument(p_track)->def_volume.get();
	tmpvol=p_volume;
	tmpvol=tmpvol*127/64;

	return tmpvol;
}

void Event_Execute::stop_channel(int p_track,int p_column) {

	if (track[p_track].column[p_column].note<128) midiout->send_MIDI_noteoff(get_hw_device(p_track),get_hw_channel(p_track),track[p_track].column[p_column].note,127);
	track[p_track].column[p_column].note=Note::CLEAR;
}

void Event_Execute::stop_note_in_another_track (int p_track,int p_column,char p_note) {

	bool tmpres;
	int j;
	tmpres=false;

/* fixme: Que se fije si hay otros tracs con lo mismo..ofkoz.

	for(i=0;i<song->get_tracks_used();i++) {

		for(j=0;j<song->track[i]->width();j++) {

			if (trackdata[i].column[j].current_note-1==note) {

				if ((i!=track) || (j!=column)) {

					stop_channel(i,j);
				}
			}
		}
	}

*/
		for(j=0;j<song->get_track_width(p_track);j++) {

			if (track[p_track].column[j].note==p_note) {

				if ((j!=p_column)) {

					stop_channel(p_track,j);
				}
			}
		}

}


