/***************************************************************************
                          note.h  -  description
                             -------------------
    begin                : Sat Sep 16 2000
    copyright            : (C) 2000 by Juan Sebastian Linietsky
    email                : reduz@anime.com.ar
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#ifndef __NOTE_H
#define __NOTE_H

#include "typedefs.h"

/*

	That's it. Just a note.

*/

class Note {
public:

	enum {

		CLEAR=255,
		OFF=254,
		CUT=253,
                NOTES=128
	};		

	int note; /* note to be played 1-128 0 = no note*/
	Uint8 volume; /* volume of the note (0-127) */
	Uint8 command; /* Tracker Commands */
	Uint8 parameter; /* Parameter */
	Uint8 controller_set; /* 0-127 is the controller 128+ effects for them */
	Uint8 controller_value; /* Parameter for this */
	
	void clear () {
	
		note=command=controller_set=CLEAR;
		parameter=controller_value=0;
		volume=65;
	};
	
	void raise () {

		if (note==0 || note>NOTES) return;
		note++;
		if (note>NOTES) note=NOTES;
	}

	void lower () {

		if (note==0 || note>128) return;
		note--;
		if (note<1) note=1;
	}


	bool operator= (Note rvalue) {

		note=rvalue.note;
		volume=rvalue.volume;
		command=rvalue.command;
		parameter=rvalue.parameter;
		controller_set=rvalue.controller_set;
		controller_value=rvalue.controller_value;

		return true;
	};
	
	bool operator== (Note rvalue) {

		if (note==rvalue.note && volume==rvalue.volume &&
		command==rvalue.command && parameter==rvalue.parameter &&
		controller_set==rvalue.controller_set &&
		controller_value==rvalue.controller_value)
		return true; else return false;	
	}

	Note() {

		clear();
	}
};


#endif
