/***************************************************************************
                          song.h  -  description
                             -------------------
    begin                : Mon Sep 18 2000
    copyright            : (C) 2000 by Juan Sebastian Linietsky
    email                : reduz@anime.com.ar
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef SONG_H
#define SONG_H

#include "track.h"
#include "devicelist.h"

// STL stuff
#include <list>
#include <vector>

class Song;

#define SHAKETRACKER_VERSION_MAJOR 0
#define SHAKETRACKER_VERSION_MINOR 3
#define SHAKETRACKER_VERSION_REVISION 9


/**
  *@author Juan Sebastian Linietsky
  */

class Song {

	/* Version info of the tracker */
	struct Version {
	
		char major;
		char minor;
		char revision;
	} version;

	struct Track_Cache {

		int track,column;
	};

	struct Pattern_Cache {

		int pattern,row;
	};

	vector<Track_Cache> track_cache;
	vector<Pattern_Cache> pattern_cache;
	
	void regenerate_track_cache();
	void regenerate_pattern_cache();

	int tracks;
        int new_track_counter;
	/* tracks, containing MIDI instrument info and patterns for it */

	vector<Track*> track;
	vector<int> order;

	/* Tracks data */
        Track::Pattern_Data pattern_data;
        Track* get_track(int p_track);
public:

	enum Order_Type {

		ORDER_SKIP=-2,
		ORDER_CLEAR=-1
	};

	/* Song Information */
	struct Song_Info {

		string name;
		string author;
		string comments;
                string current_filename;
	} info;

	/* Song Speed Information */

	struct Song_Speed {

		Uint8 rpq; // rows_per_quarter_note
		Uint8 tempo;

	} speed;

	/* Orderlist Data */

	int get_order(int p_position);
	void set_order(int p_position, int p_order);
	int get_next_order(int p_position);
	int get_max_order();
	int find_order(int p_pattern);

	/* Track Data */

 	void add_track(int p_columns=1);
	void delete_track(int p_track);
	void clone_track(int p_track);
	void add_track_column(int p_track);
	void remove_track_column(int p_track);

	int get_track_width(int p_track);

	bool move_track_up(int p_track); //move one track to the previous slot
	bool move_track_down(int p_track); //move one track to the previous slot

	int get_tracks() { return tracks; }

	Instrument *get_instrument(int p_track);

	/*Pattern Data*/

	void set_pattern_length(int p_pattern,int p_length);
	int get_pattern_length(int p_pattern);

	void set_pattern_hl_minor(int p_pattern,int p_hl);
	int get_pattern_hl_minor(int p_pattern);

	void set_pattern_hl_major(int p_pattern,int p_hl);
	int get_pattern_hl_major(int p_pattern);
	 int get_patterns();

	/* Note Data */

	Note abs_note(int p_column,int p_row);
	Note& abs_note_ref(int p_column,int p_row);

	Note get_note(int p_track,int p_pattern,int p_column,int p_row);
	Note& get_note_ref(int p_track,int p_pattern,int p_column,int p_row);

	int get_abs_pattern(int p_row);
	int get_abs_row(int p_row);
	int get_abs_column(int p_column);
	int get_abs_track(int p_column);
	int get_abs_width();
	int get_abs_height();
	int get_global_row(int p_row,int p_pattern);
	/* User-Created devices */
	User_Device_List user_devices;

	int find_unused_channel(int p_track);

/*Gotta Move this out*/
	/* Midi out. I'll remove this from here soon */
//	MidiOutDeviceManager midiout;


	/* Track dealing methods */

	/* Current File Operations */
//	void clear_all();
//	void save(const char *filename);
//	void save_current();
//        void load(const char *filename);

	string get_version_string();	
	void reset();

	Song();
	~Song();
};



#endif
