#import "GSDrawFunctions.h"

@interface NSProgressIndicator (theme)
@end

@implementation NSProgressIndicator (theme)

- (void)drawRect:(NSRect)rect
{
   NSRect       r;

   // Draw the Bezel
   if (_isBezeled)
     {
       // Calc the inside rect to be drawn
       r = [GSDrawFunctions drawGrayBezelRound: _bounds :rect];
     }
   else
     r = _bounds;

   if (_isIndeterminate)                // Draw indeterminate
     {
       // FIXME: Do nothing at this stage
     }
   else                         // Draw determinate 
     {
       if (_doubleValue > _minValue)
         {
           double val;
           
           if (_doubleValue > _maxValue)
             val = _maxValue - _minValue;
           else  
             val = _doubleValue - _minValue;
  
           if (_isVertical)
             r.size.height = NSHeight(r) * (val / (_maxValue - _minValue));
           else
             r.size.width = NSWidth(r) * (val / (_maxValue - _minValue));
           r = NSIntersectionRect(r,rect);
           if (!NSIsEmptyRect(r))
             {
		NSBezierPath* inside = [NSBezierPath bezierPath];
		float radius = 8;
		r.size.height-=1;
		r.origin.y +=1;
		if ((r.size.height < 20) || (r.size.width < 20)) { radius = 4; }
		if ((r.size.height < 10) || (r.size.width < 10)) { radius = 2; }
		[inside appendBezierPathWithRoundedRectangle: r withRadius: radius];
                [[NSColor blueColor] set];
		[[NSColor colorWithCalibratedRed: 0.0 green: 0.0 blue: 0.0 alpha: 0.2] set];
		[inside fill];
		[[NSColor colorWithCalibratedRed: 0.0 green: 0.0 blue: 0.0 alpha: 0.5] set];
		[inside stroke];
             }
         }
     }
}

@end
