
/* $Id: stdebug.h,v 400.1 2002/07/25 08:43:16 sgifford Exp $ */

#ifndef STDEBUG_H
#define STDEBUG_H

#include <stdarg.h>

int dumpbuf_cont(const char *buf, int size);
int dumpbuf_start(const char *buf, int size);
int dumpbuf_end(void);
int dumpbuf(const char *buf, int size);
int setdebuglevel(int newlevel);
int debuglevel(int testlevel);

int debugf(int minlevel, const char *format, ...)
#ifdef __GNUC__
  __attribute__ ((format (printf, 2, 3)))
#endif
  ;

void die(const char *format, ...)
#ifdef __GNUC__
  __attribute__ ((format (printf, 1, 2)))
#endif
  ;
  

void warn(const char *format, ...)
#ifdef __GNUC__
  __attribute__ ((format (printf, 1, 2)))
#endif
  ;
  
void errdump(const char *format, ...)
#ifdef __GNUC__
  __attribute__ ((format (printf, 1, 2)))
#endif
  ;

int errorf(const char *format, ...)
#ifdef __GNUC__
  __attribute__ ((format (printf, 1, 2)))
#endif
  ;

int reterr(int ret, const char *format, ...)
#ifdef __GNUC__
  __attribute ((format (printf, 2, 3)))
#endif
  ;
  
int vreterr(int ret, const char *format, va_list a);
void clearerrors(void);
void finished(void);

#endif /* STDEBUG_H */
