/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;

public final class Color {
    public float[] handle;
    Device device;

    Color() {
    }

    public Color(Device device, int red, int green, int blue) {
        this.init(device, red, green, blue);
    }

    public Color(Device device, RGB rgb) {
        if (rgb == null) {
            SWT.error(4);
        }
        this.init(device, rgb.red, rgb.green, rgb.blue);
    }

    public void dispose() {
        if (this.handle == null) {
            return;
        }
        if (this.device.isDisposed()) {
            return;
        }
        this.device = null;
        this.handle = null;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Color)) {
            return false;
        }
        Color color = (Color)object;
        float[] rgbColor = color.handle;
        if (this.handle == rgbColor) {
            return true;
        }
        return this.device == color.device && this.handle[0] == rgbColor[0] && this.handle[1] == rgbColor[1] && this.handle[2] == rgbColor[2];
    }

    public int getBlue() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return (int)(this.handle[2] * 255.0f);
    }

    public int getGreen() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return (int)(this.handle[1] * 255.0f);
    }

    public int getRed() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return (int)(this.handle[0] * 255.0f);
    }

    public int hashCode() {
        if (this.isDisposed()) {
            return 0;
        }
        return (int)(this.handle[0] * 255.0f) ^ (int)(this.handle[1] * 255.0f) ^ (int)(this.handle[2] * 255.0f);
    }

    public RGB getRGB() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return new RGB(this.getRed(), this.getGreen(), this.getBlue());
    }

    public static Color carbon_new(Device device, float[] rgbColor) {
        if (device == null) {
            device = Device.getDevice();
        }
        Color color = new Color();
        color.handle = rgbColor;
        color.device = device;
        return color;
    }

    void init(Device device, int red, int green, int blue) {
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        this.device = device;
        if (red > 255 || red < 0 || green > 255 || green < 0 || blue > 255 || blue < 0) {
            SWT.error(5);
        }
        float[] rgbColor = new float[]{(float)red / 255.0f, (float)green / 255.0f, (float)blue / 255.0f, 1.0f};
        this.handle = rgbColor;
    }

    public boolean isDisposed() {
        return this.handle == null;
    }

    public String toString() {
        if (this.isDisposed()) {
            return "Color {*DISPOSED*}";
        }
        return "Color {" + this.getRed() + ", " + this.getGreen() + ", " + this.getBlue() + "}";
    }
}

