/*
 * Decompiled with CFR 0.152.
 */
package swingwt.awt.image;

import java.util.HashMap;
import swingwt.awt.image.ImageConsumer;
import swingwt.awt.image.ImageFilter;
import swingwt.awt.image.ImageProducer;

public class FilteredImageSource
implements ImageProducer {
    ImageProducer imageProducer;
    ImageFilter imageFilter;
    HashMap consumers = new HashMap();

    public FilteredImageSource(ImageProducer imageProducer, ImageFilter imageFilter) {
        this.imageProducer = imageProducer;
        this.imageFilter = imageFilter;
    }

    public void addConsumer(ImageConsumer imageConsumer) {
        if (this.consumers.containsKey(imageConsumer)) {
            return;
        }
        ImageFilter filter = this.imageFilter.getFilterInstance(imageConsumer);
        this.consumers.put(imageConsumer, filter);
        this.imageProducer.addConsumer(filter);
    }

    public boolean isConsumer(ImageConsumer imageConsumer) {
        ImageFilter filter = (ImageFilter)this.consumers.get(imageConsumer);
        if (filter != null) {
            return this.imageProducer.isConsumer(filter);
        }
        return false;
    }

    public void removeConsumer(ImageConsumer imageConsumer) {
        ImageFilter filter = (ImageFilter)this.consumers.remove(imageConsumer);
        if (filter != null) {
            this.imageProducer.removeConsumer(filter);
        }
    }

    public void startProduction(ImageConsumer imageConsumer) {
        ImageFilter filter;
        if (!this.consumers.containsKey(imageConsumer)) {
            filter = this.imageFilter.getFilterInstance(imageConsumer);
            this.consumers.put(imageConsumer, filter);
            this.imageProducer.addConsumer(filter);
        } else {
            filter = (ImageFilter)this.consumers.get(imageConsumer);
        }
        this.imageProducer.startProduction(filter);
    }

    public void requestTopDownLeftRightResend(ImageConsumer imageConsumer) {
        ImageFilter filter = (ImageFilter)this.consumers.get(imageConsumer);
        this.imageProducer.requestTopDownLeftRightResend(filter);
    }
}

