/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dnd;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.util.Geometry;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tracker;
import org.eclipse.ui.internal.DragCursors;
import org.eclipse.ui.internal.dnd.DragListener;
import org.eclipse.ui.internal.dnd.IDragOverListener;
import org.eclipse.ui.internal.dnd.IDragSource;
import org.eclipse.ui.internal.dnd.IDropTarget;

public class DragUtil {
    private static final String DROP_TARGET_ID = "org.eclipse.ui.internal.dnd.dropTarget";
    private static DragListener listener = new DragListener();
    private static List defaultTargets = new ArrayList();

    public static void addDragTarget(Control control, IDragOverListener target) {
        if (control == null) {
            defaultTargets.add(target);
        } else {
            control.setData(DROP_TARGET_ID, (Object)target);
        }
    }

    public static void removeDragTarget(Control control, IDragOverListener target) {
        if (control == null) {
            defaultTargets.remove(target);
        } else {
            control.setData(DROP_TARGET_ID, null);
        }
    }

    public static Rectangle getDisplayBounds(Control boundsControl) {
        Composite parent = boundsControl.getParent();
        if (parent == null) {
            return boundsControl.getBounds();
        }
        return Geometry.toDisplay((Control)parent, (Rectangle)boundsControl.getBounds());
    }

    public static boolean performDrag(Object draggedItem, Rectangle sourceBounds) {
        return DragUtil.performDrag(draggedItem, sourceBounds, Display.getDefault().getCursorLocation(), false);
    }

    public static boolean performDrag(Object draggedItem, Rectangle sourceBounds, Point initialLocation, boolean allowSnapping) {
        IDropTarget target = DragUtil.dragToTarget(draggedItem, sourceBounds, initialLocation, allowSnapping);
        if (target == null) {
            return false;
        }
        target.drop();
        return true;
    }

    static IDropTarget dragToTarget(final Object draggedItem, final Rectangle sourceBounds, final Point initialLocation, final boolean allowSnapping) {
        Control startControl;
        final Display display = Display.getDefault();
        final Tracker tracker = new Tracker(display, 0);
        tracker.setStippled(true);
        tracker.addListener(10, new Listener(){

            public void handleEvent(Event event) {
                display.syncExec(new Runnable(this, event, display, draggedItem, tracker, allowSnapping, sourceBounds, initialLocation){
                    final /* synthetic */ 1 this$1;
                    private final /* synthetic */ Event val$event;
                    private final /* synthetic */ Display val$display;
                    private final /* synthetic */ Object val$draggedItem;
                    private final /* synthetic */ Tracker val$tracker;
                    private final /* synthetic */ boolean val$allowSnapping;
                    private final /* synthetic */ Rectangle val$sourceBounds;
                    private final /* synthetic */ Point val$initialLocation;
                    {
                        this.this$1 = var1_1;
                        this.val$event = event;
                        this.val$display = display;
                        this.val$draggedItem = object;
                        this.val$tracker = tracker;
                        this.val$allowSnapping = bl;
                        this.val$sourceBounds = rectangle;
                        this.val$initialLocation = point;
                    }

                    public void run() {
                        Point location = new Point(this.val$event.x, this.val$event.y);
                        Control targetControl = this.val$display.getCursorControl();
                        IDropTarget target = DragUtil.getDropTarget(targetControl, this.val$draggedItem, location, this.val$tracker.getRectangles()[0]);
                        Rectangle snapTarget = null;
                        if (target != null) {
                            snapTarget = target.getSnapRectangle();
                            this.val$tracker.setCursor(target.getCursor());
                        } else {
                            this.val$tracker.setCursor(DragCursors.getCursor(0));
                        }
                        if (this.val$allowSnapping) {
                            Rectangle[] currentRectangles;
                            if (snapTarget == null) {
                                snapTarget = new Rectangle(this.val$sourceBounds.x + location.x - this.val$initialLocation.x, this.val$sourceBounds.y + location.y - this.val$initialLocation.y, this.val$sourceBounds.width, this.val$sourceBounds.height);
                            }
                            if ((currentRectangles = this.val$tracker.getRectangles()).length != 1 || !currentRectangles[0].equals((Object)snapTarget)) {
                                this.val$tracker.setRectangles(new Rectangle[]{snapTarget});
                            }
                        }
                    }
                });
            }
        });
        if (sourceBounds != null) {
            tracker.setRectangles(new Rectangle[]{new Rectangle(sourceBounds.x, sourceBounds.y, sourceBounds.width, sourceBounds.height)});
        }
        if ((startControl = display.getCursorControl()) != null) {
            startControl.setCapture(true);
        }
        boolean trackingOk = tracker.open();
        if (startControl != null) {
            startControl.setCapture(false);
        }
        Point finalLocation = display.getCursorLocation();
        IDropTarget dropTarget = null;
        if (trackingOk) {
            Control targetControl = display.getCursorControl();
            dropTarget = DragUtil.getDropTarget(targetControl, draggedItem, finalLocation, tracker.getRectangles()[0]);
        }
        tracker.dispose();
        return dropTarget;
    }

    public static void addDragSource(Control control, IDragSource source) {
        listener.attach(control, source);
    }

    public static void removeDragSource(Control control) {
        listener.detach(control);
    }

    public static IDropTarget getDropTarget(Control toSearch, Object draggedObject, Point position, Rectangle dragRectangle) {
        IDropTarget dropTarget;
        Control current = toSearch;
        while (current != null) {
            IDragOverListener target = (IDragOverListener)current.getData(DROP_TARGET_ID);
            if (target != null && (dropTarget = target.drag(toSearch, draggedObject, position, dragRectangle)) != null) {
                return dropTarget;
            }
            if (current instanceof Shell) break;
            current = current.getParent();
        }
        Iterator iter = defaultTargets.iterator();
        while (iter.hasNext()) {
            IDragOverListener next = (IDragOverListener)iter.next();
            dropTarget = next.drag(toSearch, draggedObject, position, dragRectangle);
            if (dropTarget == null) continue;
            return dropTarget;
        }
        return null;
    }
}

