/*
 * twlog:  A basic ham loging program using Motif
 * Copyright (C) 1997 Ted Williams WA0EIR (ted@bluestone.com)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be
 * useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU General Public License for more details.
 *
 * You should have recieved a copy of the GNU General Public
 * License along with this program; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge. MA 02139,
 * USA. See the COPYING file in this directory.
 *
 * Versions: 1.3 -  Feb 2001
 */

/*
 * main Function
 * Main defines a structure for the application defined resources,
 * initializes the toolkit, builds the widgets, initializes some
 * variables, and then realizes the widgets. 
 */

#include "twlog.h"
#include "twlog.xpm"

int  main (int argc, char *argv[])
{
   XtAppContext ac;
   LogRes log_res;
   struct stat buf;
   int length;
   Dimension h=0, w=0;
   XtActionsRec actions[] =
   {
      {"CRkey", CRkey}
   };

   Widget iconwin;
   Pixel bg;       	       
   Pixmap pixmap, mask;
   XpmAttributes pix_attributes;
   XpmColorSymbol transparentColor[1] = {{NULL, "none", 0}};

   /*
    * Describe the application defined resources. This struct is
    * for the app resources which are read in the resource
    * file.  See the resource file (Twlog) for more info.
    */
   XtResource app_res_desc[] =
   {
      {
      XmNdirpath,                    /* Name */
      XmCDirpath,                    /* Class */
      XmRString,                     /* Target data type */
      sizeof (char *),               /* size of target type */
      XtOffsetOf (LogRes, dirpath),  /* Offset into LogRes */
      XmRImmediate,                  /* Default data type */
      "bogus"                        /* Pointer to default value */
      },

      {
      XmNtzone,                      /* Same a above */
      XmCTzone,
      XmRInt,
      sizeof (int),
      XtOffsetOf (LogRes, tzone),
      XtRImmediate,
      (XtPointer)2                   /* Force an error if not found */
      },

      {
      XmNbands,                      /* Same a above */
      XmCBands,
      XmRXmStringTable,
      sizeof (XmStringTable),
      XtOffsetOf (LogRes, bands),
      XtRString,
      "Not Found"                    /* Default to "Not Found" */
      },

      {
      XmNdefault_band,               /* Same a above */
      XmCDefault_band,
      XmRInt,
      sizeof (int),
      XtOffsetOf (LogRes, default_band),
      XtRImmediate, 0                /* Default to first button*/
      },

      {
      XmNmodes,                      /* Same a above */
      XmCModes,
      XmRXmStringTable,
      sizeof (XmStringTable),
      XtOffsetOf (LogRes, modes),
      XtRString,
      "Not Found"                    /* Default to "Not Found" */
      },

      {
      XmNdefault_mode,               /* Same a above */
      XmCDefault_mode,
      XmRInt,
      sizeof (int),
      XtOffsetOf (LogRes, default_mode),
      XtRImmediate, 0                /* Default to first button*/
      },

      {
      XmNpower,                      /* Same a above */
      XmCPower,
      XmRXmStringTable,
      sizeof (XmStringTable),
      XtOffsetOf (LogRes, power),
      XtRString,
      "Not Found"                    /* Default to "Not Found" */
      },

      {
      XmNdefault_power,              /* Same a above */
      XmCDefault_power,
      XmRInt,
      sizeof (int),
      XtOffsetOf (LogRes, default_power),
      XtRImmediate, 0                /* Default to first button*/
      }
   };

   /*
    * Initialize the tool kit,create the application shell,
    * and get the app defined resources
    */
   logSH = XtVaAppInitialize (&ac, "Twlog", NULL, 0, &argc, argv, NULL,
              XmNmwmFunctions, MWM_FUNC_ALL | MWM_FUNC_CLOSE,
              XmNiconName, "TWLOG",
              NULL);

   XtGetApplicationResources (logSH, &log_res, app_res_desc,
      XtNumber (app_res_desc), NULL, 0);

   /*
    * Create Icon window and its pixmap
    */
   iconwin = XtVaAppCreateShell ("Iconwin", "logSH",
                wmShellWidgetClass, XtDisplay(logSH),
                XmNmappedWhenManaged, False,
                XmNwidth,  60,
                XmNheight, 40,
                NULL);

   XtVaGetValues (iconwin,
      XmNbackground, &bg,
      NULL);

   transparentColor[0].pixel = bg;
   pix_attributes.closeness = 40000;
   pix_attributes.valuemask = XpmColorSymbols | XpmCloseness;
   pix_attributes.colorsymbols = transparentColor;
   pix_attributes.numsymbols = 1;

   XpmCreatePixmapFromData (XtDisplay(logSH),
      DefaultRootWindow (XtDisplay(logSH)),
      twlog_xpm, &pixmap, &mask, &pix_attributes);
   
   /*
    * Build the widgets
    */
   build_widgets (logSH, log_res);

   /*
    * Initialize dirpath, and logpath.
    * This calculates the length of the dirpath resource +
    * MAXNAME, and mallocs space for it. Then, it copies
    * the resource string to it and cats LOGFILE on the end.
    * Finally, check the the path is valid.  The pointer for
    * the helpfile gets the same treatment.
    */ 
   length = strlen (log_res.dirpath + 1); /* +1 if we need a "/" on the end */
   dirpath = malloc (length);
   strcpy (dirpath, log_res.dirpath);

   if (stat (dirpath, &buf) == -1)        /* check to see if dirpath exists */
   {
      perror ("twlog");
      if (strcmp(dirpath, "bogus") == 0)
      {
         /* If "make install" ran OK, we should never get here */
         fprintf (stderr, "twlog: resource file (Twlog) is not installed.\n");
         fprintf (stderr, "twlog: Did you run \"make install\" as root?\n");
      }
      else
      {
         printf ("twlog: Can't find the directory %s\n", dirpath);
         printf ("twlog: Did you edit the resource file (Twpsk)?\n");
      }

      exit (1);
   }

   if (dirpath[length] != '/')
       strcat (dirpath, "/");             /* add a "/" if there isn't one */

   logpath = malloc (length + MAXNAME);   /* no check, will be created */
   strcpy (logpath, dirpath);             /* if need be */
   strcat (logpath, LOGFILE);

   helppath = malloc (length + MAXNAME);
   strcpy (helppath, "/usr/share/twlog/");
   strcat (helppath, HELPFILE);
   if (stat (helppath, &buf) == -1)
   {
      perror ("twlog");
      fprintf (stdout, "twlog: Can't find %s\n", helppath);
      exit (1);
   }

   /*
    * Initialize the Timezone
    * Check the timezone resource and do a tzset if OK.  If the value
    * is bad or the resource was not found (default resource = 2
    * above) force an error and exit.
    */
   switch (log_res.tzone)
   {
      case 0:
         putenv ("TZ");
         break;

      case 1:
         putenv ("TZ=GMT");
         break;

      default:
         fprintf (stderr, "twlog: Warning - Invalid tzone in Twlog\n");
         fprintf (stderr, "Using GMT\n");
         putenv ("TZ=GMT");
   }
   tzset();

   /*
    * Add Actions
    */
   XtAppAddActions(ac, actions, XtNumber(actions));
    
   /*
    * Realize the widgets and set pixmap properties for logSH
    * and iconwin
    */
   XtRealizeWidget (logSH);
   XtRealizeWidget (iconwin);

   XtVaSetValues (iconwin,
      XmNbackgroundPixmap, pixmap,
      NULL);

   XtVaSetValues (logSH,
      XmNiconWindow, XtWindow(iconwin),
      NULL);

   /*
    * Set max and min height to current height.  Set min width to 
    * current width.  Then, go into loop mode.
    */ 
   XtVaGetValues (logSH,
      XmNheight, &h,
      XmNwidth,  &w,
      NULL);

   XtVaSetValues (logSH,
      XmNminHeight, h,
      XmNmaxHeight, h,
      XmNminWidth,  w,
      NULL);

   XtAppMainLoop (ac);
   return 0;   /* Never get here */
}
