/* ==================================================== ======== ======= *
 *
 *  usymbol.hh
 *  Ubit Project [Elc::2003]
 *  Author: Eric Lecolinet
 *
 *  Part of the Ubit Toolkit: A Brick Construction Game Model for Creating GUIs
 *
 *  (C) 1999-2003 Eric Lecolinet @ ENST Paris
 *  WWW: http://www.enst.fr/~elc/ubit   Email: elc@enst.fr (subject: ubit)
 *
 * ***********************************************************************
 * COPYRIGHT NOTICE : 
 * THIS PROGRAM IS DISTRIBUTED WITHOUT ANY WARRANTY AND WITHOUT EVEN THE 
 * IMPLIED WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. 
 * YOU CAN REDISTRIBUTE IT AND/OR MODIFY IT UNDER THE TERMS OF THE GNU 
 * GENERAL PUBLIC LICENSE AS PUBLISHED BY THE FREE SOFTWARE FOUNDATION; 
 * EITHER VERSION 2 OF THE LICENSE, OR (AT YOUR OPTION) ANY LATER VERSION.
 * SEE FILES 'COPYRIGHT' AND 'COPYING' FOR MORE DETAILS.
 * ***********************************************************************
 *
 * ==================================================== [Elc:03] ======= *
 * ==================================================== ======== ======= */

#ifndef _usymbol_hh
#define	_usymbol_hh
//pragma ident	"@(#)usymbol_hh	ubit:03.02.00"
#include <ubit/uelem.hpp>


/** Active Symbol Class.
 */
class USymbol: public UElem {
public:
  /// predefined symbols:
  static USymbol left, right, up, down, check, radio, square, circle, slider;

  USymbol(const USymbol&);
  friend USymbol& usymbol(const USymbol&);

  // - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

  void set(const USymbol&);
  virtual void update();

  void setColor(const UColor&);
  void setFrontShadowColor(const UColor&);
  void setBackShadowColor(const UColor&);

protected:
  friend class UBox;
  enum  {
    S_LEFT, S_RIGHT, S_UP, S_DOWN, S_CHECK, S_RADIO, S_SQUARE, S_CIRCLE, 
    S_SLIDER
  };

  // private constructor (internal implementation):
  USymbol(int ix, u_modes bmodes = 0);
  int ix;		// internal index
  const class UColor *color, *frontShadowColor, *backShadowColor;
  virtual void getSize(UContext*, u_dim *w, u_dim *h) const;
  virtual void paint(UWinGraph&, UContext*, const URegion &r) const;
};

#endif
/* ==================================================== [TheEnd] ======= */
/* ==================================================== [Elc:03] ======= */
