/* ==================================================== ======== ======= *
 *
 *  uhtmldoc.hpp
 *  Ubit Project [Elc][2003]
 *  Author: Eric Lecolinet
 *
 *  Part of the Ubit Toolkit: A Brick Construction Game Model for Creating GUIs
 *
 *  (C) 1999-2003 Eric Lecolinet @ ENST Paris
 *  WWW: http://www.enst.fr/~elc/ubit   Email: elc@enst.fr (subject: ubit)
 *
 * ***********************************************************************
 * COPYRIGHT NOTICE : 
 * THIS PROGRAM IS DISTRIBUTED WITHOUT ANY WARRANTY AND WITHOUT EVEN THE 
 * IMPLIED WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. 
 * YOU CAN REDISTRIBUTE IT AND/OR MODIFY IT UNDER THE TERMS OF THE GNU 
 * GENERAL PUBLIC LICENSE AS PUBLISHED BY THE FREE SOFTWARE FOUNDATION; 
 * EITHER VERSION 2 OF THE LICENSE, OR (AT YOUR OPTION) ANY LATER VERSION.
 * SEE FILES 'COPYRIGHT' AND 'COPYING' FOR MORE DETAILS.
 * ***********************************************************************
 *
 * ==================================================== [Elc:03] ======= *
 * ==================================================== ======== ======= */

#ifndef _uhtmldoc_hpp_
#define _uhtmldoc_hpp_
//pragma ident	"@(#)uhtmldoc.hpp	ubit:03.06.03"
#include <ubit/xml/uxmldoc.hpp>

/* ==================================================== [Elc:03] ======= */
/* ==================================================== ======== ======= */
/** XHTML Document.
 *  details
 *  - most methods and constructs are inherited from UDoc and UXmlDoc.
 *  - UDoc::readDoc() reads and creates a Document from a file.
 *    see the UDoc class.
 */
class UHtmlDoc : public UXmlDoc {
public:

  class Reader : public UDoc::Reader {
  public:
    virtual UDoc* read(const UStr& pathname, Callbacks*, Errors*);
  };
  
  UHtmlDoc(const UStr& pathname, UDoc::Callbacks* = null);
  virtual ~UHtmlDoc();

  virtual UDoc::Errors readFile(const UStr& pathname);

protected:
  virtual void initModels();
  virtual const class UXmlElemModel* getElemModels() const {return elem_models;}
  virtual const class UXmlAttrModel* getAttrModels() const {return attr_models;}

private:
  static bool is_model_initialized;
  static class UXmlElemModel elem_models[];
  static class UXmlAttrModel attr_models[];
};

#endif
/* ==================================================== [TheEnd] ======= */
/* ==================================================== [Elc:03] ======= */
