
#ifndef _uremote_hpp_
#define _uremote_hpp_

#include <ubit/ubit.hpp>
#include <ubit/umsclient.hpp>

/* ==================================================== [Elc:03] ======= */
/* ==================================================== ======== ======= */

struct WinPos {
  u_pos x, y;
};

class Remote : public UBox {
public:
  static const char* default_hosts[];
  static const char* default_files[];
  static const char* default_urls[];
  static const char* default_scenes[];

  Remote(const UStr& hostname, const UArgs& args = UArgs::none);

  void setHost(UEvent&, UListbox*);
  void addHost(UEvent&, UListbox*);
  void sendMsg(UStr* target, const char* action);
  void sendBoxMsg(UEvent&, UStr* target, const char* action);
  void sendClick(UStr* target, WinPos* pos);
  void sendPress(UStr* target, WinPos* pos);
  void sendRelease(UStr* target, WinPos* pos);
  void editPos(UEvent& e, WinPos* pos);
  
  // - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

  std::vector<UStr*> hosts;
  std::vector<UMSclient*> ums_clients;
  UMSclient* client;
  UStr  host_name, host_stat;
  UVbox host_panel;
  UScrollpane host_spane;
  UPane cardbox;
  class CustomPanel* custom_panel;
  class MacroEditor* macedit;
};

/* ==================================================== ======== ======= */

class CampusPanel : public UVbox {
public:
  static const char* targets[];
  CampusPanel(Remote*);

protected:
  //Remote& remote;
  UStr target;
};

/* ==================================================== ======== ======= */

class NetscapePanel : public UVbox {
public:
  struct Profile {
    WinPos reload, stop, 
      back, home, forward,
      previous, top, next;
  };
  
  static const char* targets[];
  NetscapePanel(Remote*);

protected:
  //Remote& remote;
  UStr target;
  static Profile prof;
};

/* ==================================================== ======== ======= */

class VrengPanel : public UVbox {
public:
  static const char* targets[];
  VrengPanel(Remote*);

protected:
  //Remote& remote;
  UStr target;
};

/* ==================================================== ======== ======= */

struct Macro {
  enum CommandType {MClick, Message};

  Macro();
  void send(Remote*);

  CommandType command_type;
  UStr  name, target, mesg;
  UIntg xpos, ypos;
};

struct MacroItem : public Macro, public UItem {
  MacroItem(const Macro&, class CustomPanel*);
  MacroItem& operator=(const Macro&);
};

/* ==================================================== ======== ======= */

class MacroEditor : public UVbox {
public:
  MacroEditor(Remote*);
  void open(UBox* opening_panel, MacroItem*);
  void ok();
  void cancel();
  void selectTarget(Macro*);

protected:
  Remote& remote;
  Macro mac;
  uptr<UBox> opening_panel;
  uptr<MacroItem> edited_mac;
  UStr title;
  int mac_no;
};

/* ==================================================== ======== ======= */

class CustomPanel : public UVbox {
public:
  CustomPanel(Remote*);

  void createMacro();
  void editMacro();
  void deleteMacro();
  
  Remote& remote;
  UListbox macro_list;
};

/* ==================================================== ======== ======= */

class MousePad : public UVbox {
public:
  MousePad(Remote*);

  void pressMouse(UEvent& e, u_id mbutton);
  void releaseMouse(UEvent& e, u_id mbutton);
  void moveMouse(UEvent& e);

private:
  Remote& remote;
  int ptr_no;
  float mag_factor;
};

/* ==================================================== [Elc:03] ======= */
/* ==================================================== ======== ======= */
#endif
