/*
 * WallFire -- a comprehensive firewall administration tool.
 * 
 * Copyright (C) 2001 Herv Eychenne <rv@wallfire.org>
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */

#ifndef _WF_INMODULE_H
#define _WF_INMODULE_H

#include <iostream>
#include <string>
#include <stdio.h> /* for FILE */

#include "wflogentries.h"

#define WF_LOGLINE_MAXLEN 1024 /* maximum size of a log line */

enum wf_logentries_parsing_strictness {
  /* no warning. Store log entry all the way */
  WF_LOGENTRIES_PARSING_STRICTNESS_LOOSE,
  /* no warning. Do not store if check wrong */
  WF_LOGENTRIES_PARSING_STRICTNESS_NOWARNING,
  /* warning. Do not store if check wrong */
  WF_LOGENTRIES_PARSING_STRICTNESS_WARNING,
  /* error. Don't store anything if something is wrong */
  WF_LOGENTRIES_PARSING_STRICTNESS_ERROR
};

enum wf_logentry_parsing_result {
  WF_LOGENTRY_PARSING_OK,
  WF_LOGENTRY_PARSING_ERROR,
  WF_LOGENTRY_PARSING_NOHIT,   /* line is not a log line */
  WF_LOGENTRY_PARSING_NOMATCH  /* line does not match a module */
};

class wf_inmodule {
 public:
  wf_inmodule() {}
  virtual ~wf_inmodule() {}
  // wf_inmodule(wf_inmodule&) {}

  virtual char* name() const = 0;

  virtual bool match(const string& line) const = 0;

  virtual enum wf_logentry_parsing_result
    parse(wf_logentry** logentry, const string& line, int linenum) = 0;

  wf_logentries* parse(FILE* file, const string& filename,
		       unsigned int* lineno,
		       enum wf_logentries_parsing_strictness strictness =
		       WF_LOGENTRIES_PARSING_STRICTNESS_WARNING);
};

enum wf_logentry_parsing_result
wf_inmodule_parse(wf_logentry** logentry, const string& line,
		  const string& filename, unsigned int lineno,
		  const list<wf_inmodule*>& input_modules);

/* With strictness. Used in realtime mode, for example. */
enum wf_logentry_parsing_result
wf_inmodule_parse(wf_logentry** logentry, const string& line,
		  const string& filename, unsigned int lineno,
		  const list<wf_inmodule*>& input_modules,
		  enum wf_logentries_parsing_strictness strictness);

wf_logentries*
wf_inmodule_parse(FILE* file, const string& filename, unsigned int* lineno,
		  const list<wf_inmodule*>& input_modules,
		  enum wf_logentries_parsing_strictness strictness);
  
struct wf_inmodulelist {
  string name;
  wf_inmodule* (*initfunc)();
};

wf_inmodule* wf_inmodule_init(const string& name);
ostream& wf_inmodule_available_modules_print(ostream& os);

extern wf_inmodulelist inmodules[];
extern unsigned int inmodules_size;

#endif
