/*
 *   Copyright (C) 2002,2003 by Jonathan Naylor G4KLX
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "JT44Levels.h"

#include <wx/wx.h>

#include "JT44Defs.h"

#include "common/Average.h"

CJT44Levels::CJT44Levels() :
m_audioData(NULL),
m_dfData(NULL),
m_dtData(NULL)
{
	m_audioData = new double[JT44_GRAPH_WIDTH];
	m_dfData    = new double[JT44_GRAPH_WIDTH];
	m_dtData    = new double[JT44_GRAPH_WIDTH];

	for (int i = 0; i < JT44_GRAPH_WIDTH; i++) {
		m_audioData[i] = 0.0;
		m_dfData[i]    = 0.0;
		m_dtData[i]    = 0.0;
	}
}

CJT44Levels::~CJT44Levels()
{
	delete[] m_audioData;
	delete[] m_dfData;
	delete[] m_dtData;
}

void CJT44Levels::setAudioData(double* data, int count)
{
	wxASSERT(data != NULL);
	wxASSERT(count > 0);

	double scale = double(JT44_GRAPH_WIDTH) / double(JT44_MAX_AUDIO_DATA);

	fillinData(data, count, scale, m_audioData);
}

void CJT44Levels::setDFData(double* data, int count)
{
	wxASSERT(data != NULL);
	wxASSERT(count > 0);

	double scale = double(JT44_GRAPH_WIDTH) / double(count);

	fillinData(data, count, scale, m_dfData);
}

void CJT44Levels::setDtData(double* data, int count)
{
	wxASSERT(data != NULL);
	wxASSERT(count > 0);

	double scale = double(JT44_GRAPH_WIDTH) / double(count);

	fillinData(data, count, scale, m_dtData);
}

double CJT44Levels::getAudioData(int pixel) const
{
	wxASSERT(pixel >= 0 && pixel < JT44_GRAPH_WIDTH);

	return m_audioData[pixel];
}

double CJT44Levels::getDFData(int pixel) const
{
	wxASSERT(pixel >= 0 && pixel < JT44_GRAPH_WIDTH);

	return m_dfData[pixel];
}

double CJT44Levels::getDtData(int pixel) const
{
	wxASSERT(pixel >= 0 && pixel < JT44_GRAPH_WIDTH);

	return m_dtData[pixel];
}

void CJT44Levels::fillinData(double* data, int count, double scale, double*& member)
{
	int lastPixel = 0;
	CAverage value;

	for (int i = 0; i < count; i++) {
		int pixel = int(scale * double(i));

		if (pixel == lastPixel) {
			value.addValue(data[i] * data[i]);
		} else {
			member[lastPixel] = value.getMaximum();
			value.clear();

			value.addValue(data[i] * data[i]);
			lastPixel = pixel;
		}
	}

	member[lastPixel] = value.getMaximum();
}
