/*
 * Decompiled with CFR 0.152.
 */
package jalview.appletgui;

import jalview.appletgui.AlignmentPanel;
import jalview.bin.JalviewLite;
import jalview.datamodel.SequenceGroup;
import jalview.schemes.ColourSchemeI;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Scrollbar;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;

public class SliderPanel
extends Panel
implements ActionListener,
AdjustmentListener,
MouseListener {
    AlignmentPanel ap;
    boolean forConservation = true;
    ColourSchemeI cs;
    static Frame conservationSlider;
    static Frame PIDSlider;
    protected Scrollbar slider = new Scrollbar();
    protected TextField valueField = new TextField();
    protected Label label = new Label();
    Panel jPanel1 = new Panel();
    Panel jPanel2 = new Panel();
    protected Button applyButton = new Button();
    protected Button undoButton = new Button();
    FlowLayout flowLayout1 = new FlowLayout();
    protected Checkbox allGroupsCheck = new Checkbox();
    BorderLayout borderLayout1 = new BorderLayout();
    BorderLayout borderLayout2 = new BorderLayout();
    FlowLayout flowLayout2 = new FlowLayout();

    public static int setConservationSlider(AlignmentPanel ap, ColourSchemeI cs, String source) {
        SliderPanel sp = null;
        if (conservationSlider == null) {
            sp = new SliderPanel(ap, cs.getConservationInc(), true, cs);
            conservationSlider = new Frame();
            conservationSlider.add(sp);
        } else {
            sp = (SliderPanel)conservationSlider.getComponent(0);
            sp.cs = cs;
        }
        conservationSlider.setTitle("Conservation Colour Increment  (" + source + ")");
        if (ap.av.alignment.getGroups() != null) {
            sp.setAllGroupsCheckEnabled(true);
        } else {
            sp.setAllGroupsCheckEnabled(false);
        }
        return sp.getValue();
    }

    public static void showConservationSlider() {
        try {
            PIDSlider.setVisible(false);
            PIDSlider = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!conservationSlider.isVisible()) {
            JalviewLite.addFrame(conservationSlider, conservationSlider.getTitle(), 420, 100);
            conservationSlider.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent e) {
                    conservationSlider = null;
                }
            });
        }
    }

    public static int setPIDSliderSource(AlignmentPanel ap, ColourSchemeI cs, String source) {
        SliderPanel pid = null;
        if (PIDSlider == null) {
            pid = new SliderPanel(ap, 50, false, cs);
            PIDSlider = new Frame();
            PIDSlider.add(pid);
        } else {
            pid = (SliderPanel)PIDSlider.getComponent(0);
            pid.cs = cs;
        }
        PIDSlider.setTitle("Percentage Identity Threshold (" + source + ")");
        if (ap.av.alignment.getGroups() != null) {
            pid.setAllGroupsCheckEnabled(true);
        } else {
            pid.setAllGroupsCheckEnabled(false);
        }
        return pid.getValue();
    }

    public static void showPIDSlider() {
        try {
            conservationSlider.setVisible(false);
            conservationSlider = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!PIDSlider.isVisible()) {
            JalviewLite.addFrame(PIDSlider, PIDSlider.getTitle(), 420, 100);
            PIDSlider.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent e) {
                    PIDSlider = null;
                }
            });
        }
    }

    public SliderPanel(AlignmentPanel ap, int value, boolean forConserve, ColourSchemeI cs) {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.ap = ap;
        this.cs = cs;
        this.forConservation = forConserve;
        this.undoButton.setVisible(false);
        this.applyButton.setVisible(false);
        if (this.forConservation) {
            this.label.setText("Modify conservation visibility");
            this.slider.setMinimum(0);
            this.slider.setMaximum(50 + this.slider.getVisibleAmount());
            this.slider.setUnitIncrement(1);
        } else {
            this.label.setText("Colour residues above % occurence");
            this.slider.setMinimum(0);
            this.slider.setMaximum(100 + this.slider.getVisibleAmount());
            this.slider.setBlockIncrement(1);
        }
        this.slider.addAdjustmentListener(this);
        this.slider.addMouseListener(this);
        this.slider.setValue(value);
        this.valueField.setText(value + "");
    }

    public void valueChanged(int i) {
        if (this.cs == null) {
            return;
        }
        ColourSchemeI toChange = null;
        Vector allGroups = null;
        int groupIndex = 0;
        if (this.allGroupsCheck.getState()) {
            allGroups = this.ap.av.alignment.getGroups();
            groupIndex = allGroups.size() - 1;
        } else {
            toChange = this.cs;
        }
        while (groupIndex > -1) {
            if (allGroups != null) {
                toChange = ((SequenceGroup)allGroups.elementAt((int)groupIndex)).cs;
            }
            if (this.forConservation) {
                toChange.setConservationInc(i);
            } else {
                toChange.setThreshold(i, this.ap.av.getIgnoreGapsConsensus());
            }
            --groupIndex;
        }
        this.ap.seqPanel.seqCanvas.repaint();
    }

    public void setAllGroupsCheckEnabled(boolean b) {
        this.allGroupsCheck.setEnabled(b);
    }

    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this.applyButton) {
            this.applyButton_actionPerformed();
        } else if (evt.getSource() == this.undoButton) {
            this.undoButton_actionPerformed();
        } else if (evt.getSource() == this.valueField) {
            this.valueField_actionPerformed();
        }
    }

    public void adjustmentValueChanged(AdjustmentEvent evt) {
        this.valueField.setText(this.slider.getValue() + "");
        this.valueChanged(this.slider.getValue());
    }

    public void valueField_actionPerformed() {
        try {
            int i = Integer.parseInt(this.valueField.getText());
            this.slider.setValue(i);
        }
        catch (Exception ex) {
            this.valueField.setText(this.slider.getValue() + "");
        }
    }

    public void setValue(int value) {
        this.slider.setValue(value);
    }

    public int getValue() {
        return Integer.parseInt(this.valueField.getText());
    }

    private void jbInit() throws Exception {
        this.setLayout(this.borderLayout2);
        this.slider.setBackground(Color.white);
        this.slider.setFont(new Font("Verdana", 0, 11));
        this.slider.setOrientation(0);
        this.valueField.setFont(new Font("Verdana", 0, 11));
        this.valueField.setText("      ");
        this.valueField.addActionListener(this);
        this.label.setFont(new Font("Verdana", 0, 11));
        this.label.setText("set this label text");
        this.jPanel1.setLayout(this.borderLayout1);
        this.jPanel2.setLayout(this.flowLayout1);
        this.applyButton.setFont(new Font("Verdana", 0, 11));
        this.applyButton.setLabel("Apply");
        this.applyButton.addActionListener(this);
        this.undoButton.setEnabled(false);
        this.undoButton.setFont(new Font("Verdana", 0, 11));
        this.undoButton.setLabel("Undo");
        this.undoButton.addActionListener(this);
        this.allGroupsCheck.setEnabled(false);
        this.allGroupsCheck.setFont(new Font("Verdana", 0, 11));
        this.allGroupsCheck.setLabel("Apply threshold to all groups");
        this.allGroupsCheck.setName("Apply to all Groups");
        this.setBackground(Color.white);
        this.setForeground(Color.black);
        this.jPanel2.add((Component)this.label, null);
        this.jPanel2.add((Component)this.applyButton, null);
        this.jPanel2.add((Component)this.undoButton, null);
        this.jPanel2.add(this.allGroupsCheck);
        this.jPanel1.add((Component)this.valueField, "East");
        this.jPanel1.add((Component)this.slider, "Center");
        this.add((Component)this.jPanel1, "South");
        this.add((Component)this.jPanel2, "Center");
    }

    protected void applyButton_actionPerformed() {
    }

    protected void undoButton_actionPerformed() {
    }

    public void mousePressed(MouseEvent evt) {
    }

    public void mouseReleased(MouseEvent evt) {
        this.ap.paintAlignment(true);
    }

    public void mouseClicked(MouseEvent evt) {
    }

    public void mouseEntered(MouseEvent evt) {
    }

    public void mouseExited(MouseEvent evt) {
    }
}

