#!/bin/bash

# ACM root directory:
base=../..

# Destination directory of the generated charts to be set per zone:
dst=

# Chart program common options:
opts="--wmm-cof $base/objects/WMM.COF"

# Generates PDF of a navigation chart.
# Global variables:
# $dst: destination directory of the PDF.
# $opts: global options for chart.exe.
# Parameters:
# $1: scenery file.
# $2: destination PDF file name without extension.
# $3: title.
# $4: central latitude.
# $5: central longitude.
# $6: scale.
# $7, $8, $9: optional further parameters for the chart.exe program.
function f
{
	echo "Generating $1 --> $dst/$2.pdf"
	./chart.exe $opts \
		--scene "$1" \
		--title "$3" \
		--olat $4 \
		--olon $5 \
		--scale $6 \
		$7 $8 $9 > $dst/$2.ps || exit 1
	ps2pdf -sPAPERSIZE=a4 $dst/$2.ps $dst/$2.pdf || exit 1
	rm $dst/$2.ps
}

function italy()
{
	local src
	src=$base/objects/zones/europe/italy.txt
	dst=$base/doc/charts/europe/italy
	# Navigation charts:
	f $src italy "Italy" 43-00N 13-00E 5000000 --no-ils
	f $src A "Italy/A" 44-10N 09-50E 2000000 --no-ils
	f $src B "Italy/B" 44-10N 14-50E 2000000 --no-ils
	f $src C "Italy/C" 39-10N 09-50E 2000000 --no-ils
	f $src D "Italy/D" 39-10N 14-50E 2000000 --no-ils
	# Instrumental landing:
	f $src alghero-fertilia "Alghero-Fertilia (LIEA - AHO)" 40-37N 8-17E 250000
	f $src ancona-falconara "Ancona-Falconara (LIPY - AOI)" 43-37N 13-25E 250000
	f $src bari-palese "Bari-Palese (LIBD - BRI)" 41-07N 16-45E 250000
	f $src bergamo-orio-al-serio "Bergamo-Orio al Serio (LIME - BGY)" 45-40N 09-42E 250000
	f $src bologna-borgopanigale "Bologna-Borgo Panigale (LIPE - BLQ)" 44-32N 11-15E 250000
	f $src brindisi-casale "Brindisi-Casale (LIBR - BDS)" 40-40N 17-55E 250000
	f $src cagliari-elmas "Cagliari-Elmas (LIEE - CAG)" 39-15N 09-03E 250000
	f $src catania-fontanarossa "Catania-Fontanarossa (LICC - CTA)" 37-27N 15-00E 250000
	f $src firenze-peretola "Firenze-Peretola (LIRQ - FLR)" 43-50N 11-10E 250000
	f $src genova-sestri "Genova-Sestri (LIMJ - GOA)" 44-25N 08-55E 250000
	f $src milano-linate "Milano-Linate (LIML - LIN)" 45-27N 09-15E 250000
	f $src milano-malpensa "Milano-Malpensa (LIMC - MXP)" 45-35N 8-45E 250000
	f $src napoli-capodichino "Napoli-Capodichino (LIRN - NAP)" 40-50N 14-17E 250000
	f $src palermo-puntaraisi "Palermo-Punta Raisi (LICJ - PMO)" 38-10N 13-05E 250000
	f $src reggiocalabria "Reggio Calabria (LICR - REG)" 38-05N 15-40E 250000
	f $src roma-ciampino "Roma-Ciampino (LIRA - CIA)" 41-55N 12-30E 250000
	f $src roma-fiumicino "Roma-Fiumicino (LIRF-FCO)" 41-52N 12-22E 250000
	f $src torino-caselle "Torino-Caselle (LIMF - TRN)" 45-05N 07-45E 250000
	f $src venezia-tessera "Venezia-Tessera (LIPZ)" 45-30N 12-15E 250000
	f $src verona-villafranca "Verona-Villafranca (LIPX - VRN)" 45-20N 10-50E 250000
}

italy
