// THIS FILE IS AUTOMATICALLY GENERATED. DO NOT EDIT.

// Package cloudformation provides a client for AWS CloudFormation.
package cloudformation

import (
	"time"

	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/query"
)

const opCancelUpdateStack = "CancelUpdateStack"

// CancelUpdateStackRequest generates a request for the CancelUpdateStack operation.
func (c *CloudFormation) CancelUpdateStackRequest(input *CancelUpdateStackInput) (req *request.Request, output *CancelUpdateStackOutput) {
	op := &request.Operation{
		Name:       opCancelUpdateStack,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CancelUpdateStackInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &CancelUpdateStackOutput{}
	req.Data = output
	return
}

// Cancels an update on the specified stack. If the call completes successfully,
// the stack rolls back the update and reverts to the previous stack configuration.
//
// You can cancel only stacks that are in the UPDATE_IN_PROGRESS state.
func (c *CloudFormation) CancelUpdateStack(input *CancelUpdateStackInput) (*CancelUpdateStackOutput, error) {
	req, out := c.CancelUpdateStackRequest(input)
	err := req.Send()
	return out, err
}

const opContinueUpdateRollback = "ContinueUpdateRollback"

// ContinueUpdateRollbackRequest generates a request for the ContinueUpdateRollback operation.
func (c *CloudFormation) ContinueUpdateRollbackRequest(input *ContinueUpdateRollbackInput) (req *request.Request, output *ContinueUpdateRollbackOutput) {
	op := &request.Operation{
		Name:       opContinueUpdateRollback,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ContinueUpdateRollbackInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ContinueUpdateRollbackOutput{}
	req.Data = output
	return
}

// For a specified stack that is in the UPDATE_ROLLBACK_FAILED state, continues
// rolling it back to the UPDATE_ROLLBACK_COMPLETE state. Depending on the cause
// of the failure, you can manually  fix the error (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/troubleshooting.html#troubleshooting-errors-update-rollback-failed)
// and continue the rollback. By continuing the rollback, you can return your
// stack to a working state (the UPDATE_ROLLBACK_COMPLETE state), return the
// stack to its original settings, and then try to update the stack again.
//
// A stack goes into the UPDATE_ROLLBACK_FAILED state when AWS CloudFormation
// cannot roll back all changes after a failed stack update. For example, you
// might have a stack that is rolling back to an old database instance that
// was deleted outside of AWS CloudFormation. Because AWS CloudFormation doesn't
// know the database was deleted, it assumes that the database instance still
// exists and attempts to roll back to it, causing the update rollback to fail.
func (c *CloudFormation) ContinueUpdateRollback(input *ContinueUpdateRollbackInput) (*ContinueUpdateRollbackOutput, error) {
	req, out := c.ContinueUpdateRollbackRequest(input)
	err := req.Send()
	return out, err
}

const opCreateStack = "CreateStack"

// CreateStackRequest generates a request for the CreateStack operation.
func (c *CloudFormation) CreateStackRequest(input *CreateStackInput) (req *request.Request, output *CreateStackOutput) {
	op := &request.Operation{
		Name:       opCreateStack,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateStackInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateStackOutput{}
	req.Data = output
	return
}

// Creates a stack as specified in the template. After the call completes successfully,
// the stack creation starts. You can check the status of the stack via the
// DescribeStacks API.
func (c *CloudFormation) CreateStack(input *CreateStackInput) (*CreateStackOutput, error) {
	req, out := c.CreateStackRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteStack = "DeleteStack"

// DeleteStackRequest generates a request for the DeleteStack operation.
func (c *CloudFormation) DeleteStackRequest(input *DeleteStackInput) (req *request.Request, output *DeleteStackOutput) {
	op := &request.Operation{
		Name:       opDeleteStack,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteStackInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &DeleteStackOutput{}
	req.Data = output
	return
}

// Deletes a specified stack. Once the call completes successfully, stack deletion
// starts. Deleted stacks do not show up in the DescribeStacks API if the deletion
// has been completed successfully.
func (c *CloudFormation) DeleteStack(input *DeleteStackInput) (*DeleteStackOutput, error) {
	req, out := c.DeleteStackRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeAccountLimits = "DescribeAccountLimits"

// DescribeAccountLimitsRequest generates a request for the DescribeAccountLimits operation.
func (c *CloudFormation) DescribeAccountLimitsRequest(input *DescribeAccountLimitsInput) (req *request.Request, output *DescribeAccountLimitsOutput) {
	op := &request.Operation{
		Name:       opDescribeAccountLimits,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeAccountLimitsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeAccountLimitsOutput{}
	req.Data = output
	return
}

// Retrieves your account's AWS CloudFormation limits, such as the maximum number
// of stacks that you can create in your account.
func (c *CloudFormation) DescribeAccountLimits(input *DescribeAccountLimitsInput) (*DescribeAccountLimitsOutput, error) {
	req, out := c.DescribeAccountLimitsRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeStackEvents = "DescribeStackEvents"

// DescribeStackEventsRequest generates a request for the DescribeStackEvents operation.
func (c *CloudFormation) DescribeStackEventsRequest(input *DescribeStackEventsInput) (req *request.Request, output *DescribeStackEventsOutput) {
	op := &request.Operation{
		Name:       opDescribeStackEvents,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeStackEventsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeStackEventsOutput{}
	req.Data = output
	return
}

// Returns all stack related events for a specified stack. For more information
// about a stack's event history, go to Stacks (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/concept-stack.html)
// in the AWS CloudFormation User Guide.
//
// You can list events for stacks that have failed to create or have been deleted
// by specifying the unique stack identifier (stack ID).
func (c *CloudFormation) DescribeStackEvents(input *DescribeStackEventsInput) (*DescribeStackEventsOutput, error) {
	req, out := c.DescribeStackEventsRequest(input)
	err := req.Send()
	return out, err
}

func (c *CloudFormation) DescribeStackEventsPages(input *DescribeStackEventsInput, fn func(p *DescribeStackEventsOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.DescribeStackEventsRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*DescribeStackEventsOutput), lastPage)
	})
}

const opDescribeStackResource = "DescribeStackResource"

// DescribeStackResourceRequest generates a request for the DescribeStackResource operation.
func (c *CloudFormation) DescribeStackResourceRequest(input *DescribeStackResourceInput) (req *request.Request, output *DescribeStackResourceOutput) {
	op := &request.Operation{
		Name:       opDescribeStackResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeStackResourceInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeStackResourceOutput{}
	req.Data = output
	return
}

// Returns a description of the specified resource in the specified stack.
//
// For deleted stacks, DescribeStackResource returns resource information for
// up to 90 days after the stack has been deleted.
func (c *CloudFormation) DescribeStackResource(input *DescribeStackResourceInput) (*DescribeStackResourceOutput, error) {
	req, out := c.DescribeStackResourceRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeStackResources = "DescribeStackResources"

// DescribeStackResourcesRequest generates a request for the DescribeStackResources operation.
func (c *CloudFormation) DescribeStackResourcesRequest(input *DescribeStackResourcesInput) (req *request.Request, output *DescribeStackResourcesOutput) {
	op := &request.Operation{
		Name:       opDescribeStackResources,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeStackResourcesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeStackResourcesOutput{}
	req.Data = output
	return
}

// Returns AWS resource descriptions for running and deleted stacks. If StackName
// is specified, all the associated resources that are part of the stack are
// returned. If PhysicalResourceId is specified, the associated resources of
// the stack that the resource belongs to are returned.
//
// Only the first 100 resources will be returned. If your stack has more resources
// than this, you should use ListStackResources instead. For deleted stacks,
// DescribeStackResources returns resource information for up to 90 days after
// the stack has been deleted.
//
// You must specify either StackName or PhysicalResourceId, but not both. In
// addition, you can specify LogicalResourceId to filter the returned result.
// For more information about resources, the LogicalResourceId and PhysicalResourceId,
// go to the AWS CloudFormation User Guide (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/).
//
// A ValidationError is returned if you specify both StackName and PhysicalResourceId
// in the same request.
func (c *CloudFormation) DescribeStackResources(input *DescribeStackResourcesInput) (*DescribeStackResourcesOutput, error) {
	req, out := c.DescribeStackResourcesRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeStacks = "DescribeStacks"

// DescribeStacksRequest generates a request for the DescribeStacks operation.
func (c *CloudFormation) DescribeStacksRequest(input *DescribeStacksInput) (req *request.Request, output *DescribeStacksOutput) {
	op := &request.Operation{
		Name:       opDescribeStacks,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeStacksInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeStacksOutput{}
	req.Data = output
	return
}

// Returns the description for the specified stack; if no stack name was specified,
// then it returns the description for all the stacks created.
func (c *CloudFormation) DescribeStacks(input *DescribeStacksInput) (*DescribeStacksOutput, error) {
	req, out := c.DescribeStacksRequest(input)
	err := req.Send()
	return out, err
}

func (c *CloudFormation) DescribeStacksPages(input *DescribeStacksInput, fn func(p *DescribeStacksOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.DescribeStacksRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*DescribeStacksOutput), lastPage)
	})
}

const opEstimateTemplateCost = "EstimateTemplateCost"

// EstimateTemplateCostRequest generates a request for the EstimateTemplateCost operation.
func (c *CloudFormation) EstimateTemplateCostRequest(input *EstimateTemplateCostInput) (req *request.Request, output *EstimateTemplateCostOutput) {
	op := &request.Operation{
		Name:       opEstimateTemplateCost,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &EstimateTemplateCostInput{}
	}

	req = c.newRequest(op, input, output)
	output = &EstimateTemplateCostOutput{}
	req.Data = output
	return
}

// Returns the estimated monthly cost of a template. The return value is an
// AWS Simple Monthly Calculator URL with a query string that describes the
// resources required to run the template.
func (c *CloudFormation) EstimateTemplateCost(input *EstimateTemplateCostInput) (*EstimateTemplateCostOutput, error) {
	req, out := c.EstimateTemplateCostRequest(input)
	err := req.Send()
	return out, err
}

const opGetStackPolicy = "GetStackPolicy"

// GetStackPolicyRequest generates a request for the GetStackPolicy operation.
func (c *CloudFormation) GetStackPolicyRequest(input *GetStackPolicyInput) (req *request.Request, output *GetStackPolicyOutput) {
	op := &request.Operation{
		Name:       opGetStackPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetStackPolicyInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetStackPolicyOutput{}
	req.Data = output
	return
}

// Returns the stack policy for a specified stack. If a stack doesn't have a
// policy, a null value is returned.
func (c *CloudFormation) GetStackPolicy(input *GetStackPolicyInput) (*GetStackPolicyOutput, error) {
	req, out := c.GetStackPolicyRequest(input)
	err := req.Send()
	return out, err
}

const opGetTemplate = "GetTemplate"

// GetTemplateRequest generates a request for the GetTemplate operation.
func (c *CloudFormation) GetTemplateRequest(input *GetTemplateInput) (req *request.Request, output *GetTemplateOutput) {
	op := &request.Operation{
		Name:       opGetTemplate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetTemplateInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetTemplateOutput{}
	req.Data = output
	return
}

// Returns the template body for a specified stack. You can get the template
// for running or deleted stacks.
//
// For deleted stacks, GetTemplate returns the template for up to 90 days after
// the stack has been deleted.
//
//  If the template does not exist, a ValidationError is returned.
func (c *CloudFormation) GetTemplate(input *GetTemplateInput) (*GetTemplateOutput, error) {
	req, out := c.GetTemplateRequest(input)
	err := req.Send()
	return out, err
}

const opGetTemplateSummary = "GetTemplateSummary"

// GetTemplateSummaryRequest generates a request for the GetTemplateSummary operation.
func (c *CloudFormation) GetTemplateSummaryRequest(input *GetTemplateSummaryInput) (req *request.Request, output *GetTemplateSummaryOutput) {
	op := &request.Operation{
		Name:       opGetTemplateSummary,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetTemplateSummaryInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetTemplateSummaryOutput{}
	req.Data = output
	return
}

// Returns information about a new or existing template. The GetTemplateSummary
// action is useful for viewing parameter information, such as default parameter
// values and parameter types, before you create or update a stack.
//
// You can use the GetTemplateSummary action when you submit a template, or
// you can get template information for a running or deleted stack.
//
// For deleted stacks, GetTemplateSummary returns the template information
// for up to 90 days after the stack has been deleted. If the template does
// not exist, a ValidationError is returned.
func (c *CloudFormation) GetTemplateSummary(input *GetTemplateSummaryInput) (*GetTemplateSummaryOutput, error) {
	req, out := c.GetTemplateSummaryRequest(input)
	err := req.Send()
	return out, err
}

const opListStackResources = "ListStackResources"

// ListStackResourcesRequest generates a request for the ListStackResources operation.
func (c *CloudFormation) ListStackResourcesRequest(input *ListStackResourcesInput) (req *request.Request, output *ListStackResourcesOutput) {
	op := &request.Operation{
		Name:       opListStackResources,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListStackResourcesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListStackResourcesOutput{}
	req.Data = output
	return
}

// Returns descriptions of all resources of the specified stack.
//
// For deleted stacks, ListStackResources returns resource information for
// up to 90 days after the stack has been deleted.
func (c *CloudFormation) ListStackResources(input *ListStackResourcesInput) (*ListStackResourcesOutput, error) {
	req, out := c.ListStackResourcesRequest(input)
	err := req.Send()
	return out, err
}

func (c *CloudFormation) ListStackResourcesPages(input *ListStackResourcesInput, fn func(p *ListStackResourcesOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.ListStackResourcesRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*ListStackResourcesOutput), lastPage)
	})
}

const opListStacks = "ListStacks"

// ListStacksRequest generates a request for the ListStacks operation.
func (c *CloudFormation) ListStacksRequest(input *ListStacksInput) (req *request.Request, output *ListStacksOutput) {
	op := &request.Operation{
		Name:       opListStacks,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListStacksInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListStacksOutput{}
	req.Data = output
	return
}

// Returns the summary information for stacks whose status matches the specified
// StackStatusFilter. Summary information for stacks that have been deleted
// is kept for 90 days after the stack is deleted. If no StackStatusFilter is
// specified, summary information for all stacks is returned (including existing
// stacks and stacks that have been deleted).
func (c *CloudFormation) ListStacks(input *ListStacksInput) (*ListStacksOutput, error) {
	req, out := c.ListStacksRequest(input)
	err := req.Send()
	return out, err
}

func (c *CloudFormation) ListStacksPages(input *ListStacksInput, fn func(p *ListStacksOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.ListStacksRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*ListStacksOutput), lastPage)
	})
}

const opSetStackPolicy = "SetStackPolicy"

// SetStackPolicyRequest generates a request for the SetStackPolicy operation.
func (c *CloudFormation) SetStackPolicyRequest(input *SetStackPolicyInput) (req *request.Request, output *SetStackPolicyOutput) {
	op := &request.Operation{
		Name:       opSetStackPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SetStackPolicyInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &SetStackPolicyOutput{}
	req.Data = output
	return
}

// Sets a stack policy for a specified stack.
func (c *CloudFormation) SetStackPolicy(input *SetStackPolicyInput) (*SetStackPolicyOutput, error) {
	req, out := c.SetStackPolicyRequest(input)
	err := req.Send()
	return out, err
}

const opSignalResource = "SignalResource"

// SignalResourceRequest generates a request for the SignalResource operation.
func (c *CloudFormation) SignalResourceRequest(input *SignalResourceInput) (req *request.Request, output *SignalResourceOutput) {
	op := &request.Operation{
		Name:       opSignalResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SignalResourceInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &SignalResourceOutput{}
	req.Data = output
	return
}

// Sends a signal to the specified resource with a success or failure status.
// You can use the SignalResource API in conjunction with a creation policy
// or update policy. AWS CloudFormation doesn't proceed with a stack creation
// or update until resources receive the required number of signals or the timeout
// period is exceeded. The SignalResource API is useful in cases where you want
// to send signals from anywhere other than an Amazon EC2 instance.
func (c *CloudFormation) SignalResource(input *SignalResourceInput) (*SignalResourceOutput, error) {
	req, out := c.SignalResourceRequest(input)
	err := req.Send()
	return out, err
}

const opUpdateStack = "UpdateStack"

// UpdateStackRequest generates a request for the UpdateStack operation.
func (c *CloudFormation) UpdateStackRequest(input *UpdateStackInput) (req *request.Request, output *UpdateStackOutput) {
	op := &request.Operation{
		Name:       opUpdateStack,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateStackInput{}
	}

	req = c.newRequest(op, input, output)
	output = &UpdateStackOutput{}
	req.Data = output
	return
}

// Updates a stack as specified in the template. After the call completes successfully,
// the stack update starts. You can check the status of the stack via the DescribeStacks
// action.
//
// To get a copy of the template for an existing stack, you can use the GetTemplate
// action.
//
// Tags that were associated with this stack during creation time will still
// be associated with the stack after an UpdateStack operation.
//
// For more information about creating an update template, updating a stack,
// and monitoring the progress of the update, see Updating a Stack (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks.html).
func (c *CloudFormation) UpdateStack(input *UpdateStackInput) (*UpdateStackOutput, error) {
	req, out := c.UpdateStackRequest(input)
	err := req.Send()
	return out, err
}

const opValidateTemplate = "ValidateTemplate"

// ValidateTemplateRequest generates a request for the ValidateTemplate operation.
func (c *CloudFormation) ValidateTemplateRequest(input *ValidateTemplateInput) (req *request.Request, output *ValidateTemplateOutput) {
	op := &request.Operation{
		Name:       opValidateTemplate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ValidateTemplateInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ValidateTemplateOutput{}
	req.Data = output
	return
}

// Validates a specified template.
func (c *CloudFormation) ValidateTemplate(input *ValidateTemplateInput) (*ValidateTemplateOutput, error) {
	req, out := c.ValidateTemplateRequest(input)
	err := req.Send()
	return out, err
}

// The AccountLimit data type.
type AccountLimit struct {
	_ struct{} `type:"structure"`

	// The name of the account limit. Currently, the only account limit is StackLimit.
	Name *string `type:"string"`

	// The value that is associated with the account limit name.
	Value *int64 `type:"integer"`
}

// String returns the string representation
func (s AccountLimit) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AccountLimit) GoString() string {
	return s.String()
}

// The input for the CancelUpdateStack action.
type CancelUpdateStackInput struct {
	_ struct{} `type:"structure"`

	// The name or the unique stack ID that is associated with the stack.
	StackName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CancelUpdateStackInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CancelUpdateStackInput) GoString() string {
	return s.String()
}

type CancelUpdateStackOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s CancelUpdateStackOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CancelUpdateStackOutput) GoString() string {
	return s.String()
}

// The input for the ContinueUpdateRollback action.
type ContinueUpdateRollbackInput struct {
	_ struct{} `type:"structure"`

	// The name or the unique ID of the stack that you want to continue rolling
	// back.
	StackName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ContinueUpdateRollbackInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ContinueUpdateRollbackInput) GoString() string {
	return s.String()
}

// The output for a ContinueUpdateRollback action.
type ContinueUpdateRollbackOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s ContinueUpdateRollbackOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ContinueUpdateRollbackOutput) GoString() string {
	return s.String()
}

// The input for CreateStack action.
type CreateStackInput struct {
	_ struct{} `type:"structure"`

	// A list of capabilities that you must specify before AWS CloudFormation can
	// create or update certain stacks. Some stack templates might include resources
	// that can affect permissions in your AWS account. For those stacks, you must
	// explicitly acknowledge their capabilities by specifying this parameter.
	//
	// Currently, the only valid value is CAPABILITY_IAM, which is required for
	// the following resources:  AWS::IAM::AccessKey (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-accesskey.html),
	//  AWS::IAM::Group (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-group.html),
	//  AWS::IAM::InstanceProfile (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html),
	//  AWS::IAM::Policy (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html),
	//  AWS::IAM::Role (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html),
	//  AWS::IAM::User (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-user.html),
	// and  AWS::IAM::UserToGroupAddition (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-addusertogroup.html).
	// If your stack template contains these resources, we recommend that you review
	// any permissions associated with them. If you don't specify this parameter,
	// this action returns an InsufficientCapabilities error.
	Capabilities []*string `type:"list"`

	// Set to true to disable rollback of the stack if stack creation failed. You
	// can specify either DisableRollback or OnFailure, but not both.
	//
	// Default: false
	DisableRollback *bool `type:"boolean"`

	// The Simple Notification Service (SNS) topic ARNs to publish stack related
	// events. You can find your SNS topic ARNs using the SNS console (http://console.aws.amazon.com/sns)
	// or your Command Line Interface (CLI).
	NotificationARNs []*string `type:"list"`

	// Determines what action will be taken if stack creation fails. This must be
	// one of: DO_NOTHING, ROLLBACK, or DELETE. You can specify either OnFailure
	// or DisableRollback, but not both.
	//
	// Default: ROLLBACK
	OnFailure *string `type:"string" enum:"OnFailure"`

	// A list of Parameter structures that specify input parameters for the stack.
	// For more information, see the Parameter (http://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_Parameter.html)
	// data type.
	Parameters []*Parameter `type:"list"`

	// The template resource types that you have permissions to work with for this
	// create stack action, such as AWS::EC2::Instance, AWS::EC2::*, or Custom::MyCustomInstance.
	// Use the following syntax to describe template resource types: AWS::* (for
	// all AWS resource), Custom::* (for all custom resources), Custom::logical_ID
	// (for a specific custom resource), AWS::service_name::* (for all resources
	// of a particular AWS service), and AWS::service_name::resource_logical_ID
	// (for a specific AWS resource).
	//
	// If the list of resource types doesn't include a resource that you're creating,
	// the stack creation fails. By default, AWS CloudFormation grants permissions
	// to all resource types. AWS Identity and Access Management (IAM) uses this
	// parameter for AWS CloudFormation-specific condition keys in IAM policies.
	// For more information, see Controlling Access with AWS Identity and Access
	// Management (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html).
	ResourceTypes []*string `type:"list"`

	// The name that is associated with the stack. The name must be unique in the
	// region in which you are creating the stack.
	//
	// A stack name can contain only alphanumeric characters (case sensitive) and
	// hyphens. It must start with an alphabetic character and cannot be longer
	// than 128 characters.
	StackName *string `type:"string" required:"true"`

	// Structure containing the stack policy body. For more information, go to
	// Prevent Updates to Stack Resources (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/protect-stack-resources.html)
	// in the AWS CloudFormation User Guide. You can specify either the StackPolicyBody
	// or the StackPolicyURL parameter, but not both.
	StackPolicyBody *string `min:"1" type:"string"`

	// Location of a file containing the stack policy. The URL must point to a policy
	// (max size: 16KB) located in an S3 bucket in the same region as the stack.
	// You can specify either the StackPolicyBody or the StackPolicyURL parameter,
	// but not both.
	StackPolicyURL *string `min:"1" type:"string"`

	// Key-value pairs to associate with this stack. AWS CloudFormation also propagates
	// these tags to the resources created in the stack. A maximum number of 10
	// tags can be specified.
	Tags []*Tag `type:"list"`

	// Structure containing the template body with a minimum length of 1 byte and
	// a maximum length of 51,200 bytes. For more information, go to Template Anatomy
	// (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html)
	// in the AWS CloudFormation User Guide.
	//
	// Conditional: You must specify either the TemplateBody or the TemplateURL
	// parameter, but not both.
	TemplateBody *string `min:"1" type:"string"`

	// Location of file containing the template body. The URL must point to a template
	// (max size: 460,800 bytes) that is located in an Amazon S3 bucket. For more
	// information, go to the Template Anatomy (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html)
	// in the AWS CloudFormation User Guide.
	//
	// Conditional: You must specify either the TemplateBody or the TemplateURL
	// parameter, but not both.
	TemplateURL *string `min:"1" type:"string"`

	// The amount of time that can pass before the stack status becomes CREATE_FAILED;
	// if DisableRollback is not set or is set to false, the stack will be rolled
	// back.
	TimeoutInMinutes *int64 `min:"1" type:"integer"`
}

// String returns the string representation
func (s CreateStackInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateStackInput) GoString() string {
	return s.String()
}

// The output for a CreateStack action.
type CreateStackOutput struct {
	_ struct{} `type:"structure"`

	// Unique identifier of the stack.
	StackId *string `type:"string"`
}

// String returns the string representation
func (s CreateStackOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateStackOutput) GoString() string {
	return s.String()
}

// The input for DeleteStack action.
type DeleteStackInput struct {
	_ struct{} `type:"structure"`

	// The name or the unique stack ID that is associated with the stack.
	StackName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteStackInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteStackInput) GoString() string {
	return s.String()
}

type DeleteStackOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteStackOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteStackOutput) GoString() string {
	return s.String()
}

// The input for the DescribeAccountLimits action.
type DescribeAccountLimitsInput struct {
	_ struct{} `type:"structure"`

	// A string that identifies the next page of limits that you want to retrieve.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeAccountLimitsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAccountLimitsInput) GoString() string {
	return s.String()
}

// The output for the DescribeAccountLimits action.
type DescribeAccountLimitsOutput struct {
	_ struct{} `type:"structure"`

	// An account limit structure that contain a list of AWS CloudFormation account
	// limits and their values.
	AccountLimits []*AccountLimit `type:"list"`

	// If the output exceeds 1 MB in size, a string that identifies the next page
	// of limits. If no additional page exists, this value is null.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeAccountLimitsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAccountLimitsOutput) GoString() string {
	return s.String()
}

// The input for DescribeStackEvents action.
type DescribeStackEventsInput struct {
	_ struct{} `type:"structure"`

	// A string that identifies the next page of events that you want to retrieve.
	NextToken *string `min:"1" type:"string"`

	// The name or the unique stack ID that is associated with the stack, which
	// are not always interchangeable:
	//
	//  Running stacks: You can specify either the stack's name or its unique stack
	// ID. Deleted stacks: You must specify the unique stack ID.  Default: There
	// is no default value.
	StackName *string `type:"string"`
}

// String returns the string representation
func (s DescribeStackEventsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeStackEventsInput) GoString() string {
	return s.String()
}

// The output for a DescribeStackEvents action.
type DescribeStackEventsOutput struct {
	_ struct{} `type:"structure"`

	// If the output exceeds 1 MB in size, a string that identifies the next page
	// of events. If no additional page exists, this value is null.
	NextToken *string `min:"1" type:"string"`

	// A list of StackEvents structures.
	StackEvents []*StackEvent `type:"list"`
}

// String returns the string representation
func (s DescribeStackEventsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeStackEventsOutput) GoString() string {
	return s.String()
}

// The input for DescribeStackResource action.
type DescribeStackResourceInput struct {
	_ struct{} `type:"structure"`

	// The logical name of the resource as specified in the template.
	//
	// Default: There is no default value.
	LogicalResourceId *string `type:"string" required:"true"`

	// The name or the unique stack ID that is associated with the stack, which
	// are not always interchangeable:
	//
	//  Running stacks: You can specify either the stack's name or its unique stack
	// ID. Deleted stacks: You must specify the unique stack ID.  Default: There
	// is no default value.
	StackName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeStackResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeStackResourceInput) GoString() string {
	return s.String()
}

// The output for a DescribeStackResource action.
type DescribeStackResourceOutput struct {
	_ struct{} `type:"structure"`

	// A StackResourceDetail structure containing the description of the specified
	// resource in the specified stack.
	StackResourceDetail *StackResourceDetail `type:"structure"`
}

// String returns the string representation
func (s DescribeStackResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeStackResourceOutput) GoString() string {
	return s.String()
}

// The input for DescribeStackResources action.
type DescribeStackResourcesInput struct {
	_ struct{} `type:"structure"`

	// The logical name of the resource as specified in the template.
	//
	// Default: There is no default value.
	LogicalResourceId *string `type:"string"`

	// The name or unique identifier that corresponds to a physical instance ID
	// of a resource supported by AWS CloudFormation.
	//
	// For example, for an Amazon Elastic Compute Cloud (EC2) instance, PhysicalResourceId
	// corresponds to the InstanceId. You can pass the EC2 InstanceId to DescribeStackResources
	// to find which stack the instance belongs to and what other resources are
	// part of the stack.
	//
	// Required: Conditional. If you do not specify PhysicalResourceId, you must
	// specify StackName.
	//
	// Default: There is no default value.
	PhysicalResourceId *string `type:"string"`

	// The name or the unique stack ID that is associated with the stack, which
	// are not always interchangeable:
	//
	//  Running stacks: You can specify either the stack's name or its unique stack
	// ID. Deleted stacks: You must specify the unique stack ID.  Default: There
	// is no default value.
	//
	// Required: Conditional. If you do not specify StackName, you must specify
	// PhysicalResourceId.
	StackName *string `type:"string"`
}

// String returns the string representation
func (s DescribeStackResourcesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeStackResourcesInput) GoString() string {
	return s.String()
}

// The output for a DescribeStackResources action.
type DescribeStackResourcesOutput struct {
	_ struct{} `type:"structure"`

	// A list of StackResource structures.
	StackResources []*StackResource `type:"list"`
}

// String returns the string representation
func (s DescribeStackResourcesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeStackResourcesOutput) GoString() string {
	return s.String()
}

// The input for DescribeStacks action.
type DescribeStacksInput struct {
	_ struct{} `type:"structure"`

	// A string that identifies the next page of stacks that you want to retrieve.
	NextToken *string `min:"1" type:"string"`

	// The name or the unique stack ID that is associated with the stack, which
	// are not always interchangeable:
	//
	//  Running stacks: You can specify either the stack's name or its unique stack
	// ID. Deleted stacks: You must specify the unique stack ID.  Default: There
	// is no default value.
	StackName *string `type:"string"`
}

// String returns the string representation
func (s DescribeStacksInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeStacksInput) GoString() string {
	return s.String()
}

// The output for a DescribeStacks action.
type DescribeStacksOutput struct {
	_ struct{} `type:"structure"`

	// If the output exceeds 1 MB in size, a string that identifies the next page
	// of stacks. If no additional page exists, this value is null.
	NextToken *string `min:"1" type:"string"`

	// A list of stack structures.
	Stacks []*Stack `type:"list"`
}

// String returns the string representation
func (s DescribeStacksOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeStacksOutput) GoString() string {
	return s.String()
}

type EstimateTemplateCostInput struct {
	_ struct{} `type:"structure"`

	// A list of Parameter structures that specify input parameters.
	Parameters []*Parameter `type:"list"`

	// Structure containing the template body with a minimum length of 1 byte and
	// a maximum length of 51,200 bytes. (For more information, go to Template Anatomy
	// (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html)
	// in the AWS CloudFormation User Guide.)
	//
	// Conditional: You must pass TemplateBody or TemplateURL. If both are passed,
	// only TemplateBody is used.
	TemplateBody *string `min:"1" type:"string"`

	// Location of file containing the template body. The URL must point to a template
	// that is located in an Amazon S3 bucket. For more information, go to Template
	// Anatomy (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html)
	// in the AWS CloudFormation User Guide.
	//
	// Conditional: You must pass TemplateURL or TemplateBody. If both are passed,
	// only TemplateBody is used.
	TemplateURL *string `min:"1" type:"string"`
}

// String returns the string representation
func (s EstimateTemplateCostInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EstimateTemplateCostInput) GoString() string {
	return s.String()
}

// The output for a EstimateTemplateCost action.
type EstimateTemplateCostOutput struct {
	_ struct{} `type:"structure"`

	// An AWS Simple Monthly Calculator URL with a query string that describes the
	// resources required to run the template.
	Url *string `type:"string"`
}

// String returns the string representation
func (s EstimateTemplateCostOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EstimateTemplateCostOutput) GoString() string {
	return s.String()
}

// The input for the GetStackPolicy action.
type GetStackPolicyInput struct {
	_ struct{} `type:"structure"`

	// The name or unique stack ID that is associated with the stack whose policy
	// you want to get.
	StackName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s GetStackPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetStackPolicyInput) GoString() string {
	return s.String()
}

// The output for the GetStackPolicy action.
type GetStackPolicyOutput struct {
	_ struct{} `type:"structure"`

	// Structure containing the stack policy body. (For more information, go to
	//  Prevent Updates to Stack Resources (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/protect-stack-resources.html)
	// in the AWS CloudFormation User Guide.)
	StackPolicyBody *string `min:"1" type:"string"`
}

// String returns the string representation
func (s GetStackPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetStackPolicyOutput) GoString() string {
	return s.String()
}

// The input for a GetTemplate action.
type GetTemplateInput struct {
	_ struct{} `type:"structure"`

	// The name or the unique stack ID that is associated with the stack, which
	// are not always interchangeable:
	//
	//  Running stacks: You can specify either the stack's name or its unique stack
	// ID. Deleted stacks: You must specify the unique stack ID.  Default: There
	// is no default value.
	StackName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s GetTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetTemplateInput) GoString() string {
	return s.String()
}

// The output for GetTemplate action.
type GetTemplateOutput struct {
	_ struct{} `type:"structure"`

	// Structure containing the template body. (For more information, go to Template
	// Anatomy (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html)
	// in the AWS CloudFormation User Guide.)
	TemplateBody *string `min:"1" type:"string"`
}

// String returns the string representation
func (s GetTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetTemplateOutput) GoString() string {
	return s.String()
}

// The input for the GetTemplateSummary action.
type GetTemplateSummaryInput struct {
	_ struct{} `type:"structure"`

	// The name or the stack ID that is associated with the stack, which are not
	// always interchangeable. For running stacks, you can specify either the stack's
	// name or its unique stack ID. For deleted stack, you must specify the unique
	// stack ID.
	//
	// Conditional: You must specify only one of the following parameters: StackName,
	// TemplateBody, or TemplateURL.
	StackName *string `min:"1" type:"string"`

	// Structure containing the template body with a minimum length of 1 byte and
	// a maximum length of 51,200 bytes. For more information about templates, see
	// Template Anatomy (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html)
	// in the AWS CloudFormation User Guide.
	//
	// Conditional: You must specify only one of the following parameters: StackName,
	// TemplateBody, or TemplateURL.
	TemplateBody *string `min:"1" type:"string"`

	// Location of file containing the template body. The URL must point to a template
	// (max size: 460,800 bytes) that is located in an Amazon S3 bucket. For more
	// information about templates, see Template Anatomy (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html)
	// in the AWS CloudFormation User Guide.
	//
	// Conditional: You must specify only one of the following parameters: StackName,
	// TemplateBody, or TemplateURL.
	TemplateURL *string `min:"1" type:"string"`
}

// String returns the string representation
func (s GetTemplateSummaryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetTemplateSummaryInput) GoString() string {
	return s.String()
}

// The output for the GetTemplateSummary action.
type GetTemplateSummaryOutput struct {
	_ struct{} `type:"structure"`

	// The capabilities found within the template. Currently, AWS CloudFormation
	// supports only the CAPABILITY_IAM capability. If your template contains IAM
	// resources, you must specify the CAPABILITY_IAM value for this parameter when
	// you use the CreateStack or UpdateStack actions with your template; otherwise,
	// those actions return an InsufficientCapabilities error.
	Capabilities []*string `type:"list"`

	// The list of resources that generated the values in the Capabilities response
	// element.
	CapabilitiesReason *string `type:"string"`

	// The value that is defined in the Description property of the template.
	Description *string `type:"string"`

	// The value that is defined for the Metadata property of the template.
	Metadata *string `type:"string"`

	// A list of parameter declarations that describe various properties for each
	// parameter.
	Parameters []*ParameterDeclaration `type:"list"`

	// A list of all the template resource types that are defined in the template,
	// such as AWS::EC2::Instance, AWS::Dynamo::Table, and Custom::MyCustomInstance.
	ResourceTypes []*string `type:"list"`

	// The AWS template format version, which identifies the capabilities of the
	// template.
	Version *string `type:"string"`
}

// String returns the string representation
func (s GetTemplateSummaryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetTemplateSummaryOutput) GoString() string {
	return s.String()
}

// The input for the ListStackResource action.
type ListStackResourcesInput struct {
	_ struct{} `type:"structure"`

	// A string that identifies the next page of stack resources that you want to
	// retrieve.
	NextToken *string `min:"1" type:"string"`

	// The name or the unique stack ID that is associated with the stack, which
	// are not always interchangeable:
	//
	//  Running stacks: You can specify either the stack's name or its unique stack
	// ID. Deleted stacks: You must specify the unique stack ID.  Default: There
	// is no default value.
	StackName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ListStackResourcesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListStackResourcesInput) GoString() string {
	return s.String()
}

// The output for a ListStackResources action.
type ListStackResourcesOutput struct {
	_ struct{} `type:"structure"`

	// If the output exceeds 1 MB in size, a string that identifies the next page
	// of stack resources. If no additional page exists, this value is null.
	NextToken *string `min:"1" type:"string"`

	// A list of StackResourceSummary structures.
	StackResourceSummaries []*StackResourceSummary `type:"list"`
}

// String returns the string representation
func (s ListStackResourcesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListStackResourcesOutput) GoString() string {
	return s.String()
}

// The input for ListStacks action.
type ListStacksInput struct {
	_ struct{} `type:"structure"`

	// A string that identifies the next page of stacks that you want to retrieve.
	NextToken *string `min:"1" type:"string"`

	// Stack status to use as a filter. Specify one or more stack status codes to
	// list only stacks with the specified status codes. For a complete list of
	// stack status codes, see the StackStatus parameter of the Stack data type.
	StackStatusFilter []*string `type:"list"`
}

// String returns the string representation
func (s ListStacksInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListStacksInput) GoString() string {
	return s.String()
}

// The output for ListStacks action.
type ListStacksOutput struct {
	_ struct{} `type:"structure"`

	// If the output exceeds 1 MB in size, a string that identifies the next page
	// of stacks. If no additional page exists, this value is null.
	NextToken *string `min:"1" type:"string"`

	// A list of StackSummary structures containing information about the specified
	// stacks.
	StackSummaries []*StackSummary `type:"list"`
}

// String returns the string representation
func (s ListStacksOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListStacksOutput) GoString() string {
	return s.String()
}

// The Output data type.
type Output struct {
	_ struct{} `type:"structure"`

	// User defined description associated with the output.
	Description *string `type:"string"`

	// The key associated with the output.
	OutputKey *string `type:"string"`

	// The value associated with the output.
	OutputValue *string `type:"string"`
}

// String returns the string representation
func (s Output) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Output) GoString() string {
	return s.String()
}

// The Parameter data type.
type Parameter struct {
	_ struct{} `type:"structure"`

	// The key associated with the parameter. If you don't specify a key and value
	// for a particular parameter, AWS CloudFormation uses the default value that
	// is specified in your template.
	ParameterKey *string `type:"string"`

	// The value associated with the parameter.
	ParameterValue *string `type:"string"`

	// During a stack update, use the existing parameter value that the stack is
	// using for a given parameter key. If you specify true, do not specify a parameter
	// value.
	UsePreviousValue *bool `type:"boolean"`
}

// String returns the string representation
func (s Parameter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Parameter) GoString() string {
	return s.String()
}

// A set of criteria that AWS CloudFormation uses to validate parameter values.
// Although other constraints might be defined in the stack template, AWS CloudFormation
// returns only the AllowedValues property.
type ParameterConstraints struct {
	_ struct{} `type:"structure"`

	// A list of values that are permitted for a parameter.
	AllowedValues []*string `type:"list"`
}

// String returns the string representation
func (s ParameterConstraints) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ParameterConstraints) GoString() string {
	return s.String()
}

// The ParameterDeclaration data type.
type ParameterDeclaration struct {
	_ struct{} `type:"structure"`

	// The default value of the parameter.
	DefaultValue *string `type:"string"`

	// The description that is associate with the parameter.
	Description *string `type:"string"`

	// Flag that indicates whether the parameter value is shown as plain text in
	// logs and in the AWS Management Console.
	NoEcho *bool `type:"boolean"`

	// The criteria that AWS CloudFormation uses to validate parameter values.
	ParameterConstraints *ParameterConstraints `type:"structure"`

	// The name that is associated with the parameter.
	ParameterKey *string `type:"string"`

	// The type of parameter.
	ParameterType *string `type:"string"`
}

// String returns the string representation
func (s ParameterDeclaration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ParameterDeclaration) GoString() string {
	return s.String()
}

// The input for the SetStackPolicy action.
type SetStackPolicyInput struct {
	_ struct{} `type:"structure"`

	// The name or unique stack ID that you want to associate a policy with.
	StackName *string `type:"string" required:"true"`

	// Structure containing the stack policy body. For more information, go to
	// Prevent Updates to Stack Resources (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/protect-stack-resources.html)
	// in the AWS CloudFormation User Guide. You can specify either the StackPolicyBody
	// or the StackPolicyURL parameter, but not both.
	StackPolicyBody *string `min:"1" type:"string"`

	// Location of a file containing the stack policy. The URL must point to a policy
	// (max size: 16KB) located in an S3 bucket in the same region as the stack.
	// You can specify either the StackPolicyBody or the StackPolicyURL parameter,
	// but not both.
	StackPolicyURL *string `min:"1" type:"string"`
}

// String returns the string representation
func (s SetStackPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SetStackPolicyInput) GoString() string {
	return s.String()
}

type SetStackPolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s SetStackPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SetStackPolicyOutput) GoString() string {
	return s.String()
}

// The input for the SignalResource action.
type SignalResourceInput struct {
	_ struct{} `type:"structure"`

	// The logical ID of the resource that you want to signal. The logical ID is
	// the name of the resource that given in the template.
	LogicalResourceId *string `type:"string" required:"true"`

	// The stack name or unique stack ID that includes the resource that you want
	// to signal.
	StackName *string `min:"1" type:"string" required:"true"`

	// The status of the signal, which is either success or failure. A failure signal
	// causes AWS CloudFormation to immediately fail the stack creation or update.
	Status *string `type:"string" required:"true" enum:"ResourceSignalStatus"`

	// A unique ID of the signal. When you signal Amazon EC2 instances or Auto Scaling
	// groups, specify the instance ID that you are signaling as the unique ID.
	// If you send multiple signals to a single resource (such as signaling a wait
	// condition), each signal requires a different unique ID.
	UniqueId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s SignalResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SignalResourceInput) GoString() string {
	return s.String()
}

type SignalResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s SignalResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SignalResourceOutput) GoString() string {
	return s.String()
}

// The Stack data type.
type Stack struct {
	_ struct{} `type:"structure"`

	// The capabilities allowed in the stack.
	Capabilities []*string `type:"list"`

	// The time at which the stack was created.
	CreationTime *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// A user-defined description associated with the stack.
	Description *string `type:"string"`

	// Boolean to enable or disable rollback on stack creation failures:
	//
	//   true: disable rollback false: enable rollback
	DisableRollback *bool `type:"boolean"`

	// The time the stack was last updated. This field will only be returned if
	// the stack has been updated at least once.
	LastUpdatedTime *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// SNS topic ARNs to which stack related events are published.
	NotificationARNs []*string `type:"list"`

	// A list of output structures.
	Outputs []*Output `type:"list"`

	// A list of Parameter structures.
	Parameters []*Parameter `type:"list"`

	// Unique identifier of the stack.
	StackId *string `type:"string"`

	// The name associated with the stack.
	StackName *string `type:"string" required:"true"`

	// Current status of the stack.
	StackStatus *string `type:"string" required:"true" enum:"StackStatus"`

	// Success/failure message associated with the stack status.
	StackStatusReason *string `type:"string"`

	// A list of Tags that specify cost allocation information for the stack.
	Tags []*Tag `type:"list"`

	// The amount of time within which stack creation should complete.
	TimeoutInMinutes *int64 `min:"1" type:"integer"`
}

// String returns the string representation
func (s Stack) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Stack) GoString() string {
	return s.String()
}

// The StackEvent data type.
type StackEvent struct {
	_ struct{} `type:"structure"`

	// The unique ID of this event.
	EventId *string `type:"string" required:"true"`

	// The logical name of the resource specified in the template.
	LogicalResourceId *string `type:"string"`

	// The name or unique identifier associated with the physical instance of the
	// resource.
	PhysicalResourceId *string `type:"string"`

	// BLOB of the properties used to create the resource.
	ResourceProperties *string `type:"string"`

	// Current status of the resource.
	ResourceStatus *string `type:"string" enum:"ResourceStatus"`

	// Success/failure message associated with the resource.
	ResourceStatusReason *string `type:"string"`

	// Type of resource. (For more information, go to  AWS Resource Types Reference
	// (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html)
	// in the AWS CloudFormation User Guide.)
	ResourceType *string `type:"string"`

	// The unique ID name of the instance of the stack.
	StackId *string `type:"string" required:"true"`

	// The name associated with a stack.
	StackName *string `type:"string" required:"true"`

	// Time the status was updated.
	Timestamp *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`
}

// String returns the string representation
func (s StackEvent) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StackEvent) GoString() string {
	return s.String()
}

// The StackResource data type.
type StackResource struct {
	_ struct{} `type:"structure"`

	// User defined description associated with the resource.
	Description *string `type:"string"`

	// The logical name of the resource specified in the template.
	LogicalResourceId *string `type:"string" required:"true"`

	// The name or unique identifier that corresponds to a physical instance ID
	// of a resource supported by AWS CloudFormation.
	PhysicalResourceId *string `type:"string"`

	// Current status of the resource.
	ResourceStatus *string `type:"string" required:"true" enum:"ResourceStatus"`

	// Success/failure message associated with the resource.
	ResourceStatusReason *string `type:"string"`

	// Type of resource. (For more information, go to  AWS Resource Types Reference
	// (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html)
	// in the AWS CloudFormation User Guide.)
	ResourceType *string `type:"string" required:"true"`

	// Unique identifier of the stack.
	StackId *string `type:"string"`

	// The name associated with the stack.
	StackName *string `type:"string"`

	// Time the status was updated.
	Timestamp *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`
}

// String returns the string representation
func (s StackResource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StackResource) GoString() string {
	return s.String()
}

// Contains detailed information about the specified stack resource.
type StackResourceDetail struct {
	_ struct{} `type:"structure"`

	// User defined description associated with the resource.
	Description *string `type:"string"`

	// Time the status was updated.
	LastUpdatedTimestamp *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The logical name of the resource specified in the template.
	LogicalResourceId *string `type:"string" required:"true"`

	// The JSON format content of the Metadata attribute declared for the resource.
	// For more information, see Metadata Attribute (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-metadata.html)
	// in the AWS CloudFormation User Guide.
	Metadata *string `type:"string"`

	// The name or unique identifier that corresponds to a physical instance ID
	// of a resource supported by AWS CloudFormation.
	PhysicalResourceId *string `type:"string"`

	// Current status of the resource.
	ResourceStatus *string `type:"string" required:"true" enum:"ResourceStatus"`

	// Success/failure message associated with the resource.
	ResourceStatusReason *string `type:"string"`

	// Type of resource. ((For more information, go to  AWS Resource Types Reference
	// (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html)
	// in the AWS CloudFormation User Guide.)
	ResourceType *string `type:"string" required:"true"`

	// Unique identifier of the stack.
	StackId *string `type:"string"`

	// The name associated with the stack.
	StackName *string `type:"string"`
}

// String returns the string representation
func (s StackResourceDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StackResourceDetail) GoString() string {
	return s.String()
}

// Contains high-level information about the specified stack resource.
type StackResourceSummary struct {
	_ struct{} `type:"structure"`

	// Time the status was updated.
	LastUpdatedTimestamp *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The logical name of the resource specified in the template.
	LogicalResourceId *string `type:"string" required:"true"`

	// The name or unique identifier that corresponds to a physical instance ID
	// of the resource.
	PhysicalResourceId *string `type:"string"`

	// Current status of the resource.
	ResourceStatus *string `type:"string" required:"true" enum:"ResourceStatus"`

	// Success/failure message associated with the resource.
	ResourceStatusReason *string `type:"string"`

	// Type of resource. (For more information, go to  AWS Resource Types Reference
	// (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html)
	// in the AWS CloudFormation User Guide.)
	ResourceType *string `type:"string" required:"true"`
}

// String returns the string representation
func (s StackResourceSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StackResourceSummary) GoString() string {
	return s.String()
}

// The StackSummary Data Type
type StackSummary struct {
	_ struct{} `type:"structure"`

	// The time the stack was created.
	CreationTime *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The time the stack was deleted.
	DeletionTime *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The time the stack was last updated. This field will only be returned if
	// the stack has been updated at least once.
	LastUpdatedTime *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// Unique stack identifier.
	StackId *string `type:"string"`

	// The name associated with the stack.
	StackName *string `type:"string" required:"true"`

	// The current status of the stack.
	StackStatus *string `type:"string" required:"true" enum:"StackStatus"`

	// Success/Failure message associated with the stack status.
	StackStatusReason *string `type:"string"`

	// The template description of the template used to create the stack.
	TemplateDescription *string `type:"string"`
}

// String returns the string representation
func (s StackSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StackSummary) GoString() string {
	return s.String()
}

// The Tag type is used by CreateStack in the Tags parameter. It allows you
// to specify a key-value pair that can be used to store information related
// to cost allocation for an AWS CloudFormation stack.
type Tag struct {
	_ struct{} `type:"structure"`

	// Required. A string used to identify this tag. You can specify a maximum of
	// 128 characters for a tag key. Tags owned by Amazon Web Services (AWS) have
	// the reserved prefix: aws:.
	Key *string `type:"string"`

	// Required. A string containing the value for this tag. You can specify a maximum
	// of 256 characters for a tag value.
	Value *string `type:"string"`
}

// String returns the string representation
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Tag) GoString() string {
	return s.String()
}

// The TemplateParameter data type.
type TemplateParameter struct {
	_ struct{} `type:"structure"`

	// The default value associated with the parameter.
	DefaultValue *string `type:"string"`

	// User defined description associated with the parameter.
	Description *string `type:"string"`

	// Flag indicating whether the parameter should be displayed as plain text in
	// logs and UIs.
	NoEcho *bool `type:"boolean"`

	// The name associated with the parameter.
	ParameterKey *string `type:"string"`
}

// String returns the string representation
func (s TemplateParameter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TemplateParameter) GoString() string {
	return s.String()
}

// The input for UpdateStack action.
type UpdateStackInput struct {
	_ struct{} `type:"structure"`

	// A list of capabilities that you must specify before AWS CloudFormation can
	// create or update certain stacks. Some stack templates might include resources
	// that can affect permissions in your AWS account. For those stacks, you must
	// explicitly acknowledge their capabilities by specifying this parameter. Currently,
	// the only valid value is CAPABILITY_IAM, which is required for the following
	// resources:  AWS::IAM::AccessKey (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-accesskey.html),
	//  AWS::IAM::Group (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-group.html),
	//  AWS::IAM::InstanceProfile (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html),
	//  AWS::IAM::Policy (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html),
	//  AWS::IAM::Role (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html),
	//  AWS::IAM::User (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-user.html),
	// and  AWS::IAM::UserToGroupAddition (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-addusertogroup.html).
	// If your stack template contains these resources, we recommend that you review
	// any permissions associated with them. If you don't specify this parameter,
	// this action returns an InsufficientCapabilities error.
	Capabilities []*string `type:"list"`

	// Amazon Simple Notification Service topic Amazon Resource Names (ARNs) that
	// AWS CloudFormation associates with the stack. Specify an empty list to remove
	// all notification topics.
	NotificationARNs []*string `type:"list"`

	// A list of Parameter structures that specify input parameters for the stack.
	// For more information, see the Parameter (http://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_Parameter.html)
	// data type.
	Parameters []*Parameter `type:"list"`

	// The template resource types that you have permissions to work with for this
	// update stack action, such as AWS::EC2::Instance, AWS::EC2::*, or Custom::MyCustomInstance.
	//
	// If the list of resource types doesn't include a resource that you're updating,
	// the stack update fails. By default, AWS CloudFormation grants permissions
	// to all resource types. AWS Identity and Access Management (IAM) uses this
	// parameter for AWS CloudFormation-specific condition keys in IAM policies.
	// For more information, see Controlling Access with AWS Identity and Access
	// Management (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html).
	ResourceTypes []*string `type:"list"`

	// The name or unique stack ID of the stack to update.
	StackName *string `type:"string" required:"true"`

	// Structure containing a new stack policy body. You can specify either the
	// StackPolicyBody or the StackPolicyURL parameter, but not both.
	//
	// You might update the stack policy, for example, in order to protect a new
	// resource that you created during a stack update. If you do not specify a
	// stack policy, the current policy that is associated with the stack is unchanged.
	StackPolicyBody *string `min:"1" type:"string"`

	// Structure containing the temporary overriding stack policy body. You can
	// specify either the StackPolicyDuringUpdateBody or the StackPolicyDuringUpdateURL
	// parameter, but not both.
	//
	// If you want to update protected resources, specify a temporary overriding
	// stack policy during this update. If you do not specify a stack policy, the
	// current policy that is associated with the stack will be used.
	StackPolicyDuringUpdateBody *string `min:"1" type:"string"`

	// Location of a file containing the temporary overriding stack policy. The
	// URL must point to a policy (max size: 16KB) located in an S3 bucket in the
	// same region as the stack. You can specify either the StackPolicyDuringUpdateBody
	// or the StackPolicyDuringUpdateURL parameter, but not both.
	//
	// If you want to update protected resources, specify a temporary overriding
	// stack policy during this update. If you do not specify a stack policy, the
	// current policy that is associated with the stack will be used.
	StackPolicyDuringUpdateURL *string `min:"1" type:"string"`

	// Location of a file containing the updated stack policy. The URL must point
	// to a policy (max size: 16KB) located in an S3 bucket in the same region as
	// the stack. You can specify either the StackPolicyBody or the StackPolicyURL
	// parameter, but not both.
	//
	// You might update the stack policy, for example, in order to protect a new
	// resource that you created during a stack update. If you do not specify a
	// stack policy, the current policy that is associated with the stack is unchanged.
	StackPolicyURL *string `min:"1" type:"string"`

	// Structure containing the template body with a minimum length of 1 byte and
	// a maximum length of 51,200 bytes. (For more information, go to Template Anatomy
	// (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html)
	// in the AWS CloudFormation User Guide.)
	//
	// Conditional: You must specify either the TemplateBody or the TemplateURL
	// parameter, but not both.
	TemplateBody *string `min:"1" type:"string"`

	// Location of file containing the template body. The URL must point to a template
	// that is located in an Amazon S3 bucket. For more information, go to Template
	// Anatomy (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html)
	// in the AWS CloudFormation User Guide.
	//
	// Conditional: You must specify either the TemplateBody or the TemplateURL
	// parameter, but not both.
	TemplateURL *string `min:"1" type:"string"`

	// Reuse the existing template that is associated with the stack that you are
	// updating.
	UsePreviousTemplate *bool `type:"boolean"`
}

// String returns the string representation
func (s UpdateStackInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateStackInput) GoString() string {
	return s.String()
}

// The output for a UpdateStack action.
type UpdateStackOutput struct {
	_ struct{} `type:"structure"`

	// Unique identifier of the stack.
	StackId *string `type:"string"`
}

// String returns the string representation
func (s UpdateStackOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateStackOutput) GoString() string {
	return s.String()
}

// The input for ValidateTemplate action.
type ValidateTemplateInput struct {
	_ struct{} `type:"structure"`

	// Structure containing the template body with a minimum length of 1 byte and
	// a maximum length of 51,200 bytes. For more information, go to Template Anatomy
	// (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html)
	// in the AWS CloudFormation User Guide.
	//
	// Conditional: You must pass TemplateURL or TemplateBody. If both are passed,
	// only TemplateBody is used.
	TemplateBody *string `min:"1" type:"string"`

	// Location of file containing the template body. The URL must point to a template
	// (max size: 460,800 bytes) that is located in an Amazon S3 bucket. For more
	// information, go to Template Anatomy (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html)
	// in the AWS CloudFormation User Guide.
	//
	// Conditional: You must pass TemplateURL or TemplateBody. If both are passed,
	// only TemplateBody is used.
	TemplateURL *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ValidateTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ValidateTemplateInput) GoString() string {
	return s.String()
}

// The output for ValidateTemplate action.
type ValidateTemplateOutput struct {
	_ struct{} `type:"structure"`

	// The capabilities found within the template. Currently, AWS CloudFormation
	// supports only the CAPABILITY_IAM capability. If your template contains IAM
	// resources, you must specify the CAPABILITY_IAM value for this parameter when
	// you use the CreateStack or UpdateStack actions with your template; otherwise,
	// those actions return an InsufficientCapabilities error.
	Capabilities []*string `type:"list"`

	// The list of resources that generated the values in the Capabilities response
	// element.
	CapabilitiesReason *string `type:"string"`

	// The description found within the template.
	Description *string `type:"string"`

	// A list of TemplateParameter structures.
	Parameters []*TemplateParameter `type:"list"`
}

// String returns the string representation
func (s ValidateTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ValidateTemplateOutput) GoString() string {
	return s.String()
}

const (
	// @enum Capability
	CapabilityCapabilityIam = "CAPABILITY_IAM"
)

const (
	// @enum OnFailure
	OnFailureDoNothing = "DO_NOTHING"
	// @enum OnFailure
	OnFailureRollback = "ROLLBACK"
	// @enum OnFailure
	OnFailureDelete = "DELETE"
)

const (
	// @enum ResourceSignalStatus
	ResourceSignalStatusSuccess = "SUCCESS"
	// @enum ResourceSignalStatus
	ResourceSignalStatusFailure = "FAILURE"
)

const (
	// @enum ResourceStatus
	ResourceStatusCreateInProgress = "CREATE_IN_PROGRESS"
	// @enum ResourceStatus
	ResourceStatusCreateFailed = "CREATE_FAILED"
	// @enum ResourceStatus
	ResourceStatusCreateComplete = "CREATE_COMPLETE"
	// @enum ResourceStatus
	ResourceStatusDeleteInProgress = "DELETE_IN_PROGRESS"
	// @enum ResourceStatus
	ResourceStatusDeleteFailed = "DELETE_FAILED"
	// @enum ResourceStatus
	ResourceStatusDeleteComplete = "DELETE_COMPLETE"
	// @enum ResourceStatus
	ResourceStatusDeleteSkipped = "DELETE_SKIPPED"
	// @enum ResourceStatus
	ResourceStatusUpdateInProgress = "UPDATE_IN_PROGRESS"
	// @enum ResourceStatus
	ResourceStatusUpdateFailed = "UPDATE_FAILED"
	// @enum ResourceStatus
	ResourceStatusUpdateComplete = "UPDATE_COMPLETE"
)

const (
	// @enum StackStatus
	StackStatusCreateInProgress = "CREATE_IN_PROGRESS"
	// @enum StackStatus
	StackStatusCreateFailed = "CREATE_FAILED"
	// @enum StackStatus
	StackStatusCreateComplete = "CREATE_COMPLETE"
	// @enum StackStatus
	StackStatusRollbackInProgress = "ROLLBACK_IN_PROGRESS"
	// @enum StackStatus
	StackStatusRollbackFailed = "ROLLBACK_FAILED"
	// @enum StackStatus
	StackStatusRollbackComplete = "ROLLBACK_COMPLETE"
	// @enum StackStatus
	StackStatusDeleteInProgress = "DELETE_IN_PROGRESS"
	// @enum StackStatus
	StackStatusDeleteFailed = "DELETE_FAILED"
	// @enum StackStatus
	StackStatusDeleteComplete = "DELETE_COMPLETE"
	// @enum StackStatus
	StackStatusUpdateInProgress = "UPDATE_IN_PROGRESS"
	// @enum StackStatus
	StackStatusUpdateCompleteCleanupInProgress = "UPDATE_COMPLETE_CLEANUP_IN_PROGRESS"
	// @enum StackStatus
	StackStatusUpdateComplete = "UPDATE_COMPLETE"
	// @enum StackStatus
	StackStatusUpdateRollbackInProgress = "UPDATE_ROLLBACK_IN_PROGRESS"
	// @enum StackStatus
	StackStatusUpdateRollbackFailed = "UPDATE_ROLLBACK_FAILED"
	// @enum StackStatus
	StackStatusUpdateRollbackCompleteCleanupInProgress = "UPDATE_ROLLBACK_COMPLETE_CLEANUP_IN_PROGRESS"
	// @enum StackStatus
	StackStatusUpdateRollbackComplete = "UPDATE_ROLLBACK_COMPLETE"
)
