#
# Make a version file that includes the ArrayFire version and git revision
#
SET(AF_VERSION_MAJOR "3")
SET(AF_VERSION_MINOR "3")
SET(AF_VERSION_PATCH "2")

SET(AF_VERSION "${AF_VERSION_MAJOR}.${AF_VERSION_MINOR}.${AF_VERSION_PATCH}")
SET(AF_API_VERSION_CURRENT ${AF_VERSION_MAJOR}${AF_VERSION_MINOR})

# From CMake 3.0.0 CMAKE_<LANG>_COMPILER_ID is AppleClang for OSX machines
# that use clang for compilations
IF("${CMAKE_C_COMPILER_ID}" STREQUAL "AppleClang")
    SET(COMPILER_NAME "AppleClang")
ELSEIF("${CMAKE_C_COMPILER_ID}" STREQUAL "Clang")
    SET(COMPILER_NAME "LLVM Clang")
ELSEIF("${CMAKE_C_COMPILER_ID}" STREQUAL "GNU")
    SET(COMPILER_NAME "GNU Compiler Collection(GCC/G++)")
ELSEIF("${CMAKE_C_COMPILER_ID}" STREQUAL "Intel")
    SET(COMPILER_NAME "Intel Compiler")
ELSEIF("${CMAKE_C_COMPILER_ID}" STREQUAL "MSVC")
    SET(COMPILER_NAME "Microsoft Visual Studio")
ENDIF()

SET(COMPILER_VERSION "${CMAKE_C_COMPILER_VERSION}")
SET(AF_COMPILER_STRING "${COMPILER_NAME} ${COMPILER_VERSION}")

EXECUTE_PROCESS(
    COMMAND git log -1 --format=%h
    WORKING_DIRECTORY ${CMAKE_SOURCE_DIR}
    OUTPUT_VARIABLE GIT_COMMIT_HASH
    OUTPUT_STRIP_TRAILING_WHITESPACE
)

IF(NOT GIT_COMMIT_HASH)
    MESSAGE(STATUS "No git. Setting hash to default")
    SET(GIT_COMMIT_HASH "default")
ENDIF()

CONFIGURE_FILE(
    ${CMAKE_MODULE_PATH}/version.h.in
    ${CMAKE_SOURCE_DIR}/include/af/version.h
)

CONFIGURE_FILE(
    ${CMAKE_MODULE_PATH}/version.hpp.in
    ${CMAKE_SOURCE_DIR}/src/backend/version.hpp
)
