/*********************                                                        */
/*! \file module_template.cpp
 ** \verbatim
 ** Top contributors (to current version):
 **   Morgan Deters, Mathias Preiner
 ** This file is part of the CVC4 project.
 ** Copyright (c) 2009-2018 by the authors listed in the file AUTHORS
 ** in the top-level source directory) and their institutional affiliations.
 ** All rights reserved.  See the file COPYING in the top-level source
 ** directory for licensing information.\endverbatim
 **
 ** \brief Option template for option modules.
 **
 ** For each <module>_options.toml configuration file, mkoptions.py
 ** expands this template and generates a <module>_options.cpp file.
 **/

#include "options/options_holder.h"

namespace CVC4 {

template <> const options::decisionRandomWeight__option_t::type& Options::operator[](
    options::decisionRandomWeight__option_t) const
{
  return d_holder->decisionRandomWeight;
}
template <> bool Options::wasSetByUser(options::decisionRandomWeight__option_t) const
{
  return d_holder->decisionRandomWeight__setByUser__;
}
template <> const options::decisionThreshold__option_t::type& Options::operator[](
    options::decisionThreshold__option_t) const
{
  return d_holder->decisionThreshold;
}
template <> bool Options::wasSetByUser(options::decisionThreshold__option_t) const
{
  return d_holder->decisionThreshold__setByUser__;
}
template <> const options::decisionUseWeight__option_t::type& Options::operator[](
    options::decisionUseWeight__option_t) const
{
  return d_holder->decisionUseWeight;
}
template <> bool Options::wasSetByUser(options::decisionUseWeight__option_t) const
{
  return d_holder->decisionUseWeight__setByUser__;
}
template <> const options::decisionWeightInternal__option_t::type& Options::operator[](
    options::decisionWeightInternal__option_t) const
{
  return d_holder->decisionWeightInternal;
}
template <> bool Options::wasSetByUser(options::decisionWeightInternal__option_t) const
{
  return d_holder->decisionWeightInternal__setByUser__;
}
template <> void Options::set(
    options::decisionMode__option_t,
    const options::decisionMode__option_t::type& x)
{
  d_holder->decisionMode = x;
}
template <> const options::decisionMode__option_t::type& Options::operator[](
    options::decisionMode__option_t) const
{
  return d_holder->decisionMode;
}
template <> bool Options::wasSetByUser(options::decisionMode__option_t) const
{
  return d_holder->decisionMode__setByUser__;
}
template <> void Options::set(
    options::decisionStopOnly__option_t,
    const options::decisionStopOnly__option_t::type& x)
{
  d_holder->decisionStopOnly = x;
}
template <> const options::decisionStopOnly__option_t::type& Options::operator[](
    options::decisionStopOnly__option_t) const
{
  return d_holder->decisionStopOnly;
}
template <> bool Options::wasSetByUser(options::decisionStopOnly__option_t) const
{
  return d_holder->decisionStopOnly__setByUser__;
}


namespace options {

struct decisionRandomWeight__option_t decisionRandomWeight;
struct decisionThreshold__option_t decisionThreshold;
struct decisionUseWeight__option_t decisionUseWeight;
struct decisionWeightInternal__option_t decisionWeightInternal;
struct decisionMode__option_t decisionMode;
struct decisionStopOnly__option_t decisionStopOnly;


}  // namespace options
}  // namespace CVC4
