/*
  Definitions for the DB Fourier Synthesis Daemon.

  Author: Robert Michael S Dean
  copyright, (c) 1999, 2000

  For the dbfsd, a "channel" is defined as a data producer or consumer.
  the control structure is the channel_struct.


   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public Licensse as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
 
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
 
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

 */

#ifndef __DB_CHANNEL_H_
#define __DB_CHANNEL_H_

#ifdef __cplusplus
extern "C"
{
#endif

	/* #include <sys/socket.h> */
	/* #include <netinet/in.h> */
#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>

#include <dbsoundcard.h>
#include "dbaudiolib.h"

#define DB_CHANNEL_BUF_SIZE       1024
#define DB_CHANNEL_NUM_SAMPLES    1024  /* number of samples per buffer */
#define DB_CHANNEL_NUM_CHANNELS      2
#define DB_SAMPLE_SIZE               2  /* number of bytes per sample */
#define DB_SAMPLE_RATE           44100  /* default sample rate for dbfsd */
#define DB_CHANNEL_NAME_SIZE        20  /* maximum length of a channel name */
#define DB_BUFSIZE_SHORT           512
#define DB_BUFSIZE_CHAR           (DB_BUFSIZE_SHORT * DB_SAMPLE_SIZE)

#define DB_SAMPLER_DEFAULT_TIME   (10.0)  /* default # seconds in sample buffer  */

#define DB_MIN_AUDIO_BUFFS          10

	/* defines for shared memory*/
#define DB_CHANNELS_SM_KEY       23435
#define DB_CHANNELS_SM_KEY_CUE   23445
#define DB_SYSTEM_SM_KEY         10998
#define DB_SYSTEM_SM_KEY_CUE     10988

	/* defines for message queues */
#define DB_CHANNELS_Q_KEY_BASE   31234

	/* defines for semaphores */
#define DB_SEMAPHORE_KEY         16789

	/* defines for communication tokens */
#define TOKEN_1                    '0'
#define TOKEN_2                    '1'
#define TOKEN_3                    '2'
#define TOKEN_4                    '3'
#define NO_TOKEN                   'N'

#define DB_TALKOVER_DIVISOR         4  /* 25%*/
#define DB_TALKOVER_DIVISOR_POWER   2  /* 4 = 2^2 */

#define DEFAULT_SKIP_MAX           20
#define MAX_SKIP_MAX              200

#define DEFAULT_GAIN               ((85 * 128) / 100)
#define DEFAULT_PITCH           100.0


	/* message types are defined in dbaudiolib.h */

	/* channel flags - used to describe the capabilities of a channel 
        i.e. does the client support pitch control? Is it a microphone? 
        can it be paused? */
#define CUE_FLAG        0x00000001
#define MIC_FLAG        0x00000002
#define PITCH_FLAG      0x00000004
#define PAUSE_FLAG      0x00000008

	/* channel flag enabled macros */
#define ENABLED(a)      ((ch->channel_flags & a) == a)

#define CUE_ENABLED     ENABLED(CUE_FLAG)
#define MIC_ENABLED     ENABLED(MIC_FLAG)
#define PITCH_ENABLED   ENABLED(PITCH_FLAG)
#define PAUSE_ENABLED   ENABLED(PAUSE_FLAG)

typedef struct wav_header_s
{
	guint32 main_chunk;
	guint32 length;
	guint32 chunk_type;
	guint32 sub_chunk;
	guint32 sc_len;
	guint16 format;
	guint16 modus;
	guint32 sample_fq;
	guint32 byte_p_sec;
	guint16 byte_p_spl;
	guint16 bit_p_spl;
	guint32 data_chunk;
	guint32 data_length;
} wav_header;

#define MAX_WAV_LENGTH 0xFFFFFFFF

	/* enumeration of the different channels types */
/* 	enum channel_type_e {PIPE_CHANNEL, SOCKET_CHANNEL}; */

	/*
	 * channel_buf_s is the structure used by a channel to hold data.
	 */

	typedef struct channel_buf_s
	{
		short len;
		char data_ready;
		signed short buf[DB_BUFSIZE_SHORT];
	} channel_buf;


	/*
	 * local_channel is the structure describing a channel on that exist on 
	 * the same machine as the daemon.
	 */
	typedef struct local_channel_s
	{ 
		/* channel control variables */
		int    msg_q_id;        /* message queue id for this channel */
		int    msg_flags;       /* message flags */
		int    channel_flags;   /* to hold server options  */
		enum   channel_type_e channel_type;
		short  index;           /* what is the index of this channel? */
		short  client_comm_fd;    /* communication pipes fid's - opened by client */
		short  client_cue_fd;
		short  server_comm_fd;  /* communication pipes fid's - opened by server */
		short  server_cue_fd;
		short  free_channel;    /* flag, is this channel unused? */
		short  is_symlink;      /* is this channel symlinked to /tmp/ch ? */
		short  skip_count;      /* number of times read has been skipped due to too little data ready  */
		char   comm_filename[512]; /* filename for main data pipe */
		char   cue_filename[512];  /* filename for cue data pipe */
		char   channel_name[64];
		void   (*message_handler)(dbfsd_msg message); /* pointer to IPC message handler function */

		/* audio playback control variables */
		float  base_pitch;      /* pitch value set by DBAudio_Set_Rate() */ 
		float  user_pitch;      /* pitch value set by user */
		short  left_gain;       /* gain for left stereo channel */
		short  right_gain;      /* gain for right stereo channel */
		short  cue_left_gain;   /* gain for left stereo cue channel */
		short  cue_right_gain;  /* gain for right stereo cue channel */
		char   pause;           /* flag, is this channel paused? */
		char   mute;            /* flag, is this channel muted? */
		char   cue;             /* flag, is this channel in cue mode? */

		char   writing;         /* data is currently being written */
		
		/* sampler control variables */
		enum   sampler_state_e sampler_state;
		float  sampler_time;     /* time length of sample buffer */
		int    sampler_bufsize;  /* size of sample buffer */
		int    sampler_size;     /* size of recorded sample */
		int    sampler_readoffset;  /* location of playback read point within buffer */
		int    sampler_startoffset; /* location of start of samples within buffer */
		int    sampler_endoffset; /* end of samples within buffer */
		char * sampler_buf;      /* pointer to sample buffer */

		/* buffers used for fourier synthesis */
		channel_buf buffer;
		channel_buf cue_buffer;
	} local_channel;

	/*
	 * Still haven't decided what to do with this yet...
	 * it should be enough that most clients will have network support
	 * themselves...
	 */
/* 	typedef struct socket_channel_s */
/* 	{ */
/* 		short  server_read_fd; */
/* 		short  server_write_fd; */
/* 		short  client_read_fd; */
/* 		short  client_write_fd; */
/* 		short  write_fd; */
/* 		short  data_ready; */
/* 		short  free_channel; */
/* 		short  is_symlink; */
/* 		int    len; */
/* 		signed short buf[DB_CHANNEL_BUF_SIZE]; */
/* 		struct sockaddr_in client_address; */
/* 		int    client_len; */
/* 	}socket_channel; */

	/*
	 * dbfsd_data holds system data for the daemon. 
	 */

	typedef struct dbfsd_data_s
	{
		pid_t pid; /* pid of the daemon */
		pid_t cue_pid;
		pid_t mixer_pid;
		int   num_cue_buffs;          /* number of audio buffers for main device */
		int   num_main_buffs;         /* number of audio buffers for cue device */ 
		int   debug_level;            /* system wide debug level - not implemented */
		int   num_channels;           /* number of pipe input channels */
		int   num_sockets;            /* number of network input channels */
		int   ready_count;            /* number of ready input pipes */
		int   clipping_threshold;     /* # of allowable clipped samples */
		int   free_channel_index;     /* index of next free channel */
		int   clipping;               /* difference between calc. level and max level */
		int   skip_max;               /* maximum skipped reads before audio is passed through */
		int   left_balance;           /* system wide left balance */
		int   right_balance;          /* system wide right balance */
		int   cue_split;              /* flag, enable cue splitting */
		int   single_output;          /* flag, cue with only a single master output */
		int   cue_enabled;            /* flag, is cue enabled in this dbfsd instance? */
		int   talkover_enabled;       /* flag, mic talkover is enabled */
		float default_sampler_time;   /* default # of seconds for sampler buffer */
		char  main_audio_device[256]; /* path names to audio and mixer devices */
		char  cue_audio_device[256];
		char  main_mixer_device[256];
		char  cue_mixer_device[256];
		char  filename[FILENAME_MAX]; /* path name used to transfer samples between channels */
		char  sampler_op_flag;
		char  recording;              /* main output is being recorded to a wav file */
	} dbfsd_data;


	/* included here becuase it is needed by dbmixer */
#define DB_FRAGSIZE       9 /* 2^DB_FRAGSIZE is the size of the fragment: 2^11 = 2048 */  
#define DB_NUM_FRAGMENTS  128 /*  65536 / (2^DB_FRAGSIZE) */

#ifdef __cplusplus
}
#endif


#endif /*  __DB_CHANNEL_H_ */







