/* tpf-persona.c generated by valac 0.34.0.3-63fa6, the Vala compiler
 * generated from tpf-persona.vala, do not modify */

/*
 * Copyright (C) 2010 Collabora Ltd.
 * Copyright (C) 2013 Philip Withnall
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *       Travis Reitter <travis.reitter@collabora.co.uk>
 *       Philip Withnall <philip@tecnocode.co.uk>
 */

#include <glib.h>
#include <glib-object.h>
#include <folks/folks.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <folks/small-set.h>
#include <gee.h>
#include <telepathy-glib/telepathy-glib.h>
#include <glib/gi18n-lib.h>
#include <folks-internal.h>


#define TPF_TYPE_PERSONA (tpf_persona_get_type ())
#define TPF_PERSONA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TPF_TYPE_PERSONA, TpfPersona))
#define TPF_PERSONA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TPF_TYPE_PERSONA, TpfPersonaClass))
#define TPF_IS_PERSONA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TPF_TYPE_PERSONA))
#define TPF_IS_PERSONA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TPF_TYPE_PERSONA))
#define TPF_PERSONA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TPF_TYPE_PERSONA, TpfPersonaClass))

typedef struct _TpfPersona TpfPersona;
typedef struct _TpfPersonaClass TpfPersonaClass;
typedef struct _TpfPersonaPrivate TpfPersonaPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))

#define TPF_TYPE_PERSONA_STORE (tpf_persona_store_get_type ())
#define TPF_PERSONA_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TPF_TYPE_PERSONA_STORE, TpfPersonaStore))
#define TPF_PERSONA_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TPF_TYPE_PERSONA_STORE, TpfPersonaStoreClass))
#define TPF_IS_PERSONA_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TPF_TYPE_PERSONA_STORE))
#define TPF_IS_PERSONA_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TPF_TYPE_PERSONA_STORE))
#define TPF_PERSONA_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TPF_TYPE_PERSONA_STORE, TpfPersonaStoreClass))

typedef struct _TpfPersonaStore TpfPersonaStore;
typedef struct _TpfPersonaStoreClass TpfPersonaStoreClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _TpfPersonaChangeFullNameData TpfPersonaChangeFullNameData;
typedef struct _TpfPersonaChangeBirthdayData TpfPersonaChangeBirthdayData;
typedef struct _TpfPersonaChangeAliasData TpfPersonaChangeAliasData;
typedef struct _TpfPersonaChangeIsFavouriteData TpfPersonaChangeIsFavouriteData;
typedef struct _TpfPersonaChangeEmailAddressesData TpfPersonaChangeEmailAddressesData;
typedef struct _TpfPersonaChangeGroupData TpfPersonaChangeGroupData;
typedef struct _TpfPersonaChangeGroupsData TpfPersonaChangeGroupsData;
typedef struct _TpfPersonaChangePhoneNumbersData TpfPersonaChangePhoneNumbersData;
typedef struct _TpfPersonaChangeUrlsData TpfPersonaChangeUrlsData;
typedef struct _TpfPersonaChangeDetailsData TpfPersonaChangeDetailsData;
#define __vala_TpContactInfoField_free0(var) ((var == NULL) ? NULL : (var = (_vala_TpContactInfoField_free (var), NULL)))
#define __g_list_free___vala_TpContactInfoField_free0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free___vala_TpContactInfoField_free0_ (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _TpfPersona {
	FolksPersona parent_instance;
	TpfPersonaPrivate * priv;
	GDateTime* _last_im_interaction_datetime;
	GDateTime* _last_call_interaction_datetime;
};

struct _TpfPersonaClass {
	FolksPersonaClass parent_class;
};

struct _TpfPersonaPrivate {
	gchar** _writeable_properties;
	gint _writeable_properties_length1;
	gint __writeable_properties_size_;
	gboolean _is_constructed;
	gboolean _is_in_contact_list;
	GLoadableIcon* _avatar;
	gchar* _full_name;
	GDateTime* _birthday;
	FolksPresenceType _presence_type;
	gchar* _presence_status;
	gchar* _presence_message;
	gchar** _client_types;
	gint _client_types_length1;
	gint __client_types_size_;
	gchar* _alias;
	gboolean _is_favourite;
	FolksSmallSet* _email_addresses;
	GeeSet* _email_addresses_ro;
	GeeHashMultiMap* _im_addresses;
	guint _im_interaction_count;
	guint _call_interaction_count;
	FolksSmallSet* _groups;
	GeeSet* _groups_ro;
	TpContact* _contact;
	FolksSmallSet* _phone_numbers;
	GeeSet* _phone_numbers_ro;
	FolksSmallSet* _urls;
	GeeSet* _urls_ro;
};

struct _TpfPersonaChangeFullNameData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TpfPersona* self;
	gchar* full_name;
	TpfPersonaStore* tpf_store;
	FolksPersonaStore* _tmp0_;
	FolksPersonaStore* _tmp1_;
	TpfPersonaStore* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gboolean _tmp5_;
	TpfPersonaStore* _tmp6_;
	const gchar* _tmp7_;
	GError* e1;
	GError* _tmp8_;
	const gchar* _tmp9_;
	GError* _tmp10_;
	GError* e2;
	GError* _tmp11_;
	const gchar* _tmp12_;
	GError* _tmp13_;
	GError* e3;
	GError* _tmp14_;
	const gchar* _tmp15_;
	GError* _tmp16_;
	GError * _inner_error_;
};

struct _TpfPersonaChangeBirthdayData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TpfPersona* self;
	GDateTime* birthday;
	TpfPersonaStore* tpf_store;
	FolksPersonaStore* _tmp0_;
	FolksPersonaStore* _tmp1_;
	TpfPersonaStore* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	GDateTime* _tmp5_;
	GDateTime* _tmp6_;
	GDateTime* _tmp7_;
	GDateTime* _tmp8_;
	gboolean _tmp9_;
	gboolean _tmp10_;
	TpfPersonaStore* _tmp11_;
	GDateTime* _tmp12_;
	GError* e1;
	GError* _tmp13_;
	const gchar* _tmp14_;
	GError* _tmp15_;
	GError* e2;
	GError* _tmp16_;
	const gchar* _tmp17_;
	GError* _tmp18_;
	GError* e3;
	GError* _tmp19_;
	const gchar* _tmp20_;
	GError* _tmp21_;
	GError * _inner_error_;
};

struct _TpfPersonaChangeAliasData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TpfPersona* self;
	gchar* alias;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gboolean _tmp2_;
	FolksPersonaStore* _tmp3_;
	FolksPersonaStore* _tmp4_;
	const gchar* _tmp5_;
	GError * _inner_error_;
};

struct _TpfPersonaChangeIsFavouriteData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TpfPersona* self;
	gboolean is_favourite;
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	FolksPersonaStore* _tmp3_;
	FolksPersonaStore* _tmp4_;
	gboolean _tmp5_;
	GError * _inner_error_;
};

struct _TpfPersonaChangeEmailAddressesData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TpfPersona* self;
	GeeSet* email_addresses;
	GeeSet* _tmp0_;
	FolksSmallSet* _tmp1_;
	GError * _inner_error_;
};

struct _TpfPersonaChangeGroupData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TpfPersona* self;
	gchar* group;
	gboolean is_member;
	TpContact* contact;
	TpContact* _tmp0_;
	TpContact* _tmp1_;
	TpContact* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	GError* _tmp5_;
	gboolean _tmp6_;
	gboolean _tmp7_;
	FolksSmallSet* _tmp8_;
	const gchar* _tmp9_;
	gboolean _tmp10_;
	TpContact* _tmp11_;
	const gchar* _tmp12_;
	gboolean _tmp13_;
	gboolean _tmp14_;
	FolksSmallSet* _tmp15_;
	const gchar* _tmp16_;
	gboolean _tmp17_;
	TpContact* _tmp18_;
	const gchar* _tmp19_;
	GError* e;
	const gchar* _tmp20_;
	GError* _tmp21_;
	const gchar* _tmp22_;
	GError* _tmp23_;
	GError * _inner_error_;
};

struct _TpfPersonaChangeGroupsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TpfPersona* self;
	GeeSet* groups;
	TpContact* contact;
	TpContact* _tmp0_;
	TpContact* _tmp1_;
	TpContact* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	GError* _tmp5_;
	TpContact* _tmp6_;
	GeeSet* _tmp7_;
	gint _tmp8_;
	gpointer* _tmp9_;
	gchar** _tmp10_;
	gint _tmp10__length1;
	GError* e;
	const gchar* _tmp11_;
	GError* _tmp12_;
	const gchar* _tmp13_;
	GError* _tmp14_;
	GError * _inner_error_;
};

struct _TpfPersonaChangePhoneNumbersData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TpfPersona* self;
	GeeSet* phone_numbers;
	GeeSet* _tmp0_;
	FolksSmallSet* _tmp1_;
	GError * _inner_error_;
};

struct _TpfPersonaChangeUrlsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TpfPersona* self;
	GeeSet* urls;
	GeeSet* _tmp0_;
	FolksSmallSet* _tmp1_;
	GError * _inner_error_;
};

struct _TpfPersonaChangeDetailsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TpfPersona* self;
	GeeSet* details;
	GeeSet* member_set;
	gchar* field_name;
	GType t_type;
	GBoxedCopyFunc t_dup_func;
	GDestroyNotify t_destroy_func;
	TpfPersonaStore* tpf_store;
	FolksPersonaStore* _tmp0_;
	FolksPersonaStore* _tmp1_;
	TpfPersonaStore* _tmp2_;
	gboolean _tmp3_;
	GeeSet* _tmp4_;
	GeeSet* _tmp5_;
	GeeSet* _tmp6_;
	gboolean _tmp7_;
	gboolean _tmp8_;
	TpfPersonaStore* _tmp9_;
	GeeSet* _tmp10_;
	const gchar* _tmp11_;
	GError* e1;
	GError* _tmp12_;
	const gchar* _tmp13_;
	GError* _tmp14_;
	GError* e2;
	GError* _tmp15_;
	const gchar* _tmp16_;
	GError* _tmp17_;
	GError* e3;
	GError* _tmp18_;
	const gchar* _tmp19_;
	GError* _tmp20_;
	GError * _inner_error_;
};


static gpointer tpf_persona_parent_class = NULL;
static FolksAliasDetailsIface* tpf_persona_folks_alias_details_parent_iface = NULL;
static FolksAvatarDetailsIface* tpf_persona_folks_avatar_details_parent_iface = NULL;
static FolksBirthdayDetailsIface* tpf_persona_folks_birthday_details_parent_iface = NULL;
static FolksEmailDetailsIface* tpf_persona_folks_email_details_parent_iface = NULL;
static FolksFavouriteDetailsIface* tpf_persona_folks_favourite_details_parent_iface = NULL;
static FolksGroupDetailsIface* tpf_persona_folks_group_details_parent_iface = NULL;
static FolksInteractionDetailsIface* tpf_persona_folks_interaction_details_parent_iface = NULL;
static FolksImDetailsIface* tpf_persona_folks_im_details_parent_iface = NULL;
static FolksNameDetailsIface* tpf_persona_folks_name_details_parent_iface = NULL;
static FolksPhoneDetailsIface* tpf_persona_folks_phone_details_parent_iface = NULL;
static FolksPresenceDetailsIface* tpf_persona_folks_presence_details_parent_iface = NULL;
static FolksUrlDetailsIface* tpf_persona_folks_url_details_parent_iface = NULL;

GType tpf_persona_get_type (void) G_GNUC_CONST;
#define TPF_PERSONA_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TPF_TYPE_PERSONA, TpfPersonaPrivate))
enum  {
	TPF_PERSONA_DUMMY_PROPERTY,
	TPF_PERSONA_IS_IN_CONTACT_LIST,
	TPF_PERSONA_AVATAR,
	TPF_PERSONA_STRUCTURED_NAME,
	TPF_PERSONA_FULL_NAME,
	TPF_PERSONA_NICKNAME,
	TPF_PERSONA_CALENDAR_EVENT_ID,
	TPF_PERSONA_BIRTHDAY,
	TPF_PERSONA_PRESENCE_TYPE,
	TPF_PERSONA_PRESENCE_STATUS,
	TPF_PERSONA_PRESENCE_MESSAGE,
	TPF_PERSONA_CLIENT_TYPES,
	TPF_PERSONA_LINKABLE_PROPERTIES,
	TPF_PERSONA_WRITEABLE_PROPERTIES,
	TPF_PERSONA_ALIAS,
	TPF_PERSONA_IS_FAVOURITE,
	TPF_PERSONA_EMAIL_ADDRESSES,
	TPF_PERSONA_IM_ADDRESSES,
	TPF_PERSONA_IM_INTERACTION_COUNT,
	TPF_PERSONA_LAST_IM_INTERACTION_DATETIME,
	TPF_PERSONA_CALL_INTERACTION_COUNT,
	TPF_PERSONA_LAST_CALL_INTERACTION_DATETIME,
	TPF_PERSONA_GROUPS,
	TPF_PERSONA_CONTACT,
	TPF_PERSONA_PHONE_NUMBERS,
	TPF_PERSONA_URLS
};
static guint _folks_abstract_field_details_hash_static_gee_hash_data_func (gconstpointer v, gpointer self);
static gboolean _folks_abstract_field_details_equal_static_gee_equal_data_func (gconstpointer a, gconstpointer b, gpointer self);
static void tpf_persona_real_change_full_name_data_free (gpointer _data);
static void tpf_persona_real_change_full_name (FolksNameDetails* base, const gchar* full_name, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean tpf_persona_real_change_full_name_co (TpfPersonaChangeFullNameData* _data_);
GType tpf_persona_store_get_type (void) G_GNUC_CONST;
void tpf_persona_store_change_user_full_name (TpfPersonaStore* self, TpfPersona* persona, const gchar* full_name, GAsyncReadyCallback _callback_, gpointer _user_data_);
void tpf_persona_store_change_user_full_name_finish (TpfPersonaStore* self, GAsyncResult* _res_, GError** error);
static void tpf_persona_change_full_name_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void tpf_persona_real_change_birthday_data_free (gpointer _data);
static void tpf_persona_real_change_birthday (FolksBirthdayDetails* base, GDateTime* birthday, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean tpf_persona_real_change_birthday_co (TpfPersonaChangeBirthdayData* _data_);
void tpf_persona_store_change_user_birthday (TpfPersonaStore* self, TpfPersona* persona, GDateTime* birthday, GAsyncReadyCallback _callback_, gpointer _user_data_);
void tpf_persona_store_change_user_birthday_finish (TpfPersonaStore* self, GAsyncResult* _res_, GError** error);
static void tpf_persona_change_birthday_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void tpf_persona_real_change_alias_data_free (gpointer _data);
static void tpf_persona_real_change_alias (FolksAliasDetails* base, const gchar* alias, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean tpf_persona_real_change_alias_co (TpfPersonaChangeAliasData* _data_);
void tpf_persona_store_change_alias (TpfPersonaStore* self, TpfPersona* persona, const gchar* alias, GAsyncReadyCallback _callback_, gpointer _user_data_);
void tpf_persona_store_change_alias_finish (TpfPersonaStore* self, GAsyncResult* _res_, GError** error);
static void tpf_persona_change_alias_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void tpf_persona_real_change_is_favourite_data_free (gpointer _data);
static void tpf_persona_real_change_is_favourite (FolksFavouriteDetails* base, gboolean is_favourite, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean tpf_persona_real_change_is_favourite_co (TpfPersonaChangeIsFavouriteData* _data_);
void tpf_persona_store_change_is_favourite (TpfPersonaStore* self, FolksPersona* persona, gboolean is_favourite, GAsyncReadyCallback _callback_, gpointer _user_data_);
void tpf_persona_store_change_is_favourite_finish (TpfPersonaStore* self, GAsyncResult* _res_, GError** error);
static void tpf_persona_change_is_favourite_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void _tpf_persona_set_is_favourite (TpfPersona* self, gboolean is_favourite);
void _tpf_persona_store_set_cache_needs_update (TpfPersonaStore* self);
static void tpf_persona_real_change_email_addresses_data_free (gpointer _data);
static void tpf_persona_real_change_email_addresses (FolksEmailDetails* base, GeeSet* email_addresses, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean tpf_persona_real_change_email_addresses_co (TpfPersonaChangeEmailAddressesData* _data_);
static void _tpf_persona_change_details (TpfPersona* self, GType t_type, GBoxedCopyFunc t_dup_func, GDestroyNotify t_destroy_func, GeeSet* details, GeeSet* member_set, const gchar* field_name, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void _tpf_persona_change_details_finish (TpfPersona* self, GAsyncResult* _res_, GError** error);
static void tpf_persona_change_email_addresses_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void tpf_persona_real_change_group_data_free (gpointer _data);
static void tpf_persona_real_change_group (FolksGroupDetails* base, const gchar* group, gboolean is_member, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean tpf_persona_real_change_group_co (TpfPersonaChangeGroupData* _data_);
static void tpf_persona_change_group_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void _tpf_persona_contact_groups_changed (TpfPersona* self, gchar** added, int added_length1, gchar** removed, int removed_length1);
static void tpf_persona_real_change_groups_data_free (gpointer _data);
static void tpf_persona_real_change_groups (FolksGroupDetails* base, GeeSet* groups, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean tpf_persona_real_change_groups_co (TpfPersonaChangeGroupsData* _data_);
static void tpf_persona_change_groups_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void _tpf_persona_contact_weak_notify (TpfPersona* self);
static void tpf_persona_real_change_phone_numbers_data_free (gpointer _data);
static void tpf_persona_real_change_phone_numbers (FolksPhoneDetails* base, GeeSet* phone_numbers, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean tpf_persona_real_change_phone_numbers_co (TpfPersonaChangePhoneNumbersData* _data_);
static void tpf_persona_change_phone_numbers_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void tpf_persona_real_change_urls_data_free (gpointer _data);
static void tpf_persona_real_change_urls (FolksUrlDetails* base, GeeSet* urls, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean tpf_persona_real_change_urls_co (TpfPersonaChangeUrlsData* _data_);
static void tpf_persona_change_urls_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void _tpf_persona_change_details_data_free (gpointer _data);
static gboolean _tpf_persona_change_details_co (TpfPersonaChangeDetailsData* _data_);
void _tpf_persona_store_change_user_details (TpfPersonaStore* self, TpfPersona* persona, GeeSet* details, const gchar* field_name, GAsyncReadyCallback _callback_, gpointer _user_data_);
void _tpf_persona_store_change_user_details_finish (TpfPersonaStore* self, GAsyncResult* _res_, GError** error);
static void _tpf_persona_change_details_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
TpfPersona* tpf_persona_new (TpContact* contact, TpfPersonaStore* store);
TpfPersona* tpf_persona_construct (GType object_type, TpContact* contact, TpfPersonaStore* store);
static void tpf_persona_real_constructed (GObject* base);
static void _tpf_persona_update_writeable_properties (TpfPersona* self);
static gchar** _vala_array_dup1 (gchar** self, int length);
GeeSet* tpf_persona_store_get_supported_fields (TpfPersonaStore* self);
static void _vala_array_add1 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add2 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add3 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add4 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add5 (gchar*** array, int* length, int* size, gchar* value);
static void _tpf_persona_contact_notify_contact_info (TpfPersona* self, gboolean create_if_not_exists, gboolean emit_notification);
static TpContactInfoField* _vala_TpContactInfoField_copy (TpContactInfoField* self);
static GeeMultiMap* _tpf_persona_afd_params_from_strv (TpfPersona* self, gchar** parameters, int parameters_length1);
static void _vala_TpContactInfoField_free (TpContactInfoField* self);
static void __vala_TpContactInfoField_free0_ (gpointer var);
static void _g_list_free___vala_TpContactInfoField_free0_ (GList* self);
TpfPersona* tpf_persona_new_from_cache (TpfPersonaStore* store, const gchar* uid, const gchar* iid, const gchar* im_address, const gchar* protocol, FolksSmallSet* groups, gboolean is_favourite, const gchar* alias, gboolean is_in_contact_list, gboolean is_user, GLoadableIcon* avatar, GDateTime* birthday, const gchar* full_name, FolksSmallSet* email_addresses, FolksSmallSet* phone_numbers, FolksSmallSet* urls);
TpfPersona* tpf_persona_construct_from_cache (GType object_type, TpfPersonaStore* store, const gchar* uid, const gchar* iid, const gchar* im_address, const gchar* protocol, FolksSmallSet* groups, gboolean is_favourite, const gchar* alias, gboolean is_in_contact_list, gboolean is_user, GLoadableIcon* avatar, GDateTime* birthday, const gchar* full_name, FolksSmallSet* email_addresses, FolksSmallSet* phone_numbers, FolksSmallSet* urls);
void tpf_persona_set_is_in_contact_list (TpfPersona* self, gboolean value);
void _tpf_persona_store_update_avatar_cache (TpfPersonaStore* self, const gchar* persona_iid, GFile* avatar_file);
static void _tpf_persona_contact_notify_presence_message (TpfPersona* self);
static void _tpf_persona_contact_notify_presence_type (TpfPersona* self);
static FolksPresenceType _tpf_persona_folks_presence_type_from_tp (TpConnectionPresenceType type);
static void _tpf_persona_contact_notify_client_types (TpfPersona* self);
static void _tpf_persona_contact_notify_presence_status (TpfPersona* self);
static void _tpf_persona_contact_notify_avatar (TpfPersona* self);
GFile* _tpf_persona_store_query_avatar_cache (TpfPersonaStore* self, const gchar* persona_iid);
TpfPersona* tpf_persona_dup_for_contact (TpContact* contact);
TpfPersonaStore* tpf_persona_store_dup_for_account (TpAccount* account);
TpfPersona* _tpf_persona_store_ensure_persona_for_contact (TpfPersonaStore* self, TpContact* contact);
void _tpf_persona_increase_im_interaction_counter (TpfPersona* self, GDateTime* converted_datetime);
void _tpf_persona_increase_last_call_interaction_counter (TpfPersona* self, GDateTime* converted_datetime);
gboolean tpf_persona_get_is_in_contact_list (TpfPersona* self);
static gchar** _vala_array_dup2 (gchar** self, int length);
TpContact* tpf_persona_get_contact (TpfPersona* self);
static void tpf_persona_set_contact (TpfPersona* self, TpContact* value);
static GObject * tpf_persona_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void _tpf_persona___lambda16_ (TpfPersona* self, GObject* s, GParamSpec* p);
static void __tpf_persona___lambda16__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _tpf_persona___lambda17_ (TpfPersona* self, GObject* s, GParamSpec* p);
static void __tpf_persona___lambda17__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _tpf_persona___lambda18_ (TpfPersona* self, GObject* s, GParamSpec* p);
static void __tpf_persona___lambda18__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _tpf_persona___lambda19_ (TpfPersona* self, GObject* s, GParamSpec* p);
static void __tpf_persona___lambda19__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _tpf_persona___lambda20_ (TpfPersona* self, GObject* s, GParamSpec* p);
static void __tpf_persona___lambda20__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _tpf_persona___lambda21_ (TpfPersona* self, GObject* s, GParamSpec* p);
static void __tpf_persona___lambda21__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _tpf_persona___lambda22_ (TpfPersona* self, GObject* s, GParamSpec* p);
static void __tpf_persona___lambda22__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _tpf_persona___lambda23_ (TpfPersona* self, gchar** added, int added_length1, gchar** removed, int removed_length1);
static void __tpf_persona___lambda23__tp_contact_contact_groups_changed (TpContact* _sender, gchar** added, gchar** removed, gpointer self);
static void _tpf_persona____lambda24_ (TpfPersona* self, GObject* s, GParamSpec* p);
static void __tpf_persona____lambda24__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _tpf_persona___lambda25_ (TpfPersona* self, GObject* s, GParamSpec* p);
static void __tpf_persona___lambda25__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void tpf_persona_finalize (GObject* obj);
static void _vala_tpf_persona_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_tpf_persona_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static const gchar* TPF_PERSONA__linkable_properties[2] = {"im-addresses", NULL};

static guint _folks_abstract_field_details_hash_static_gee_hash_data_func (gconstpointer v, gpointer self) {
	guint result;
	result = folks_abstract_field_details_hash_static ((FolksAbstractFieldDetails*) v);
	return result;
}


static gboolean _folks_abstract_field_details_equal_static_gee_equal_data_func (gconstpointer a, gconstpointer b, gpointer self) {
	gboolean result;
	result = folks_abstract_field_details_equal_static ((FolksAbstractFieldDetails*) a, (FolksAbstractFieldDetails*) b);
	return result;
}


static void tpf_persona_real_change_full_name_data_free (gpointer _data) {
	TpfPersonaChangeFullNameData* _data_;
	_data_ = _data;
	_g_free0 (_data_->full_name);
	_g_object_unref0 (_data_->self);
	g_slice_free (TpfPersonaChangeFullNameData, _data_);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void tpf_persona_real_change_full_name (FolksNameDetails* base, const gchar* full_name, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TpfPersona * self;
	TpfPersonaChangeFullNameData* _data_;
	TpfPersona* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	self = (TpfPersona*) base;
	_data_ = g_slice_new0 (TpfPersonaChangeFullNameData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, tpf_persona_real_change_full_name);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tpf_persona_real_change_full_name_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = full_name;
	_tmp2_ = g_strdup (_tmp1_);
	_g_free0 (_data_->full_name);
	_data_->full_name = _tmp2_;
	tpf_persona_real_change_full_name_co (_data_);
}


static void tpf_persona_real_change_full_name_finish (FolksNameDetails* base, GAsyncResult* _res_, GError** error) {
	TpfPersonaChangeFullNameData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * {@inheritDoc}
   *
   * @since 0.6.4
   */
static void tpf_persona_change_full_name_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TpfPersonaChangeFullNameData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	tpf_persona_real_change_full_name_co (_data_);
}


static gboolean tpf_persona_real_change_full_name_co (TpfPersonaChangeFullNameData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = folks_persona_get_store ((FolksPersona*) _data_->self);
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = _data_->_tmp0_;
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp1_, TPF_TYPE_PERSONA_STORE) ? ((TpfPersonaStore*) _data_->_tmp1_) : NULL);
	_data_->tpf_store = _data_->_tmp2_;
	_data_->_tmp3_ = NULL;
	_data_->_tmp3_ = _data_->full_name;
	_data_->_tmp4_ = NULL;
	_data_->_tmp4_ = _data_->self->priv->_full_name;
	if (g_strcmp0 (_data_->_tmp3_, _data_->_tmp4_) == 0) {
		_g_object_unref0 (_data_->tpf_store);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp5_ = FALSE;
	_data_->_tmp5_ = _data_->self->priv->_is_constructed;
	if (_data_->_tmp5_) {
		{
			_data_->_tmp6_ = NULL;
			_data_->_tmp6_ = _data_->tpf_store;
			_data_->_tmp7_ = NULL;
			_data_->_tmp7_ = _data_->full_name;
			_data_->_state_ = 1;
			tpf_persona_store_change_user_full_name (_data_->_tmp6_, _data_->self, _data_->_tmp7_, tpf_persona_change_full_name_ready, _data_);
			return FALSE;
			_state_1:
			tpf_persona_store_change_user_full_name_finish (_data_->_tmp6_, _data_->_res_, &_data_->_inner_error_);
			if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
				if (g_error_matches (_data_->_inner_error_, FOLKS_PERSONA_STORE_ERROR, FOLKS_PERSONA_STORE_ERROR_INVALID_ARGUMENT)) {
					goto __catch0_folks_persona_store_error_invalid_argument;
				}
				if (g_error_matches (_data_->_inner_error_, FOLKS_PERSONA_STORE_ERROR, FOLKS_PERSONA_STORE_ERROR_STORE_OFFLINE)) {
					goto __catch0_folks_persona_store_error_store_offline;
				}
				if (_data_->_inner_error_->domain == FOLKS_PERSONA_STORE_ERROR) {
					goto __catch0_folks_persona_store_error;
				}
				_g_object_unref0 (_data_->tpf_store);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
				g_clear_error (&_data_->_inner_error_);
				return FALSE;
			}
		}
		goto __finally0;
		__catch0_folks_persona_store_error_invalid_argument:
		{
			_data_->e1 = _data_->_inner_error_;
			_data_->_inner_error_ = NULL;
			_data_->_tmp8_ = NULL;
			_data_->_tmp8_ = _data_->e1;
			_data_->_tmp9_ = NULL;
			_data_->_tmp9_ = _data_->_tmp8_->message;
			_data_->_tmp10_ = NULL;
			_data_->_tmp10_ = g_error_new_literal (FOLKS_PROPERTY_ERROR, FOLKS_PROPERTY_ERROR_NOT_WRITEABLE, _data_->_tmp9_);
			_data_->_inner_error_ = _data_->_tmp10_;
			_g_error_free0 (_data_->e1);
			goto __finally0;
		}
		goto __finally0;
		__catch0_folks_persona_store_error_store_offline:
		{
			_data_->e2 = _data_->_inner_error_;
			_data_->_inner_error_ = NULL;
			_data_->_tmp11_ = NULL;
			_data_->_tmp11_ = _data_->e2;
			_data_->_tmp12_ = NULL;
			_data_->_tmp12_ = _data_->_tmp11_->message;
			_data_->_tmp13_ = NULL;
			_data_->_tmp13_ = g_error_new_literal (FOLKS_PROPERTY_ERROR, FOLKS_PROPERTY_ERROR_UNKNOWN_ERROR, _data_->_tmp12_);
			_data_->_inner_error_ = _data_->_tmp13_;
			_g_error_free0 (_data_->e2);
			goto __finally0;
		}
		goto __finally0;
		__catch0_folks_persona_store_error:
		{
			_data_->e3 = _data_->_inner_error_;
			_data_->_inner_error_ = NULL;
			_data_->_tmp14_ = NULL;
			_data_->_tmp14_ = _data_->e3;
			_data_->_tmp15_ = NULL;
			_data_->_tmp15_ = _data_->_tmp14_->message;
			_data_->_tmp16_ = NULL;
			_data_->_tmp16_ = g_error_new_literal (FOLKS_PROPERTY_ERROR, FOLKS_PROPERTY_ERROR_UNKNOWN_ERROR, _data_->_tmp15_);
			_data_->_inner_error_ = _data_->_tmp16_;
			_g_error_free0 (_data_->e3);
			goto __finally0;
		}
		__finally0:
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			if (_data_->_inner_error_->domain == FOLKS_PROPERTY_ERROR) {
				g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
				g_error_free (_data_->_inner_error_);
				_g_object_unref0 (_data_->tpf_store);
				if (_data_->_state_ == 0) {
					g_simple_async_result_complete_in_idle (_data_->_async_result);
				} else {
					g_simple_async_result_complete (_data_->_async_result);
				}
				g_object_unref (_data_->_async_result);
				return FALSE;
			} else {
				_g_object_unref0 (_data_->tpf_store);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
				g_clear_error (&_data_->_inner_error_);
				return FALSE;
			}
		}
	}
	_g_object_unref0 (_data_->tpf_store);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void tpf_persona_real_change_birthday_data_free (gpointer _data) {
	TpfPersonaChangeBirthdayData* _data_;
	_data_ = _data;
	_g_date_time_unref0 (_data_->birthday);
	_g_object_unref0 (_data_->self);
	g_slice_free (TpfPersonaChangeBirthdayData, _data_);
}


static gpointer _g_date_time_ref0 (gpointer self) {
	return self ? g_date_time_ref (self) : NULL;
}


static void tpf_persona_real_change_birthday (FolksBirthdayDetails* base, GDateTime* birthday, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TpfPersona * self;
	TpfPersonaChangeBirthdayData* _data_;
	TpfPersona* _tmp0_ = NULL;
	GDateTime* _tmp1_ = NULL;
	GDateTime* _tmp2_ = NULL;
	self = (TpfPersona*) base;
	_data_ = g_slice_new0 (TpfPersonaChangeBirthdayData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, tpf_persona_real_change_birthday);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tpf_persona_real_change_birthday_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = birthday;
	_tmp2_ = _g_date_time_ref0 (_tmp1_);
	_g_date_time_unref0 (_data_->birthday);
	_data_->birthday = _tmp2_;
	tpf_persona_real_change_birthday_co (_data_);
}


static void tpf_persona_real_change_birthday_finish (FolksBirthdayDetails* base, GAsyncResult* _res_, GError** error) {
	TpfPersonaChangeBirthdayData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * {@inheritDoc}
   *
   * @since 0.6.4
   */
static void tpf_persona_change_birthday_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TpfPersonaChangeBirthdayData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	tpf_persona_real_change_birthday_co (_data_);
}


static gboolean tpf_persona_real_change_birthday_co (TpfPersonaChangeBirthdayData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = folks_persona_get_store ((FolksPersona*) _data_->self);
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = _data_->_tmp0_;
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp1_, TPF_TYPE_PERSONA_STORE) ? ((TpfPersonaStore*) _data_->_tmp1_) : NULL);
	_data_->tpf_store = _data_->_tmp2_;
	_data_->_tmp5_ = NULL;
	_data_->_tmp5_ = _data_->birthday;
	if (_data_->_tmp5_ != NULL) {
		_data_->_tmp6_ = NULL;
		_data_->_tmp6_ = _data_->self->priv->_birthday;
		_data_->_tmp4_ = _data_->_tmp6_ != NULL;
	} else {
		_data_->_tmp4_ = FALSE;
	}
	if (_data_->_tmp4_) {
		_data_->_tmp7_ = NULL;
		_data_->_tmp7_ = _data_->birthday;
		_data_->_tmp8_ = NULL;
		_data_->_tmp8_ = _data_->self->priv->_birthday;
		_data_->_tmp9_ = FALSE;
		_data_->_tmp9_ = g_date_time_equal (_data_->_tmp7_, _data_->_tmp8_);
		_data_->_tmp3_ = _data_->_tmp9_;
	} else {
		_data_->_tmp3_ = FALSE;
	}
	if (_data_->_tmp3_) {
		_g_object_unref0 (_data_->tpf_store);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp10_ = FALSE;
	_data_->_tmp10_ = _data_->self->priv->_is_constructed;
	if (_data_->_tmp10_) {
		{
			_data_->_tmp11_ = NULL;
			_data_->_tmp11_ = _data_->tpf_store;
			_data_->_tmp12_ = NULL;
			_data_->_tmp12_ = _data_->birthday;
			_data_->_state_ = 1;
			tpf_persona_store_change_user_birthday (_data_->_tmp11_, _data_->self, _data_->_tmp12_, tpf_persona_change_birthday_ready, _data_);
			return FALSE;
			_state_1:
			tpf_persona_store_change_user_birthday_finish (_data_->_tmp11_, _data_->_res_, &_data_->_inner_error_);
			if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
				if (g_error_matches (_data_->_inner_error_, FOLKS_PERSONA_STORE_ERROR, FOLKS_PERSONA_STORE_ERROR_INVALID_ARGUMENT)) {
					goto __catch1_folks_persona_store_error_invalid_argument;
				}
				if (g_error_matches (_data_->_inner_error_, FOLKS_PERSONA_STORE_ERROR, FOLKS_PERSONA_STORE_ERROR_STORE_OFFLINE)) {
					goto __catch1_folks_persona_store_error_store_offline;
				}
				if (_data_->_inner_error_->domain == FOLKS_PERSONA_STORE_ERROR) {
					goto __catch1_folks_persona_store_error;
				}
				_g_object_unref0 (_data_->tpf_store);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
				g_clear_error (&_data_->_inner_error_);
				return FALSE;
			}
		}
		goto __finally1;
		__catch1_folks_persona_store_error_invalid_argument:
		{
			_data_->e1 = _data_->_inner_error_;
			_data_->_inner_error_ = NULL;
			_data_->_tmp13_ = NULL;
			_data_->_tmp13_ = _data_->e1;
			_data_->_tmp14_ = NULL;
			_data_->_tmp14_ = _data_->_tmp13_->message;
			_data_->_tmp15_ = NULL;
			_data_->_tmp15_ = g_error_new_literal (FOLKS_PROPERTY_ERROR, FOLKS_PROPERTY_ERROR_NOT_WRITEABLE, _data_->_tmp14_);
			_data_->_inner_error_ = _data_->_tmp15_;
			_g_error_free0 (_data_->e1);
			goto __finally1;
		}
		goto __finally1;
		__catch1_folks_persona_store_error_store_offline:
		{
			_data_->e2 = _data_->_inner_error_;
			_data_->_inner_error_ = NULL;
			_data_->_tmp16_ = NULL;
			_data_->_tmp16_ = _data_->e2;
			_data_->_tmp17_ = NULL;
			_data_->_tmp17_ = _data_->_tmp16_->message;
			_data_->_tmp18_ = NULL;
			_data_->_tmp18_ = g_error_new_literal (FOLKS_PROPERTY_ERROR, FOLKS_PROPERTY_ERROR_UNKNOWN_ERROR, _data_->_tmp17_);
			_data_->_inner_error_ = _data_->_tmp18_;
			_g_error_free0 (_data_->e2);
			goto __finally1;
		}
		goto __finally1;
		__catch1_folks_persona_store_error:
		{
			_data_->e3 = _data_->_inner_error_;
			_data_->_inner_error_ = NULL;
			_data_->_tmp19_ = NULL;
			_data_->_tmp19_ = _data_->e3;
			_data_->_tmp20_ = NULL;
			_data_->_tmp20_ = _data_->_tmp19_->message;
			_data_->_tmp21_ = NULL;
			_data_->_tmp21_ = g_error_new_literal (FOLKS_PROPERTY_ERROR, FOLKS_PROPERTY_ERROR_UNKNOWN_ERROR, _data_->_tmp20_);
			_data_->_inner_error_ = _data_->_tmp21_;
			_g_error_free0 (_data_->e3);
			goto __finally1;
		}
		__finally1:
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			if (_data_->_inner_error_->domain == FOLKS_PROPERTY_ERROR) {
				g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
				g_error_free (_data_->_inner_error_);
				_g_object_unref0 (_data_->tpf_store);
				if (_data_->_state_ == 0) {
					g_simple_async_result_complete_in_idle (_data_->_async_result);
				} else {
					g_simple_async_result_complete (_data_->_async_result);
				}
				g_object_unref (_data_->_async_result);
				return FALSE;
			} else {
				_g_object_unref0 (_data_->tpf_store);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
				g_clear_error (&_data_->_inner_error_);
				return FALSE;
			}
		}
	}
	_g_object_unref0 (_data_->tpf_store);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void tpf_persona_real_change_alias_data_free (gpointer _data) {
	TpfPersonaChangeAliasData* _data_;
	_data_ = _data;
	_g_free0 (_data_->alias);
	_g_object_unref0 (_data_->self);
	g_slice_free (TpfPersonaChangeAliasData, _data_);
}


static void tpf_persona_real_change_alias (FolksAliasDetails* base, const gchar* alias, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TpfPersona * self;
	TpfPersonaChangeAliasData* _data_;
	TpfPersona* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	self = (TpfPersona*) base;
	_data_ = g_slice_new0 (TpfPersonaChangeAliasData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, tpf_persona_real_change_alias);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tpf_persona_real_change_alias_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = alias;
	_tmp2_ = g_strdup (_tmp1_);
	_g_free0 (_data_->alias);
	_data_->alias = _tmp2_;
	tpf_persona_real_change_alias_co (_data_);
}


static void tpf_persona_real_change_alias_finish (FolksAliasDetails* base, GAsyncResult* _res_, GError** error) {
	TpfPersonaChangeAliasData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * {@inheritDoc}
   *
   * @since 0.6.2
   */
static void tpf_persona_change_alias_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TpfPersonaChangeAliasData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	tpf_persona_real_change_alias_co (_data_);
}


static gboolean tpf_persona_real_change_alias_co (TpfPersonaChangeAliasData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = _data_->self->priv->_alias;
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = _data_->alias;
	if (g_strcmp0 (_data_->_tmp0_, _data_->_tmp1_) == 0) {
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp2_ = FALSE;
	_data_->_tmp2_ = _data_->self->priv->_is_constructed;
	if (_data_->_tmp2_) {
		_data_->_tmp3_ = NULL;
		_data_->_tmp3_ = folks_persona_get_store ((FolksPersona*) _data_->self);
		_data_->_tmp4_ = NULL;
		_data_->_tmp4_ = _data_->_tmp3_;
		_data_->_tmp5_ = NULL;
		_data_->_tmp5_ = _data_->alias;
		_data_->_state_ = 1;
		tpf_persona_store_change_alias (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp4_, TPF_TYPE_PERSONA_STORE, TpfPersonaStore), _data_->self, _data_->_tmp5_, tpf_persona_change_alias_ready, _data_);
		return FALSE;
		_state_1:
		tpf_persona_store_change_alias_finish (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp4_, TPF_TYPE_PERSONA_STORE, TpfPersonaStore), _data_->_res_, &_data_->_inner_error_);
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			if (_data_->_inner_error_->domain == FOLKS_PROPERTY_ERROR) {
				g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
				g_error_free (_data_->_inner_error_);
				if (_data_->_state_ == 0) {
					g_simple_async_result_complete_in_idle (_data_->_async_result);
				} else {
					g_simple_async_result_complete (_data_->_async_result);
				}
				g_object_unref (_data_->_async_result);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
				g_clear_error (&_data_->_inner_error_);
				return FALSE;
			}
		}
	}
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void tpf_persona_real_change_is_favourite_data_free (gpointer _data) {
	TpfPersonaChangeIsFavouriteData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (TpfPersonaChangeIsFavouriteData, _data_);
}


static void tpf_persona_real_change_is_favourite (FolksFavouriteDetails* base, gboolean is_favourite, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TpfPersona * self;
	TpfPersonaChangeIsFavouriteData* _data_;
	TpfPersona* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	self = (TpfPersona*) base;
	_data_ = g_slice_new0 (TpfPersonaChangeIsFavouriteData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, tpf_persona_real_change_is_favourite);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tpf_persona_real_change_is_favourite_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = is_favourite;
	_data_->is_favourite = _tmp1_;
	tpf_persona_real_change_is_favourite_co (_data_);
}


static void tpf_persona_real_change_is_favourite_finish (FolksFavouriteDetails* base, GAsyncResult* _res_, GError** error) {
	TpfPersonaChangeIsFavouriteData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * {@inheritDoc}
   *
   * @since 0.6.2
   */
static void tpf_persona_change_is_favourite_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TpfPersonaChangeIsFavouriteData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	tpf_persona_real_change_is_favourite_co (_data_);
}


static gboolean tpf_persona_real_change_is_favourite_co (TpfPersonaChangeIsFavouriteData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = FALSE;
	_data_->_tmp0_ = _data_->self->priv->_is_favourite;
	_data_->_tmp1_ = FALSE;
	_data_->_tmp1_ = _data_->is_favourite;
	if (_data_->_tmp0_ == _data_->_tmp1_) {
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp2_ = FALSE;
	_data_->_tmp2_ = _data_->self->priv->_is_constructed;
	if (_data_->_tmp2_) {
		_data_->_tmp3_ = NULL;
		_data_->_tmp3_ = folks_persona_get_store ((FolksPersona*) _data_->self);
		_data_->_tmp4_ = NULL;
		_data_->_tmp4_ = _data_->_tmp3_;
		_data_->_tmp5_ = FALSE;
		_data_->_tmp5_ = _data_->is_favourite;
		_data_->_state_ = 1;
		tpf_persona_store_change_is_favourite (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp4_, TPF_TYPE_PERSONA_STORE, TpfPersonaStore), (FolksPersona*) _data_->self, _data_->_tmp5_, tpf_persona_change_is_favourite_ready, _data_);
		return FALSE;
		_state_1:
		tpf_persona_store_change_is_favourite_finish (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp4_, TPF_TYPE_PERSONA_STORE, TpfPersonaStore), _data_->_res_, &_data_->_inner_error_);
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			if (_data_->_inner_error_->domain == FOLKS_PROPERTY_ERROR) {
				g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
				g_error_free (_data_->_inner_error_);
				if (_data_->_state_ == 0) {
					g_simple_async_result_complete_in_idle (_data_->_async_result);
				} else {
					g_simple_async_result_complete (_data_->_async_result);
				}
				g_object_unref (_data_->_async_result);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
				g_clear_error (&_data_->_inner_error_);
				return FALSE;
			}
		}
	}
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


void _tpf_persona_set_is_favourite (TpfPersona* self, gboolean is_favourite) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	FolksPersonaStore* _tmp3_ = NULL;
	FolksPersonaStore* _tmp4_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_is_favourite;
	_tmp1_ = is_favourite;
	if (_tmp0_ == _tmp1_) {
		return;
	}
	_tmp2_ = is_favourite;
	self->priv->_is_favourite = _tmp2_;
	g_object_notify ((GObject*) self, "is-favourite");
	_tmp3_ = folks_persona_get_store ((FolksPersona*) self);
	_tmp4_ = _tmp3_;
	_tpf_persona_store_set_cache_needs_update (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, TPF_TYPE_PERSONA_STORE, TpfPersonaStore));
}


static void tpf_persona_real_change_email_addresses_data_free (gpointer _data) {
	TpfPersonaChangeEmailAddressesData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->email_addresses);
	_g_object_unref0 (_data_->self);
	g_slice_free (TpfPersonaChangeEmailAddressesData, _data_);
}


static void tpf_persona_real_change_email_addresses (FolksEmailDetails* base, GeeSet* email_addresses, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TpfPersona * self;
	TpfPersonaChangeEmailAddressesData* _data_;
	TpfPersona* _tmp0_ = NULL;
	GeeSet* _tmp1_ = NULL;
	GeeSet* _tmp2_ = NULL;
	self = (TpfPersona*) base;
	_data_ = g_slice_new0 (TpfPersonaChangeEmailAddressesData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, tpf_persona_real_change_email_addresses);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tpf_persona_real_change_email_addresses_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = email_addresses;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (_data_->email_addresses);
	_data_->email_addresses = _tmp2_;
	tpf_persona_real_change_email_addresses_co (_data_);
}


static void tpf_persona_real_change_email_addresses_finish (FolksEmailDetails* base, GAsyncResult* _res_, GError** error) {
	TpfPersonaChangeEmailAddressesData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * {@inheritDoc}
   *
   * @since 0.6.4
   */
static void tpf_persona_change_email_addresses_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TpfPersonaChangeEmailAddressesData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	tpf_persona_real_change_email_addresses_co (_data_);
}


static gboolean tpf_persona_real_change_email_addresses_co (TpfPersonaChangeEmailAddressesData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = _data_->email_addresses;
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = _data_->self->priv->_email_addresses;
	_data_->_state_ = 1;
	_tpf_persona_change_details (_data_->self, FOLKS_TYPE_EMAIL_FIELD_DETAILS, (GBoxedCopyFunc) g_object_ref, g_object_unref, _data_->_tmp0_, (GeeSet*) _data_->_tmp1_, "email", tpf_persona_change_email_addresses_ready, _data_);
	return FALSE;
	_state_1:
	_tpf_persona_change_details_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		if (_data_->_inner_error_->domain == FOLKS_PROPERTY_ERROR) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
	}
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void tpf_persona_real_change_group_data_free (gpointer _data) {
	TpfPersonaChangeGroupData* _data_;
	_data_ = _data;
	_g_free0 (_data_->group);
	_g_object_unref0 (_data_->self);
	g_slice_free (TpfPersonaChangeGroupData, _data_);
}


static void tpf_persona_real_change_group (FolksGroupDetails* base, const gchar* group, gboolean is_member, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TpfPersona * self;
	TpfPersonaChangeGroupData* _data_;
	TpfPersona* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	self = (TpfPersona*) base;
	_data_ = g_slice_new0 (TpfPersonaChangeGroupData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, tpf_persona_real_change_group);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tpf_persona_real_change_group_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = group;
	_tmp2_ = g_strdup (_tmp1_);
	_g_free0 (_data_->group);
	_data_->group = _tmp2_;
	_tmp3_ = is_member;
	_data_->is_member = _tmp3_;
	tpf_persona_real_change_group_co (_data_);
}


static void tpf_persona_real_change_group_finish (FolksGroupDetails* base, GAsyncResult* _res_, GError** error) {
	TpfPersonaChangeGroupData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * Add or remove the Persona from the specified group.
   *
   * See {@link Folks.GroupDetails.change_group}.
   *
   * @throws Folks.PropertyError.UNKNOWN_ERROR if changing group membership
   * failed
   */
static void tpf_persona_change_group_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TpfPersonaChangeGroupData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	tpf_persona_real_change_group_co (_data_);
}


static gboolean tpf_persona_real_change_group_co (TpfPersonaChangeGroupData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = _data_->self->priv->_contact;
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp0_, tp_contact_get_type (), TpContact));
	_data_->contact = _data_->_tmp1_;
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = _data_->contact;
	if (_data_->_tmp2_ == NULL) {
		_data_->_tmp3_ = NULL;
		_data_->_tmp3_ = _ ("Failed to change group membership: %s");
		_data_->_tmp4_ = NULL;
		_data_->_tmp4_ = _ ("Account is offline.");
		_data_->_tmp5_ = NULL;
		_data_->_tmp5_ = g_error_new (FOLKS_PROPERTY_ERROR, FOLKS_PROPERTY_ERROR_UNAVAILABLE, _data_->_tmp3_, _data_->_tmp4_);
		_data_->_inner_error_ = _data_->_tmp5_;
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		_g_object_unref0 (_data_->contact);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	{
		_data_->_tmp7_ = FALSE;
		_data_->_tmp7_ = _data_->is_member;
		if (_data_->_tmp7_) {
			_data_->_tmp8_ = NULL;
			_data_->_tmp8_ = _data_->self->priv->_groups;
			_data_->_tmp9_ = NULL;
			_data_->_tmp9_ = _data_->group;
			_data_->_tmp10_ = FALSE;
			_data_->_tmp10_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _data_->_tmp8_, _data_->_tmp9_);
			_data_->_tmp6_ = !_data_->_tmp10_;
		} else {
			_data_->_tmp6_ = FALSE;
		}
		if (_data_->_tmp6_) {
			_data_->_tmp11_ = NULL;
			_data_->_tmp11_ = _data_->contact;
			_data_->_tmp12_ = NULL;
			_data_->_tmp12_ = _data_->group;
			_data_->_state_ = 1;
			tp_contact_add_to_group_async (_data_->_tmp11_, _data_->_tmp12_, tpf_persona_change_group_ready, _data_);
			return FALSE;
			_state_1:
			tp_contact_add_to_group_finish (_data_->_tmp11_, _data_->_res_, &_data_->_inner_error_);
			if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
				goto __catch2_g_error;
			}
		} else {
			_data_->_tmp14_ = FALSE;
			_data_->_tmp14_ = _data_->is_member;
			if (!_data_->_tmp14_) {
				_data_->_tmp15_ = NULL;
				_data_->_tmp15_ = _data_->self->priv->_groups;
				_data_->_tmp16_ = NULL;
				_data_->_tmp16_ = _data_->group;
				_data_->_tmp17_ = FALSE;
				_data_->_tmp17_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _data_->_tmp15_, _data_->_tmp16_);
				_data_->_tmp13_ = _data_->_tmp17_;
			} else {
				_data_->_tmp13_ = FALSE;
			}
			if (_data_->_tmp13_) {
				_data_->_tmp18_ = NULL;
				_data_->_tmp18_ = _data_->contact;
				_data_->_tmp19_ = NULL;
				_data_->_tmp19_ = _data_->group;
				_data_->_state_ = 2;
				tp_contact_remove_from_group_async (_data_->_tmp18_, _data_->_tmp19_, tpf_persona_change_group_ready, _data_);
				return FALSE;
				_state_2:
				tp_contact_remove_from_group_finish (_data_->_tmp18_, _data_->_res_, &_data_->_inner_error_);
				if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
					goto __catch2_g_error;
				}
			}
		}
	}
	goto __finally2;
	__catch2_g_error:
	{
		_data_->e = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp20_ = NULL;
		_data_->_tmp20_ = _ ("Failed to change group membership: %s");
		_data_->_tmp21_ = NULL;
		_data_->_tmp21_ = _data_->e;
		_data_->_tmp22_ = NULL;
		_data_->_tmp22_ = _data_->_tmp21_->message;
		_data_->_tmp23_ = NULL;
		_data_->_tmp23_ = g_error_new (FOLKS_PROPERTY_ERROR, FOLKS_PROPERTY_ERROR_UNKNOWN_ERROR, _data_->_tmp20_, _data_->_tmp22_);
		_data_->_inner_error_ = _data_->_tmp23_;
		_g_error_free0 (_data_->e);
		goto __finally2;
	}
	__finally2:
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		_g_object_unref0 (_data_->contact);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_g_object_unref0 (_data_->contact);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void _tpf_persona_contact_groups_changed (TpfPersona* self, gchar** added, int added_length1, gchar** removed, int removed_length1) {
	gboolean changed = FALSE;
	gchar** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gchar** _tmp6_ = NULL;
	gint _tmp6__length1 = 0;
	gboolean _tmp12_ = FALSE;
	g_return_if_fail (self != NULL);
	changed = FALSE;
	_tmp0_ = added;
	_tmp0__length1 = added_length1;
	{
		gchar** group_collection = NULL;
		gint group_collection_length1 = 0;
		gint _group_collection_size_ = 0;
		gint group_it = 0;
		group_collection = _tmp0_;
		group_collection_length1 = _tmp0__length1;
		for (group_it = 0; group_it < _tmp0__length1; group_it = group_it + 1) {
			gchar* _tmp1_ = NULL;
			gchar* group = NULL;
			_tmp1_ = g_strdup (group_collection[group_it]);
			group = _tmp1_;
			{
				FolksSmallSet* _tmp2_ = NULL;
				const gchar* _tmp3_ = NULL;
				gboolean _tmp4_ = FALSE;
				_tmp2_ = self->priv->_groups;
				_tmp3_ = group;
				_tmp4_ = gee_abstract_collection_add ((GeeAbstractCollection*) _tmp2_, _tmp3_);
				if (_tmp4_ == TRUE) {
					const gchar* _tmp5_ = NULL;
					changed = TRUE;
					_tmp5_ = group;
					g_signal_emit_by_name ((FolksGroupDetails*) self, "group-changed", _tmp5_, TRUE);
				}
				_g_free0 (group);
			}
		}
	}
	_tmp6_ = removed;
	_tmp6__length1 = removed_length1;
	{
		gchar** group_collection = NULL;
		gint group_collection_length1 = 0;
		gint _group_collection_size_ = 0;
		gint group_it = 0;
		group_collection = _tmp6_;
		group_collection_length1 = _tmp6__length1;
		for (group_it = 0; group_it < _tmp6__length1; group_it = group_it + 1) {
			gchar* _tmp7_ = NULL;
			gchar* group = NULL;
			_tmp7_ = g_strdup (group_collection[group_it]);
			group = _tmp7_;
			{
				FolksSmallSet* _tmp8_ = NULL;
				const gchar* _tmp9_ = NULL;
				gboolean _tmp10_ = FALSE;
				_tmp8_ = self->priv->_groups;
				_tmp9_ = group;
				_tmp10_ = gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp8_, _tmp9_);
				if (_tmp10_ == TRUE) {
					const gchar* _tmp11_ = NULL;
					changed = TRUE;
					_tmp11_ = group;
					g_signal_emit_by_name ((FolksGroupDetails*) self, "group-changed", _tmp11_, FALSE);
				}
				_g_free0 (group);
			}
		}
	}
	_tmp12_ = changed;
	if (_tmp12_ == TRUE) {
		FolksPersonaStore* _tmp13_ = NULL;
		FolksPersonaStore* _tmp14_ = NULL;
		g_object_notify ((GObject*) self, "groups");
		_tmp13_ = folks_persona_get_store ((FolksPersona*) self);
		_tmp14_ = _tmp13_;
		_tpf_persona_store_set_cache_needs_update (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, TPF_TYPE_PERSONA_STORE, TpfPersonaStore));
	}
}


static void tpf_persona_real_change_groups_data_free (gpointer _data) {
	TpfPersonaChangeGroupsData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->groups);
	_g_object_unref0 (_data_->self);
	g_slice_free (TpfPersonaChangeGroupsData, _data_);
}


static void tpf_persona_real_change_groups (FolksGroupDetails* base, GeeSet* groups, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TpfPersona * self;
	TpfPersonaChangeGroupsData* _data_;
	TpfPersona* _tmp0_ = NULL;
	GeeSet* _tmp1_ = NULL;
	GeeSet* _tmp2_ = NULL;
	self = (TpfPersona*) base;
	_data_ = g_slice_new0 (TpfPersonaChangeGroupsData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, tpf_persona_real_change_groups);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tpf_persona_real_change_groups_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = groups;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (_data_->groups);
	_data_->groups = _tmp2_;
	tpf_persona_real_change_groups_co (_data_);
}


static void tpf_persona_real_change_groups_finish (FolksGroupDetails* base, GAsyncResult* _res_, GError** error) {
	TpfPersonaChangeGroupsData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * {@inheritDoc}
   *
   * @since 0.6.2
   */
static void tpf_persona_change_groups_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TpfPersonaChangeGroupsData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	tpf_persona_real_change_groups_co (_data_);
}


static gboolean tpf_persona_real_change_groups_co (TpfPersonaChangeGroupsData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = _data_->self->priv->_contact;
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp0_, tp_contact_get_type (), TpContact));
	_data_->contact = _data_->_tmp1_;
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = _data_->contact;
	if (_data_->_tmp2_ == NULL) {
		_data_->_tmp3_ = NULL;
		_data_->_tmp3_ = _ ("Failed to change group membership: %s");
		_data_->_tmp4_ = NULL;
		_data_->_tmp4_ = _ ("Account is offline.");
		_data_->_tmp5_ = NULL;
		_data_->_tmp5_ = g_error_new (FOLKS_PROPERTY_ERROR, FOLKS_PROPERTY_ERROR_UNAVAILABLE, _data_->_tmp3_, _data_->_tmp4_);
		_data_->_inner_error_ = _data_->_tmp5_;
		if (_data_->_inner_error_->domain == FOLKS_PROPERTY_ERROR) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			_g_object_unref0 (_data_->contact);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			_g_object_unref0 (_data_->contact);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
	}
	{
		_data_->_tmp6_ = NULL;
		_data_->_tmp6_ = _data_->contact;
		_data_->_tmp7_ = NULL;
		_data_->_tmp7_ = _data_->groups;
		_data_->_tmp8_ = 0;
		_data_->_tmp9_ = NULL;
		_data_->_tmp9_ = gee_collection_to_array ((GeeCollection*) _data_->_tmp7_, &_data_->_tmp8_);
		_data_->_tmp10_ = NULL;
		_data_->_tmp10__length1 = 0;
		_data_->_tmp10_ = _data_->_tmp9_;
		_data_->_tmp10__length1 = _data_->_tmp8_;
		_data_->_state_ = 1;
		tp_contact_set_contact_groups_async (_data_->_tmp6_, _data_->_tmp8_, _data_->_tmp10_, tpf_persona_change_groups_ready, _data_);
		return FALSE;
		_state_1:
		tp_contact_set_contact_groups_finish (_data_->_tmp6_, _data_->_res_, &_data_->_inner_error_);
		_data_->_tmp10_ = (_vala_array_free (_data_->_tmp10_, _data_->_tmp10__length1, (GDestroyNotify) g_free), NULL);
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			goto __catch3_g_error;
		}
	}
	goto __finally3;
	__catch3_g_error:
	{
		_data_->e = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp11_ = NULL;
		_data_->_tmp11_ = _ ("Failed to change group membership: %s");
		_data_->_tmp12_ = NULL;
		_data_->_tmp12_ = _data_->e;
		_data_->_tmp13_ = NULL;
		_data_->_tmp13_ = _data_->_tmp12_->message;
		_data_->_tmp14_ = NULL;
		_data_->_tmp14_ = g_error_new (FOLKS_PROPERTY_ERROR, FOLKS_PROPERTY_ERROR_UNKNOWN_ERROR, _data_->_tmp11_, _data_->_tmp13_);
		_data_->_inner_error_ = _data_->_tmp14_;
		_g_error_free0 (_data_->e);
		goto __finally3;
	}
	__finally3:
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		if (_data_->_inner_error_->domain == FOLKS_PROPERTY_ERROR) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			_g_object_unref0 (_data_->contact);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			_g_object_unref0 (_data_->contact);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
	}
	_g_object_unref0 (_data_->contact);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


void _tpf_persona_contact_weak_notify (TpfPersona* self) {
	TpContact* _tmp0_ = NULL;
	TpContact* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_contact;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = self->priv->_contact;
	g_debug ("tpf-persona.vala:616: TpContact %p destroyed; setting ._contact = null" \
" in Persona %p", _tmp1_, self);
	self->priv->_contact = NULL;
	g_object_notify ((GObject*) self, "contact");
}


static void tpf_persona_real_change_phone_numbers_data_free (gpointer _data) {
	TpfPersonaChangePhoneNumbersData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->phone_numbers);
	_g_object_unref0 (_data_->self);
	g_slice_free (TpfPersonaChangePhoneNumbersData, _data_);
}


static void tpf_persona_real_change_phone_numbers (FolksPhoneDetails* base, GeeSet* phone_numbers, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TpfPersona * self;
	TpfPersonaChangePhoneNumbersData* _data_;
	TpfPersona* _tmp0_ = NULL;
	GeeSet* _tmp1_ = NULL;
	GeeSet* _tmp2_ = NULL;
	self = (TpfPersona*) base;
	_data_ = g_slice_new0 (TpfPersonaChangePhoneNumbersData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, tpf_persona_real_change_phone_numbers);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tpf_persona_real_change_phone_numbers_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = phone_numbers;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (_data_->phone_numbers);
	_data_->phone_numbers = _tmp2_;
	tpf_persona_real_change_phone_numbers_co (_data_);
}


static void tpf_persona_real_change_phone_numbers_finish (FolksPhoneDetails* base, GAsyncResult* _res_, GError** error) {
	TpfPersonaChangePhoneNumbersData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * {@inheritDoc}
   *
   * @since 0.6.4
   */
static void tpf_persona_change_phone_numbers_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TpfPersonaChangePhoneNumbersData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	tpf_persona_real_change_phone_numbers_co (_data_);
}


static gboolean tpf_persona_real_change_phone_numbers_co (TpfPersonaChangePhoneNumbersData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = _data_->phone_numbers;
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = _data_->self->priv->_phone_numbers;
	_data_->_state_ = 1;
	_tpf_persona_change_details (_data_->self, FOLKS_TYPE_PHONE_FIELD_DETAILS, (GBoxedCopyFunc) g_object_ref, g_object_unref, _data_->_tmp0_, (GeeSet*) _data_->_tmp1_, "tel", tpf_persona_change_phone_numbers_ready, _data_);
	return FALSE;
	_state_1:
	_tpf_persona_change_details_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		if (_data_->_inner_error_->domain == FOLKS_PROPERTY_ERROR) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
	}
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void tpf_persona_real_change_urls_data_free (gpointer _data) {
	TpfPersonaChangeUrlsData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->urls);
	_g_object_unref0 (_data_->self);
	g_slice_free (TpfPersonaChangeUrlsData, _data_);
}


static void tpf_persona_real_change_urls (FolksUrlDetails* base, GeeSet* urls, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TpfPersona * self;
	TpfPersonaChangeUrlsData* _data_;
	TpfPersona* _tmp0_ = NULL;
	GeeSet* _tmp1_ = NULL;
	GeeSet* _tmp2_ = NULL;
	self = (TpfPersona*) base;
	_data_ = g_slice_new0 (TpfPersonaChangeUrlsData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, tpf_persona_real_change_urls);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tpf_persona_real_change_urls_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = urls;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (_data_->urls);
	_data_->urls = _tmp2_;
	tpf_persona_real_change_urls_co (_data_);
}


static void tpf_persona_real_change_urls_finish (FolksUrlDetails* base, GAsyncResult* _res_, GError** error) {
	TpfPersonaChangeUrlsData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * {@inheritDoc}
   *
   * @since 0.6.4
   */
static void tpf_persona_change_urls_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TpfPersonaChangeUrlsData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	tpf_persona_real_change_urls_co (_data_);
}


static gboolean tpf_persona_real_change_urls_co (TpfPersonaChangeUrlsData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = _data_->urls;
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = _data_->self->priv->_urls;
	_data_->_state_ = 1;
	_tpf_persona_change_details (_data_->self, FOLKS_TYPE_URL_FIELD_DETAILS, (GBoxedCopyFunc) g_object_ref, g_object_unref, _data_->_tmp0_, (GeeSet*) _data_->_tmp1_, "url", tpf_persona_change_urls_ready, _data_);
	return FALSE;
	_state_1:
	_tpf_persona_change_details_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		if (_data_->_inner_error_->domain == FOLKS_PROPERTY_ERROR) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
	}
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void _tpf_persona_change_details_data_free (gpointer _data) {
	TpfPersonaChangeDetailsData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->details);
	_g_object_unref0 (_data_->member_set);
	_g_free0 (_data_->field_name);
	_g_object_unref0 (_data_->self);
	g_slice_free (TpfPersonaChangeDetailsData, _data_);
}


static void _tpf_persona_change_details (TpfPersona* self, GType t_type, GBoxedCopyFunc t_dup_func, GDestroyNotify t_destroy_func, GeeSet* details, GeeSet* member_set, const gchar* field_name, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TpfPersonaChangeDetailsData* _data_;
	TpfPersona* _tmp0_ = NULL;
	GeeSet* _tmp1_ = NULL;
	GeeSet* _tmp2_ = NULL;
	GeeSet* _tmp3_ = NULL;
	GeeSet* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	_data_ = g_slice_new0 (TpfPersonaChangeDetailsData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, _tpf_persona_change_details);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, _tpf_persona_change_details_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = details;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (_data_->details);
	_data_->details = _tmp2_;
	_tmp3_ = member_set;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	_g_object_unref0 (_data_->member_set);
	_data_->member_set = _tmp4_;
	_tmp5_ = field_name;
	_tmp6_ = g_strdup (_tmp5_);
	_g_free0 (_data_->field_name);
	_data_->field_name = _tmp6_;
	_data_->t_type = t_type;
	_data_->t_dup_func = t_dup_func;
	_data_->t_destroy_func = t_destroy_func;
	_tpf_persona_change_details_co (_data_);
}


static void _tpf_persona_change_details_finish (TpfPersona* self, GAsyncResult* _res_, GError** error) {
	TpfPersonaChangeDetailsData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void _tpf_persona_change_details_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TpfPersonaChangeDetailsData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	_tpf_persona_change_details_co (_data_);
}


static gboolean _tpf_persona_change_details_co (TpfPersonaChangeDetailsData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = folks_persona_get_store ((FolksPersona*) _data_->self);
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = _data_->_tmp0_;
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp1_, TPF_TYPE_PERSONA_STORE) ? ((TpfPersonaStore*) _data_->_tmp1_) : NULL);
	_data_->tpf_store = _data_->_tmp2_;
	_data_->_tmp4_ = NULL;
	_data_->_tmp4_ = _data_->member_set;
	if (_data_->_tmp4_ != NULL) {
		_data_->_tmp5_ = NULL;
		_data_->_tmp5_ = _data_->details;
		_data_->_tmp6_ = NULL;
		_data_->_tmp6_ = _data_->member_set;
		_data_->_tmp7_ = FALSE;
		_data_->_tmp7_ = folks_internal_equal_sets (_data_->t_type, (GBoxedCopyFunc) _data_->t_dup_func, _data_->t_destroy_func, _data_->_tmp5_, _data_->_tmp6_);
		_data_->_tmp3_ = _data_->_tmp7_;
	} else {
		_data_->_tmp3_ = FALSE;
	}
	if (_data_->_tmp3_) {
		_g_object_unref0 (_data_->tpf_store);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp8_ = FALSE;
	_data_->_tmp8_ = _data_->self->priv->_is_constructed;
	if (_data_->_tmp8_) {
		{
			_data_->_tmp9_ = NULL;
			_data_->_tmp9_ = _data_->tpf_store;
			_data_->_tmp10_ = NULL;
			_data_->_tmp10_ = _data_->details;
			_data_->_tmp11_ = NULL;
			_data_->_tmp11_ = _data_->field_name;
			_data_->_state_ = 1;
			_tpf_persona_store_change_user_details (_data_->_tmp9_, _data_->self, _data_->_tmp10_, _data_->_tmp11_, _tpf_persona_change_details_ready, _data_);
			return FALSE;
			_state_1:
			_tpf_persona_store_change_user_details_finish (_data_->_tmp9_, _data_->_res_, &_data_->_inner_error_);
			if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
				if (g_error_matches (_data_->_inner_error_, FOLKS_PERSONA_STORE_ERROR, FOLKS_PERSONA_STORE_ERROR_INVALID_ARGUMENT)) {
					goto __catch4_folks_persona_store_error_invalid_argument;
				}
				if (g_error_matches (_data_->_inner_error_, FOLKS_PERSONA_STORE_ERROR, FOLKS_PERSONA_STORE_ERROR_STORE_OFFLINE)) {
					goto __catch4_folks_persona_store_error_store_offline;
				}
				if (_data_->_inner_error_->domain == FOLKS_PERSONA_STORE_ERROR) {
					goto __catch4_folks_persona_store_error;
				}
				_g_object_unref0 (_data_->tpf_store);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
				g_clear_error (&_data_->_inner_error_);
				return FALSE;
			}
		}
		goto __finally4;
		__catch4_folks_persona_store_error_invalid_argument:
		{
			_data_->e1 = _data_->_inner_error_;
			_data_->_inner_error_ = NULL;
			_data_->_tmp12_ = NULL;
			_data_->_tmp12_ = _data_->e1;
			_data_->_tmp13_ = NULL;
			_data_->_tmp13_ = _data_->_tmp12_->message;
			_data_->_tmp14_ = NULL;
			_data_->_tmp14_ = g_error_new_literal (FOLKS_PROPERTY_ERROR, FOLKS_PROPERTY_ERROR_NOT_WRITEABLE, _data_->_tmp13_);
			_data_->_inner_error_ = _data_->_tmp14_;
			_g_error_free0 (_data_->e1);
			goto __finally4;
		}
		goto __finally4;
		__catch4_folks_persona_store_error_store_offline:
		{
			_data_->e2 = _data_->_inner_error_;
			_data_->_inner_error_ = NULL;
			_data_->_tmp15_ = NULL;
			_data_->_tmp15_ = _data_->e2;
			_data_->_tmp16_ = NULL;
			_data_->_tmp16_ = _data_->_tmp15_->message;
			_data_->_tmp17_ = NULL;
			_data_->_tmp17_ = g_error_new_literal (FOLKS_PROPERTY_ERROR, FOLKS_PROPERTY_ERROR_UNKNOWN_ERROR, _data_->_tmp16_);
			_data_->_inner_error_ = _data_->_tmp17_;
			_g_error_free0 (_data_->e2);
			goto __finally4;
		}
		goto __finally4;
		__catch4_folks_persona_store_error:
		{
			_data_->e3 = _data_->_inner_error_;
			_data_->_inner_error_ = NULL;
			_data_->_tmp18_ = NULL;
			_data_->_tmp18_ = _data_->e3;
			_data_->_tmp19_ = NULL;
			_data_->_tmp19_ = _data_->_tmp18_->message;
			_data_->_tmp20_ = NULL;
			_data_->_tmp20_ = g_error_new_literal (FOLKS_PROPERTY_ERROR, FOLKS_PROPERTY_ERROR_UNKNOWN_ERROR, _data_->_tmp19_);
			_data_->_inner_error_ = _data_->_tmp20_;
			_g_error_free0 (_data_->e3);
			goto __finally4;
		}
		__finally4:
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			if (_data_->_inner_error_->domain == FOLKS_PROPERTY_ERROR) {
				g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
				g_error_free (_data_->_inner_error_);
				_g_object_unref0 (_data_->tpf_store);
				if (_data_->_state_ == 0) {
					g_simple_async_result_complete_in_idle (_data_->_async_result);
				} else {
					g_simple_async_result_complete (_data_->_async_result);
				}
				g_object_unref (_data_->_async_result);
				return FALSE;
			} else {
				_g_object_unref0 (_data_->tpf_store);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
				g_clear_error (&_data_->_inner_error_);
				return FALSE;
			}
		}
	}
	_g_object_unref0 (_data_->tpf_store);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


/**
   * Create a new persona.
   *
   * Create a new persona for the {@link PersonaStore} ``store``, representing
   * the Telepathy contact given by ``contact``.
   *
   * @param contact the Telepathy contact being represented by the persona
   * @param store the persona store to place the persona in
   */
TpfPersona* tpf_persona_construct (GType object_type, TpContact* contact, TpfPersonaStore* store) {
	TpfPersona * self = NULL;
	const gchar* id = NULL;
	TpContact* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	TpConnection* connection = NULL;
	TpContact* _tmp2_ = NULL;
	TpConnection* _tmp3_ = NULL;
	TpConnection* _tmp4_ = NULL;
	TpConnection* _tmp5_ = NULL;
	TpAccount* account = NULL;
	TpConnection* _tmp6_ = NULL;
	TpAccount* _tmp7_ = NULL;
	TpAccount* _tmp8_ = NULL;
	gchar* uid = NULL;
	TpfPersonaStore* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	TpfPersonaStore* _tmp12_ = NULL;
	const gchar* _tmp13_ = NULL;
	const gchar* _tmp14_ = NULL;
	const gchar* _tmp15_ = NULL;
	gchar* _tmp16_ = NULL;
	gboolean is_user = FALSE;
	TpConnection* _tmp17_ = NULL;
	TpContact* _tmp18_ = NULL;
	TpContact* _tmp19_ = NULL;
	TpContact* _tmp28_ = NULL;
	const gchar* _tmp29_ = NULL;
	TpAccount* _tmp30_ = NULL;
	const gchar* _tmp31_ = NULL;
	const gchar* _tmp32_ = NULL;
	gchar* _tmp33_ = NULL;
	gchar* _tmp34_ = NULL;
	const gchar* _tmp35_ = NULL;
	gchar* _tmp36_ = NULL;
	gchar* _tmp37_ = NULL;
	const gchar* _tmp38_ = NULL;
	TpfPersonaStore* _tmp39_ = NULL;
	gboolean _tmp40_ = FALSE;
	const gchar* _tmp41_ = NULL;
	const gchar* _tmp42_ = NULL;
	g_return_val_if_fail (contact != NULL, NULL);
	g_return_val_if_fail (store != NULL, NULL);
	_tmp0_ = contact;
	_tmp1_ = tp_contact_get_identifier (_tmp0_);
	id = _tmp1_;
	_tmp2_ = contact;
	_tmp3_ = tp_contact_get_connection (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = _g_object_ref0 (_tmp4_);
	connection = _tmp5_;
	_tmp6_ = connection;
	_tmp7_ = tp_connection_get_account (_tmp6_);
	_tmp8_ = _g_object_ref0 (_tmp7_);
	account = _tmp8_;
	_tmp9_ = store;
	_tmp10_ = folks_persona_store_get_type_id ((FolksPersonaStore*) _tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = store;
	_tmp13_ = folks_persona_store_get_id ((FolksPersonaStore*) _tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = id;
	_tmp16_ = folks_persona_build_uid (_tmp11_, _tmp14_, _tmp15_);
	uid = _tmp16_;
	is_user = FALSE;
	_tmp17_ = connection;
	_tmp18_ = tp_connection_get_self_contact (_tmp17_);
	_tmp19_ = _tmp18_;
	if (_tmp19_ != NULL) {
		TpContact* _tmp20_ = NULL;
		guint _tmp21_ = 0U;
		guint _tmp22_ = 0U;
		TpConnection* _tmp23_ = NULL;
		TpContact* _tmp24_ = NULL;
		TpContact* _tmp25_ = NULL;
		guint _tmp26_ = 0U;
		guint _tmp27_ = 0U;
		_tmp20_ = contact;
		_tmp21_ = tp_contact_get_handle (_tmp20_);
		_tmp22_ = _tmp21_;
		_tmp23_ = connection;
		_tmp24_ = tp_connection_get_self_contact (_tmp23_);
		_tmp25_ = _tmp24_;
		_tmp26_ = tp_contact_get_handle (_tmp25_);
		_tmp27_ = _tmp26_;
		is_user = _tmp22_ == _tmp27_;
	}
	_tmp28_ = contact;
	_tmp29_ = id;
	_tmp30_ = account;
	_tmp31_ = tp_account_get_protocol_name (_tmp30_);
	_tmp32_ = _tmp31_;
	_tmp33_ = g_strconcat (_tmp32_, ":", NULL);
	_tmp34_ = _tmp33_;
	_tmp35_ = id;
	_tmp36_ = g_strconcat (_tmp34_, _tmp35_, NULL);
	_tmp37_ = _tmp36_;
	_tmp38_ = uid;
	_tmp39_ = store;
	_tmp40_ = is_user;
	self = (TpfPersona*) g_object_new (object_type, "contact", _tmp28_, "display-id", _tmp29_, "iid", _tmp37_, "uid", _tmp38_, "store", _tmp39_, "is-user", _tmp40_, NULL);
	_g_free0 (_tmp37_);
	_g_free0 (_tmp34_);
	_tmp41_ = uid;
	_tmp42_ = id;
	g_debug ("tpf-persona.vala:783: Created new Tpf.Persona '%s' for service-specifi" \
"c UID '%s': %p", _tmp41_, _tmp42_, self);
	_g_free0 (uid);
	_g_object_unref0 (account);
	_g_object_unref0 (connection);
	return self;
}


TpfPersona* tpf_persona_new (TpContact* contact, TpfPersonaStore* store) {
	return tpf_persona_construct (TPF_TYPE_PERSONA, contact, store);
}


static void tpf_persona_real_constructed (GObject* base) {
	TpfPersona * self;
	self = (TpfPersona*) base;
	self->priv->_is_constructed = TRUE;
}


static gchar** _vala_array_dup1 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_ = NULL;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static void _vala_array_add1 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add2 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add3 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add4 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add5 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _tpf_persona_update_writeable_properties (TpfPersona* self) {
	TpfPersonaStore* tpf_store = NULL;
	FolksPersonaStore* _tmp0_ = NULL;
	FolksPersonaStore* _tmp1_ = NULL;
	TpfPersonaStore* _tmp2_ = NULL;
	FolksPersonaStore* _tmp3_ = NULL;
	FolksPersonaStore* _tmp4_ = NULL;
	gchar** _tmp5_ = NULL;
	gint _tmp5__length1 = 0;
	gchar** _tmp6_ = NULL;
	gint _tmp6__length1 = 0;
	gchar** _tmp7_ = NULL;
	gint _tmp7__length1 = 0;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp9_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = folks_persona_get_store ((FolksPersona*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, TPF_TYPE_PERSONA_STORE) ? ((TpfPersonaStore*) _tmp1_) : NULL);
	tpf_store = _tmp2_;
	_tmp3_ = folks_persona_get_store ((FolksPersona*) self);
	_tmp4_ = _tmp3_;
	_tmp5_ = folks_persona_store_get_always_writeable_properties (_tmp4_, &_tmp5__length1);
	_tmp6_ = _tmp5_;
	_tmp6__length1 = _tmp5__length1;
	_tmp7_ = (_tmp6_ != NULL) ? _vala_array_dup1 (_tmp6_, _tmp6__length1) : ((gpointer) _tmp6_);
	_tmp7__length1 = _tmp6__length1;
	self->priv->_writeable_properties = (_vala_array_free (self->priv->_writeable_properties, self->priv->_writeable_properties_length1, (GDestroyNotify) g_free), NULL);
	self->priv->_writeable_properties = _tmp7_;
	self->priv->_writeable_properties_length1 = _tmp7__length1;
	self->priv->__writeable_properties_size_ = self->priv->_writeable_properties_length1;
	_tmp8_ = folks_persona_get_is_user ((FolksPersona*) self);
	_tmp9_ = _tmp8_;
	if (_tmp9_) {
		TpfPersonaStore* _tmp10_ = NULL;
		GeeSet* _tmp11_ = NULL;
		GeeSet* _tmp12_ = NULL;
		gboolean _tmp13_ = FALSE;
		TpfPersonaStore* _tmp16_ = NULL;
		GeeSet* _tmp17_ = NULL;
		GeeSet* _tmp18_ = NULL;
		gboolean _tmp19_ = FALSE;
		TpfPersonaStore* _tmp22_ = NULL;
		GeeSet* _tmp23_ = NULL;
		GeeSet* _tmp24_ = NULL;
		gboolean _tmp25_ = FALSE;
		TpfPersonaStore* _tmp28_ = NULL;
		GeeSet* _tmp29_ = NULL;
		GeeSet* _tmp30_ = NULL;
		gboolean _tmp31_ = FALSE;
		TpfPersonaStore* _tmp34_ = NULL;
		GeeSet* _tmp35_ = NULL;
		GeeSet* _tmp36_ = NULL;
		gboolean _tmp37_ = FALSE;
		_tmp10_ = tpf_store;
		_tmp11_ = tpf_persona_store_get_supported_fields (_tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = gee_collection_contains ((GeeCollection*) _tmp12_, "bday");
		if (_tmp13_) {
			gchar** _tmp14_ = NULL;
			gint _tmp14__length1 = 0;
			gchar* _tmp15_ = NULL;
			_tmp14_ = self->priv->_writeable_properties;
			_tmp14__length1 = self->priv->_writeable_properties_length1;
			_tmp15_ = g_strdup ("birthday");
			_vala_array_add1 (&self->priv->_writeable_properties, &self->priv->_writeable_properties_length1, &self->priv->__writeable_properties_size_, _tmp15_);
		}
		_tmp16_ = tpf_store;
		_tmp17_ = tpf_persona_store_get_supported_fields (_tmp16_);
		_tmp18_ = _tmp17_;
		_tmp19_ = gee_collection_contains ((GeeCollection*) _tmp18_, "email");
		if (_tmp19_) {
			gchar** _tmp20_ = NULL;
			gint _tmp20__length1 = 0;
			gchar* _tmp21_ = NULL;
			_tmp20_ = self->priv->_writeable_properties;
			_tmp20__length1 = self->priv->_writeable_properties_length1;
			_tmp21_ = g_strdup ("email-addresses");
			_vala_array_add2 (&self->priv->_writeable_properties, &self->priv->_writeable_properties_length1, &self->priv->__writeable_properties_size_, _tmp21_);
		}
		_tmp22_ = tpf_store;
		_tmp23_ = tpf_persona_store_get_supported_fields (_tmp22_);
		_tmp24_ = _tmp23_;
		_tmp25_ = gee_collection_contains ((GeeCollection*) _tmp24_, "fn");
		if (_tmp25_) {
			gchar** _tmp26_ = NULL;
			gint _tmp26__length1 = 0;
			gchar* _tmp27_ = NULL;
			_tmp26_ = self->priv->_writeable_properties;
			_tmp26__length1 = self->priv->_writeable_properties_length1;
			_tmp27_ = g_strdup ("full-name");
			_vala_array_add3 (&self->priv->_writeable_properties, &self->priv->_writeable_properties_length1, &self->priv->__writeable_properties_size_, _tmp27_);
		}
		_tmp28_ = tpf_store;
		_tmp29_ = tpf_persona_store_get_supported_fields (_tmp28_);
		_tmp30_ = _tmp29_;
		_tmp31_ = gee_collection_contains ((GeeCollection*) _tmp30_, "tel");
		if (_tmp31_) {
			gchar** _tmp32_ = NULL;
			gint _tmp32__length1 = 0;
			gchar* _tmp33_ = NULL;
			_tmp32_ = self->priv->_writeable_properties;
			_tmp32__length1 = self->priv->_writeable_properties_length1;
			_tmp33_ = g_strdup ("phone-numbers");
			_vala_array_add4 (&self->priv->_writeable_properties, &self->priv->_writeable_properties_length1, &self->priv->__writeable_properties_size_, _tmp33_);
		}
		_tmp34_ = tpf_store;
		_tmp35_ = tpf_persona_store_get_supported_fields (_tmp34_);
		_tmp36_ = _tmp35_;
		_tmp37_ = gee_collection_contains ((GeeCollection*) _tmp36_, "url");
		if (_tmp37_) {
			gchar** _tmp38_ = NULL;
			gint _tmp38__length1 = 0;
			gchar* _tmp39_ = NULL;
			_tmp38_ = self->priv->_writeable_properties;
			_tmp38__length1 = self->priv->_writeable_properties_length1;
			_tmp39_ = g_strdup ("urls");
			_vala_array_add5 (&self->priv->_writeable_properties, &self->priv->_writeable_properties_length1, &self->priv->__writeable_properties_size_, _tmp39_);
		}
	}
	_g_object_unref0 (tpf_store);
}


static TpContactInfoField* _vala_TpContactInfoField_copy (TpContactInfoField* self) {
	return g_boxed_copy (tp_contact_info_field_get_type (), self);
}


static gpointer __vala_TpContactInfoField_copy0 (gpointer self) {
	return self ? _vala_TpContactInfoField_copy (self) : NULL;
}


static void _vala_TpContactInfoField_free (TpContactInfoField* self) {
	g_boxed_free (tp_contact_info_field_get_type (), self);
}


static void __vala_TpContactInfoField_free0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (_vala_TpContactInfoField_free (var), NULL));
}


static void _g_list_free___vala_TpContactInfoField_free0_ (GList* self) {
	g_list_foreach (self, (GFunc) __vala_TpContactInfoField_free0_, NULL);
	g_list_free (self);
}


static void _tpf_persona_contact_notify_contact_info (TpfPersona* self, gboolean create_if_not_exists, gboolean emit_notification) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	FolksSmallSet* _tmp3_ = NULL;
	gboolean _tmp11_ = FALSE;
	FolksSmallSet* _tmp12_ = NULL;
	TpContact* contact = NULL;
	TpContact* _tmp28_ = NULL;
	TpContact* _tmp29_ = NULL;
	TpContact* _tmp30_ = NULL;
	gboolean changed = FALSE;
	gchar* new_birthday_str = NULL;
	gchar* _tmp31_ = NULL;
	gchar* new_full_name = NULL;
	gchar* _tmp32_ = NULL;
	FolksSmallSet* new_email_addresses = NULL;
	FolksSmallSet* _tmp33_ = NULL;
	FolksSmallSet* new_phone_numbers = NULL;
	FolksSmallSet* _tmp34_ = NULL;
	FolksSmallSet* new_urls = NULL;
	FolksSmallSet* _tmp35_ = NULL;
	GList* contact_info = NULL;
	TpContact* _tmp36_ = NULL;
	GList* _tmp37_ = NULL;
	GList* _tmp38_ = NULL;
	const gchar* _tmp99_ = NULL;
	FolksSmallSet* _tmp121_ = NULL;
	FolksSmallSet* _tmp122_ = NULL;
	gboolean _tmp123_ = FALSE;
	const gchar* _tmp130_ = NULL;
	const gchar* _tmp131_ = NULL;
	FolksSmallSet* _tmp134_ = NULL;
	FolksSmallSet* _tmp135_ = NULL;
	gboolean _tmp136_ = FALSE;
	FolksSmallSet* _tmp143_ = NULL;
	FolksSmallSet* _tmp144_ = NULL;
	gboolean _tmp145_ = FALSE;
	gboolean _tmp151_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp3_ = self->priv->_email_addresses;
	if (_tmp3_ == NULL) {
		FolksSmallSet* _tmp4_ = NULL;
		_tmp4_ = self->priv->_phone_numbers;
		_tmp2_ = _tmp4_ == NULL;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		FolksSmallSet* _tmp5_ = NULL;
		_tmp5_ = self->priv->_urls;
		_tmp1_ = _tmp5_ == NULL;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp6_ = FALSE;
		gboolean _tmp7_ = FALSE;
		FolksSmallSet* _tmp8_ = NULL;
		_tmp8_ = self->priv->_email_addresses;
		if (_tmp8_ != NULL) {
			FolksSmallSet* _tmp9_ = NULL;
			_tmp9_ = self->priv->_phone_numbers;
			_tmp7_ = _tmp9_ != NULL;
		} else {
			_tmp7_ = FALSE;
		}
		if (_tmp7_) {
			FolksSmallSet* _tmp10_ = NULL;
			_tmp10_ = self->priv->_urls;
			_tmp6_ = _tmp10_ != NULL;
		} else {
			_tmp6_ = FALSE;
		}
		_tmp0_ = _tmp6_;
	}
	_vala_assert (_tmp0_, "(           (this._email_addresses == null) &&           (this._phone_numbers == null) &&           (this._urls == null)         ) || (           (this._email_addresses != null) &&           (this._phone_numbers != null) &&           (this._urls != null)         )");
	_tmp12_ = self->priv->_urls;
	if (_tmp12_ == NULL) {
		gboolean _tmp13_ = FALSE;
		_tmp13_ = create_if_not_exists;
		_tmp11_ = _tmp13_ == FALSE;
	} else {
		_tmp11_ = FALSE;
	}
	if (_tmp11_) {
		gboolean _tmp14_ = FALSE;
		_tmp14_ = emit_notification;
		if (_tmp14_) {
			g_object_notify ((GObject*) self, "email-addresses");
			g_object_notify ((GObject*) self, "phone-numbers");
			g_object_notify ((GObject*) self, "urls");
		}
		return;
	} else {
		FolksSmallSet* _tmp15_ = NULL;
		_tmp15_ = self->priv->_urls;
		if (_tmp15_ == NULL) {
			FolksSmallSet* _tmp16_ = NULL;
			FolksSmallSet* _tmp17_ = NULL;
			GeeSet* _tmp18_ = NULL;
			GeeSet* _tmp19_ = NULL;
			FolksSmallSet* _tmp20_ = NULL;
			FolksSmallSet* _tmp21_ = NULL;
			GeeSet* _tmp22_ = NULL;
			GeeSet* _tmp23_ = NULL;
			FolksSmallSet* _tmp24_ = NULL;
			FolksSmallSet* _tmp25_ = NULL;
			GeeSet* _tmp26_ = NULL;
			GeeSet* _tmp27_ = NULL;
			_tmp16_ = folks_small_set_new (FOLKS_TYPE_URL_FIELD_DETAILS, (GBoxedCopyFunc) g_object_ref, g_object_unref, _folks_abstract_field_details_hash_static_gee_hash_data_func, NULL, NULL, _folks_abstract_field_details_equal_static_gee_equal_data_func, NULL, NULL);
			_g_object_unref0 (self->priv->_urls);
			self->priv->_urls = _tmp16_;
			_tmp17_ = self->priv->_urls;
			_tmp18_ = gee_abstract_set_get_read_only_view ((GeeAbstractSet*) _tmp17_);
			_tmp19_ = _tmp18_;
			_g_object_unref0 (self->priv->_urls_ro);
			self->priv->_urls_ro = _tmp19_;
			_tmp20_ = folks_small_set_new (FOLKS_TYPE_EMAIL_FIELD_DETAILS, (GBoxedCopyFunc) g_object_ref, g_object_unref, _folks_abstract_field_details_hash_static_gee_hash_data_func, NULL, NULL, _folks_abstract_field_details_equal_static_gee_equal_data_func, NULL, NULL);
			_g_object_unref0 (self->priv->_email_addresses);
			self->priv->_email_addresses = _tmp20_;
			_tmp21_ = self->priv->_email_addresses;
			_tmp22_ = gee_abstract_set_get_read_only_view ((GeeAbstractSet*) _tmp21_);
			_tmp23_ = _tmp22_;
			_g_object_unref0 (self->priv->_email_addresses_ro);
			self->priv->_email_addresses_ro = _tmp23_;
			_tmp24_ = folks_small_set_new (FOLKS_TYPE_PHONE_FIELD_DETAILS, (GBoxedCopyFunc) g_object_ref, g_object_unref, _folks_abstract_field_details_hash_static_gee_hash_data_func, NULL, NULL, _folks_abstract_field_details_equal_static_gee_equal_data_func, NULL, NULL);
			_g_object_unref0 (self->priv->_phone_numbers);
			self->priv->_phone_numbers = _tmp24_;
			_tmp25_ = self->priv->_phone_numbers;
			_tmp26_ = gee_abstract_set_get_read_only_view ((GeeAbstractSet*) _tmp25_);
			_tmp27_ = _tmp26_;
			_g_object_unref0 (self->priv->_phone_numbers_ro);
			self->priv->_phone_numbers_ro = _tmp27_;
		}
	}
	_tmp28_ = self->priv->_contact;
	_tmp29_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp28_, tp_contact_get_type (), TpContact));
	contact = _tmp29_;
	_tmp30_ = contact;
	if (_tmp30_ == NULL) {
		_g_object_unref0 (contact);
		return;
	}
	changed = FALSE;
	_tmp31_ = g_strdup ("");
	new_birthday_str = _tmp31_;
	_tmp32_ = g_strdup ("");
	new_full_name = _tmp32_;
	_tmp33_ = folks_small_set_new (FOLKS_TYPE_EMAIL_FIELD_DETAILS, (GBoxedCopyFunc) g_object_ref, g_object_unref, _folks_abstract_field_details_hash_static_gee_hash_data_func, NULL, NULL, _folks_abstract_field_details_equal_static_gee_equal_data_func, NULL, NULL);
	new_email_addresses = _tmp33_;
	_tmp34_ = folks_small_set_new (FOLKS_TYPE_PHONE_FIELD_DETAILS, (GBoxedCopyFunc) g_object_ref, g_object_unref, _folks_abstract_field_details_hash_static_gee_hash_data_func, NULL, NULL, _folks_abstract_field_details_equal_static_gee_equal_data_func, NULL, NULL);
	new_phone_numbers = _tmp34_;
	_tmp35_ = folks_small_set_new (FOLKS_TYPE_URL_FIELD_DETAILS, (GBoxedCopyFunc) g_object_ref, g_object_unref, _folks_abstract_field_details_hash_static_gee_hash_data_func, NULL, NULL, _folks_abstract_field_details_equal_static_gee_equal_data_func, NULL, NULL);
	new_urls = _tmp35_;
	_tmp36_ = contact;
	_tmp37_ = tp_contact_dup_contact_info (_tmp36_);
	contact_info = _tmp37_;
	_tmp38_ = contact_info;
	{
		GList* info_collection = NULL;
		GList* info_it = NULL;
		info_collection = _tmp38_;
		for (info_it = info_collection; info_it != NULL; info_it = info_it->next) {
			TpContactInfoField* _tmp39_ = NULL;
			TpContactInfoField* info = NULL;
			_tmp39_ = __vala_TpContactInfoField_copy0 ((TpContactInfoField*) info_it->data);
			info = _tmp39_;
			{
				TpContactInfoField* _tmp40_ = NULL;
				const gchar* _tmp41_ = NULL;
				_tmp40_ = info;
				_tmp41_ = _tmp40_->field_name;
				if (g_strcmp0 (_tmp41_, "") == 0) {
				} else {
					TpContactInfoField* _tmp42_ = NULL;
					const gchar* _tmp43_ = NULL;
					_tmp42_ = info;
					_tmp43_ = _tmp42_->field_name;
					if (g_strcmp0 (_tmp43_, "bday") == 0) {
						const gchar* _tmp44_ = NULL;
						TpContactInfoField* _tmp45_ = NULL;
						gchar** _tmp46_ = NULL;
						gint _tmp46__length1 = 0;
						const gchar* _tmp47_ = NULL;
						gchar* _tmp48_ = NULL;
						_tmp45_ = info;
						_tmp46_ = _tmp45_->field_value;
						_tmp46__length1 = -1;
						_tmp47_ = _tmp46_[0];
						_tmp44_ = _tmp47_;
						if (_tmp44_ == NULL) {
							_tmp44_ = "";
						}
						_tmp48_ = g_strdup (_tmp44_);
						_g_free0 (new_birthday_str);
						new_birthday_str = _tmp48_;
					} else {
						TpContactInfoField* _tmp49_ = NULL;
						const gchar* _tmp50_ = NULL;
						_tmp49_ = info;
						_tmp50_ = _tmp49_->field_name;
						if (g_strcmp0 (_tmp50_, "email") == 0) {
							TpContactInfoField* _tmp51_ = NULL;
							gchar** _tmp52_ = NULL;
							gint _tmp52__length1 = 0;
							_tmp51_ = info;
							_tmp52_ = _tmp51_->field_value;
							_tmp52__length1 = -1;
							{
								gchar** email_addr_collection = NULL;
								gint email_addr_collection_length1 = 0;
								gint _email_addr_collection_size_ = 0;
								gint email_addr_it = 0;
								email_addr_collection = _tmp52_;
								email_addr_collection_length1 = _tmp52__length1;
								for (email_addr_it = 0; email_addr_it < _tmp52__length1; email_addr_it = email_addr_it + 1) {
									gchar* _tmp53_ = NULL;
									gchar* email_addr = NULL;
									_tmp53_ = g_strdup (email_addr_collection[email_addr_it]);
									email_addr = _tmp53_;
									{
										const gchar* _tmp54_ = NULL;
										_tmp54_ = email_addr;
										if (g_strcmp0 (_tmp54_, "") != 0) {
											GeeMultiMap* parameters = NULL;
											TpContactInfoField* _tmp55_ = NULL;
											gchar** _tmp56_ = NULL;
											gint _tmp56__length1 = 0;
											GeeMultiMap* _tmp57_ = NULL;
											FolksEmailFieldDetails* email_fd = NULL;
											const gchar* _tmp58_ = NULL;
											GeeMultiMap* _tmp59_ = NULL;
											FolksEmailFieldDetails* _tmp60_ = NULL;
											FolksSmallSet* _tmp61_ = NULL;
											FolksEmailFieldDetails* _tmp62_ = NULL;
											_tmp55_ = info;
											_tmp56_ = _tmp55_->parameters;
											_tmp56__length1 = -1;
											_tmp57_ = _tpf_persona_afd_params_from_strv (self, _tmp56_, _tmp56__length1);
											parameters = _tmp57_;
											_tmp58_ = email_addr;
											_tmp59_ = parameters;
											_tmp60_ = folks_email_field_details_new (_tmp58_, _tmp59_);
											email_fd = _tmp60_;
											_tmp61_ = new_email_addresses;
											_tmp62_ = email_fd;
											gee_abstract_collection_add ((GeeAbstractCollection*) _tmp61_, _tmp62_);
											_g_object_unref0 (email_fd);
											_g_object_unref0 (parameters);
										}
										_g_free0 (email_addr);
									}
								}
							}
						} else {
							TpContactInfoField* _tmp63_ = NULL;
							const gchar* _tmp64_ = NULL;
							_tmp63_ = info;
							_tmp64_ = _tmp63_->field_name;
							if (g_strcmp0 (_tmp64_, "fn") == 0) {
								TpContactInfoField* _tmp65_ = NULL;
								gchar** _tmp66_ = NULL;
								gint _tmp66__length1 = 0;
								const gchar* _tmp67_ = NULL;
								gchar* _tmp68_ = NULL;
								const gchar* _tmp69_ = NULL;
								_tmp65_ = info;
								_tmp66_ = _tmp65_->field_value;
								_tmp66__length1 = -1;
								_tmp67_ = _tmp66_[0];
								_tmp68_ = g_strdup (_tmp67_);
								_g_free0 (new_full_name);
								new_full_name = _tmp68_;
								_tmp69_ = new_full_name;
								if (_tmp69_ == NULL) {
									gchar* _tmp70_ = NULL;
									_tmp70_ = g_strdup ("");
									_g_free0 (new_full_name);
									new_full_name = _tmp70_;
								}
							} else {
								TpContactInfoField* _tmp71_ = NULL;
								const gchar* _tmp72_ = NULL;
								_tmp71_ = info;
								_tmp72_ = _tmp71_->field_name;
								if (g_strcmp0 (_tmp72_, "tel") == 0) {
									TpContactInfoField* _tmp73_ = NULL;
									gchar** _tmp74_ = NULL;
									gint _tmp74__length1 = 0;
									_tmp73_ = info;
									_tmp74_ = _tmp73_->field_value;
									_tmp74__length1 = -1;
									{
										gchar** phone_num_collection = NULL;
										gint phone_num_collection_length1 = 0;
										gint _phone_num_collection_size_ = 0;
										gint phone_num_it = 0;
										phone_num_collection = _tmp74_;
										phone_num_collection_length1 = _tmp74__length1;
										for (phone_num_it = 0; phone_num_it < _tmp74__length1; phone_num_it = phone_num_it + 1) {
											gchar* _tmp75_ = NULL;
											gchar* phone_num = NULL;
											_tmp75_ = g_strdup (phone_num_collection[phone_num_it]);
											phone_num = _tmp75_;
											{
												const gchar* _tmp76_ = NULL;
												_tmp76_ = phone_num;
												if (g_strcmp0 (_tmp76_, "") != 0) {
													GeeMultiMap* parameters = NULL;
													TpContactInfoField* _tmp77_ = NULL;
													gchar** _tmp78_ = NULL;
													gint _tmp78__length1 = 0;
													GeeMultiMap* _tmp79_ = NULL;
													FolksPhoneFieldDetails* phone_fd = NULL;
													const gchar* _tmp80_ = NULL;
													GeeMultiMap* _tmp81_ = NULL;
													FolksPhoneFieldDetails* _tmp82_ = NULL;
													FolksSmallSet* _tmp83_ = NULL;
													FolksPhoneFieldDetails* _tmp84_ = NULL;
													_tmp77_ = info;
													_tmp78_ = _tmp77_->parameters;
													_tmp78__length1 = -1;
													_tmp79_ = _tpf_persona_afd_params_from_strv (self, _tmp78_, _tmp78__length1);
													parameters = _tmp79_;
													_tmp80_ = phone_num;
													_tmp81_ = parameters;
													_tmp82_ = folks_phone_field_details_new (_tmp80_, _tmp81_);
													phone_fd = _tmp82_;
													_tmp83_ = new_phone_numbers;
													_tmp84_ = phone_fd;
													gee_abstract_collection_add ((GeeAbstractCollection*) _tmp83_, _tmp84_);
													_g_object_unref0 (phone_fd);
													_g_object_unref0 (parameters);
												}
												_g_free0 (phone_num);
											}
										}
									}
								} else {
									TpContactInfoField* _tmp85_ = NULL;
									const gchar* _tmp86_ = NULL;
									_tmp85_ = info;
									_tmp86_ = _tmp85_->field_name;
									if (g_strcmp0 (_tmp86_, "url") == 0) {
										TpContactInfoField* _tmp87_ = NULL;
										gchar** _tmp88_ = NULL;
										gint _tmp88__length1 = 0;
										_tmp87_ = info;
										_tmp88_ = _tmp87_->field_value;
										_tmp88__length1 = -1;
										{
											gchar** url_collection = NULL;
											gint url_collection_length1 = 0;
											gint _url_collection_size_ = 0;
											gint url_it = 0;
											url_collection = _tmp88_;
											url_collection_length1 = _tmp88__length1;
											for (url_it = 0; url_it < _tmp88__length1; url_it = url_it + 1) {
												gchar* _tmp89_ = NULL;
												gchar* url = NULL;
												_tmp89_ = g_strdup (url_collection[url_it]);
												url = _tmp89_;
												{
													const gchar* _tmp90_ = NULL;
													_tmp90_ = url;
													if (g_strcmp0 (_tmp90_, "") != 0) {
														GeeMultiMap* parameters = NULL;
														TpContactInfoField* _tmp91_ = NULL;
														gchar** _tmp92_ = NULL;
														gint _tmp92__length1 = 0;
														GeeMultiMap* _tmp93_ = NULL;
														FolksUrlFieldDetails* url_fd = NULL;
														const gchar* _tmp94_ = NULL;
														GeeMultiMap* _tmp95_ = NULL;
														FolksUrlFieldDetails* _tmp96_ = NULL;
														FolksSmallSet* _tmp97_ = NULL;
														FolksUrlFieldDetails* _tmp98_ = NULL;
														_tmp91_ = info;
														_tmp92_ = _tmp91_->parameters;
														_tmp92__length1 = -1;
														_tmp93_ = _tpf_persona_afd_params_from_strv (self, _tmp92_, _tmp92__length1);
														parameters = _tmp93_;
														_tmp94_ = url;
														_tmp95_ = parameters;
														_tmp96_ = folks_url_field_details_new (_tmp94_, _tmp95_);
														url_fd = _tmp96_;
														_tmp97_ = new_urls;
														_tmp98_ = url_fd;
														gee_abstract_collection_add ((GeeAbstractCollection*) _tmp97_, _tmp98_);
														_g_object_unref0 (url_fd);
														_g_object_unref0 (parameters);
													}
													_g_free0 (url);
												}
											}
										}
									}
								}
							}
						}
					}
				}
				__vala_TpContactInfoField_free0 (info);
			}
		}
	}
	_tmp99_ = new_birthday_str;
	if (g_strcmp0 (_tmp99_, "") != 0) {
		GTimeVal timeval = {0};
		const gchar* _tmp100_ = NULL;
		gboolean _tmp101_ = FALSE;
		g_get_current_time (&timeval);
		_tmp100_ = new_birthday_str;
		_tmp101_ = g_time_val_from_iso8601 (_tmp100_, &timeval);
		if (_tmp101_) {
			GDateTime* d = NULL;
			GTimeVal _tmp102_ = {0};
			GDateTime* _tmp103_ = NULL;
			gboolean _tmp104_ = FALSE;
			GDateTime* _tmp105_ = NULL;
			_tmp102_ = timeval;
			_tmp103_ = g_date_time_new_from_timeval_utc (&_tmp102_);
			d = _tmp103_;
			_tmp105_ = d;
			if (_tmp105_ != NULL) {
				gboolean _tmp106_ = FALSE;
				GDateTime* _tmp107_ = NULL;
				_tmp107_ = self->priv->_birthday;
				if (_tmp107_ == NULL) {
					_tmp106_ = TRUE;
				} else {
					gboolean _tmp108_ = FALSE;
					GDateTime* _tmp109_ = NULL;
					_tmp109_ = self->priv->_birthday;
					if (_tmp109_ != NULL) {
						GDateTime* _tmp110_ = NULL;
						GDateTime* _tmp111_ = NULL;
						GDateTime* _tmp112_ = NULL;
						GDateTime* _tmp113_ = NULL;
						gboolean _tmp114_ = FALSE;
						_tmp110_ = self->priv->_birthday;
						_tmp111_ = d;
						_tmp112_ = g_date_time_to_utc (_tmp111_);
						_tmp113_ = _tmp112_;
						_tmp114_ = g_date_time_equal (_tmp110_, _tmp113_);
						_tmp108_ = !_tmp114_;
						_g_date_time_unref0 (_tmp113_);
					} else {
						_tmp108_ = FALSE;
					}
					_tmp106_ = _tmp108_;
				}
				_tmp104_ = _tmp106_;
			} else {
				_tmp104_ = FALSE;
			}
			if (_tmp104_) {
				GDateTime* _tmp115_ = NULL;
				GDateTime* _tmp116_ = NULL;
				gboolean _tmp117_ = FALSE;
				_tmp115_ = d;
				_tmp116_ = g_date_time_to_utc (_tmp115_);
				_g_date_time_unref0 (self->priv->_birthday);
				self->priv->_birthday = _tmp116_;
				_tmp117_ = emit_notification;
				if (_tmp117_) {
					g_object_notify ((GObject*) self, "birthday");
				}
				changed = TRUE;
			}
			_g_date_time_unref0 (d);
		} else {
			const gchar* _tmp118_ = NULL;
			_tmp118_ = new_birthday_str;
			g_debug ("tpf-persona.vala:1063: Failed to parse new birthday string '%s'", _tmp118_);
		}
	} else {
		GDateTime* _tmp119_ = NULL;
		_tmp119_ = self->priv->_birthday;
		if (_tmp119_ != NULL) {
			gboolean _tmp120_ = FALSE;
			_g_date_time_unref0 (self->priv->_birthday);
			self->priv->_birthday = NULL;
			_tmp120_ = emit_notification;
			if (_tmp120_) {
				g_object_notify ((GObject*) self, "birthday");
			}
			changed = TRUE;
		}
	}
	_tmp121_ = new_email_addresses;
	_tmp122_ = self->priv->_email_addresses;
	_tmp123_ = folks_internal_equal_sets (FOLKS_TYPE_EMAIL_FIELD_DETAILS, (GBoxedCopyFunc) g_object_ref, g_object_unref, (GeeSet*) _tmp121_, (GeeSet*) _tmp122_);
	if (!_tmp123_) {
		FolksSmallSet* _tmp124_ = NULL;
		FolksSmallSet* _tmp125_ = NULL;
		FolksSmallSet* _tmp126_ = NULL;
		GeeSet* _tmp127_ = NULL;
		GeeSet* _tmp128_ = NULL;
		gboolean _tmp129_ = FALSE;
		_tmp124_ = new_email_addresses;
		_tmp125_ = _g_object_ref0 (_tmp124_);
		_g_object_unref0 (self->priv->_email_addresses);
		self->priv->_email_addresses = _tmp125_;
		_tmp126_ = new_email_addresses;
		_tmp127_ = gee_abstract_set_get_read_only_view ((GeeAbstractSet*) _tmp126_);
		_tmp128_ = _tmp127_;
		_g_object_unref0 (self->priv->_email_addresses_ro);
		self->priv->_email_addresses_ro = _tmp128_;
		_tmp129_ = emit_notification;
		if (_tmp129_) {
			g_object_notify ((GObject*) self, "email-addresses");
		}
		changed = TRUE;
	}
	_tmp130_ = new_full_name;
	_tmp131_ = self->priv->_full_name;
	if (g_strcmp0 (_tmp130_, _tmp131_) != 0) {
		const gchar* _tmp132_ = NULL;
		gchar* _tmp133_ = NULL;
		_tmp132_ = new_full_name;
		_tmp133_ = g_strdup (_tmp132_);
		_g_free0 (self->priv->_full_name);
		self->priv->_full_name = _tmp133_;
		g_object_notify ((GObject*) self, "full-name");
		changed = TRUE;
	}
	_tmp134_ = new_phone_numbers;
	_tmp135_ = self->priv->_phone_numbers;
	_tmp136_ = folks_utils_set_string_afd_equal ((GeeSet*) _tmp134_, (GeeSet*) _tmp135_);
	if (!_tmp136_) {
		FolksSmallSet* _tmp137_ = NULL;
		FolksSmallSet* _tmp138_ = NULL;
		FolksSmallSet* _tmp139_ = NULL;
		GeeSet* _tmp140_ = NULL;
		GeeSet* _tmp141_ = NULL;
		gboolean _tmp142_ = FALSE;
		_tmp137_ = new_phone_numbers;
		_tmp138_ = _g_object_ref0 (_tmp137_);
		_g_object_unref0 (self->priv->_phone_numbers);
		self->priv->_phone_numbers = _tmp138_;
		_tmp139_ = new_phone_numbers;
		_tmp140_ = gee_abstract_set_get_read_only_view ((GeeAbstractSet*) _tmp139_);
		_tmp141_ = _tmp140_;
		_g_object_unref0 (self->priv->_phone_numbers_ro);
		self->priv->_phone_numbers_ro = _tmp141_;
		_tmp142_ = emit_notification;
		if (_tmp142_) {
			g_object_notify ((GObject*) self, "phone-numbers");
		}
		changed = TRUE;
	}
	_tmp143_ = new_urls;
	_tmp144_ = self->priv->_urls;
	_tmp145_ = folks_internal_equal_sets (FOLKS_TYPE_URL_FIELD_DETAILS, (GBoxedCopyFunc) g_object_ref, g_object_unref, (GeeSet*) _tmp143_, (GeeSet*) _tmp144_);
	if (!_tmp145_) {
		FolksSmallSet* _tmp146_ = NULL;
		FolksSmallSet* _tmp147_ = NULL;
		FolksSmallSet* _tmp148_ = NULL;
		GeeSet* _tmp149_ = NULL;
		GeeSet* _tmp150_ = NULL;
		_tmp146_ = new_urls;
		_tmp147_ = _g_object_ref0 (_tmp146_);
		_g_object_unref0 (self->priv->_urls);
		self->priv->_urls = _tmp147_;
		_tmp148_ = new_urls;
		_tmp149_ = gee_abstract_set_get_read_only_view ((GeeAbstractSet*) _tmp148_);
		_tmp150_ = _tmp149_;
		_g_object_unref0 (self->priv->_urls_ro);
		self->priv->_urls_ro = _tmp150_;
		g_object_notify ((GObject*) self, "urls");
		changed = TRUE;
	}
	_tmp151_ = changed;
	if (_tmp151_ == TRUE) {
		FolksPersonaStore* _tmp152_ = NULL;
		FolksPersonaStore* _tmp153_ = NULL;
		_tmp152_ = folks_persona_get_store ((FolksPersona*) self);
		_tmp153_ = _tmp152_;
		_tpf_persona_store_set_cache_needs_update (G_TYPE_CHECK_INSTANCE_CAST (_tmp153_, TPF_TYPE_PERSONA_STORE, TpfPersonaStore));
	}
	__g_list_free___vala_TpContactInfoField_free0_0 (contact_info);
	_g_object_unref0 (new_urls);
	_g_object_unref0 (new_phone_numbers);
	_g_object_unref0 (new_email_addresses);
	_g_free0 (new_full_name);
	_g_free0 (new_birthday_str);
	_g_object_unref0 (contact);
}


static GeeMultiMap* _tpf_persona_afd_params_from_strv (TpfPersona* self, gchar** parameters, int parameters_length1) {
	GeeMultiMap* result = NULL;
	GeeHashMultiMap* retval = NULL;
	GeeHashMultiMap* _tmp0_ = NULL;
	gchar** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gee_hash_multi_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	retval = _tmp0_;
	_tmp1_ = parameters;
	_tmp1__length1 = parameters_length1;
	{
		gchar** entry_collection = NULL;
		gint entry_collection_length1 = 0;
		gint _entry_collection_size_ = 0;
		gint entry_it = 0;
		entry_collection = _tmp1_;
		entry_collection_length1 = _tmp1__length1;
		for (entry_it = 0; entry_it < _tmp1__length1; entry_it = entry_it + 1) {
			gchar* _tmp2_ = NULL;
			gchar* entry = NULL;
			_tmp2_ = g_strdup (entry_collection[entry_it]);
			entry = _tmp2_;
			{
				gchar** tokens = NULL;
				const gchar* _tmp3_ = NULL;
				gchar** _tmp4_ = NULL;
				gchar** _tmp5_ = NULL;
				gint tokens_length1 = 0;
				gint _tokens_size_ = 0;
				gchar** _tmp6_ = NULL;
				gint _tmp6__length1 = 0;
				_tmp3_ = entry;
				_tmp5_ = _tmp4_ = g_strsplit (_tmp3_, "=", 2);
				tokens = _tmp5_;
				tokens_length1 = _vala_array_length (_tmp4_);
				_tokens_size_ = tokens_length1;
				_tmp6_ = tokens;
				_tmp6__length1 = tokens_length1;
				if (_tmp6__length1 == 2) {
					GeeHashMultiMap* _tmp7_ = NULL;
					gchar** _tmp8_ = NULL;
					gint _tmp8__length1 = 0;
					const gchar* _tmp9_ = NULL;
					gchar** _tmp10_ = NULL;
					gint _tmp10__length1 = 0;
					const gchar* _tmp11_ = NULL;
					_tmp7_ = retval;
					_tmp8_ = tokens;
					_tmp8__length1 = tokens_length1;
					_tmp9_ = _tmp8_[0];
					_tmp10_ = tokens;
					_tmp10__length1 = tokens_length1;
					_tmp11_ = _tmp10_[1];
					gee_multi_map_set ((GeeMultiMap*) _tmp7_, _tmp9_, _tmp11_);
				} else {
					const gchar* _tmp12_ = NULL;
					_tmp12_ = entry;
					g_warning ("tpf-persona.vala:1139: Failed to parse vCard parameter from string '%s" \
"'", _tmp12_);
				}
				tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (entry);
			}
		}
	}
	result = (GeeMultiMap*) retval;
	return result;
}


/**
   * Create a new persona for the {@link PersonaStore} ``store``, representing
   * a cached contact for which we currently have no Telepathy contact.
   *
   * @param store The persona store to place the persona in.
   * @param uid The cached UID of the persona.
   * @param iid The cached IID of the persona.
   * @param im_address The cached IM address of the persona (excluding
   * protocol).
   * @param protocol The cached protocol of the persona.
   * @param groups The cached set of groups the persona is in.
   * @param is_favourite Whether the persona is a favourite.
   * @param alias The cached alias for the persona.
   * @param is_in_contact_list Whether the persona is in the user's contact
   * list.
   * @param is_user Whether the persona is the user.
   * @param avatar The icon for the persona's cached avatar, or ``null`` if they
   * have no avatar.
   * @param birthday The date/time of birth of the persona, or ``null`` if it's
   * unknown.
   * @param full_name The persona's full name, or the empty string if it's
   * unknown.
   * @param email_addresses A set of the persona's e-mail addresses, which may
   * be empty (but may not be ``null``).
   * @param phone_numbers A set of the persona's phone numbers, which may be
   * empty (but may not be ``null``).
   * @param urls A set of the persona's URLs, which may be empty (but may not be
   * ``null``).
   * @return A new {@link Tpf.Persona} representing the cached persona.
   *
   * @since 0.6.0
   */
TpfPersona* tpf_persona_construct_from_cache (GType object_type, TpfPersonaStore* store, const gchar* uid, const gchar* iid, const gchar* im_address, const gchar* protocol, FolksSmallSet* groups, gboolean is_favourite, const gchar* alias, gboolean is_in_contact_list, gboolean is_user, GLoadableIcon* avatar, GDateTime* birthday, const gchar* full_name, FolksSmallSet* email_addresses, FolksSmallSet* phone_numbers, FolksSmallSet* urls) {
	TpfPersona * self = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	TpfPersonaStore* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	const gchar* _tmp5_ = NULL;
	FolksImFieldDetails* im_fd = NULL;
	const gchar* _tmp6_ = NULL;
	FolksImFieldDetails* _tmp7_ = NULL;
	GeeHashMultiMap* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	FolksImFieldDetails* _tmp10_ = NULL;
	FolksSmallSet* _tmp11_ = NULL;
	FolksSmallSet* _tmp12_ = NULL;
	FolksSmallSet* _tmp13_ = NULL;
	GeeSet* _tmp14_ = NULL;
	GeeSet* _tmp15_ = NULL;
	FolksSmallSet* _tmp16_ = NULL;
	FolksSmallSet* _tmp17_ = NULL;
	FolksSmallSet* _tmp18_ = NULL;
	GeeSet* _tmp19_ = NULL;
	GeeSet* _tmp20_ = NULL;
	FolksSmallSet* _tmp21_ = NULL;
	FolksSmallSet* _tmp22_ = NULL;
	FolksSmallSet* _tmp23_ = NULL;
	GeeSet* _tmp24_ = NULL;
	GeeSet* _tmp25_ = NULL;
	FolksSmallSet* _tmp26_ = NULL;
	FolksSmallSet* _tmp27_ = NULL;
	FolksSmallSet* _tmp28_ = NULL;
	GeeSet* _tmp29_ = NULL;
	GeeSet* _tmp30_ = NULL;
	const gchar* _tmp31_ = NULL;
	const gchar* _tmp32_ = NULL;
	const gchar* _tmp33_ = NULL;
	gchar* _tmp34_ = NULL;
	gboolean _tmp35_ = FALSE;
	gboolean _tmp36_ = FALSE;
	GDateTime* _tmp37_ = NULL;
	GDateTime* _tmp38_ = NULL;
	const gchar* _tmp39_ = NULL;
	gchar* _tmp40_ = NULL;
	GLoadableIcon* _tmp41_ = NULL;
	GLoadableIcon* _tmp42_ = NULL;
	GFile* _tmp43_ = NULL;
	GLoadableIcon* _tmp44_ = NULL;
	GFile* avatar_file = NULL;
	GFile* _tmp47_ = NULL;
	TpfPersonaStore* _tmp48_ = NULL;
	const gchar* _tmp49_ = NULL;
	gchar** _tmp50_ = NULL;
	gchar** _tmp51_ = NULL;
	gint _tmp51__length1 = 0;
	gchar** _tmp52_ = NULL;
	g_return_val_if_fail (store != NULL, NULL);
	g_return_val_if_fail (uid != NULL, NULL);
	g_return_val_if_fail (iid != NULL, NULL);
	g_return_val_if_fail (im_address != NULL, NULL);
	g_return_val_if_fail (protocol != NULL, NULL);
	g_return_val_if_fail (groups != NULL, NULL);
	g_return_val_if_fail (alias != NULL, NULL);
	g_return_val_if_fail (full_name != NULL, NULL);
	g_return_val_if_fail (email_addresses != NULL, NULL);
	g_return_val_if_fail (phone_numbers != NULL, NULL);
	g_return_val_if_fail (urls != NULL, NULL);
	_tmp0_ = im_address;
	_tmp1_ = iid;
	_tmp2_ = uid;
	_tmp3_ = store;
	_tmp4_ = is_user;
	self = (TpfPersona*) g_object_new (object_type, "contact", NULL, "display-id", _tmp0_, "iid", _tmp1_, "uid", _tmp2_, "store", _tmp3_, "is-user", _tmp4_, NULL);
	_tmp5_ = uid;
	g_debug ("tpf-persona.vala:1193: Created new Tpf.Persona '%s' from cache: %p", _tmp5_, self);
	_tmp6_ = im_address;
	_tmp7_ = folks_im_field_details_new (_tmp6_, NULL);
	im_fd = _tmp7_;
	_tmp8_ = self->priv->_im_addresses;
	_tmp9_ = protocol;
	_tmp10_ = im_fd;
	gee_multi_map_set ((GeeMultiMap*) _tmp8_, _tmp9_, _tmp10_);
	_tmp11_ = groups;
	_tmp12_ = _g_object_ref0 (_tmp11_);
	_g_object_unref0 (self->priv->_groups);
	self->priv->_groups = _tmp12_;
	_tmp13_ = self->priv->_groups;
	_tmp14_ = gee_abstract_set_get_read_only_view ((GeeAbstractSet*) _tmp13_);
	_tmp15_ = _tmp14_;
	_g_object_unref0 (self->priv->_groups_ro);
	self->priv->_groups_ro = _tmp15_;
	_tmp16_ = email_addresses;
	_tmp17_ = _g_object_ref0 (_tmp16_);
	_g_object_unref0 (self->priv->_email_addresses);
	self->priv->_email_addresses = _tmp17_;
	_tmp18_ = self->priv->_email_addresses;
	_tmp19_ = gee_abstract_set_get_read_only_view ((GeeAbstractSet*) _tmp18_);
	_tmp20_ = _tmp19_;
	_g_object_unref0 (self->priv->_email_addresses_ro);
	self->priv->_email_addresses_ro = _tmp20_;
	_tmp21_ = phone_numbers;
	_tmp22_ = _g_object_ref0 (_tmp21_);
	_g_object_unref0 (self->priv->_phone_numbers);
	self->priv->_phone_numbers = _tmp22_;
	_tmp23_ = self->priv->_phone_numbers;
	_tmp24_ = gee_abstract_set_get_read_only_view ((GeeAbstractSet*) _tmp23_);
	_tmp25_ = _tmp24_;
	_g_object_unref0 (self->priv->_phone_numbers_ro);
	self->priv->_phone_numbers_ro = _tmp25_;
	_tmp26_ = urls;
	_tmp27_ = _g_object_ref0 (_tmp26_);
	_g_object_unref0 (self->priv->_urls);
	self->priv->_urls = _tmp27_;
	_tmp28_ = self->priv->_urls;
	_tmp29_ = gee_abstract_set_get_read_only_view ((GeeAbstractSet*) _tmp28_);
	_tmp30_ = _tmp29_;
	_g_object_unref0 (self->priv->_urls_ro);
	self->priv->_urls_ro = _tmp30_;
	_tmp31_ = alias;
	if (_tmp31_ == NULL) {
		alias = "";
	}
	_tmp32_ = full_name;
	if (_tmp32_ == NULL) {
		full_name = "";
	}
	_tmp33_ = alias;
	_tmp34_ = g_strdup (_tmp33_);
	_g_free0 (self->priv->_alias);
	self->priv->_alias = _tmp34_;
	_tmp35_ = is_favourite;
	self->priv->_is_favourite = _tmp35_;
	_tmp36_ = is_in_contact_list;
	tpf_persona_set_is_in_contact_list (self, _tmp36_);
	_tmp37_ = birthday;
	_tmp38_ = _g_date_time_ref0 (_tmp37_);
	_g_date_time_unref0 (self->priv->_birthday);
	self->priv->_birthday = _tmp38_;
	_tmp39_ = full_name;
	_tmp40_ = g_strdup (_tmp39_);
	_g_free0 (self->priv->_full_name);
	self->priv->_full_name = _tmp40_;
	_tmp41_ = avatar;
	_tmp42_ = _g_object_ref0 (_tmp41_);
	_g_object_unref0 (self->priv->_avatar);
	self->priv->_avatar = _tmp42_;
	_tmp44_ = avatar;
	if (_tmp44_ != NULL) {
		GLoadableIcon* _tmp45_ = NULL;
		GFile* _tmp46_ = NULL;
		_tmp45_ = avatar;
		_tmp46_ = g_file_icon_get_file (G_TYPE_CHECK_INSTANCE_CAST (_tmp45_, g_file_icon_get_type (), GFileIcon));
		_tmp43_ = _tmp46_;
	} else {
		_tmp43_ = NULL;
	}
	_tmp47_ = _g_object_ref0 (_tmp43_);
	avatar_file = _tmp47_;
	_tmp48_ = store;
	_tmp49_ = iid;
	_tpf_persona_store_update_avatar_cache (G_TYPE_CHECK_INSTANCE_CAST (_tmp48_, TPF_TYPE_PERSONA_STORE, TpfPersonaStore), _tmp49_, avatar_file);
	folks_presence_details_set_presence_type ((FolksPresenceDetails*) self, FOLKS_PRESENCE_TYPE_OFFLINE);
	folks_presence_details_set_presence_message ((FolksPresenceDetails*) self, "");
	folks_presence_details_set_presence_status ((FolksPresenceDetails*) self, "offline");
	_tmp50_ = g_new0 (gchar*, 0 + 1);
	_tmp51_ = _tmp50_;
	_tmp51__length1 = 0;
	folks_presence_details_set_client_types ((FolksPresenceDetails*) self, _tmp51_, 0);
	_tmp51_ = (_vala_array_free (_tmp51_, _tmp51__length1, (GDestroyNotify) g_free), NULL);
	_tmp52_ = g_new0 (gchar*, 0 + 1);
	self->priv->_writeable_properties = (_vala_array_free (self->priv->_writeable_properties, self->priv->_writeable_properties_length1, (GDestroyNotify) g_free), NULL);
	self->priv->_writeable_properties = _tmp52_;
	self->priv->_writeable_properties_length1 = 0;
	self->priv->__writeable_properties_size_ = self->priv->_writeable_properties_length1;
	_g_object_unref0 (avatar_file);
	_g_object_unref0 (im_fd);
	return self;
}


TpfPersona* tpf_persona_new_from_cache (TpfPersonaStore* store, const gchar* uid, const gchar* iid, const gchar* im_address, const gchar* protocol, FolksSmallSet* groups, gboolean is_favourite, const gchar* alias, gboolean is_in_contact_list, gboolean is_user, GLoadableIcon* avatar, GDateTime* birthday, const gchar* full_name, FolksSmallSet* email_addresses, FolksSmallSet* phone_numbers, FolksSmallSet* urls) {
	return tpf_persona_construct_from_cache (TPF_TYPE_PERSONA, store, uid, iid, im_address, protocol, groups, is_favourite, alias, is_in_contact_list, is_user, avatar, birthday, full_name, email_addresses, phone_numbers, urls);
}


static void _tpf_persona_contact_notify_presence_message (TpfPersona* self) {
	TpContact* contact = NULL;
	TpContact* _tmp0_ = NULL;
	TpContact* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_contact;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, tp_contact_get_type (), TpContact));
	contact = _tmp1_;
	_vala_assert (contact != NULL, "contact != null");
	_tmp2_ = tp_contact_get_presence_message (contact);
	folks_presence_details_set_presence_message ((FolksPresenceDetails*) self, _tmp2_);
	_g_object_unref0 (contact);
}


static void _tpf_persona_contact_notify_presence_type (TpfPersona* self) {
	TpContact* contact = NULL;
	TpContact* _tmp0_ = NULL;
	TpContact* _tmp1_ = NULL;
	TpConnectionPresenceType _tmp2_ = 0;
	FolksPresenceType _tmp3_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_contact;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, tp_contact_get_type (), TpContact));
	contact = _tmp1_;
	_vala_assert (contact != NULL, "contact != null");
	_tmp2_ = tp_contact_get_presence_type (contact);
	_tmp3_ = _tpf_persona_folks_presence_type_from_tp (_tmp2_);
	folks_presence_details_set_presence_type ((FolksPresenceDetails*) self, _tmp3_);
	_g_object_unref0 (contact);
}


static void _tpf_persona_contact_notify_client_types (TpfPersona* self) {
	TpContact* contact = NULL;
	TpContact* _tmp0_ = NULL;
	TpContact* _tmp1_ = NULL;
	gchar** _tmp2_ = NULL;
	gchar** _tmp3_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_contact;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, tp_contact_get_type (), TpContact));
	contact = _tmp1_;
	_vala_assert (contact != NULL, "contact != null");
	_tmp3_ = _tmp2_ = tp_contact_get_client_types (contact);
	folks_presence_details_set_client_types ((FolksPresenceDetails*) self, _tmp3_, _vala_array_length (_tmp2_));
	_g_object_unref0 (contact);
}


static void _tpf_persona_contact_notify_presence_status (TpfPersona* self) {
	TpContact* contact = NULL;
	TpContact* _tmp0_ = NULL;
	TpContact* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_contact;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, tp_contact_get_type (), TpContact));
	contact = _tmp1_;
	_vala_assert (contact != NULL, "contact != null");
	_tmp2_ = tp_contact_get_presence_status (contact);
	folks_presence_details_set_presence_status ((FolksPresenceDetails*) self, _tmp2_);
	_g_object_unref0 (contact);
}


static FolksPresenceType _tpf_persona_folks_presence_type_from_tp (TpConnectionPresenceType type) {
	FolksPresenceType result = 0;
	TpConnectionPresenceType _tmp0_ = 0;
	_tmp0_ = type;
	switch (_tmp0_) {
		case TP_CONNECTION_PRESENCE_TYPE_AVAILABLE:
		{
			result = FOLKS_PRESENCE_TYPE_AVAILABLE;
			return result;
		}
		case TP_CONNECTION_PRESENCE_TYPE_AWAY:
		{
			result = FOLKS_PRESENCE_TYPE_AWAY;
			return result;
		}
		case TP_CONNECTION_PRESENCE_TYPE_BUSY:
		{
			result = FOLKS_PRESENCE_TYPE_BUSY;
			return result;
		}
		case TP_CONNECTION_PRESENCE_TYPE_ERROR:
		{
			result = FOLKS_PRESENCE_TYPE_ERROR;
			return result;
		}
		case TP_CONNECTION_PRESENCE_TYPE_EXTENDED_AWAY:
		{
			result = FOLKS_PRESENCE_TYPE_EXTENDED_AWAY;
			return result;
		}
		case TP_CONNECTION_PRESENCE_TYPE_HIDDEN:
		{
			result = FOLKS_PRESENCE_TYPE_HIDDEN;
			return result;
		}
		case TP_CONNECTION_PRESENCE_TYPE_OFFLINE:
		{
			result = FOLKS_PRESENCE_TYPE_OFFLINE;
			return result;
		}
		case TP_CONNECTION_PRESENCE_TYPE_UNKNOWN:
		{
			result = FOLKS_PRESENCE_TYPE_UNKNOWN;
			return result;
		}
		case TP_CONNECTION_PRESENCE_TYPE_UNSET:
		{
			result = FOLKS_PRESENCE_TYPE_UNSET;
			return result;
		}
		default:
		{
			result = FOLKS_PRESENCE_TYPE_UNKNOWN;
			return result;
		}
	}
}


static void _tpf_persona_contact_notify_avatar (TpfPersona* self) {
	TpContact* contact = NULL;
	TpContact* _tmp0_ = NULL;
	TpContact* _tmp1_ = NULL;
	TpContact* _tmp2_ = NULL;
	GFile* file = NULL;
	TpContact* _tmp3_ = NULL;
	GFile* _tmp4_ = NULL;
	GFile* _tmp5_ = NULL;
	GFile* _tmp6_ = NULL;
	gchar* token = NULL;
	TpContact* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	GIcon* icon = NULL;
	gboolean from_cache = FALSE;
	const gchar* _tmp11_ = NULL;
	GFile* _tmp20_ = NULL;
	gboolean _tmp23_ = FALSE;
	GLoadableIcon* _tmp24_ = NULL;
	GIcon* _tmp25_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_contact;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, tp_contact_get_type (), TpContact));
	contact = _tmp1_;
	_tmp2_ = contact;
	_vala_assert (_tmp2_ != NULL, "contact != null");
	_tmp3_ = contact;
	_tmp4_ = tp_contact_get_avatar_file (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = _g_object_ref0 (_tmp5_);
	file = _tmp6_;
	_tmp7_ = contact;
	_tmp8_ = tp_contact_get_avatar_token (_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = g_strdup (_tmp9_);
	token = _tmp10_;
	icon = NULL;
	from_cache = FALSE;
	_tmp11_ = token;
	if (g_strcmp0 (_tmp11_, "") == 0) {
		_g_object_unref0 (file);
		file = NULL;
		from_cache = FALSE;
	} else {
		gboolean _tmp12_ = FALSE;
		const gchar* _tmp13_ = NULL;
		_tmp13_ = token;
		if (_tmp13_ != NULL) {
			GFile* _tmp14_ = NULL;
			_tmp14_ = file;
			_tmp12_ = _tmp14_ != NULL;
		} else {
			_tmp12_ = FALSE;
		}
		if (_tmp12_) {
			from_cache = FALSE;
		} else {
			FolksPersonaStore* _tmp15_ = NULL;
			FolksPersonaStore* _tmp16_ = NULL;
			const gchar* _tmp17_ = NULL;
			const gchar* _tmp18_ = NULL;
			GFile* _tmp19_ = NULL;
			_tmp15_ = folks_persona_get_store ((FolksPersona*) self);
			_tmp16_ = _tmp15_;
			_tmp17_ = folks_persona_get_iid ((FolksPersona*) self);
			_tmp18_ = _tmp17_;
			_tmp19_ = _tpf_persona_store_query_avatar_cache (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, TPF_TYPE_PERSONA_STORE, TpfPersonaStore), _tmp18_);
			_g_object_unref0 (file);
			file = _tmp19_;
			from_cache = TRUE;
		}
	}
	_tmp20_ = file;
	if (_tmp20_ != NULL) {
		GFile* _tmp21_ = NULL;
		GFileIcon* _tmp22_ = NULL;
		_tmp21_ = file;
		_tmp22_ = (GFileIcon*) g_file_icon_new (_tmp21_);
		_g_object_unref0 (icon);
		icon = (GIcon*) _tmp22_;
	}
	_tmp24_ = self->priv->_avatar;
	_tmp25_ = icon;
	if ((_tmp24_ == NULL) != (_tmp25_ == NULL)) {
		_tmp23_ = TRUE;
	} else {
		GLoadableIcon* _tmp26_ = NULL;
		GIcon* _tmp27_ = NULL;
		gboolean _tmp28_ = FALSE;
		_tmp26_ = self->priv->_avatar;
		_tmp27_ = icon;
		_tmp28_ = g_icon_equal ((GIcon*) _tmp26_, _tmp27_);
		_tmp23_ = !_tmp28_;
	}
	if (_tmp23_) {
		GIcon* _tmp29_ = NULL;
		GLoadableIcon* _tmp30_ = NULL;
		gboolean _tmp31_ = FALSE;
		_tmp29_ = icon;
		_tmp30_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp29_, g_loadable_icon_get_type (), GLoadableIcon));
		_g_object_unref0 (self->priv->_avatar);
		self->priv->_avatar = _tmp30_;
		g_object_notify ((GObject*) self, "avatar");
		_tmp31_ = from_cache;
		if (_tmp31_ == FALSE) {
			FolksPersonaStore* _tmp32_ = NULL;
			FolksPersonaStore* _tmp33_ = NULL;
			FolksPersonaStore* _tmp34_ = NULL;
			FolksPersonaStore* _tmp35_ = NULL;
			const gchar* _tmp36_ = NULL;
			const gchar* _tmp37_ = NULL;
			GFile* _tmp38_ = NULL;
			_tmp32_ = folks_persona_get_store ((FolksPersona*) self);
			_tmp33_ = _tmp32_;
			_tpf_persona_store_set_cache_needs_update (G_TYPE_CHECK_INSTANCE_CAST (_tmp33_, TPF_TYPE_PERSONA_STORE, TpfPersonaStore));
			_tmp34_ = folks_persona_get_store ((FolksPersona*) self);
			_tmp35_ = _tmp34_;
			_tmp36_ = folks_persona_get_iid ((FolksPersona*) self);
			_tmp37_ = _tmp36_;
			_tmp38_ = file;
			_tpf_persona_store_update_avatar_cache (G_TYPE_CHECK_INSTANCE_CAST (_tmp35_, TPF_TYPE_PERSONA_STORE, TpfPersonaStore), _tmp37_, _tmp38_);
		}
	}
	_g_object_unref0 (icon);
	_g_free0 (token);
	_g_object_unref0 (file);
	_g_object_unref0 (contact);
}


/**
   * Look up a {@link Tpf.Persona} by its {@link TelepathyGLib.Contact}.
   *
   * If the {@link TelepathyGLib.Account} for the contact's
   * {@link TelepathyGLib.Connection} is ``null``, or if a
   * {@link Tpf.PersonaStore} can't be found for that account, ``null`` will be
   * returned. Otherwise, if a {@link Tpf.Persona} already exists for the given
   * contact, that will be returned; if one doesn't exist a new one will be
   * created and returned. In this case, the {@link Tpf.Persona} will be added
   * to the {@link PersonaStore} associated with the account, and will be
   * removed when ``contact`` is destroyed.
   *
   * @param contact the Telepathy contact of the persona
   * @return the persona associated with the contact, or ``null``
   * @since 0.6.6
   */
TpfPersona* tpf_persona_dup_for_contact (TpContact* contact) {
	TpfPersona* result = NULL;
	TpAccount* account = NULL;
	TpContact* _tmp0_ = NULL;
	TpConnection* _tmp1_ = NULL;
	TpConnection* _tmp2_ = NULL;
	TpAccount* _tmp3_ = NULL;
	TpAccount* _tmp4_ = NULL;
	TpContact* _tmp5_ = NULL;
	TpAccount* _tmp6_ = NULL;
	TpAccount* _tmp7_ = NULL;
	TpfPersonaStore* store = NULL;
	TpAccount* _tmp8_ = NULL;
	TpfPersonaStore* _tmp9_ = NULL;
	TpfPersonaStore* _tmp10_ = NULL;
	TpContact* _tmp11_ = NULL;
	TpfPersona* _tmp12_ = NULL;
	g_return_val_if_fail (contact != NULL, NULL);
	_tmp0_ = contact;
	_tmp1_ = tp_contact_get_connection (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = tp_connection_get_account (_tmp2_);
	_tmp4_ = _g_object_ref0 (_tmp3_);
	account = _tmp4_;
	_tmp5_ = contact;
	_tmp6_ = account;
	g_debug ("tpf-persona.vala:1382: Tpf.Persona.dup_for_contact (%p): got account %" \
"p", _tmp5_, _tmp6_);
	_tmp7_ = account;
	if (_tmp7_ == NULL) {
		result = NULL;
		_g_object_unref0 (account);
		return result;
	}
	_tmp8_ = account;
	_tmp9_ = tpf_persona_store_dup_for_account (_tmp8_);
	store = _tmp9_;
	_tmp10_ = store;
	_tmp11_ = contact;
	_tmp12_ = _tpf_persona_store_ensure_persona_for_contact (_tmp10_, _tmp11_);
	result = _tmp12_;
	_g_object_unref0 (store);
	_g_object_unref0 (account);
	return result;
}


void _tpf_persona_increase_im_interaction_counter (TpfPersona* self, GDateTime* converted_datetime) {
	guint _tmp0_ = 0U;
	gboolean _tmp1_ = FALSE;
	GDateTime* _tmp2_ = NULL;
	const gchar* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	guint _tmp10_ = 0U;
	GDateTime* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	gchar* _tmp13_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (converted_datetime != NULL);
	_tmp0_ = self->priv->_im_interaction_count;
	self->priv->_im_interaction_count = _tmp0_ + 1;
	g_object_notify ((GObject*) self, "im-interaction-count");
	_tmp2_ = self->_last_im_interaction_datetime;
	if (_tmp2_ == NULL) {
		_tmp1_ = TRUE;
	} else {
		GDateTime* _tmp3_ = NULL;
		GDateTime* _tmp4_ = NULL;
		gint _tmp5_ = 0;
		_tmp3_ = self->_last_im_interaction_datetime;
		_tmp4_ = converted_datetime;
		_tmp5_ = g_date_time_compare (_tmp3_, _tmp4_);
		_tmp1_ = _tmp5_ == -1;
	}
	if (_tmp1_) {
		GDateTime* _tmp6_ = NULL;
		GDateTime* _tmp7_ = NULL;
		_tmp6_ = converted_datetime;
		_tmp7_ = _g_date_time_ref0 (_tmp6_);
		_g_date_time_unref0 (self->_last_im_interaction_datetime);
		self->_last_im_interaction_datetime = _tmp7_;
		g_object_notify ((GObject*) self, "last-im-interaction-datetime");
	}
	_tmp8_ = folks_persona_get_iid ((FolksPersona*) self);
	_tmp9_ = _tmp8_;
	_tmp10_ = self->priv->_im_interaction_count;
	_tmp11_ = self->_last_im_interaction_datetime;
	_tmp12_ = g_date_time_format (_tmp11_, "%H %M %S - %d %m %y");
	_tmp13_ = _tmp12_;
	g_debug ("Persona %s IM interaction details changed:\n" " - count: %u \n - timestamp: %lld", _tmp9_, _tmp10_, _tmp13_);
	_g_free0 (_tmp13_);
}


void _tpf_persona_increase_last_call_interaction_counter (TpfPersona* self, GDateTime* converted_datetime) {
	guint _tmp0_ = 0U;
	gboolean _tmp1_ = FALSE;
	GDateTime* _tmp2_ = NULL;
	const gchar* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	guint _tmp10_ = 0U;
	GDateTime* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	gchar* _tmp13_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (converted_datetime != NULL);
	_tmp0_ = self->priv->_call_interaction_count;
	self->priv->_call_interaction_count = _tmp0_ + 1;
	g_object_notify ((GObject*) self, "call-interaction-count");
	_tmp2_ = self->_last_call_interaction_datetime;
	if (_tmp2_ == NULL) {
		_tmp1_ = TRUE;
	} else {
		GDateTime* _tmp3_ = NULL;
		GDateTime* _tmp4_ = NULL;
		gint _tmp5_ = 0;
		_tmp3_ = self->_last_call_interaction_datetime;
		_tmp4_ = converted_datetime;
		_tmp5_ = g_date_time_compare (_tmp3_, _tmp4_);
		_tmp1_ = _tmp5_ == -1;
	}
	if (_tmp1_) {
		GDateTime* _tmp6_ = NULL;
		GDateTime* _tmp7_ = NULL;
		_tmp6_ = converted_datetime;
		_tmp7_ = _g_date_time_ref0 (_tmp6_);
		_g_date_time_unref0 (self->_last_call_interaction_datetime);
		self->_last_call_interaction_datetime = _tmp7_;
		g_object_notify ((GObject*) self, "last-call-interaction-datetime");
	}
	_tmp8_ = folks_persona_get_iid ((FolksPersona*) self);
	_tmp9_ = _tmp8_;
	_tmp10_ = self->priv->_call_interaction_count;
	_tmp11_ = self->_last_call_interaction_datetime;
	_tmp12_ = g_date_time_format (_tmp11_, "%H %M %S - %d %m %y");
	_tmp13_ = _tmp12_;
	g_debug ("Persona %s Call interaction details changed:\n" " - count: %u \n - timestamp: %lld", _tmp9_, _tmp10_, _tmp13_);
	_g_free0 (_tmp13_);
}


gboolean tpf_persona_get_is_in_contact_list (TpfPersona* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_in_contact_list;
	result = _tmp0_;
	return result;
}


void tpf_persona_set_is_in_contact_list (TpfPersona* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_is_in_contact_list = _tmp0_;
	g_object_notify ((GObject *) self, "is-in-contact-list");
}


static GLoadableIcon* tpf_persona_real_get_avatar (FolksAvatarDetails* base) {
	GLoadableIcon* result;
	TpfPersona* self;
	GLoadableIcon* _tmp0_ = NULL;
	self = (TpfPersona*) base;
	_tmp0_ = self->priv->_avatar;
	result = _tmp0_;
	return result;
}


static void tpf_persona_real_set_avatar (FolksAvatarDetails* base, GLoadableIcon* value) {
	TpfPersona* self;
	GLoadableIcon* _tmp0_ = NULL;
	self = (TpfPersona*) base;
	_tmp0_ = value;
	folks_avatar_details_change_avatar ((FolksAvatarDetails*) self, _tmp0_, NULL, NULL);
}


static FolksStructuredName* tpf_persona_real_get_structured_name (FolksNameDetails* base) {
	FolksStructuredName* result;
	TpfPersona* self;
	self = (TpfPersona*) base;
	result = NULL;
	return result;
}


static void tpf_persona_real_set_structured_name (FolksNameDetails* base, FolksStructuredName* value) {
	TpfPersona* self;
	FolksStructuredName* _tmp0_ = NULL;
	self = (TpfPersona*) base;
	_tmp0_ = value;
	folks_name_details_change_structured_name ((FolksNameDetails*) self, _tmp0_, NULL, NULL);
}


static const gchar* tpf_persona_real_get_full_name (FolksNameDetails* base) {
	const gchar* result;
	TpfPersona* self;
	const gchar* _tmp0_ = NULL;
	self = (TpfPersona*) base;
	_tmp0_ = self->priv->_full_name;
	result = _tmp0_;
	return result;
}


static void tpf_persona_real_set_full_name (FolksNameDetails* base, const gchar* value) {
	TpfPersona* self;
	const gchar* _tmp0_ = NULL;
	self = (TpfPersona*) base;
	_tmp0_ = value;
	folks_name_details_change_full_name ((FolksNameDetails*) self, _tmp0_, NULL, NULL);
}


static const gchar* tpf_persona_real_get_nickname (FolksNameDetails* base) {
	const gchar* result;
	TpfPersona* self;
	self = (TpfPersona*) base;
	result = "";
	return result;
}


static void tpf_persona_real_set_nickname (FolksNameDetails* base, const gchar* value) {
	TpfPersona* self;
	const gchar* _tmp0_ = NULL;
	self = (TpfPersona*) base;
	_tmp0_ = value;
	folks_name_details_change_nickname ((FolksNameDetails*) self, _tmp0_, NULL, NULL);
}


static const gchar* tpf_persona_real_get_calendar_event_id (FolksBirthdayDetails* base) {
	const gchar* result;
	TpfPersona* self;
	self = (TpfPersona*) base;
	result = NULL;
	return result;
}


static void tpf_persona_real_set_calendar_event_id (FolksBirthdayDetails* base, const gchar* value) {
	TpfPersona* self;
	const gchar* _tmp0_ = NULL;
	self = (TpfPersona*) base;
	_tmp0_ = value;
	folks_birthday_details_change_calendar_event_id ((FolksBirthdayDetails*) self, _tmp0_, NULL, NULL);
}


static GDateTime* tpf_persona_real_get_birthday (FolksBirthdayDetails* base) {
	GDateTime* result;
	TpfPersona* self;
	GDateTime* _tmp0_ = NULL;
	self = (TpfPersona*) base;
	_tmp0_ = self->priv->_birthday;
	result = _tmp0_;
	return result;
}


static void tpf_persona_real_set_birthday (FolksBirthdayDetails* base, GDateTime* value) {
	TpfPersona* self;
	GDateTime* _tmp0_ = NULL;
	self = (TpfPersona*) base;
	_tmp0_ = value;
	folks_birthday_details_change_birthday ((FolksBirthdayDetails*) self, _tmp0_, NULL, NULL);
}


static FolksPresenceType tpf_persona_real_get_presence_type (FolksPresenceDetails* base) {
	FolksPresenceType result;
	TpfPersona* self;
	FolksPresenceType _tmp0_ = 0;
	self = (TpfPersona*) base;
	_tmp0_ = self->priv->_presence_type;
	result = _tmp0_;
	return result;
}


static void tpf_persona_real_set_presence_type (FolksPresenceDetails* base, FolksPresenceType value) {
	TpfPersona* self;
	FolksPresenceType _tmp0_ = 0;
	self = (TpfPersona*) base;
	_tmp0_ = value;
	self->priv->_presence_type = _tmp0_;
	g_object_notify ((GObject *) self, "presence-type");
}


static const gchar* tpf_persona_real_get_presence_status (FolksPresenceDetails* base) {
	const gchar* result;
	TpfPersona* self;
	const gchar* _tmp0_ = NULL;
	self = (TpfPersona*) base;
	_tmp0_ = self->priv->_presence_status;
	result = _tmp0_;
	return result;
}


static void tpf_persona_real_set_presence_status (FolksPresenceDetails* base, const gchar* value) {
	TpfPersona* self;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	self = (TpfPersona*) base;
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_presence_status);
	self->priv->_presence_status = _tmp1_;
	g_object_notify ((GObject *) self, "presence-status");
}


static const gchar* tpf_persona_real_get_presence_message (FolksPresenceDetails* base) {
	const gchar* result;
	TpfPersona* self;
	const gchar* _tmp0_ = NULL;
	self = (TpfPersona*) base;
	_tmp0_ = self->priv->_presence_message;
	result = _tmp0_;
	return result;
}


static void tpf_persona_real_set_presence_message (FolksPresenceDetails* base, const gchar* value) {
	TpfPersona* self;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	self = (TpfPersona*) base;
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_presence_message);
	self->priv->_presence_message = _tmp1_;
	g_object_notify ((GObject *) self, "presence-message");
}


static gchar** tpf_persona_real_get_client_types (FolksPresenceDetails* base, int* result_length1) {
	gchar** result;
	TpfPersona* self;
	gchar** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gchar** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	self = (TpfPersona*) base;
	_tmp0_ = self->priv->_client_types;
	_tmp0__length1 = self->priv->_client_types_length1;
	_tmp1_ = _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	if (result_length1) {
		*result_length1 = _tmp1__length1;
	}
	result = _tmp1_;
	return result;
}


static gchar** _vala_array_dup2 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_ = NULL;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static void tpf_persona_real_set_client_types (FolksPresenceDetails* base, gchar** value, int value_length1) {
	TpfPersona* self;
	gchar** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gchar** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	self = (TpfPersona*) base;
	_tmp0_ = value;
	_tmp0__length1 = value_length1;
	_tmp1_ = (_tmp0_ != NULL) ? _vala_array_dup2 (_tmp0_, _tmp0__length1) : ((gpointer) _tmp0_);
	_tmp1__length1 = _tmp0__length1;
	self->priv->_client_types = (_vala_array_free (self->priv->_client_types, self->priv->_client_types_length1, (GDestroyNotify) g_free), NULL);
	self->priv->_client_types = _tmp1_;
	self->priv->_client_types_length1 = _tmp1__length1;
	self->priv->__client_types_size_ = self->priv->_client_types_length1;
	g_object_notify ((GObject *) self, "client-types");
}


static gchar** tpf_persona_real_get_linkable_properties (FolksPersona* base, int* result_length1) {
	gchar** result;
	TpfPersona* self;
	gchar** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	self = (TpfPersona*) base;
	_tmp0_ = TPF_PERSONA__linkable_properties;
	_tmp0__length1 = G_N_ELEMENTS (TPF_PERSONA__linkable_properties);
	if (result_length1) {
		*result_length1 = _tmp0__length1;
	}
	result = _tmp0_;
	return result;
}


static gchar** tpf_persona_real_get_writeable_properties (FolksPersona* base, int* result_length1) {
	gchar** result;
	TpfPersona* self;
	gchar** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gchar** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	self = (TpfPersona*) base;
	_tmp0_ = self->priv->_writeable_properties;
	_tmp0__length1 = self->priv->_writeable_properties_length1;
	_tmp1_ = _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	if (result_length1) {
		*result_length1 = _tmp1__length1;
	}
	result = _tmp1_;
	return result;
}


static const gchar* tpf_persona_real_get_alias (FolksAliasDetails* base) {
	const gchar* result;
	TpfPersona* self;
	const gchar* _tmp0_ = NULL;
	self = (TpfPersona*) base;
	_tmp0_ = self->priv->_alias;
	result = _tmp0_;
	return result;
}


static void tpf_persona_real_set_alias (FolksAliasDetails* base, const gchar* value) {
	TpfPersona* self;
	const gchar* _tmp0_ = NULL;
	self = (TpfPersona*) base;
	_tmp0_ = value;
	folks_alias_details_change_alias ((FolksAliasDetails*) self, _tmp0_, NULL, NULL);
}


static gboolean tpf_persona_real_get_is_favourite (FolksFavouriteDetails* base) {
	gboolean result;
	TpfPersona* self;
	gboolean _tmp0_ = FALSE;
	self = (TpfPersona*) base;
	_tmp0_ = self->priv->_is_favourite;
	result = _tmp0_;
	return result;
}


static void tpf_persona_real_set_is_favourite (FolksFavouriteDetails* base, gboolean value) {
	TpfPersona* self;
	gboolean _tmp0_ = FALSE;
	self = (TpfPersona*) base;
	_tmp0_ = value;
	folks_favourite_details_change_is_favourite ((FolksFavouriteDetails*) self, _tmp0_, NULL, NULL);
}


static GeeSet* tpf_persona_real_get_email_addresses (FolksEmailDetails* base) {
	GeeSet* result;
	TpfPersona* self;
	GeeSet* _tmp0_ = NULL;
	self = (TpfPersona*) base;
	_tpf_persona_contact_notify_contact_info (self, TRUE, FALSE);
	_tmp0_ = self->priv->_email_addresses_ro;
	result = _tmp0_;
	return result;
}


static void tpf_persona_real_set_email_addresses (FolksEmailDetails* base, GeeSet* value) {
	TpfPersona* self;
	GeeSet* _tmp0_ = NULL;
	self = (TpfPersona*) base;
	_tmp0_ = value;
	folks_email_details_change_email_addresses ((FolksEmailDetails*) self, _tmp0_, NULL, NULL);
}


static GeeMultiMap* tpf_persona_real_get_im_addresses (FolksImDetails* base) {
	GeeMultiMap* result;
	TpfPersona* self;
	GeeHashMultiMap* _tmp0_ = NULL;
	self = (TpfPersona*) base;
	_tmp0_ = self->priv->_im_addresses;
	result = (GeeMultiMap*) _tmp0_;
	return result;
}


static void tpf_persona_real_set_im_addresses (FolksImDetails* base, GeeMultiMap* value) {
	TpfPersona* self;
	GeeMultiMap* _tmp0_ = NULL;
	self = (TpfPersona*) base;
	_tmp0_ = value;
	folks_im_details_change_im_addresses ((FolksImDetails*) self, _tmp0_, NULL, NULL);
}


static guint tpf_persona_real_get_im_interaction_count (FolksInteractionDetails* base) {
	guint result;
	TpfPersona* self;
	guint _tmp0_ = 0U;
	self = (TpfPersona*) base;
	_tmp0_ = self->priv->_im_interaction_count;
	result = _tmp0_;
	return result;
}


static GDateTime* tpf_persona_real_get_last_im_interaction_datetime (FolksInteractionDetails* base) {
	GDateTime* result;
	TpfPersona* self;
	GDateTime* _tmp0_ = NULL;
	self = (TpfPersona*) base;
	_tmp0_ = self->_last_im_interaction_datetime;
	result = _tmp0_;
	return result;
}


static guint tpf_persona_real_get_call_interaction_count (FolksInteractionDetails* base) {
	guint result;
	TpfPersona* self;
	guint _tmp0_ = 0U;
	self = (TpfPersona*) base;
	_tmp0_ = self->priv->_call_interaction_count;
	result = _tmp0_;
	return result;
}


static GDateTime* tpf_persona_real_get_last_call_interaction_datetime (FolksInteractionDetails* base) {
	GDateTime* result;
	TpfPersona* self;
	GDateTime* _tmp0_ = NULL;
	self = (TpfPersona*) base;
	_tmp0_ = self->_last_call_interaction_datetime;
	result = _tmp0_;
	return result;
}


static GeeSet* tpf_persona_real_get_groups (FolksGroupDetails* base) {
	GeeSet* result;
	TpfPersona* self;
	GeeSet* _tmp0_ = NULL;
	self = (TpfPersona*) base;
	_tmp0_ = self->priv->_groups_ro;
	result = _tmp0_;
	return result;
}


static void tpf_persona_real_set_groups (FolksGroupDetails* base, GeeSet* value) {
	TpfPersona* self;
	GeeSet* _tmp0_ = NULL;
	self = (TpfPersona*) base;
	_tmp0_ = value;
	folks_group_details_change_groups ((FolksGroupDetails*) self, _tmp0_, NULL, NULL);
}


TpContact* tpf_persona_get_contact (TpfPersona* self) {
	TpContact* result;
	TpContact* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_contact;
	result = _tmp0_;
	return result;
}


static void tpf_persona_set_contact (TpfPersona* self, TpContact* value) {
	TpContact* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_contact = _tmp0_;
	g_object_notify ((GObject *) self, "contact");
}


static GeeSet* tpf_persona_real_get_phone_numbers (FolksPhoneDetails* base) {
	GeeSet* result;
	TpfPersona* self;
	GeeSet* _tmp0_ = NULL;
	self = (TpfPersona*) base;
	_tpf_persona_contact_notify_contact_info (self, TRUE, FALSE);
	_tmp0_ = self->priv->_phone_numbers_ro;
	result = _tmp0_;
	return result;
}


static void tpf_persona_real_set_phone_numbers (FolksPhoneDetails* base, GeeSet* value) {
	TpfPersona* self;
	GeeSet* _tmp0_ = NULL;
	self = (TpfPersona*) base;
	_tmp0_ = value;
	folks_phone_details_change_phone_numbers ((FolksPhoneDetails*) self, _tmp0_, NULL, NULL);
}


static GeeSet* tpf_persona_real_get_urls (FolksUrlDetails* base) {
	GeeSet* result;
	TpfPersona* self;
	GeeSet* _tmp0_ = NULL;
	self = (TpfPersona*) base;
	_tpf_persona_contact_notify_contact_info (self, TRUE, FALSE);
	_tmp0_ = self->priv->_urls_ro;
	result = _tmp0_;
	return result;
}


static void tpf_persona_real_set_urls (FolksUrlDetails* base, GeeSet* value) {
	TpfPersona* self;
	GeeSet* _tmp0_ = NULL;
	self = (TpfPersona*) base;
	_tmp0_ = value;
	folks_url_details_change_urls ((FolksUrlDetails*) self, _tmp0_, NULL, NULL);
}


static void _tpf_persona___lambda16_ (TpfPersona* self, GObject* s, GParamSpec* p) {
	TpContact* c = NULL;
	TpContact* _tmp0_ = NULL;
	TpContact* _tmp1_ = NULL;
	TpContact* _tmp2_ = NULL;
	TpContact* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	TpContact* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	g_return_if_fail (s != NULL);
	g_return_if_fail (p != NULL);
	_tmp0_ = self->priv->_contact;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, tp_contact_get_type (), TpContact));
	c = _tmp1_;
	_tmp2_ = c;
	_vala_assert (_tmp2_ != NULL, "c != null");
	_tmp3_ = c;
	_tmp4_ = tp_contact_get_alias (_tmp3_);
	_tmp5_ = _tmp4_;
	_vala_assert (_tmp5_ != NULL, "c.alias != null");
	_tmp6_ = self->priv->_alias;
	_tmp7_ = c;
	_tmp8_ = tp_contact_get_alias (_tmp7_);
	_tmp9_ = _tmp8_;
	if (g_strcmp0 (_tmp6_, _tmp9_) != 0) {
		TpContact* _tmp10_ = NULL;
		const gchar* _tmp11_ = NULL;
		const gchar* _tmp12_ = NULL;
		gchar* _tmp13_ = NULL;
		FolksPersonaStore* _tmp14_ = NULL;
		FolksPersonaStore* _tmp15_ = NULL;
		_tmp10_ = c;
		_tmp11_ = tp_contact_get_alias (_tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = g_strdup (_tmp12_);
		_g_free0 (self->priv->_alias);
		self->priv->_alias = _tmp13_;
		g_object_notify ((GObject*) self, "alias");
		_tmp14_ = folks_persona_get_store ((FolksPersona*) self);
		_tmp15_ = _tmp14_;
		_tpf_persona_store_set_cache_needs_update (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, TPF_TYPE_PERSONA_STORE, TpfPersonaStore));
	}
	_g_object_unref0 (c);
}


static void __tpf_persona___lambda16__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_tpf_persona___lambda16_ ((TpfPersona*) self, _sender, pspec);
}


static void _tpf_persona___lambda17_ (TpfPersona* self, GObject* s, GParamSpec* p) {
	g_return_if_fail (s != NULL);
	g_return_if_fail (p != NULL);
	_tpf_persona_contact_notify_avatar (self);
}


static void __tpf_persona___lambda17__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_tpf_persona___lambda17_ ((TpfPersona*) self, _sender, pspec);
}


static void _tpf_persona___lambda18_ (TpfPersona* self, GObject* s, GParamSpec* p) {
	g_return_if_fail (s != NULL);
	g_return_if_fail (p != NULL);
	_tpf_persona_contact_notify_presence_message (self);
}


static void __tpf_persona___lambda18__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_tpf_persona___lambda18_ ((TpfPersona*) self, _sender, pspec);
}


static void _tpf_persona___lambda19_ (TpfPersona* self, GObject* s, GParamSpec* p) {
	g_return_if_fail (s != NULL);
	g_return_if_fail (p != NULL);
	_tpf_persona_contact_notify_presence_type (self);
}


static void __tpf_persona___lambda19__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_tpf_persona___lambda19_ ((TpfPersona*) self, _sender, pspec);
}


static void _tpf_persona___lambda20_ (TpfPersona* self, GObject* s, GParamSpec* p) {
	g_return_if_fail (s != NULL);
	g_return_if_fail (p != NULL);
	_tpf_persona_contact_notify_presence_status (self);
}


static void __tpf_persona___lambda20__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_tpf_persona___lambda20_ ((TpfPersona*) self, _sender, pspec);
}


static void _tpf_persona___lambda21_ (TpfPersona* self, GObject* s, GParamSpec* p) {
	g_return_if_fail (s != NULL);
	g_return_if_fail (p != NULL);
	_tpf_persona_contact_notify_client_types (self);
}


static void __tpf_persona___lambda21__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_tpf_persona___lambda21_ ((TpfPersona*) self, _sender, pspec);
}


static void _tpf_persona___lambda22_ (TpfPersona* self, GObject* s, GParamSpec* p) {
	g_return_if_fail (s != NULL);
	g_return_if_fail (p != NULL);
	_tpf_persona_contact_notify_contact_info (self, FALSE, TRUE);
}


static void __tpf_persona___lambda22__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_tpf_persona___lambda22_ ((TpfPersona*) self, _sender, pspec);
}


static void _tpf_persona___lambda23_ (TpfPersona* self, gchar** added, int added_length1, gchar** removed, int removed_length1) {
	gchar** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gchar** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	_tmp0_ = added;
	_tmp0__length1 = added_length1;
	_tmp1_ = removed;
	_tmp1__length1 = removed_length1;
	_tpf_persona_contact_groups_changed (self, _tmp0_, _tmp0__length1, _tmp1_, _tmp1__length1);
}


static void __tpf_persona___lambda23__tp_contact_contact_groups_changed (TpContact* _sender, gchar** added, gchar** removed, gpointer self) {
	_tpf_persona___lambda23_ ((TpfPersona*) self, added, _vala_array_length (added), removed, _vala_array_length (removed));
}


static void _tpf_persona____lambda24_ (TpfPersona* self, GObject* s, GParamSpec* p) {
	g_return_if_fail (s != NULL);
	g_return_if_fail (p != NULL);
	_tpf_persona_update_writeable_properties (self);
}


static void __tpf_persona____lambda24__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_tpf_persona____lambda24_ ((TpfPersona*) self, _sender, pspec);
}


static void _tpf_persona___lambda25_ (TpfPersona* self, GObject* s, GParamSpec* p) {
	g_return_if_fail (s != NULL);
	g_return_if_fail (p != NULL);
	_tpf_persona_update_writeable_properties (self);
}


static void __tpf_persona___lambda25__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_tpf_persona___lambda25_ ((TpfPersona*) self, _sender, pspec);
}


static GObject * tpf_persona_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	TpfPersona * self;
	FolksSmallSet* _tmp0_ = NULL;
	GeeSet* _tmp1_ = NULL;
	GeeSet* _tmp2_ = NULL;
	TpContact* contact = NULL;
	TpContact* _tmp3_ = NULL;
	TpContact* _tmp4_ = NULL;
	TpContact* _tmp5_ = NULL;
	TpContact* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	TpContact* _tmp9_ = NULL;
	TpConnection* connection = NULL;
	TpContact* _tmp10_ = NULL;
	TpConnection* _tmp11_ = NULL;
	TpConnection* _tmp12_ = NULL;
	TpConnection* _tmp13_ = NULL;
	TpAccount* account = NULL;
	TpConnection* _tmp14_ = NULL;
	TpAccount* _tmp15_ = NULL;
	TpAccount* _tmp16_ = NULL;
	TpContact* _tmp32_ = NULL;
	TpContact* _tmp33_ = NULL;
	TpContact* _tmp34_ = NULL;
	TpContact* _tmp35_ = NULL;
	TpContact* _tmp36_ = NULL;
	TpContact* _tmp37_ = NULL;
	TpContact* _tmp38_ = NULL;
	TpContact* _tmp39_ = NULL;
	gchar** _tmp40_ = NULL;
	gchar** _tmp41_ = NULL;
	gchar** _tmp42_ = NULL;
	gchar** _tmp43_ = NULL;
	gint _tmp43__length1 = 0;
	TpfPersonaStore* tpf_store = NULL;
	FolksPersonaStore* _tmp44_ = NULL;
	FolksPersonaStore* _tmp45_ = NULL;
	TpfPersonaStore* _tmp46_ = NULL;
	gboolean _tmp47_ = FALSE;
	gboolean _tmp48_ = FALSE;
	TpfPersonaStore* _tmp50_ = NULL;
	GError * _inner_error_ = NULL;
	parent_class = G_OBJECT_CLASS (tpf_persona_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TPF_TYPE_PERSONA, TpfPersona);
	_tmp0_ = self->priv->_groups;
	_tmp1_ = gee_abstract_set_get_read_only_view ((GeeAbstractSet*) _tmp0_);
	_tmp2_ = _tmp1_;
	_g_object_unref0 (self->priv->_groups_ro);
	self->priv->_groups_ro = _tmp2_;
	_tmp3_ = self->priv->_contact;
	_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, tp_contact_get_type (), TpContact));
	contact = _tmp4_;
	_tmp5_ = contact;
	if (_tmp5_ == NULL) {
		_g_object_unref0 (contact);
		return obj;
	}
	_tmp6_ = contact;
	_tmp7_ = tp_contact_get_alias (_tmp6_);
	_tmp8_ = g_strdup (_tmp7_);
	_g_free0 (self->priv->_alias);
	self->priv->_alias = _tmp8_;
	_tmp9_ = contact;
	g_signal_connect_object ((GObject*) _tmp9_, "notify::alias", (GCallback) __tpf_persona___lambda16__g_object_notify, self, 0);
	_tmp10_ = contact;
	_tmp11_ = tp_contact_get_connection (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = _g_object_ref0 (_tmp12_);
	connection = _tmp13_;
	_tmp14_ = connection;
	_tmp15_ = tp_connection_get_account (_tmp14_);
	_tmp16_ = _g_object_ref0 (_tmp15_);
	account = _tmp16_;
	{
		gchar* im_addr = NULL;
		const gchar* _tmp17_ = NULL;
		const gchar* _tmp18_ = NULL;
		TpAccount* _tmp19_ = NULL;
		const gchar* _tmp20_ = NULL;
		const gchar* _tmp21_ = NULL;
		gchar* _tmp22_ = NULL;
		FolksImFieldDetails* im_fd = NULL;
		const gchar* _tmp23_ = NULL;
		FolksImFieldDetails* _tmp24_ = NULL;
		GeeHashMultiMap* _tmp25_ = NULL;
		TpAccount* _tmp26_ = NULL;
		const gchar* _tmp27_ = NULL;
		const gchar* _tmp28_ = NULL;
		FolksImFieldDetails* _tmp29_ = NULL;
		_tmp17_ = folks_persona_get_display_id ((FolksPersona*) self);
		_tmp18_ = _tmp17_;
		_tmp19_ = account;
		_tmp20_ = tp_account_get_protocol_name (_tmp19_);
		_tmp21_ = _tmp20_;
		_tmp22_ = folks_im_details_normalise_im_address (_tmp18_, _tmp21_, &_inner_error_);
		im_addr = _tmp22_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == FOLKS_IM_DETAILS_ERROR) {
				goto __catch5_folks_im_details_error;
			}
			_g_object_unref0 (account);
			_g_object_unref0 (connection);
			_g_object_unref0 (contact);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
		}
		_tmp23_ = im_addr;
		_tmp24_ = folks_im_field_details_new (_tmp23_, NULL);
		im_fd = _tmp24_;
		_tmp25_ = self->priv->_im_addresses;
		_tmp26_ = account;
		_tmp27_ = tp_account_get_protocol_name (_tmp26_);
		_tmp28_ = _tmp27_;
		_tmp29_ = im_fd;
		gee_multi_map_set ((GeeMultiMap*) _tmp25_, _tmp28_, _tmp29_);
		_g_object_unref0 (im_fd);
		_g_free0 (im_addr);
	}
	goto __finally5;
	__catch5_folks_im_details_error:
	{
		GError* e = NULL;
		GError* _tmp30_ = NULL;
		const gchar* _tmp31_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp30_ = e;
		_tmp31_ = _tmp30_->message;
		g_warning ("tpf-persona.vala:835: %s", _tmp31_);
		_g_error_free0 (e);
	}
	__finally5:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (account);
		_g_object_unref0 (connection);
		_g_object_unref0 (contact);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
	}
	_tmp32_ = contact;
	g_signal_connect_object ((GObject*) _tmp32_, "notify::avatar-file", (GCallback) __tpf_persona___lambda17__g_object_notify, self, 0);
	_tpf_persona_contact_notify_avatar (self);
	_tmp33_ = contact;
	g_signal_connect_object ((GObject*) _tmp33_, "notify::presence-message", (GCallback) __tpf_persona___lambda18__g_object_notify, self, 0);
	_tmp34_ = contact;
	g_signal_connect_object ((GObject*) _tmp34_, "notify::presence-type", (GCallback) __tpf_persona___lambda19__g_object_notify, self, 0);
	_tmp35_ = contact;
	g_signal_connect_object ((GObject*) _tmp35_, "notify::presence-status", (GCallback) __tpf_persona___lambda20__g_object_notify, self, 0);
	_tmp36_ = contact;
	g_signal_connect_object ((GObject*) _tmp36_, "notify::client-types", (GCallback) __tpf_persona___lambda21__g_object_notify, self, 0);
	_tpf_persona_contact_notify_presence_message (self);
	_tpf_persona_contact_notify_presence_type (self);
	_tpf_persona_contact_notify_presence_status (self);
	_tpf_persona_contact_notify_client_types (self);
	_tmp37_ = contact;
	g_signal_connect_object ((GObject*) _tmp37_, "notify::contact-info", (GCallback) __tpf_persona___lambda22__g_object_notify, self, 0);
	_tpf_persona_contact_notify_contact_info (self, FALSE, TRUE);
	_tmp38_ = contact;
	g_signal_connect_object (_tmp38_, "contact-groups-changed", (GCallback) __tpf_persona___lambda23__tp_contact_contact_groups_changed, self, 0);
	_tmp39_ = contact;
	_tmp41_ = _tmp40_ = tp_contact_get_contact_groups (_tmp39_);
	_tmp42_ = g_new0 (gchar*, 0 + 1);
	_tmp43_ = _tmp42_;
	_tmp43__length1 = 0;
	_tpf_persona_contact_groups_changed (self, _tmp41_, _vala_array_length (_tmp40_), _tmp43_, 0);
	_tmp43_ = (_vala_array_free (_tmp43_, _tmp43__length1, (GDestroyNotify) g_free), NULL);
	_tmp44_ = folks_persona_get_store ((FolksPersona*) self);
	_tmp45_ = _tmp44_;
	_tmp46_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp45_, TPF_TYPE_PERSONA_STORE) ? ((TpfPersonaStore*) _tmp45_) : NULL);
	tpf_store = _tmp46_;
	_tmp47_ = folks_persona_get_is_user ((FolksPersona*) self);
	_tmp48_ = _tmp47_;
	if (_tmp48_) {
		TpfPersonaStore* _tmp49_ = NULL;
		_tmp49_ = tpf_store;
		g_signal_connect_object ((GObject*) _tmp49_, "notify::supported-fields", (GCallback) __tpf_persona____lambda24__g_object_notify, self, 0);
	}
	_tmp50_ = tpf_store;
	g_signal_connect_object ((GObject*) _tmp50_, "notify::always-writeable-properties", (GCallback) __tpf_persona___lambda25__g_object_notify, self, 0);
	_tpf_persona_update_writeable_properties (self);
	_g_object_unref0 (tpf_store);
	_g_object_unref0 (account);
	_g_object_unref0 (connection);
	_g_object_unref0 (contact);
	return obj;
}


static void tpf_persona_class_init (TpfPersonaClass * klass) {
	tpf_persona_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (TpfPersonaPrivate));
	((GObjectClass *) klass)->constructed = tpf_persona_real_constructed;
	FOLKS_PERSONA_CLASS (klass)->get_linkable_properties = tpf_persona_real_get_linkable_properties;
	FOLKS_PERSONA_CLASS (klass)->get_writeable_properties = tpf_persona_real_get_writeable_properties;
	G_OBJECT_CLASS (klass)->get_property = _vala_tpf_persona_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_tpf_persona_set_property;
	G_OBJECT_CLASS (klass)->constructor = tpf_persona_constructor;
	G_OBJECT_CLASS (klass)->finalize = tpf_persona_finalize;
	/**
	   * Whether the Persona is in the user's contact list.
	   *
	   * This will be true for most {@link Folks.Persona}s, but may not be true for
	   * personas where {@link Folks.Persona.is_user} is true. If it's false in
	   * this case, it means that the persona has been retrieved from the Telepathy
	   * connection, but has not been added to the user's contact list.
	   *
	   * @since 0.3.5
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), TPF_PERSONA_IS_IN_CONTACT_LIST, g_param_spec_boolean ("is-in-contact-list", "is-in-contact-list", "is-in-contact-list", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	   * An avatar for the Persona.
	   *
	   * See {@link Folks.AvatarDetails.avatar}.
	   *
	   * @since 0.6.0
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), TPF_PERSONA_AVATAR, g_param_spec_object ("avatar", "avatar", "avatar", g_loadable_icon_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	   * {@inheritDoc}
	   *
	   * @since 0.6.4
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), TPF_PERSONA_STRUCTURED_NAME, g_param_spec_object ("structured-name", "structured-name", "structured-name", FOLKS_TYPE_STRUCTURED_NAME, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	   * {@inheritDoc}
	   *
	   * @since 0.6.4
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), TPF_PERSONA_FULL_NAME, g_param_spec_string ("full-name", "full-name", "full-name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	   * {@inheritDoc}
	   *
	   * @since 0.6.4
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), TPF_PERSONA_NICKNAME, g_param_spec_string ("nickname", "nickname", "nickname", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	   * {@inheritDoc}
	   *
	   * ContactInfo has no equivalent field, so this is unsupported.
	   *
	   * @since 0.6.4
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), TPF_PERSONA_CALENDAR_EVENT_ID, g_param_spec_string ("calendar-event-id", "calendar-event-id", "calendar-event-id", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	   * {@inheritDoc}
	   *
	   * @since 0.6.4
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), TPF_PERSONA_BIRTHDAY, g_param_spec_boxed ("birthday", "birthday", "birthday", G_TYPE_DATE_TIME, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	   * The Persona's presence type.
	   *
	   * See {@link Folks.PresenceDetails.presence_type}.
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), TPF_PERSONA_PRESENCE_TYPE, g_param_spec_enum ("presence-type", "presence-type", "presence-type", FOLKS_TYPE_PRESENCE_TYPE, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	   * The Persona's presence status.
	   *
	   * See {@link Folks.PresenceDetails.presence_status}.
	   *
	   * @since 0.6.0
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), TPF_PERSONA_PRESENCE_STATUS, g_param_spec_string ("presence-status", "presence-status", "presence-status", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	   * The Persona's presence message.
	   *
	   * See {@link Folks.PresenceDetails.presence_message}.
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), TPF_PERSONA_PRESENCE_MESSAGE, g_param_spec_string ("presence-message", "presence-message", "presence-message", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	   * The Persona's client types.
	   *
	   * See {@link Folks.PresenceDetails.client_types}.
	   *
	   * @since 0.9.5
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), TPF_PERSONA_CLIENT_TYPES, g_param_spec_boxed ("client-types", "client-types", "client-types", G_TYPE_STRV, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	   * The names of the Persona's linkable properties.
	   *
	   * See {@link Folks.Persona.linkable_properties}.
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), TPF_PERSONA_LINKABLE_PROPERTIES, g_param_spec_boxed ("linkable-properties", "linkable-properties", "linkable-properties", G_TYPE_STRV, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	   * {@inheritDoc}
	   *
	   * @since 0.6.0
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), TPF_PERSONA_WRITEABLE_PROPERTIES, g_param_spec_boxed ("writeable-properties", "writeable-properties", "writeable-properties", G_TYPE_STRV, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	   * An alias for the Persona.
	   *
	   * See {@link Folks.AliasDetails.alias}.
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), TPF_PERSONA_ALIAS, g_param_spec_string ("alias", "alias", "alias", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	   * Whether this Persona is a user-defined favourite.
	   *
	   * See {@link Folks.FavouriteDetails.is_favourite}.
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), TPF_PERSONA_IS_FAVOURITE, g_param_spec_boolean ("is-favourite", "is-favourite", "is-favourite", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	   * {@inheritDoc}
	   *
	   * @since 0.6.4
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), TPF_PERSONA_EMAIL_ADDRESSES, g_param_spec_object ("email-addresses", "email-addresses", "email-addresses", GEE_TYPE_SET, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	   * A mapping of IM protocol to an (unordered) set of IM addresses.
	   *
	   * See {@link Folks.ImDetails.im_addresses}.
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), TPF_PERSONA_IM_ADDRESSES, g_param_spec_object ("im-addresses", "im-addresses", "im-addresses", GEE_TYPE_MULTI_MAP, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	   * A counter for IM interactions (send/receive message) with the persona.
	   *
	   * See {@link Folks.InteractionDetails.im_interaction_count}
	   *
	   * @since 0.7.1
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), TPF_PERSONA_IM_INTERACTION_COUNT, g_param_spec_uint ("im-interaction-count", "im-interaction-count", "im-interaction-count", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	   * The latest datetime for IM interactions (send/receive message) with the
	   * persona.
	   *
	   * See {@link Folks.InteractionDetails.last_im_interaction_datetime}
	   *
	   * @since 0.7.1
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), TPF_PERSONA_LAST_IM_INTERACTION_DATETIME, g_param_spec_boxed ("last-im-interaction-datetime", "last-im-interaction-datetime", "last-im-interaction-datetime", G_TYPE_DATE_TIME, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	   * A counter for call interactions (only successful calls) with the persona.
	   *
	   * See {@link Folks.InteractionDetails.call_interaction_count}
	   *
	   * @since 0.7.1
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), TPF_PERSONA_CALL_INTERACTION_COUNT, g_param_spec_uint ("call-interaction-count", "call-interaction-count", "call-interaction-count", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	   * The latest datetime for call interactions (only successful calls) with the
	   * persona.
	   *
	   * See {@link Folks.InteractionDetails.last_call_interaction_datetime}
	   *
	   * @since 0.7.1
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), TPF_PERSONA_LAST_CALL_INTERACTION_DATETIME, g_param_spec_boxed ("last-call-interaction-datetime", "last-call-interaction-datetime", "last-call-interaction-datetime", G_TYPE_DATE_TIME, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	   * A set group IDs for the groups the contact is a member of.
	   *
	   * See {@link Folks.GroupDetails.groups}.
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), TPF_PERSONA_GROUPS, g_param_spec_object ("groups", "groups", "groups", GEE_TYPE_SET, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	   * The Telepathy contact represented by this persona.
	   *
	   * Note that this may be ``null`` if the {@link PersonaStore} providing this
	   * {@link Persona} isn't currently available (e.g. due to not being connected
	   * to the network). In this case, most other properties of the {@link Persona}
	   * are being retrieved from a cache and may not be current (though there's no
	   * way to tell this).
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), TPF_PERSONA_CONTACT, g_param_spec_object ("contact", "contact", "contact", tp_contact_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	/**
	   * {@inheritDoc}
	   *
	   * @since 0.6.4
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), TPF_PERSONA_PHONE_NUMBERS, g_param_spec_object ("phone-numbers", "phone-numbers", "phone-numbers", GEE_TYPE_SET, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	   * {@inheritDoc}
	   *
	   * @since 0.6.4
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), TPF_PERSONA_URLS, g_param_spec_object ("urls", "urls", "urls", GEE_TYPE_SET, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void tpf_persona_folks_alias_details_interface_init (FolksAliasDetailsIface * iface) {
	tpf_persona_folks_alias_details_parent_iface = g_type_interface_peek_parent (iface);
	iface->change_alias = (void (*)(FolksAliasDetails*, const gchar*, GError**)) tpf_persona_real_change_alias;
	iface->change_alias_finish = tpf_persona_real_change_alias_finish;
	iface->get_alias = tpf_persona_real_get_alias;
	iface->set_alias = tpf_persona_real_set_alias;
}


static void tpf_persona_folks_avatar_details_interface_init (FolksAvatarDetailsIface * iface) {
	tpf_persona_folks_avatar_details_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_avatar = tpf_persona_real_get_avatar;
	iface->set_avatar = tpf_persona_real_set_avatar;
}


static void tpf_persona_folks_birthday_details_interface_init (FolksBirthdayDetailsIface * iface) {
	tpf_persona_folks_birthday_details_parent_iface = g_type_interface_peek_parent (iface);
	iface->change_birthday = (void (*)(FolksBirthdayDetails*, GDateTime*, GError**)) tpf_persona_real_change_birthday;
	iface->change_birthday_finish = tpf_persona_real_change_birthday_finish;
	iface->get_calendar_event_id = tpf_persona_real_get_calendar_event_id;
	iface->set_calendar_event_id = tpf_persona_real_set_calendar_event_id;
	iface->get_birthday = tpf_persona_real_get_birthday;
	iface->set_birthday = tpf_persona_real_set_birthday;
}


static void tpf_persona_folks_email_details_interface_init (FolksEmailDetailsIface * iface) {
	tpf_persona_folks_email_details_parent_iface = g_type_interface_peek_parent (iface);
	iface->change_email_addresses = (void (*)(FolksEmailDetails*, GeeSet*, GError**)) tpf_persona_real_change_email_addresses;
	iface->change_email_addresses_finish = tpf_persona_real_change_email_addresses_finish;
	iface->get_email_addresses = tpf_persona_real_get_email_addresses;
	iface->set_email_addresses = tpf_persona_real_set_email_addresses;
}


static void tpf_persona_folks_favourite_details_interface_init (FolksFavouriteDetailsIface * iface) {
	tpf_persona_folks_favourite_details_parent_iface = g_type_interface_peek_parent (iface);
	iface->change_is_favourite = (void (*)(FolksFavouriteDetails*, gboolean, GError**)) tpf_persona_real_change_is_favourite;
	iface->change_is_favourite_finish = tpf_persona_real_change_is_favourite_finish;
	iface->get_is_favourite = tpf_persona_real_get_is_favourite;
	iface->set_is_favourite = tpf_persona_real_set_is_favourite;
}


static void tpf_persona_folks_group_details_interface_init (FolksGroupDetailsIface * iface) {
	tpf_persona_folks_group_details_parent_iface = g_type_interface_peek_parent (iface);
	iface->change_group = (void (*)(FolksGroupDetails*, const gchar*, gboolean, GError**)) tpf_persona_real_change_group;
	iface->change_group_finish = tpf_persona_real_change_group_finish;
	iface->change_groups = (void (*)(FolksGroupDetails*, GeeSet*, GError**)) tpf_persona_real_change_groups;
	iface->change_groups_finish = tpf_persona_real_change_groups_finish;
	iface->get_groups = tpf_persona_real_get_groups;
	iface->set_groups = tpf_persona_real_set_groups;
}


static void tpf_persona_folks_interaction_details_interface_init (FolksInteractionDetailsIface * iface) {
	tpf_persona_folks_interaction_details_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_im_interaction_count = tpf_persona_real_get_im_interaction_count;
	iface->get_last_im_interaction_datetime = tpf_persona_real_get_last_im_interaction_datetime;
	iface->get_call_interaction_count = tpf_persona_real_get_call_interaction_count;
	iface->get_last_call_interaction_datetime = tpf_persona_real_get_last_call_interaction_datetime;
}


static void tpf_persona_folks_im_details_interface_init (FolksImDetailsIface * iface) {
	tpf_persona_folks_im_details_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_im_addresses = tpf_persona_real_get_im_addresses;
	iface->set_im_addresses = tpf_persona_real_set_im_addresses;
}


static void tpf_persona_folks_name_details_interface_init (FolksNameDetailsIface * iface) {
	tpf_persona_folks_name_details_parent_iface = g_type_interface_peek_parent (iface);
	iface->change_full_name = (void (*)(FolksNameDetails*, const gchar*, GError**)) tpf_persona_real_change_full_name;
	iface->change_full_name_finish = tpf_persona_real_change_full_name_finish;
	iface->get_structured_name = tpf_persona_real_get_structured_name;
	iface->set_structured_name = tpf_persona_real_set_structured_name;
	iface->get_full_name = tpf_persona_real_get_full_name;
	iface->set_full_name = tpf_persona_real_set_full_name;
	iface->get_nickname = tpf_persona_real_get_nickname;
	iface->set_nickname = tpf_persona_real_set_nickname;
}


static void tpf_persona_folks_phone_details_interface_init (FolksPhoneDetailsIface * iface) {
	tpf_persona_folks_phone_details_parent_iface = g_type_interface_peek_parent (iface);
	iface->change_phone_numbers = (void (*)(FolksPhoneDetails*, GeeSet*, GError**)) tpf_persona_real_change_phone_numbers;
	iface->change_phone_numbers_finish = tpf_persona_real_change_phone_numbers_finish;
	iface->get_phone_numbers = tpf_persona_real_get_phone_numbers;
	iface->set_phone_numbers = tpf_persona_real_set_phone_numbers;
}


static void tpf_persona_folks_presence_details_interface_init (FolksPresenceDetailsIface * iface) {
	tpf_persona_folks_presence_details_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_presence_type = tpf_persona_real_get_presence_type;
	iface->set_presence_type = tpf_persona_real_set_presence_type;
	iface->get_presence_status = tpf_persona_real_get_presence_status;
	iface->set_presence_status = tpf_persona_real_set_presence_status;
	iface->get_presence_message = tpf_persona_real_get_presence_message;
	iface->set_presence_message = tpf_persona_real_set_presence_message;
	iface->get_client_types = tpf_persona_real_get_client_types;
	iface->set_client_types = tpf_persona_real_set_client_types;
}


static void tpf_persona_folks_url_details_interface_init (FolksUrlDetailsIface * iface) {
	tpf_persona_folks_url_details_parent_iface = g_type_interface_peek_parent (iface);
	iface->change_urls = (void (*)(FolksUrlDetails*, GeeSet*, GError**)) tpf_persona_real_change_urls;
	iface->change_urls_finish = tpf_persona_real_change_urls_finish;
	iface->get_urls = tpf_persona_real_get_urls;
	iface->set_urls = tpf_persona_real_set_urls;
}


static void tpf_persona_instance_init (TpfPersona * self) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	GeeHashMultiMap* _tmp2_ = NULL;
	FolksSmallSet* _tmp3_ = NULL;
	self->priv = TPF_PERSONA_GET_PRIVATE (self);
	self->priv->_writeable_properties = NULL;
	self->priv->_writeable_properties_length1 = 0;
	self->priv->__writeable_properties_size_ = self->priv->_writeable_properties_length1;
	self->priv->_is_constructed = FALSE;
	self->priv->_avatar = NULL;
	_tmp0_ = g_strdup ("");
	self->priv->_full_name = _tmp0_;
	self->priv->_birthday = NULL;
	_tmp1_ = g_strdup ("");
	self->priv->_alias = _tmp1_;
	self->priv->_is_favourite = FALSE;
	self->priv->_email_addresses = NULL;
	self->priv->_email_addresses_ro = NULL;
	_tmp2_ = gee_hash_multi_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, FOLKS_TYPE_IM_FIELD_DETAILS, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, _folks_abstract_field_details_hash_static_gee_hash_data_func, NULL, NULL, _folks_abstract_field_details_equal_static_gee_equal_data_func, NULL, NULL);
	self->priv->_im_addresses = _tmp2_;
	self->priv->_im_interaction_count = (guint) 0;
	self->_last_im_interaction_datetime = NULL;
	self->priv->_call_interaction_count = (guint) 0;
	self->_last_call_interaction_datetime = NULL;
	_tmp3_ = folks_small_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL, NULL, NULL, NULL);
	self->priv->_groups = _tmp3_;
	self->priv->_phone_numbers = NULL;
	self->priv->_phone_numbers_ro = NULL;
	self->priv->_urls = NULL;
	self->priv->_urls_ro = NULL;
}


static void tpf_persona_finalize (GObject* obj) {
	TpfPersona * self;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TPF_TYPE_PERSONA, TpfPersona);
	_tmp0_ = folks_persona_get_uid ((FolksPersona*) self);
	_tmp1_ = _tmp0_;
	g_debug ("tpf-persona.vala:1251: Destroying Tpf.Persona '%s': %p", _tmp1_, self);
	self->priv->_writeable_properties = (_vala_array_free (self->priv->_writeable_properties, self->priv->_writeable_properties_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (self->priv->_avatar);
	_g_free0 (self->priv->_full_name);
	_g_date_time_unref0 (self->priv->_birthday);
	_g_free0 (self->priv->_presence_status);
	_g_free0 (self->priv->_presence_message);
	self->priv->_client_types = (_vala_array_free (self->priv->_client_types, self->priv->_client_types_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (self->priv->_alias);
	_g_object_unref0 (self->priv->_email_addresses);
	_g_object_unref0 (self->priv->_email_addresses_ro);
	_g_object_unref0 (self->priv->_im_addresses);
	_g_date_time_unref0 (self->_last_im_interaction_datetime);
	_g_date_time_unref0 (self->_last_call_interaction_datetime);
	_g_object_unref0 (self->priv->_groups);
	_g_object_unref0 (self->priv->_groups_ro);
	_g_object_unref0 (self->priv->_phone_numbers);
	_g_object_unref0 (self->priv->_phone_numbers_ro);
	_g_object_unref0 (self->priv->_urls);
	_g_object_unref0 (self->priv->_urls_ro);
	G_OBJECT_CLASS (tpf_persona_parent_class)->finalize (obj);
}


/**
 * A persona subclass which represents a single instant messaging contact from
 * Telepathy.
 *
 * There is a one-to-one correspondence between {@link Tpf.Persona}s and
 * {@link TelepathyGLib.Contact}s, although at any time the
 * {@link Tpf.Persona.contact} property of a persona may be ``null`` if the
 * contact's Telepathy connection isn't available (e.g. due to being offline).
 * In this case, the persona's properties persist from a local cache.
 */
GType tpf_persona_get_type (void) {
	static volatile gsize tpf_persona_type_id__volatile = 0;
	if (g_once_init_enter (&tpf_persona_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TpfPersonaClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tpf_persona_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TpfPersona), 0, (GInstanceInitFunc) tpf_persona_instance_init, NULL };
		static const GInterfaceInfo folks_alias_details_info = { (GInterfaceInitFunc) tpf_persona_folks_alias_details_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo folks_avatar_details_info = { (GInterfaceInitFunc) tpf_persona_folks_avatar_details_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo folks_birthday_details_info = { (GInterfaceInitFunc) tpf_persona_folks_birthday_details_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo folks_email_details_info = { (GInterfaceInitFunc) tpf_persona_folks_email_details_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo folks_favourite_details_info = { (GInterfaceInitFunc) tpf_persona_folks_favourite_details_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo folks_group_details_info = { (GInterfaceInitFunc) tpf_persona_folks_group_details_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo folks_interaction_details_info = { (GInterfaceInitFunc) tpf_persona_folks_interaction_details_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo folks_im_details_info = { (GInterfaceInitFunc) tpf_persona_folks_im_details_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo folks_name_details_info = { (GInterfaceInitFunc) tpf_persona_folks_name_details_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo folks_phone_details_info = { (GInterfaceInitFunc) tpf_persona_folks_phone_details_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo folks_presence_details_info = { (GInterfaceInitFunc) tpf_persona_folks_presence_details_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo folks_url_details_info = { (GInterfaceInitFunc) tpf_persona_folks_url_details_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType tpf_persona_type_id;
		tpf_persona_type_id = g_type_register_static (FOLKS_TYPE_PERSONA, "TpfPersona", &g_define_type_info, 0);
		g_type_add_interface_static (tpf_persona_type_id, FOLKS_TYPE_ALIAS_DETAILS, &folks_alias_details_info);
		g_type_add_interface_static (tpf_persona_type_id, FOLKS_TYPE_AVATAR_DETAILS, &folks_avatar_details_info);
		g_type_add_interface_static (tpf_persona_type_id, FOLKS_TYPE_BIRTHDAY_DETAILS, &folks_birthday_details_info);
		g_type_add_interface_static (tpf_persona_type_id, FOLKS_TYPE_EMAIL_DETAILS, &folks_email_details_info);
		g_type_add_interface_static (tpf_persona_type_id, FOLKS_TYPE_FAVOURITE_DETAILS, &folks_favourite_details_info);
		g_type_add_interface_static (tpf_persona_type_id, FOLKS_TYPE_GROUP_DETAILS, &folks_group_details_info);
		g_type_add_interface_static (tpf_persona_type_id, FOLKS_TYPE_INTERACTION_DETAILS, &folks_interaction_details_info);
		g_type_add_interface_static (tpf_persona_type_id, FOLKS_TYPE_IM_DETAILS, &folks_im_details_info);
		g_type_add_interface_static (tpf_persona_type_id, FOLKS_TYPE_NAME_DETAILS, &folks_name_details_info);
		g_type_add_interface_static (tpf_persona_type_id, FOLKS_TYPE_PHONE_DETAILS, &folks_phone_details_info);
		g_type_add_interface_static (tpf_persona_type_id, FOLKS_TYPE_PRESENCE_DETAILS, &folks_presence_details_info);
		g_type_add_interface_static (tpf_persona_type_id, FOLKS_TYPE_URL_DETAILS, &folks_url_details_info);
		g_once_init_leave (&tpf_persona_type_id__volatile, tpf_persona_type_id);
	}
	return tpf_persona_type_id__volatile;
}


static void _vala_tpf_persona_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	TpfPersona * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TPF_TYPE_PERSONA, TpfPersona);
	switch (property_id) {
		case TPF_PERSONA_IS_IN_CONTACT_LIST:
		g_value_set_boolean (value, tpf_persona_get_is_in_contact_list (self));
		break;
		case TPF_PERSONA_AVATAR:
		g_value_set_object (value, folks_avatar_details_get_avatar ((FolksAvatarDetails*) self));
		break;
		case TPF_PERSONA_STRUCTURED_NAME:
		g_value_set_object (value, folks_name_details_get_structured_name ((FolksNameDetails*) self));
		break;
		case TPF_PERSONA_FULL_NAME:
		g_value_set_string (value, folks_name_details_get_full_name ((FolksNameDetails*) self));
		break;
		case TPF_PERSONA_NICKNAME:
		g_value_set_string (value, folks_name_details_get_nickname ((FolksNameDetails*) self));
		break;
		case TPF_PERSONA_CALENDAR_EVENT_ID:
		g_value_set_string (value, folks_birthday_details_get_calendar_event_id ((FolksBirthdayDetails*) self));
		break;
		case TPF_PERSONA_BIRTHDAY:
		g_value_set_boxed (value, folks_birthday_details_get_birthday ((FolksBirthdayDetails*) self));
		break;
		case TPF_PERSONA_PRESENCE_TYPE:
		g_value_set_enum (value, folks_presence_details_get_presence_type ((FolksPresenceDetails*) self));
		break;
		case TPF_PERSONA_PRESENCE_STATUS:
		g_value_set_string (value, folks_presence_details_get_presence_status ((FolksPresenceDetails*) self));
		break;
		case TPF_PERSONA_PRESENCE_MESSAGE:
		g_value_set_string (value, folks_presence_details_get_presence_message ((FolksPresenceDetails*) self));
		break;
		case TPF_PERSONA_CLIENT_TYPES:
		{
			int length;
			g_value_set_boxed (value, folks_presence_details_get_client_types ((FolksPresenceDetails*) self, &length));
		}
		break;
		case TPF_PERSONA_LINKABLE_PROPERTIES:
		{
			int length;
			g_value_set_boxed (value, folks_persona_get_linkable_properties ((FolksPersona*) self, &length));
		}
		break;
		case TPF_PERSONA_WRITEABLE_PROPERTIES:
		{
			int length;
			g_value_set_boxed (value, folks_persona_get_writeable_properties ((FolksPersona*) self, &length));
		}
		break;
		case TPF_PERSONA_ALIAS:
		g_value_set_string (value, folks_alias_details_get_alias ((FolksAliasDetails*) self));
		break;
		case TPF_PERSONA_IS_FAVOURITE:
		g_value_set_boolean (value, folks_favourite_details_get_is_favourite ((FolksFavouriteDetails*) self));
		break;
		case TPF_PERSONA_EMAIL_ADDRESSES:
		g_value_set_object (value, folks_email_details_get_email_addresses ((FolksEmailDetails*) self));
		break;
		case TPF_PERSONA_IM_ADDRESSES:
		g_value_set_object (value, folks_im_details_get_im_addresses ((FolksImDetails*) self));
		break;
		case TPF_PERSONA_IM_INTERACTION_COUNT:
		g_value_set_uint (value, folks_interaction_details_get_im_interaction_count ((FolksInteractionDetails*) self));
		break;
		case TPF_PERSONA_LAST_IM_INTERACTION_DATETIME:
		g_value_set_boxed (value, folks_interaction_details_get_last_im_interaction_datetime ((FolksInteractionDetails*) self));
		break;
		case TPF_PERSONA_CALL_INTERACTION_COUNT:
		g_value_set_uint (value, folks_interaction_details_get_call_interaction_count ((FolksInteractionDetails*) self));
		break;
		case TPF_PERSONA_LAST_CALL_INTERACTION_DATETIME:
		g_value_set_boxed (value, folks_interaction_details_get_last_call_interaction_datetime ((FolksInteractionDetails*) self));
		break;
		case TPF_PERSONA_GROUPS:
		g_value_set_object (value, folks_group_details_get_groups ((FolksGroupDetails*) self));
		break;
		case TPF_PERSONA_CONTACT:
		g_value_set_object (value, tpf_persona_get_contact (self));
		break;
		case TPF_PERSONA_PHONE_NUMBERS:
		g_value_set_object (value, folks_phone_details_get_phone_numbers ((FolksPhoneDetails*) self));
		break;
		case TPF_PERSONA_URLS:
		g_value_set_object (value, folks_url_details_get_urls ((FolksUrlDetails*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_tpf_persona_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	TpfPersona * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TPF_TYPE_PERSONA, TpfPersona);
	switch (property_id) {
		case TPF_PERSONA_IS_IN_CONTACT_LIST:
		tpf_persona_set_is_in_contact_list (self, g_value_get_boolean (value));
		break;
		case TPF_PERSONA_AVATAR:
		folks_avatar_details_set_avatar ((FolksAvatarDetails*) self, g_value_get_object (value));
		break;
		case TPF_PERSONA_STRUCTURED_NAME:
		folks_name_details_set_structured_name ((FolksNameDetails*) self, g_value_get_object (value));
		break;
		case TPF_PERSONA_FULL_NAME:
		folks_name_details_set_full_name ((FolksNameDetails*) self, g_value_get_string (value));
		break;
		case TPF_PERSONA_NICKNAME:
		folks_name_details_set_nickname ((FolksNameDetails*) self, g_value_get_string (value));
		break;
		case TPF_PERSONA_CALENDAR_EVENT_ID:
		folks_birthday_details_set_calendar_event_id ((FolksBirthdayDetails*) self, g_value_get_string (value));
		break;
		case TPF_PERSONA_BIRTHDAY:
		folks_birthday_details_set_birthday ((FolksBirthdayDetails*) self, g_value_get_boxed (value));
		break;
		case TPF_PERSONA_PRESENCE_TYPE:
		folks_presence_details_set_presence_type ((FolksPresenceDetails*) self, g_value_get_enum (value));
		break;
		case TPF_PERSONA_PRESENCE_STATUS:
		folks_presence_details_set_presence_status ((FolksPresenceDetails*) self, g_value_get_string (value));
		break;
		case TPF_PERSONA_PRESENCE_MESSAGE:
		folks_presence_details_set_presence_message ((FolksPresenceDetails*) self, g_value_get_string (value));
		break;
		case TPF_PERSONA_CLIENT_TYPES:
		{
			gpointer boxed;
			boxed = g_value_get_boxed (value);
			folks_presence_details_set_client_types ((FolksPresenceDetails*) self, boxed, (boxed == NULL) ? 0 : g_strv_length (boxed));
		}
		break;
		case TPF_PERSONA_ALIAS:
		folks_alias_details_set_alias ((FolksAliasDetails*) self, g_value_get_string (value));
		break;
		case TPF_PERSONA_IS_FAVOURITE:
		folks_favourite_details_set_is_favourite ((FolksFavouriteDetails*) self, g_value_get_boolean (value));
		break;
		case TPF_PERSONA_EMAIL_ADDRESSES:
		folks_email_details_set_email_addresses ((FolksEmailDetails*) self, g_value_get_object (value));
		break;
		case TPF_PERSONA_IM_ADDRESSES:
		folks_im_details_set_im_addresses ((FolksImDetails*) self, g_value_get_object (value));
		break;
		case TPF_PERSONA_GROUPS:
		folks_group_details_set_groups ((FolksGroupDetails*) self, g_value_get_object (value));
		break;
		case TPF_PERSONA_CONTACT:
		tpf_persona_set_contact (self, g_value_get_object (value));
		break;
		case TPF_PERSONA_PHONE_NUMBERS:
		folks_phone_details_set_phone_numbers ((FolksPhoneDetails*) self, g_value_get_object (value));
		break;
		case TPF_PERSONA_URLS:
		folks_url_details_set_urls ((FolksUrlDetails*) self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



