/*
  utils.h - Some useful things
   
  (c) 1999 Robert Cheramy <tibob@via.ecp.fr>
  (c) 2000 Samuel Hocevar <sam@via.ecp.fr>
  (c) 2001 Loc Tortay & IN2P3 Computing Center <tortay@cc.in2p3.fr>

*/

/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef UTILS_H
#define UTILS_H

/* Boolean values */
#define TRUE  1
#define FALSE 0

/* Size of a filename, for strftime() */
#ifndef FILENAME_MAX
#define FILENAME_MAX 4095
#endif

/* Default mode for directories */
#define DEFAULT_DIR_MODE (S_IRUSR | S_IXUSR | S_IWUSR | S_IXGRP | S_IRGRP | S_IXOTH | S_IROTH)

char *timefile(char* filename, time_t when);
int makedirname(char *filename);
int check_pid (char *pidfile);
int read_pid (char *pidfile);
int write_pid (char *pidfile);
int remove_pid (char *pidfile);
void *xmalloc(size_t size);
void xfree(void *p);
char *xstrdup(const char *s1);
#endif
