// Copyright Filippo Rusconi, GPLv3+

/////////////////////// StdLib includes


/////////////////////// Qt includes


/////////////////////// Local includes
#include "colormapplotconfig.h"


namespace pappso
{

ColorMapPlotConfig::ColorMapPlotConfig()
{
}

ColorMapPlotConfig::ColorMapPlotConfig(DataKind x_axis_data_kind,
                                       DataKind y_axis_data_kind,

                                       AxisScale x_axis_scale,
                                       AxisScale y_axis_scale,
                                       AxisScale z_axis_scale,

                                       std::size_t key_cell_count,
                                       std::size_t mz_cell_count,

                                       double min_key_value,
                                       double max_key_value,

                                       double min_mz_value,
                                       double max_mz_value)
  : xAxisDataKind(x_axis_data_kind),
    yAxisDataKind(y_axis_data_kind),

    xAxisScale(x_axis_scale),
    yAxisScale(y_axis_scale),
    zAxisScale(z_axis_scale),

    keyCellCount(key_cell_count),
    mzCellCount(mz_cell_count),

    minKeyValue(min_key_value),
    maxKeyValue(max_key_value),

    minMzValue(min_mz_value),
    maxMzValue(max_mz_value)
{
}


QString
ColorMapPlotConfig::toString() const
{
  QString text = QString("xAxisDataKind: %1 - yAxisDataKind: %2")
                   .arg(static_cast<int>(xAxisDataKind))
                   .arg(static_cast<int>(yAxisDataKind));

  text += QString("xAxisScale: %1 - yAxisScale: %2 - zAxisScale: %3 - ")
            .arg(static_cast<int>(xAxisScale))
            .arg(static_cast<int>(yAxisScale))
            .arg(static_cast<int>(zAxisScale));

  text += QString("keyCellCount: %1 - mzCellCount: %2 - ")
            .arg(mzCellCount)
            .arg(minKeyValue);

  text +=
    QString(
      "minKeyValue: %8 - maxKeyValue: %9 - minMzValue: %10 - maxMzValue: %11")
      .arg(keyCellCount)
      .arg(maxKeyValue)
      .arg(minMzValue)
      .arg(maxMzValue);

  return text;
}

} // namespace pappso
