// Copyright (c) 2012 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef PPAPI_HOST_HOST_FACTORY_H_
#define PPAPI_HOST_HOST_FACTORY_H_

#include "base/memory/scoped_ptr.h"
#include "ppapi/c/pp_instance.h"
#include "ppapi/c/pp_resource.h"

namespace IPC {
class Message;
}

namespace ppapi {

namespace proxy {
class ResourceMessageCallParams;
}

namespace host {

class PpapiHost;
class ResourceHost;

// A host factory creates ResourceHosts for incoming create messages from
// the plugin. This allows us to implement the hosts at the chrome/content
// layer without the ppapi layer knowing about the details.
class HostFactory {
 public:
  virtual ~HostFactory() {}

  virtual scoped_ptr<ResourceHost> CreateResourceHost(
      PpapiHost* host,
      PP_Resource resource,
      PP_Instance instance,
      const IPC::Message& message) = 0;
};

}  // namespace host
}  // namespace ppapi

#endif  // PPAPI_HOST_HOST_FACTORY_H_
