% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/credential.R
\name{ssh_path}
\alias{ssh_path}
\title{Compose usual path to ssh keys}
\usage{
ssh_path(file = "")
}
\arguments{
\item{file}{basename of file for which path is requested}
}
\value{
Full path to the file
}
\description{
This function provides a consistent means across OS-types to access the
\code{.ssh} directory.
}
\details{
On Windows-based systems, 
\code{path.expand("~")} returns \code{"C:/Users/username/Documents"}, 
whereas the usual path to the \code{.ssh} directory is 
\code{"C:/Users/username"}.

On other operating systems, \code{path.expand("~")} returns the usual path
to the \code{.ssh} directory.

Calling \code{ssh_path()} with no arguments will return the usual path to
the \code{.ssh} directory.
}
\examples{
ssh_path()
ssh_path("is_rsa.pub")
}
