/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.terrain.roam;

import java.awt.Rectangle;
import org.j3d.terrain.roam.ROAMPatch;

class PatchGrid {
    private int numNorth;
    private int numEast;
    private int northOffset;
    private int eastOffset;
    private ROAMPatch[][] grid;

    PatchGrid(Rectangle rectangle) {
        this.grid = new ROAMPatch[rectangle.width][rectangle.height];
        this.numEast = rectangle.width;
        this.numNorth = rectangle.height;
        this.eastOffset = rectangle.x;
        this.northOffset = rectangle.y;
    }

    void prepareNewBounds(Rectangle rectangle) {
        int n;
        int n2;
        int n3;
        ROAMPatch[][] rOAMPatchArrayArray;
        if (rectangle.width > this.grid.length) {
            rOAMPatchArrayArray = new ROAMPatch[rectangle.width][];
            for (n3 = 0; n3 < this.grid.length; ++n3) {
                rOAMPatchArrayArray[n3] = this.grid[n3];
            }
            n2 = this.grid[0].length;
            while (n3 < rectangle.width) {
                rOAMPatchArrayArray[n3] = new ROAMPatch[n2];
                ++n3;
            }
        } else if (rectangle.width < this.numEast) {
            for (n3 = rectangle.width; n3 < this.numEast; ++n3) {
                for (n = 0; n < this.numNorth; ++n) {
                    this.grid[n3][n] = null;
                }
            }
        }
        if (rectangle.height > this.grid[0].length) {
            for (n3 = 0; n3 < this.numEast; ++n3) {
                rOAMPatchArrayArray = new ROAMPatch[rectangle.height];
                System.arraycopy(this.grid[n3], 0, rOAMPatchArrayArray, 0, this.numNorth);
                this.grid[n3] = rOAMPatchArrayArray;
            }
            while (n3 < this.grid.length) {
                this.grid[n3] = new ROAMPatch[rectangle.height];
                ++n3;
            }
        } else if (rectangle.height < this.numNorth) {
            for (n3 = 0; n3 < this.numEast; ++n3) {
                for (n = rectangle.height; n < this.numNorth; ++n) {
                    this.grid[n3][n] = null;
                }
            }
        }
        if (rectangle.y > this.northOffset) {
            int n4 = rectangle.y - this.northOffset;
            n2 = rectangle.height - n4;
            for (n3 = 0; n3 < rectangle.width; ++n3) {
                System.arraycopy(this.grid[n3], n4, this.grid[n3], 0, n2);
                for (n = n4; n < this.numNorth; ++n) {
                    this.grid[n3][n] = null;
                }
            }
        } else if (rectangle.y < this.northOffset) {
            int n5 = this.northOffset - rectangle.y;
            n2 = rectangle.height - n5;
            for (n3 = 0; n3 < rectangle.width; ++n3) {
                System.arraycopy(this.grid[n3], 0, this.grid[n3], n5, n2);
                for (n = 0; n < n5; ++n) {
                    this.grid[n3][n] = null;
                }
            }
        }
        if (rectangle.x > this.eastOffset) {
            int n6 = rectangle.x - this.eastOffset;
            n2 = rectangle.height - n6;
            for (n3 = 0; n3 < n6; ++n3) {
                System.arraycopy(this.grid[n3], 0, this.grid[n3 + 1], 0, this.numNorth);
            }
            while (n3 < rectangle.width) {
                for (n = 0; n < rectangle.height; ++n) {
                    this.grid[n3][n] = null;
                }
                ++n3;
            }
        } else if (rectangle.x < this.eastOffset) {
            int n7 = this.eastOffset - rectangle.x;
            n2 = rectangle.height - n7;
            for (n3 = n7; n3 <= rectangle.width - n7; ++n3) {
                System.arraycopy(this.grid[n3 - 1], 0, this.grid[n3], 0, this.numNorth);
            }
            for (n3 = 0; n3 < n7; ++n3) {
                for (n = 0; n < rectangle.height; ++n) {
                    this.grid[n3][n] = null;
                }
            }
        }
        this.numEast = rectangle.width;
        this.numNorth = rectangle.height;
        this.eastOffset = rectangle.x;
        this.northOffset = rectangle.y;
    }

    void addPatch(ROAMPatch rOAMPatch, int n, int n2) {
        ROAMPatch rOAMPatch2;
        int n3 = n - this.eastOffset;
        int n4 = n2 - this.northOffset;
        this.grid[n3][n4] = rOAMPatch;
        if (n3 != 0) {
            rOAMPatch2 = this.grid[n3 - 1][n4];
            rOAMPatch.setWestNeighbour(rOAMPatch2);
            if (rOAMPatch2 != null) {
                rOAMPatch2.setEastNeighbour(rOAMPatch);
            }
        }
        if (n3 < this.numEast - 1) {
            rOAMPatch2 = this.grid[n3 + 1][n4];
            if (rOAMPatch2 != null) {
                rOAMPatch2.setWestNeighbour(rOAMPatch);
            }
            rOAMPatch.setEastNeighbour(rOAMPatch2);
        }
        if (n4 != 0) {
            rOAMPatch2 = this.grid[n3][n4 - 1];
            rOAMPatch.setSouthNeighbour(rOAMPatch2);
            if (rOAMPatch2 != null) {
                rOAMPatch2.setNorthNeighbour(rOAMPatch);
            }
        }
        if (n4 < this.numNorth - 1) {
            rOAMPatch2 = this.grid[n3][n4 + 1];
            if (rOAMPatch2 != null) {
                rOAMPatch2.setSouthNeighbour(rOAMPatch);
            }
            rOAMPatch.setNorthNeighbour(rOAMPatch2);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("PatchGrid:\n");
        stringBuffer.append("Size: ");
        stringBuffer.append(this.numEast);
        stringBuffer.append(' ');
        stringBuffer.append(this.numNorth);
        stringBuffer.append("\nOffsets: ");
        stringBuffer.append(this.eastOffset);
        stringBuffer.append(' ');
        stringBuffer.append(this.northOffset);
        for (int i = this.numNorth - 1; i >= 0; --i) {
            stringBuffer.append('\n');
            for (int j = 0; j < this.numEast; ++j) {
                if (this.grid[j][i] == null) {
                    stringBuffer.append('0');
                } else {
                    stringBuffer.append(this.grid[j][i].hashCode());
                }
                stringBuffer.append(' ');
            }
        }
        return stringBuffer.toString();
    }

    public String toRelationsString() {
        StringBuffer stringBuffer = new StringBuffer("PatchGrid Relations:");
        for (int i = this.numNorth - 1; i >= 0; --i) {
            stringBuffer.append('\n');
            for (int j = 0; j < this.numEast; ++j) {
                if (this.grid[j][i] == null) {
                    stringBuffer.append('0');
                } else {
                    stringBuffer.append(this.grid[j][i].toString2());
                }
                stringBuffer.append("  ");
            }
        }
        return stringBuffer.toString();
    }
}

