
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * This program is free software; you can redistribute it and/or       *
 * modify it under the terms of the GNU General Public License as      *
 * published by the Free Software Foundation; either version 2 of the  *
 * License, or (at your option) any later version.                     *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/*
 * mod_auth_inst.c: instant passwort module for dummy users
 *
 * http://www.clifford.at/stuff/mod_auth_inst.c
 *
 * by Clifford Wolf <apache@clifford.at>
 *
 * hint: set your tabsize to 4 to read this code :-)
 *
 * Changelog:
 *
 * 1998-02-02: wrote basic version
 *
 */

/**** demo .htaccess ****

AuthName Cliffords Demo
AuthType basic
AuthInstUser clifford
AuthInstPass secret
require valid-user

************************/


#include "httpd.h"
#include "http_config.h"
#include "http_core.h"
#include "http_log.h"
#include "http_protocol.h"

typedef struct  {
	char *auth_inst_user;
	char *auth_inst_pass;
} inst_auth_config_rec;

static void *inst_auth_crdconf (pool *p, char *d)
{
	inst_auth_config_rec *sec =
		(inst_auth_config_rec *)ap_pcalloc (p, sizeof(inst_auth_config_rec));
	sec->auth_inst_user = NULL;
	sec->auth_inst_pass = NULL;
	return sec;
}

static command_rec inst_auth_cmds[] = {
	{ "AuthInstUser", ap_set_string_slot,
		(void*)XtOffsetOf(inst_auth_config_rec, auth_inst_user),
		OR_AUTHCFG, TAKE1, NULL },
	{ "AuthInstPass", ap_set_string_slot,
		(void*)XtOffsetOf(inst_auth_config_rec, auth_inst_pass),
		OR_AUTHCFG, TAKE1, NULL },
	{ NULL }
};

module inst_auth_module;

static int inst_auth_basic (request_rec *r)
{
	inst_auth_config_rec *sec =
		(inst_auth_config_rec *)ap_get_module_config (r->per_dir_config,
		&inst_auth_module);
	conn_rec *c = r->connection;
	const char *sent_pw;
	int res;
	
	/* Bye, bye if they are smart enought to use another auth-type */
	if(!sec->auth_inst_pass || !sec->auth_inst_user) return DECLINED;
	
	/* Get the clear-text password */
	if ((res = ap_get_basic_auth_pw (r, &sent_pw))) return res;
	
	/* Check for the correct username */
	if (strcmp(c->user,sec->auth_inst_user)) return AUTH_REQUIRED;
	
	/* Check for the correct passowrd */
	if (strcmp(sent_pw,sec->auth_inst_pass)) return AUTH_REQUIRED;
	
	/* Let her/him in */
	return OK;
}

module inst_auth_module = {
	STANDARD_MODULE_STUFF,
	NULL,				/* initializer */
	inst_auth_crdconf,	/* dir config creater */
	NULL,				/* dir merger --- default is to override */
	NULL,				/* server config */
	NULL,				/* merge server config */
	inst_auth_cmds,		/* command table */
	NULL,				/* handlers */
	NULL,				/* filename translation */
	inst_auth_basic,	/* check_user_id */
	NULL,				/* check auth */
	NULL,				/* check access */
	NULL,				/* type_checker */
	NULL,				/* fixups */
	NULL,				/* logger */
	NULL				/* header parser */
};
