//
// bidwatcher
// copyright (c) 1999, 2000, 2001, 2002
// Trent McNair (trent@rmci.net)
// Tom McNair  (tmcnair@cyberhighway.net)
// Wayne Schlitt (wayne@midwestcs.com)
// Ben Byer (bushing@users.sourceforge.net)
// Kevin Dwyer (kevin@pheared.net)
// 
// use of this code is restricted to the terms
// of the GNU GPL, which should have been included in this
// distribution. If not, see www.gnu.org/copyleft/gpl.html.
// Here is the short version:
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//

#include <signal.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <fcntl.h>
#include <unistd.h>
#include <sys/time.h>
#include <time.h>
#include <netinet/in.h>
#include <sys/socket.h>
#include <netdb.h>
#include <gtk/gtk.h>
#include "bidwatcher.h"

bool cancelPressed;
double avg_load_time = INITIAL_LOAD_TIME;

char cookie[512];

void getAdultCookie(char * username, char * password) {
  URL *url=new URL(g_strdup_printf("http://cgi.ebay.com/aw-cgi/eBayISAPI.dll"
				  "?MfcISAPICommand=AdultLogin&userid=%s&"
				  "password=%s", username, password),
		    proxyurl);
    
    char *HtmlBuff;
    fetchURL(url,&HtmlBuff,TIMEOUT);
    char *adultcookie=strstr(HtmlBuff,"Set-Cookie");
    if(adultcookie==NULL) {
      printf("adult cookie not found\n");
      printf(HtmlBuff);
      return;
    }
    int len=strcspn(adultcookie,";");
    adultcookie[len]='\0';
    printf("Adult cookie: %s\n",adultcookie+4); // strip "Set-"
    strcpy(cookie,adultcookie+4);
}

/* necessary because otherwise, all hostents are identical, and overwritten
   every time gethostbyname is called! :( */
struct hostent * copyhostent(struct hostent * in) {
  if(in==NULL) return NULL;
  
  struct hostent * out=(struct hostent *)malloc(sizeof( struct hostent));
  out->h_name=g_strdup(in->h_name);
  int i;
  for(i=0;in->h_aliases[i]!=0;i++);
  out->h_aliases=(char **) malloc(sizeof(char *)*i);
  for(i=0;in->h_aliases[i]!=0;i++) 
    out->h_aliases[i]=g_strdup(in->h_aliases[i]);
  out->h_addrtype=in->h_addrtype;
  out->h_length=in->h_length;
  for(i=0;in->h_addr_list[i]!=0;i++);
  out->h_addr_list=(char **) malloc(sizeof(char *)*i);
  for(i=0;in->h_addr_list[i]!=0;i++) {  // thanks Rodd Snook
    out->h_addr_list[i]=(char*)malloc(sizeof(char)*in->h_length);
    memcpy(out->h_addr_list[i],in->h_addr_list[i],in->h_length);
  }
  return out;
}

URL::URL(char *newurl,URL *proxy) {
  create(newurl,proxy);
}

void URL::create(char *newurl,URL *proxy) {
  if(proxy==NULL) { 
    char *hostoff=strstr(newurl,"://")+3;
    char tmpstr[256];
    strncpy(tmpstr,hostoff,strcspn(hostoff,"/"));
    tmpstr[strcspn(hostoff,"/")]='\0';
    if(strlen(tmpstr)<strlen(newurl)) {
      strcpy(url,hostoff+strlen(tmpstr));
    } else url[0]='\0';
    
    char *portoff=strstr(tmpstr,":");
    if(portoff!=NULL) {
      port=atoi(portoff+1);
      portoff[0]='\0';
    } else port=80;
    hostinfo=copyhostent(gethostbyname(tmpstr));
  } else {
    hostinfo=proxy->hostinfo;
    port=proxy->port;
    strcpy(url,newurl);
  }
}

void CloseSocket(int sockIT)
{
   close(sockIT);
}

int set_nonblock(int fd)
{
    int flags = fcntl(fd, F_GETFL, 0);
    if (flags == -1)
        return -1;
    return fcntl(fd, F_SETFL, flags | O_NONBLOCK);
}

bool checkredir(URL *url, char *buff) {
  if(strstr(buff,"HTTP/1.0 30")!=NULL || strstr(buff,"HTTP/1.1 30")!=NULL) {
    char *loc=strstr(buff,"Location:")+strlen("Location: ");
    loc[strcspn(loc,"\r\n ")]='\0';

    if(strstr(loc,"AdultLoginShow")) {
#ifdef DEBUG_NETWORK
    printf("Getting adult cookie\n");
#endif
    getAdultCookie(authID,authPASS);
    if(strlen(cookie)<5) showError("Could not get adult cookie.");
    } else url->create(loc,proxyurl);
#ifdef DEBUG_NETWORK
    printf("Relocated to %s\n",loc);
#endif
    return TRUE;
  }
  else return FALSE;
}

int fetchURL(URL *url, char **Buff, double timeOut)
{
   int    buffLength,recerr;
   int    socketID;
   char   lineBuff[1024];
   char   htmlBuff[HUGEBUFF];

   struct    sockaddr_in soc_in;
   int	  err;
   fd_set fds;
   struct timeval tm;

   GTimer * time_since_start=g_timer_new();
   g_timer_start(time_since_start);

   htmlBuff[0]='\0';  // clear buffer;

   memset( (char*)&soc_in, 0, sizeof(soc_in) );
   soc_in.sin_family = AF_INET;
   struct hostent * hostinfo;
   hostinfo=url->hostinfo;
   if(hostinfo==NULL) {
     // DNS error
     return NET_NETERROR;
   }
   soc_in.sin_addr=*(struct in_addr*)hostinfo->h_addr;
   soc_in.sin_port = htons(url->port);
   socketID = socket(AF_INET, SOCK_STREAM, 0);
   if (socketID < 0) return NET_NETERROR;

   set_nonblock(socketID);   
   err = connect(socketID, (struct sockaddr *)&soc_in, sizeof (soc_in));

   if ( err < 0 )
   {
       if( errno == EINPROGRESS )
       {
	   FD_ZERO(&fds);
	   FD_SET(socketID,&fds);
	   tm.tv_sec = int(timeOut / 2);
	   tm.tv_usec=0;
	   err = select(socketID+1,NULL,&fds,NULL,&tm);

	   if( err == 0 )
	   {
#ifdef DEBUG_NETWORK
	       fprintf( stderr, "connection timed out\n" );
#endif
	       CloseSocket(socketID);
	       return NET_TIMEOUT;
	   }
       }
       else
       {
#ifdef DEBUG_NETWORK
	   fprintf( stderr,
		    "connection failed immediately:  err=%d  errno=%d (%s)\n",
		    err, errno, strerror( errno ) );
#endif
	   CloseSocket(socketID);
	   return NET_NETERROR;
       }
   }

   // did we connect, or not? 
   err = 0;

   {
       socklen_t arglen = sizeof(int);

       /* this is slightly grotty to avoid problems with SysV, where    */
       /* apparently getsockopt() will fail with an async error, rather */
       /* that return it like it's supposed to.                         */

       if (getsockopt(socketID,SOL_SOCKET,SO_ERROR,(void *)&err,&arglen) < 0)
	   err = errno;
   }
   
   if( err != 0 )
   {
#ifdef DEBUG_NETWORK
       fprintf( stderr,
		"connection failed:  err=%d  errno=%d (%s)\n",
		err, errno, strerror( errno ) );
#endif
       CloseSocket(socketID);
       return NET_NETERROR;
   }

   // send our request for the web page.
   sprintf( lineBuff, "GET %s HTTP/1.0\r\n"
	    "User-Agent: bidwatcher\r\n"
	    "%s\r\n\r\n", url->url, cookie );
   if( send(socketID, lineBuff, strlen(lineBuff), 0 ) < 0 )
     {
#ifdef DEBUG_NETWORK
       fprintf( stderr,
		"could not send URL:  errno=%d (%s)\n",
		errno, strerror( errno ) );
#endif
       CloseSocket(socketID);
       return NET_NETERROR;
   }

   buffLength = 0;

   int counter = 0;
   bool goodcall = TRUE;
   GTimer * time_since_pkt=g_timer_new();
   g_timer_start(time_since_pkt);
   while ( goodcall )
   {
      if ( cancelPressed ) return NET_USERCANCEL;
      if ( counter == 5 )
      {
	  counter = 0;
	  gtk_main_iteration_do(FALSE);
	  if ( g_timer_elapsed(time_since_start,NULL) > timeOut )
	  {
	      CloseSocket(socketID);
	      return NET_TIMEOUT;
	  }

	  if ( g_timer_elapsed(time_since_pkt,NULL) > timeOut/2 )
	  {
	      CloseSocket(socketID);
	      return NET_TIMEOUT;
	  }
      }
      recerr = recv(socketID, lineBuff, 256, 0);
      if ( recerr < 0 )
      {
         if ( errno != EWOULDBLOCK )
         {
	     goodcall = FALSE;
	     break;
         }
         goodcall = TRUE;
	 gtk_main_iteration_do(FALSE);
	 usleep(10000);
	 counter++;
      }
      else if ( recerr == 0 )
	  break;
      else
	{
	  if ( (buffLength + recerr) < HUGEBUFF )
	    {
	      g_timer_reset(time_since_pkt);
	      counter = 0;
	      buffLength = buffLength + recerr;
	      lineBuff[recerr] = '\0';
	      strncat(htmlBuff, lineBuff, recerr);
	      goodcall = TRUE;
	  }
	  else break;
      }
   }
   CloseSocket(socketID);

   if(checkredir(url,htmlBuff)) 
     return fetchURL(url, Buff, timeOut);
   else {
     if ( !goodcall ) return NET_NETERROR; 
     /* make and copy buffer */
     *Buff=(char *)malloc(buffLength+1);
     strncpy(*Buff,htmlBuff,buffLength);
     (*Buff)[buffLength]='\0';
     return NET_SUCCESS; 
   }
} 
