/***************************************************************************
    This file is part of the CheeseTronic Music Tools
    url                  : http://reduz.com.ar/cheesetronic
    copyright            : (C) 2003 by Juan Linietsky
    email                : coding@reduz.com.ar
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
/***************************************************************************
                          property_bridge_view.cpp  -  description
                             -------------------
    begin                : Tue Dec 3 2002
    copyright            : (C) 2002 by Juan Linietsky
    email                : coding@reduz.com.ar
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "property_bridge_view.h"



void Bridge_View_Int::adj_value_changed() {

	if (!bridge) return;
	bridge->set((int)adj.get_value());
}



void Bridge_View_Int::set_bridge(Int_Property_Bridge *p_bridge) {

	bridge=p_bridge;
	if (!bridge) return;
	adj.set_lower(p_bridge->get_min());
	adj.set_upper(p_bridge->get_max());
	adj.set_value(p_bridge->get());
	label.set_text(p_bridge->get_name()+":");
}

Bridge_View_Int::Bridge_View_Int() : adj(0,0,100,1),spin(adj) {

	bridge=NULL;
	pack_start(label,0,0);
	pack_start(separator);
	pack_start(spin,0,0);
	adj.signal_changed().connect(SigC::slot(*this,&Bridge_View_Int::adj_value_changed));
}

/******************************************/

void Bridge_View_Int_Slider::adj_value_changed() {

	if (!bridge) return;
	bridge->set((int)adj.get_value());
}



void Bridge_View_Int_Slider::set_bridge(Int_Property_Bridge *p_bridge) {

	bridge=p_bridge;
	if (!bridge) return;
	adj.set_lower(p_bridge->get_min());
	adj.set_upper(p_bridge->get_max());
	adj.set_value(p_bridge->get());
	label.set_text(p_bridge->get_name()+":");
}

Bridge_View_Int_Slider::Bridge_View_Int_Slider() : adj(0,0,100,1),slider(adj) {

	bridge=NULL;
	pack_start(label,0,0);
	pack_start(slider);
	adj.signal_changed().connect(SigC::slot(*this,&Bridge_View_Int_Slider::adj_value_changed));
}

/******************************************/


void Bridge_View_Bool::value_changed() {

	if (!bridge) return;
	bridge->set(check.get_active());
}

void Bridge_View_Bool::set_bridge(Bool_Property_Bridge *p_bridge) {

	bridge=p_bridge;
	if (!p_bridge) return;
	check.set_active(p_bridge->get());	
	label.set_text(p_bridge->get_name());
}

Bridge_View_Bool::Bridge_View_Bool() {

	bridge=NULL;
	pack_start(label,0,0);
	pack_start(separator);
	pack_start(check,0,0);
	check.set_label("Enabled");
	
	check.signal_clicked().connect(SigC::slot(*this,&Bridge_View_Bool::value_changed));
		
};



/************************************************/



void Bridge_View_String::value_changed() {

	if (!bridge) return;
	bridge->set(entry.get_text());
}
void Bridge_View_String::set_bridge(String_Property_Bridge *p_bridge) {

	bridge=p_bridge;

	if (!bridge) return;

	entry.set_text(bridge->get());

}
Bridge_View_String::Bridge_View_String() {

	bridge=NULL;
	pack_start(label,0,0);
	pack_start(entry);
	entry.signal_changed().connect(SigC::slot(*this,&Bridge_View_String::value_changed));

}
