/*
---------------------------------------------------------------------------
 $Id: log.h,v 1.10 2001/05/30 16:13:53 acormier Exp $
---------------------------------------------------------------------------
Copyright (c) 2001 Viagenie Inc. All rights reserved.

     The contents of this file are subject to the Viagnie
     Public License Version 1.0 (the "License"); you may not
     use this file except in compliance with the License. You
     may obtain a copy of the License at
     http://www.freenet6.net/VPL/

     Software distributed under the License is distributed on
     an "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either
     express or implied. See the License for the specific
     language governing rights and limitations under the
     License.

     The Original Code is _source code of the tunnel server
     protocol-client side_.

     The Initial Developer of the Original Code is Viagnie .

     All Rights Reserved.

     Contributor(s): ______________________________________.

---------------------------------------------------------------------------
*/

#ifndef LOG_H
#define LOG_H

#ifdef LOG_IT
# define ACCESS
#else
# define ACCESS extern
#endif

enum tErrorLevel {
  ELEmergency,
  ELAlert,
  ELCritical,
  ELError,
  ELWarning,
  ELNotice,
  ELInfo,
  ELDebug 
};

ACCESS int  LogInit(char *Identity, char *Filename);
ACCESS void LogClose(void);
ACCESS int  LogPrintf(enum tErrorLevel ErrorLevel, char *FunctionName, char *Format, ...);
ACCESS int vLogPrintf(enum tErrorLevel ErrorLevel, char *FunctionName, char *Format, va_list argp);

#undef ACCESS
#endif

/*----- log.h ----------------------------------------------------------------------------------*/
