/*
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 1, or (at your option)
** any later version.

** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.

** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/*
 * Author : Alexandre Parenteau <aubonbeurre@hotmail.com> --- June 1999
 */

/*
 * InitDlg.cpp : the cvs init dialog
 */

#include "stdafx.h"

#ifdef WIN32
#	include "wincvs.h"
#endif /* WIN32 */

#include "InitDlg.h"
#include "CvsPrefs.h"

#ifdef WIN32
#	include "GetPrefs.h"
#	include "PromptFiles.h"
#	ifdef _DEBUG
#	define new DEBUG_NEW
#	undef THIS_FILE
	static char THIS_FILE[] = __FILE__;
#	endif

/////////////////////////////////////////////////////////////////////////////
// CInit_MAIN dialog


CInit_MAIN::CInit_MAIN()
	: CPropertyPage(CInit_MAIN::IDD)
{
	//{{AFX_DATA_INIT(CInit_MAIN)
	m_forceroot = FALSE;
	m_helpinit = _T("");
	//}}AFX_DATA_INIT
}

CInit_MAIN::CInit_MAIN(bool forceRoot)
	: CPropertyPage(CInit_MAIN::IDD)
{
	m_forceroot = forceRoot;
	m_helpinit = _T("If the CVSROOT (see next tab) is set to ""local"", "
		"the CVSROOT should be a Windows path (i.e. c:\\cvsroot). "
		"If the CVSROOT points on a remote machine, the path should be a Unix path "
		"(i.e. /fscvs/cvsroot : make sure you got the relevant security rights in "
		"order to create such a directory on the remote machine.");
}

void CInit_MAIN::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CInit_MAIN)
	DDX_Check(pDX, IDC_FORCEROOT, m_forceroot);
	DDX_Text(pDX, IDC_HELPINIT, m_helpinit);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CInit_MAIN, CPropertyPage)
	//{{AFX_MSG_MAP(CInit_MAIN)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

IMPLEMENT_DYNCREATE(CInit_MAIN, CPropertyPage)

/////////////////////////////////////////////////////////////////////////////
// CInit_MAIN message handlers
#endif

bool CompatGetInit(bool & forceCvsroot)
{
	bool userHitOK = false;

	forceCvsroot = true;
	
#ifdef WIN32
	CPropertySheet pages("Init settings");
	pages.m_psh.dwFlags |= PSH_NOAPPLYNOW;
	CInit_MAIN page1(forceCvsroot);
	CGetPrefs_CVSROOT page2;
	CGetPrefs_GLOBALS page3;
	pages.AddPage(&page1);
	pages.AddPage(&page2);
	pages.AddPage(&page3);
	if(pages.DoModal() == IDOK)
	{
		forceCvsroot = page1.m_forceroot == TRUE;

		page2.StoreValues();
		page3.StoreValues();
		userHitOK = true;
	}
#endif /* WIN32 */

	if(userHitOK)
	{
		gCvsPrefs.save();
	}
	return userHitOK;
}
