#ifndef __SP_DRAW_CONTEXT_H__
#define __SP_DRAW_CONTEXT_H__

/*
 * Generic drawing context
 *
 * Author:
 *   Lauris Kaplinski <lauris@kaplinski.com>
 *
 * Copyright (C) 2000 Lauris Kaplinski
 * Copyright (C) 2000-2001 Ximian, Inc.
 * Copyright (C) 2002 Lauris Kaplinski
 *
 * Released under GNU GPL
 */

#include <sigc++/sigc++.h>
#include "display/curve.h"
#include "event-context.h"
#include <forward.h>
#include <display/display-forward.h>
#include <libnr/nr-point.h>

/* Freehand context */

#define SP_TYPE_DRAW_CONTEXT (sp_draw_context_get_type())
#define SP_DRAW_CONTEXT(o) (GTK_CHECK_CAST((o), SP_TYPE_DRAW_CONTEXT, SPDrawContext))
#define SP_DRAW_CONTEXT_CLASS(k) (GTK_CHECK_CLASS_CAST((k), SP_TYPE_DRAW_CONTEXT, SPDrawContextClass))
#define SP_IS_DRAW_CONTEXT(o) (GTK_CHECK_TYPE((o), SP_TYPE_DRAW_CONTEXT))
#define SP_IS_DRAW_CONTEXT_CLASS(k) (GTK_CHECK_CLASS_TYPE((k), SP_TYPE_DRAW_CONTEXT))

struct SPDrawAnchor;

struct SPDrawContext : public SPEventContext{
    SPSelection *selection;
    SPCanvasItem *grab;

    guint attach : 1;

    guint32 red_color;
    guint32 blue_color;
    guint32 green_color;

    /* Red */
    SPCanvasItem *red_bpath;
    SPCurve *red_curve;

    /* Blue */
    SPCanvasItem *blue_bpath;
    SPCurve *blue_curve;

    /* Green */
    GSList *green_bpaths;
    SPCurve *green_curve;
    SPDrawAnchor *green_anchor;

    /* White */
    SPItem *white_item;
    GSList *white_curves;
    GSList *white_anchors;

    /* Start anchor */
    SPDrawAnchor *sa;
    /* End anchor */
    SPDrawAnchor *ea;

    sigc::connection sel_changed_connection;
    sigc::connection sel_modified_connection;

    bool red_curve_is_valid;
};

struct SPDrawContextClass : public SPEventContextClass{};

GType sp_draw_context_get_type(void);
SPDrawAnchor *spdc_test_inside(SPDrawContext *dc, NR::Point p);
void spdc_concat_colors_and_flush(SPDrawContext *dc, gboolean forceclosed);
void spdc_endpoint_snap_internal(SPEventContext const *ec, NR::Point &p, NR::Point const o, guint state);


#endif

/*
  Local Variables:
  mode:c++
  c-file-style:"stroustrup"
  c-file-offsets:((innamespace . 0)(inline-open . 0)(case-label . +))
  indent-tabs-mode:nil
  fill-column:99
  End:
*/
// vim: filetype=cpp:expandtab:shiftwidth=4:tabstop=8:softtabstop=4:encoding=utf-8:textwidth=99 :
