//=============================================================================
//
//   File : libkvichannelsjoin.cpp
//   Creation date : Thu Nov 06 2001 12:30:25 CEST by Juanjo Alvarez
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 2001-2005 Juanjo Alvarez
//   Copyright (C) 2001-2005 Szymon Stefanek (pragma at kvirc dot net)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
//=============================================================================
#include "kvi_module.h"

#include "channelsjoinwindow.h"
#include "kvi_window.h"
#include "kvi_frame.h"
#include "kvi_locale.h"
#include "kvi_config.h"

#include <qsplitter.h>

KviChannelsJoinWindow * g_pChannelsWindow = 0;
QRect                   g_rectChannelsJoinGeometry;

/*
 	@doc: channelsjoin.open
	@type:
		command
	@title:
		channelsjoin.open
	@short:
		Opens a window to join channels
	@syntax:
		channelsjoin.open
	@description:
		Shows a dialog that allows the user to enter channels in a visual manner.[br]
		This command is exported by the "channelsjoin" module.
 
*/

static bool channelsjoin_kvs_cmd_open(KviKvsModuleCommandCall * c)
{
	if(!g_pChannelsWindow)g_pChannelsWindow = new KviChannelsJoinWindow(c->window()->frame(),"channelsjoin");

	g_pChannelsWindow->setConsole(c->window()->console());
	
	g_pChannelsWindow->show();
	g_pChannelsWindow->raise();
	g_pChannelsWindow->setFocus();

	return true;


}

static bool channelsjoin_module_init(KviModule * m)
{
	QString fName;
	m->getDefaultConfigFileName(fName);
	KviConfig cfg(fName,KviConfig::Read);

	g_rectChannelsJoinGeometry = cfg.readRectEntry("geometry",QRect(30,30,320,410));
	
	KVSM_REGISTER_SIMPLE_COMMAND(m,"open",channelsjoin_kvs_cmd_open);
	return true;
}

static bool channelsjoin_module_cleanup(KviModule *m)
{
	QString fName;
	m->getDefaultConfigFileName(fName);
	KviConfig cfg(fName,KviConfig::Write);

	cfg.writeEntry("geometry",g_rectChannelsJoinGeometry);
	
	if (g_pChannelsWindow)delete g_pChannelsWindow;
	g_pChannelsWindow = 0;
	return true;
}

static bool channelsjoin_module_can_unload(KviModule *m)
{
	return (!g_pChannelsWindow);
}

KVIRC_MODULE(
	"ChannelsJoin",
	"0.0.3",
	"Copyright (C) 2001-2006 Juan Jos��varez (juanjux@yahoo.es), Alexey (wizard@opendoor.ru)",
	"Window to join channels in a GUI",
	channelsjoin_module_init,
	channelsjoin_module_can_unload,
	0,
	channelsjoin_module_cleanup
)
