/*----------------------------------------------------------------------------

   libtunepimp -- The MusicBrainz tagging library.  
                  Let a thousand taggers bloom!
   
   Copyright (C) Robert Kaye 2003
   
   This file is part of libtunepimp.

   libtunepimp is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   libtunepimp is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with libtunepimp; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

   $Id: analyzer.h,v 1.8 2003/10/07 00:54:28 robert Exp $

----------------------------------------------------------------------------*/
#ifndef __ANALYZER_H__
#define __ANALYZER_H__

#include "thread.h"
#include "semaphore.h"
#include "trm.h"
#include "track.h"

#define ANALYZER_REDO_STRING "<redo>"

class TunePimp;
class FileCache;
class SubmitInfo;
class WatchdogThread;

class Analyzer : public Thread
{
    public:

                 Analyzer(TunePimp       *tunePimp,
                          FileCache      *cache,
                          SubmitInfo     *submit,
                          WatchdogThread *watchdog);
        virtual ~Analyzer(void);

        void     wake(void);
        void     threadMain(void);

        void     setProxy(const string &proxyServer, short proxyPort)
                  {
                       this->proxyServer = proxyServer;
                       this->proxyPort = proxyPort;
                  };
        void     getSupportedExtensions(vector<string> &extList);

    private:

        bool     readMetadata(Track *track);
        void     setError(Track *track, TRMResult retVal);
        void     trimWhitespace(string &field);
        void     parseFileName(const string &fileName, Metadata &data);

        TunePimp             *tunePimp;
        FileCache            *cache;
        bool                  exitThread;
        Semaphore            *sem;
        unsigned              lastWake;
        SubmitInfo           *submitInfo;
        string                proxyServer;
        short                 proxyPort;
        WatchdogThread       *dog;
};

#endif
 
