<?php

	/**************************************************************************\
	* phpGroupWare                                                             *
	* http://www.phpgroupware.org                                              *
	* Written by Phill Zarfos <zarf@home.com>                                  *
	* --------------------------------------------                             *
	*  This program is free software; you can redistribute it and/or modify it *
	*  under the terms of the GNU General Public License as published by the   *
	*  Free Software Foundation; either version 2 of the License, or (at your  *
	*  option) any later version.                                              *
	\**************************************************************************/

	/* $Id: wap.php,v 1.3 2001/05/07 01:02:39 zarf Exp $ */

	// This php script dumps the upcoming appointments to a WAP device.
	// You must pass the login and passwd in the url.  For example:
	// http://localhost/phpgroupware/wap.php?login=demo&passwd=1234

	$phpgw_info['flags'] = array(
		'disable_template_class' => True,
		'login' => True,
		'currentapp' => 'wap',
		'noheader'  => True);

	include('../header.inc.php');

	$sessionid = $phpgw->session->create($login, $passwd);
	$owner = $phpgw_info["user"]["account_id"];

	// Necessary tags to start a WAP page...
	echo_wap_header();

	// The actual WML starts here
	echo "<wml>\n";
	// This is the start of the first "page"
	echo "<card id=\"init\" newcontext=\"true\" title=\"Appointments\">\n";
	echo "<p>";

	// Quit here if the login failed
	if (!$sessionid)
	{
		echo "Login failed</p>\n";
		echo "</card></wml>\n";
		exit;
	}

	// Everything's OK so far...  Try to echo the upcoming appointments.
	$now = time();
	$tomorrow = mktime(0, 0, 0, date("m"), date("d") + 1, date("Y"));
	$nextday = mktime(0, 0, 0, date("m"), date("d") + 2, date("Y"));

	echo_appointments("today", $now, $tomorrow, $owner);

	// The rest of the WAP "card" is static, so just finish it outside PHP
?>
    <a href="#tomorrow">Tomorrow</a><br/>
    <a href="#notdone">Pick Date</a><br/>
    <a href="#address">Address Book</a><br/>
    <a href="#todo">Todo List</a><br/>
    <a href="#about">About</a><br/>
  </p>
</card>

<card id="tomorrow" title="Appointments">
  <do type="prev" label="back">
    <go href="#init"/>
  </do>
  <p>
  <?php echo_appointments("tomorrow", $tomorrow, $nextday, $owner); ?>
  </p>
</card>

<card id="todo" title="Todo List">
  <do type="prev" label="back">
    <go href="#init"/>
  </do>
  <p>
  <?php echo_todo($owner); ?>
  </p>
</card>

<card id="address" title="Address Book">
  <do type="prev" label="back">
    <go href="#init"/>
  </do>
  <p>Not done yet</p>
</card>

<card id="notdone" title="Not Done">
  <do type="prev" label="back">
    <go href="#init"/>
  </do>
  <p>Not done yet</p>
</card>

<card id="about" title="About">
  <do type="prev" label="back">
    <go href="#init"/>
  </do>
  <p>Brought to you by phpGroupWare</p>
</card>
</wml>
