<?php

/**
 * This file contains the core function definitions for phpWebSite.
 *
 * The functions defined here are essential for the phpWebSite
 * system. This file gets included almost all the time, you should be
 * able to use the functions defined here everywhere in the code.
 *
 * @module mainfile
 * @modulegroup core
 * @package phpWebSite
 */

$mainfile = 1;

/**
 * Connects to the database using the parameters from the config file.
 *
 * This function connects to a mySQL database using the mysql_pconnect
 * function call. After successful connection, it selects the given
 * database. The needed parameters are fetched from config.php, which
 * gets included during runtime.
 */
function dbconnect()
{
  /**
   * The global configuration file.
   */
  include("config.php");
  mysql_pconnect($dbhost, $dbuname, $dbpass);
  @mysql_select_db("$dbname") or die (lang("Unable to select database"));
}

//dbconnect();

/**
 * Checks for plugins at given position and displays them.
 *
 * This function is used to check for plugins registered an the
 * plugins table. If a plugin for the given position is found, the
 * plugin code file gets included and the result is displayed using
 * the themeplugin function.
 *
 * @param int plugin block position
 */
function plug_check($position)
{
	global $admintest;
	global $phpgw;
	$phpgw->db->query ("select name, plug_dir, block_file, admin_only, user_only from wcm_plugins where block_pos = $position");

        if ($phpgw->db->num_rows() > 0)
	{
                while ($phpgw->db->next_record())
		{
                        extract($row); // I do not understand this line yet.  Pat.
                        if (($admintest && !$user_only) || (!$admintest && !$admin_only))
			{
			  /**
			   * The plugin code file. Checks to see if plugin actually exists on server.
			   */
				if (file_exists("plug-ins/$plug_dir/$block_file")) {
	                                include ("plug-ins/$plug_dir/$block_file");
                                $box_title = $name;
                                themeplugin($box_title, $box_content);
				}
                        }
                }
        }
}


/**
 * Checks for given plugin name and displays it.
 *
 * This function is used to check for a given plugin name in the
 * plugins table. If a plugin for the given name is found, the
 * plugin code file gets included and the result is displayed using
 * the themeplugin function.
 *
 * @param string plugin name
 */
function plug_get($plug_name)
{
	global $admintest;
	global $phpgw;
	$phpgw->db->query ("select name, plug_dir, block_file, admin_only, user_only from wcm_plugins where plug_dir='$plug_name'");

        if ($phpgw->db->num_rows() > 0)
	{
                while ($phpgw->db->next_record())
		{
                        extract($row); //See above
                        if (($admintest && !$user_only) || (!$admintest && !$admin_only))
			{
			  /**
			   * The plugin code file.
			   */
                                include ("plug-ins/$plug_dir/$block_file");
                                echo $box_content;
                        }
                }
        }
}


/**
 * Outputs the given parameters somehow &quot;formatted&quot;
 *
 * The given parameters are checked for containing html breaks,
 * headings or paragraph tags. If no tags are found, newlines are
 * replaced by html break tags, otherwise the input is used as is.
 *
 * The input is then printed seperated by to html break tags if the
 * following variable is not empty.
 *
 * @param string The title of the part.
 * @param string The lead-in text.
 * @param string The optional main text.
 * @param string The optional notes text.
 */
function themepreview($title, $hometext, $bodytext="", $notes="")
{
	echo "<b>$title</b><br /><br />";

	if (!strstr ($hometext, '<p') && !strstr ($hometext, '<br') && !strstr($hometext, '<h'))
	echo ereg_replace ("\n" , "<br />", $hometext);
	else
	echo "$hometext";

	if (strlen($bodytext))
	echo "<br /><br />";

	if (!strstr ($bodytext, '<p') && !strstr ($bodytext, '<br') && !strstr($bodytext, '<h'))
	echo ereg_replace ("\n" , "<br />", $bodytext);
	else
	echo "$bodytext";

	if (strlen($notes))
	echo "<br /><br />";

	if (!strstr ($notes, '<p') && !strstr ($notes, '<br') && !strstr($notes, '<h'))
	echo ereg_replace ("\n" , "<br />", $notes);
	else
	echo "$notes";
}


/**
 * Writes news headlines to a file for general purpose use
 *
 * The 10 most recent news headlines are fetched from the database and
 * stored in ultramode.txt in the web root. The file contains title,
 * URL, time, aid, text and imagename of each topic.
 */
function ultramode()
{
	global $phpgw;
    $file = fopen("ultramode.txt", "w");
    fwrite($file, lang("General purpose self-explanatory file with news headlines") . "\n");
    $phpgw->db->query("select sid, aid, title, time, comments, topic from wcm_stories order by time DESC limit 0,10");

    while($phpgw->db->next_record())
    {
	$sid=$phpgw->db->f("sid");
	$aid=$phpgw->db->f("aid");
	$title=$phpgw->db->f("title");
	$time=$phpgw->db->f("time");
	$comments=$phpgw->db->f("comments");
	$topic=$phpgw->db->f("topic");
	$phpgw->db->query("select topictext, topicimage from wcm_topics where topicid=$topic");
	$phpgw->db->next_record();
	$topictext=$phpgw->db->f("topictext");
	$topicimage=$phpgw->db->f("topicimage");
	$content = "%%\n$title\n/article.php?sid=$sid\n$time\n$aid\n$topictext\n$comments\n$topicimage\n";
	fwrite($file, $content);
    }
    fclose($file);
}

/**
 * Increments the totalhits counter in the vars table by one.
 */
function counter()
{
	global $phpgw;
	$phpgw->db->query("UPDATE wcm_vars SET value=value+1 where name='totalhits'");
}

/**
 * base64_decodes the given string and returns the contents as an array.
 *
 * The given parameter is decoded using base64_decode and then
 * exploded at : (colon). The resulting array is returned.
 *
 * @param string user settings cookie data
 * @return array decoded user settings
 */
function cookiedecode($user)
{
	global $cookie;
	$user = base64_decode($user);
	$cookie = explode(":", $user);

	return $cookie;
}

function getusrinfo($user)
{
// This function might be totally re-written

	global $userinfo;
	global $phpgw,$phpgw_info;

	$user2 = base64_decode($user);
	$user3 = explode(":", $user2);
	$phpgw->db->query("select uid, name, uname, email, femail, url, pass, storynum, umode, uorder, thold, noscore, bio, ublockon, ublock, theme, commentmax from wcm_users where uname='$user3[1]' and pass='$user3[2]'");

	if($phpgw->db->num_rows()==1) {
		$phpgw->db->next_record();
		$userinfo=array('uid'=>$phpgw->db->f('uid'),
				'name'=>$phpgw->db->f('name'),
				'uname'=>$phpgw->db->f('uname'),
				'email'=>$phpgw->db->f('email'),
				'femail'=>$phpgw->db->f('femail'),
				'url'=>$phpgw->db->f('url'),
				'pass'=>$phpgw->db->f('pass'),
				'storynum'=>$phpgw->db->f('storynum'),
				'umode'=>$phpgw->db->f('umode'),
				'uorder'=>$phpgw->db->f('uorder'),
				'thold'=>$phpgw->db->f('thold'),
				'noscore'=>$phpgw->db->f('noscore'),
				'bio'=>$phpgw->db->f('bio'),
				'ublockon'=>$phpgw->db->f('ublockon'),
				'ublock'=>$phpgw->db->f('ublock'),
				'theme'=>$phpgw->db->f('theme'),
				'commentmax'=>$phpgw->db->f('commentmax') );
//		$userinfo = mysql_fetch_array($result);
	} else
		$userinfo = 0;

	return $userinfo;
}

function FixQuotes ($what = "")
{
	$what = ereg_replace("'","''",$what);
	
	while (eregi("\\\\'", $what))
	{
		$what = ereg_replace("\\\\'","'",$what);
	}
	return $what;
}

/**
 * This is an attempt to clean up the referer function.
 *
 * @param string URL to insert into referer table
 * @author: Matt McNaney
 */
function new_url($url)
{
  global $phpgw;
  /**
   * The global configuration file.
   */
  include ("config.php");

  $test_home = ereg_replace ("http://", "", $nuke_url);
  $test_url = ereg_replace ("http://", "", $url);
  if (eregi("^$test_home", "$test_url") || eregi("^www.$test_home", "$test_url")){
    return;
  }
  $phpgw->db->query ("select ref_id from wcm_new_referer where url LIKE '$url'");
  
  // Found match
  if ($phpgw->db->num_rows()){
    $phpgw->db->next_record();
    $ref_id=$phpgw->db->f("ref_id");
    $phpgw->db->query("update wcm_new_referer set hit_total=hit_total+1, time='" . date("Y-m-d G:i:s") . "' where ref_id=$ref_id");
  }
  
  // Did not find match
  else{
    $phpgw->db->query("insert into wcm_new_referer (url, hit_total, time) values ('$url', '1','" . date("Y-m-d G:i:s") . "')");
  }
}



/**
 * Filters bad words from the given string.
 *
 * The given string is checked for bad words found in the CensorList
 * array defined in the global configuration file. According to the
 * CensorMode setting matches are found at the beginning of words, as
 * a fragment or as exact match.
 *
 * Any bad word that was found is replaced by the CensorReplace
 * variable.
 *
 * @param string the message to be filtered.
 * @return string the censored message.
 * @todo convert to using preg_replace. check whether including config.php is necessary.
 */
function check_words($Message)
{
  global $EditedMessage, $CensorList, $CensorMode, $CensorReplace;
  /**
   * The global configuration file.
   */
  include("config.php");
	
  $EditedMessage = $Message;

  if ($CensorMode != 0){
    if (is_array($CensorList)){
      $Replacement = $CensorReplace;
      
      if ($CensorMode == 1){ 	                                 // Exact match
	$RegExPrefix   = '([^[:alpha:]]|^)';
      $RegExSuffix   = '([^[:alpha:]]|$)';
      }
      elseif ($CensorMode == 2){    				// Word beginning
	$RegExPrefix   = '([^[:alpha:]]|^)';
	$RegExSuffix   = '[[:alpha:]]*([^[:alpha:]]|$)';
      }
      elseif ($CensorMode == 3){				// Word fragment
	$RegExPrefix   = '([^[:alpha:]]*)[[:alpha:]]*';
	$RegExSuffix   = '[[:alpha:]]*([^[:alpha:]]*)';
      }

      for ($i = 0; $i < count($CensorList) && $RegExPrefix != ''; $i++)
	{
	  $EditedMessage = eregi_replace("$CensorList[$i]","$Replacement",$EditedMessage);
	}
    }
  }
  return ($EditedMessage);
}

function check_html ($str, $strip="")
{
	include("config.php");

	if ($strip == "nohtml")
	$AllowableHTML=array('');

	$str = stripslashes($str);
	$str = eregi_replace("<[[:space:]]*([^>]*)[[:space:]]*>","<\\1>",$str);
	$tmp = "";

	while (eregi("<([^> ]*)([^>]*)>",$str,$reg))
	{
		$i = strpos($str,$reg[0]);
		$l = strlen($reg[0]);

		if ($reg[1][0] == "/") $tag = strtolower(substr($reg[1],1));
		else $tag = strtolower($reg[1]);
			
		if ($a = $AllowableHTML[$tag])
		{
			if ($reg[1][0] == "/") $tag = "</$tag>";
			elseif ($a == 1) $tag = "<$tag>";
			else $tag = "<$tag " . $reg[2] . ">";
		}
		else $tag = "";
		
		$tmp .= substr($str,0,$i) . $tag;
		$str = substr($str,$i+$l);
	}
	$str = $tmp . $str;

	// Squash PHP tags unconditionally
	$str = ereg_replace("<\?","",$str);
	$str = ereg_replace("\"","",$str); 

	return $str;
}

/**
 * Performs censoring and filtering of html on the given message.
 *
 * The given string is checked for bad words using the check_words
 * function. Afterwards it is cleaned from illegal html tags using
 * check_html.
 *
 * @param string The message to be filtered.
 * @param string Whether to strip HTML or not (&quot;&quot; or &quot;nohtml&quot;).
 * @return string The filtered message.
 * @see check_html(), check_words()
 * @todo CLEAN UP!
 */
function filter_text($Message, $strip="")
{
	global $EditedMessage;

	check_words($Message);
	$EditedMessage=check_html($EditedMessage, $strip);
	$EditedMessage=check_words($EditedMessage);
	return ($EditedMessage);
}

///////////////////////////////////////////////////////////////////////
// functions for formatting stories.
///////////////////////////////////////////////////////////////////////

/**
 * Formats a given timestamp according to locale configured in global configuration file.
 *
 * @param string Timestamp YYYY-MM-DD
 * @return string Natural language representation of input.
 * @todo convert to preg_match
 */
function formatTimestamp($time)
{
  /**
   * The global configuration file.
   */
  include ("config.php");
  global $datetime;

  setlocale ("LC_TIME", "$locale");

  ereg ("([0-9]{4})-([0-9]{1,2})-([0-9]{1,2}) ([0-9]{1,2}):([0-9]{1,2}):([0-9]{1,2})", $time, $datetime);
  $datetime = strftime("%A %d %B @ %H:%M:%S", mktime($datetime[4],$datetime[5],$datetime[6],$datetime[2],$datetime[3],$datetime[1]));
  $datetime = ucfirst($datetime);

  return($datetime);
}

function oldNews($storynum)
{
	global $phpgw;
  /**
   * The global configuration file.
   */
	include ("config.php");
	$boxstuff = "";
	$boxTitle = lang("Past Articles");
	 $phpgw->db->query("select sid, title, time, comments from wcm_stories order by time desc limit $storynum, $oldnum");
	while($phpgw->db->next_record())
	{
		$sid=$phpgw->db->f("sid");
		$title=$phpgw->db->f("title");
		$time=$phpgw->db->f("time");
		if ($title != "") {
		$doitman = "yes";
		}
	
		$count1 = "0";
		setlocale ("LC_TIME", "$locale");
		ereg ("([0-9]{4})-([0-9]{1,2})-([0-9]{1,2}) ([0-9]{1,2}):([0-9]{1,2}):([0-9]{1,2})", $time, $datetime2);
		$datetime2 = strftime(lang("datestring2"), mktime($datetime2[4],$datetime2[5],$datetime2[6],$datetime2[2],$datetime2[3],$datetime2[1]));
		$datetime2 = ucfirst($datetime2);
		if ($datetime2 != $time2){
		  $boxstuff .= "$datetime2<br />";
		}
			$boxstuff .= "<a href=\"article.php?sid=$sid\">$title";
			$boxstuff .= "</a><br /><br />";
			$time2 = $datetime2;
                         
		}
			if ($doitman == "yes") {
				themesidebox($boxTitle, $boxstuff);
					} 
}

function mainblock() {
	global $phpgw;
	$phpgw->db->query("select title, content from wcm_mainblock");
	while($phpgw->db->next_record()) {
		$title=$phpgw->db->f("title");
		$content=$phpgw->db->f("content");
		$content = ereg_replace("\n", "<br />", $content);
		themesidebox($title, $content);
	}
}


function rightblocks()
{
	global $phpgw;
	$phpgw->db->query("select title, content from wcm_rblocks");
	
	while($phpgw->db->next_record())
	{
		$title=$phpgw->db->f("title");
		$content=$phpgw->db->f("content");
		$content = str_replace("\n", "<br />", $content);
		themerightbox($title, $content);
	}
}

function leftblocks()
{
	global $phpgw;
	$phpgw->db->query("select title, content from wcm_lblocks");
	
	while($phpgw->db->next_record())
	{ 
		$title=$phpgw->db->f("title");
		$content=$phpgw->db->f("content");
		$content = str_replace("\n", "<br />", $content);
		themesidebox($title, $content);
	}
}

function adminblock()
{
	global $phpgw;
	$phpgw->db->query("select title, content from wcm_adminblock");

	while($phpgw->db->next_record())
	{
		$title=$phpgw->db->f("title");
		$content=$phpgw->db->f("content");
		$content = str_replace("\n", "<br />", $content);
		themesidebox($title, $content);
	}
}


/*********************************************************/
/* poll functions                                        */
/*********************************************************/
function pollMain($pollID)
{
	global $maxOptions, $boxTitle, $boxContent, $uimages, $pollTitle;
	global $phpgw;
  /**
   * The global configuration file.
   */
	include("config.php");
	
	if(!isset($pollID))
	$pollID = 1;
	
	if(!isset($url))
	$url = sprintf("/wcm/pollBooth.php?op=results&amp;pollID=%d", $pollID);

	$boxContent .= "<form action=\"pollBooth.php\" method=\"post\">\n";
	$boxContent .= "<input type=\"hidden\" name=\"pollID\" value=\"".$pollID."\" />\n";
	$boxContent .= "<input type=\"hidden\" name=\"forwarder\" value=\"".$url."\" />\n";

		
	$phpgw->db->query("SELECT pollTitle, voters FROM wcm_poll_desc WHERE pollID=$pollID");
	$phpgw->db->next_record();
	$pollTitle=$phpgw->db->f("pollTitle");
	$voters=$phpgw->db->f("voters");
	$boxTitle = lang("Survey");

##
## This is now getting passed by the Global variable so it doesn't get bunched with the $content.
##	$boxContent .= "$pollTitle<br />\n";
##	
	for($i = 1; $i <= $maxOptions; $i++)
	{
		$phpgw->db->query("SELECT pollID, optionText, optionCount, voteID FROM wcm_poll_data WHERE (pollID=$pollID) AND (voteID=$i)");
		$phpgw->db->next_record();
//		$object = mysql_fetch_object($result);
// I don't really know what to do about the following line, so I'm gonna
// wing it.
//		if(is_object($object)){
		if($phpgw->db->num_rows() > 0){
//			$optionText = $object->optionText;
			$optionText = $phpgw->db->f("optionText");
			if($optionText != ""){
				$boxContent .= "
				<input type=\"radio\" name=\"voteID\" value=\"".$i."\" />
				$optionText
				<br />";
			}
		}
	}
	$boxContent .= "
		<input type=\"submit\" value=\"" . lang("Vote Now!") . "\" /><br />";
	$boxContent .= "
	[ <a href=\"pollBooth.php?op=results&amp;pollID=$pollID\">
	" . lang("Results") . "
	</a>] <br />
	[ <a href=\"pollBooth.php\">
	" . lang("Past Surveys") . "
	</a>]
	<br />";
	//Searches database for number of votes present

//	The following info from the select is never used.
// I am commenting the whole thing out.
//	$phpgw->db->query("SELECT pollID, pollTitle, timeStamp FROM wcm_poll_desc WHERE pollID=$pollID");
//	$holdtitle = mysql_fetch_row($result);
//	mysql_free_result($result);
	$phpgw->db->query("SELECT SUM(optionCount) AS SUM FROM wcm_poll_data WHERE pollID=$pollID");
// Again, I'm gonna wing the following.
//	$sumcount = (int)mysql_result($result, 0, "SUM"); 
	$phpgw->db->next_record();
	$sumcount = $phpgw->db->f("SUM"); 
//	mysql_free_result($result);
	//end search
	if ($pollcomm){
	    $phpgw->db->query("select count(*) AS COUNT from wcm_pollcomments where pollID=$pollID");
		$phpgw->db->next_record();
	    $numcom = $phpgw->db->f("COUNT");
	    $boxContent .= "<br />" . lang("Votes:") . " <b>$sumcount</b><br />" . lang("Comments") . ": <b>$numcom</b>";
	}
	else{
	    $boxContent .= "<br />" . lang("Votes:") . " <b>$sumcount</b>";
	}
	$boxContent .= "</form>";
	themepollbox($boxTitle, $boxContent);
}

function pollLatest()
{

	global $phpgw;

	$phpgw->db->query("SELECT pollID FROM wcm_poll_data ORDER BY pollID DESC");
// Hmmm, let's do our best...
//	$pollID = mysql_fetch_row($result);
//	return($pollID[0]);
	$phpgw->db->next_record();
	$pollID = $phpgw->db->f("pollID");
}

function pollNewest()
{
	$pollID = pollLatest();
	pollMain($pollID);
}

function pollCollector($pollID, $voteID, $forwarder)
{
	global $maxOptions, $setCookies, $cookiePrefix, $HTTP_COOKIE_VARS;
  /**
   * The global configuration file.
   */
	include("config.php");
	global $phpgw;
	$voteValid = "1";

	if($setCookies>0){
		// we have to check for cookies, so get timestamp of this poll
		$phpgw->db->query("SELECT timeStamp FROM wcm_poll_desc WHERE pollID=$pollID");
		$phpgw->db->next_record();
		$timeStamp = $phpgw->db->f("timeStamp");
		$cookieName = $cookiePrefix.$timeStamp;

		// check if cookie exists
		if($HTTP_COOKIE_VARS["$cookieName"] == "1"){
			// cookie exists, invalidate this vote
			$warn = lang("You already voted today!");
			$voteValid = "0";
		}
		else{
			// cookie does not exist yet, set one now
			$cvalue = "1";
			setcookie("$cookieName",$cvalue,time()+86400);
		}
	}

	// update database if the vote is valid
	if($voteValid>0){
		@$phpgw->db->query("UPDATE wcm_poll_data SET optionCount=optionCount+1 WHERE (pollID=$pollID) AND (voteID=$voteID)");
		@$phpgw->db->query("UPDATE wcm_poll_desc SET voters=voters+1 WHERE pollID=$pollID");
		$phpgw->redirect($phpgw->link("$forwarder"));
	}
	else{
		$phpgw->redirect($phpgw->link("$forwarder"));
	}


}

function pollList()
{
	global $phpgw;
	$phpgw->db->query("SELECT pollID, pollTitle, timeStamp, voters FROM wcm_poll_desc ORDER BY timeStamp"); 
	$counter = 0;
	
	while($phpgw->db->next_record())
	{
		$resultArray[$counter] = array(
			$phpgw->db->f("pollID"), 
			$phpgw->db->f("pollTitle"), 
			$phpgw->db->f("timeStamp"), 
			$phpgw->db->f("voters"));
		$counter++;
	}
	for ($count = 0; $count < count($resultArray); $count++)
	{
		$id = $resultArray[$count][0];
		$pollTitle = $resultArray[$count][1];
		$voters = $resultArray[$count][3];
		echo("<br /><span class=\"onebiggerred\">&gt;</span> <a href=\"pollBooth.php?pollID=$id\">$pollTitle</a><br />");
		echo(" &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;(<a href=\"pollBooth.php?op=results&amp;pollID=$id\">" . lang("Results") . "</a> - $voters " .lang("votes") . ")\n");
	}
}

function pollResults($pollID)
{
	global $maxOptions, $BarScale, $resultBarFile, $setCookies;
	global $phpgw;
	
	if(!isset($pollID)) $pollID = 1;

	$phpgw->db->query("SELECT pollID, pollTitle, timeStamp FROM wcm_poll_desc WHERE pollID=$pollID");
//	$holdtitle = mysql_fetch_row($result);
	$phpgw->db->next_record();
	$holdtitle=$phpgw->db->f("pollTitle");
//	echo "<br /><b>$holdtitle[1]</b><br />";
	echo "<br /><b>$holdtitle</b><br />";
	
//	mysql_free_result($result);

	$phpgw->db->query("SELECT SUM(optionCount) AS SUM FROM wcm_poll_data WHERE pollID=$pollID");
//	$sum = (int)mysql_result($result, 0, "SUM"); 
	$phpgw->db->next_record();
	$sum = $phpgw->db->f("SUM");
//	mysql_free_result($result);

	echo "<table width=\"100%\" cellpadding=\"2\" cellspacing=\"0\" border=\"0\" summary=\"Data for Poll Results\">";

	// cycle through all options
	for($i = 1; $i <= $maxOptions; $i++){
		// select next vote option
		$phpgw->db->query("SELECT pollID, optionText, optionCount, voteID FROM wcm_poll_data WHERE (pollID=$pollID) AND (voteID=$i)");
//		$object = mysql_fetch_object($result);
		$phpgw->db->next_record();

//		if(is_object($object)){
		if($phpgw->db->num_rows() > 0){
//			$optionText = $object->optionText;
			$optionText =$phpgw->db->f("optionText");
//			$optionCount = $object->optionCount;
			$optionCount = $phpgw->db->f("optionCount");

			if($optionText){
				echo "<tr><td class=\"type5\" align=\"right\">";
				echo "$optionText";
				echo "</td>";

				if($sum){
					$percent = 100 * $optionCount * $BarScale / $sum;
				}
				else{
					$percent = 0;
				}
				echo "<td class=\"type5\" align=\"left\">";
				$percentInt = (int)$percent * 4;
				$percent2 = (int)$percent;

				if ($percent > 0){
					echo "<img src=\"images/leftbar.gif\" alt=\"" . lang("Left bar") . "\" height=\"16\" width=\"3\" />";
					echo "<img src=\"images/mainbar.gif\" height=\"16\" width=\"$percentInt\" alt=\"$percent2%\" />";
					echo "<img src=\"images/rightbar.gif\" alt=\"" . lang("Right bar") . "\" height=\"16\" width=\"3\" />";
				} else {
					echo "<img src=\"images/leftbar.gif\" height=\"16\" width=\"3\" alt=\"$percent2%\" />";
					echo "<img src=\"images/mainbar.gif\" height=\"16\" width=\"1\" alt=\"$percent2%\" />";
					echo "<img src=\"images/rightbar.gif\" height=\"16\" width=\"3\" alt=\"$percent2%\" />";
				}

                                printf(" %.2f %% (%d)", $percent, $optionCount);

				echo "</td></tr>";
		        }
		}
	}
	echo "</table>";
	echo "<b>" . lang("Total Votes:") . " $sum</b><br />";
	if($setCookies>0) {
	    echo lang("We allow just one vote per day") . "<br /><br />";
	} else {
	    echo "<br /><br />";
	}

	$booth = $pollID;
	echo("[ <a href=\"pollBooth.php?pollID=$booth\">" . lang("Voting Booth") . "</a> | ");
	echo("<a href=\"pollBooth.php\">" . lang("Other Polls") . "</a> ]");
	return(1);
}

function getTopics($s_sid)
{
    global $topicname, $topicimage, $topictext;
    global $phpgw;
    
    $sid = $s_sid;
    $phpgw->db->query("SELECT topic FROM wcm_stories where sid=$sid");
    $phpgw->db->next_record();
    $topic=$phpgw->db->f("topic");
    $phpgw->db->query("SELECT topicid, topicname, topicimage, topictext FROM wcm_topics where topicid=$topic");
    $phpgw->db->next_record();
    $topicid=$phpgw->db->f("topicid");
    $topicname=$phpgw->db->f("topicname");
    $topicimage=$phpgw->db->f("topicimage");
    $topictext=$phpgw->db->f("topictext");
}

function date_select($month, $day, $year)
{
	$select_date = "";
	if (!$month){
		$month = date(m);
		$day = date(d);
		$year = date(Y);
		$oneweek = mktime(0,0,0,$month, $day + 7, $year); 
	}else
		$oneweek = mktime(0,0,0,$month, $day, $year); 

	$select_date .= "
	<select name=\"month\">\n";
	
	for($i=1; $i<13; $i++)
	{
/*
##This won't work because the translate happens at the compile and these monthnames are created dynamically

		$month_name = "TRANSLATE[[";
		$month_name .= date('F' , mktime(0,0,0,$i,1,0));
		$month_name .= "]]";
*/

		$select_date .= "<option value=\"".date(m, mktime(0,0,0,$i,1))."\"";
				if (date(m, mktime (0,0,0, $i,1)) == date(m, $oneweek))
					$select_date .= " selected=\"selected\"";

				$select_date .= ">".date("F", mktime(0,0,0,$i,1))."</option>\n";
	}
	
	$select_date .= "</select>
	<select name=\"day\">
	";

	for($i=1; $i<32; $i++)
	{
		$select_date .= "<option value=\"".date(d, mktime(0,0,0,1,$i))."\"";
				if (date(j, mktime(0,0,0,1,$i)) == date(j, $oneweek))
					$select_date .= " selected=\"selected\"";

				$select_date .= ">".date("d", mktime(0,0,0,1,$i))."</option>\n";
	}
	$select_date .= "</select>
	<select name=\"year\">
	";
	
	for($i=$year, $j=$year+5; $i < $j; $i++)
	{
		$select_date .= "<option value=\"".date(Y, mktime(0,0,0,1, 1, $i))."\"";
		if (date(Y, mktime(0,0,0,1,1,$i)) == date(Y, $oneweek))
			$select_date .= " selected=\"selected\"";

		$select_date .= ">".date("Y", mktime(0,0,0,1,1,$i))."</option>\n";
	}

	$select_date .= "</select>\n";
	
	return $select_date;
}

/**
 * Allows page to ignore cache and reload page after an amount of time
 *
 * Original idea from Michael T. Babcock (mbabcock@fibrespeed.net)
 *
 */

function CacheControl() 
{
	include("config.php");
	if ($limit_cache){

		header ("Pragma: no-cache"); 
		header ("Cache-Control: no-cache, must-revalidate, max_age=0");
		header ("Expires: 0"); 
	}
}


function help($name) { 
	$name = str_replace(" ", "%20", $name);
	$return_value = "
	<script type=\"text/javascript\">
		function launch() 
		{
			open('help.php?op=search&name=$name','help','resizable=yes,scrollbars=yes,toolbar=no,location=no,directories=no,status=no,menubar=no,width=500,height=300') 
		}
	</script>
	[ <a href=\"javascript:launch()\">Help</a> ]";

	return $return_value;  
}

?>
